/* sktl34.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  skrelease
 *
 *  Finish the closing process on socket sknum.
 *	1 - issue a close if in state STWAIT/STLAST
 *	2 - return(-1) if in state SCLOSED
 *	3 - loop until a timeout if flag is set,
 *	    then issue a close and release the socket
 *
 *	return -1 if the socket is closed or released
 *	else return sknum
 */
int skrelease(sknum,tflag)
int sknum,tflag;
{
	register struct socket *skt;
	long time;

	/*
	 * check validity
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt==-1)
		return(-1);

	time = cticks(NULL);
	do {
		ntsleep(0);
		switch(skt->state) {
		default:		/* check for timeout */
			if(elapsed(time) < (long) RELEASETIME) {
				break;
			}

		case SLAST:		/* close the socket */
		case STWAIT:
			skclose(sknum);

 		case SCLOSED:		/* socket is released */
			return(-1);
			break;

		}
		if(tflag)
			suspnd(15);
	} while(tflag);
	return(sknum);
}
                                                                                                                                                                                                                                                                                                  