/* shost2.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "mapskt.h"
#include "bytprc.h"
#include "confgs.h"

extern	shost2();

/*
 *  Smadd
 *
 *  if(sknum<0)
 *  If machine is there just returns pointer, else
 *  Add a machine to the list. Increments machine number of machine.
 *  Puts in parameters copied from the "default" entry.
 *
 *  If(sknum>=0)
 *  If machine is there copy to socket(sknum),
 *  else put in parameters copied from the "default" entry.
 */
struct machinfo *Smadd(sknum,mname)
int sknum;
register char *mname;
{
	int i;
	register struct machinfo *m;
	register struct socket *skt;

	if(sknum>=0)
		skt = (struct socket *) mapskt(sknum);

	/*
	 *  First, do we have the name already?
	 */
	m = (struct machinfo *) ovrlay(shost2,Shostlook,2,sknum,mname);
	if(m)
		if(sknum<0) {
			return(m);
		} else {
			skt->mpp = &skt->mach;
			movebytes(skt->mpp,m,sizeof(struct machinfo));
			skt->mach.port = skt->sktport;
			return(skt->mpp);
		}
	/*
	 *   Don't have name, add another record
	 */
	if(sknum<0) {
		Smptr = (struct machinfo *) malloc(sizeof(struct machinfo));
		if(Smptr==NULL)
			return(NULL);
	} else {
		Smptr = skt->mpp = &skt->mach;
	}
	/*
	 * we have no parms
	 */
	for(i=0; i<NUMSPECS-99; i++)
		Sflags[i] = 0;
	ovrlay(shost2,Scopyfrom,1,"default");
	Smptr->sname = NULL;
	if(sknum<0) {
		/*
		 * internal machine list
		 */
		Smptr->hname = malloc(strlen(mname)+1);
		Smptr->mno = ++mno;
		Smptr->next = Smachlist;
		Smachlist = Smptr;
	} else {
		/*
		 * socket machine data
		 */
		Smptr->hname = &skt->hname;
		Smptr->mno = sknum;
		Smptr->next = NULL;
		skt->mach.port = skt->sktport;
	}
	/*
	 * copy in name of machine
	 */
	if(Smptr->hname)
		strcpy(Smptr->hname,mname);
	/*
	 * No IP yet
	 */
	Smptr->mstat = NOIP;

	return(Smptr);
}
                                         