/* ftplsn.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"


/*
 * ftplstn
 *
 * Server Opens Connections
 */
int ftplstn()
{
	register struct socket *skt;
	register char *myip;
	int port,rcode,sknum;
	char printline[32];

	/*
	 * Create socket for data connection
	 */
	sknum = socket();
	if(sknum == -1)
		return(-1);
	/*
	 * setup the appropriate listening port
	 * the default port HFTP-1 should be used
	 * only for single user mode
	 * TCPIP will select a unique port if the
	 * default port (skt->sktport) is zero,
	 * else the specified port will be used.
	 * return the socket number if ok,
	 * else return -1 on error.
	 */
	if(!sendport) {
		listen(sknum,HFTP-1);
		return(sknum);
	}
#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("ftplstn(): before dumpcon() call \r\n");
}
#endif
	dumpcon();
	/*
	 * Setup listener
	 */
	port = listen(sknum,0);
	/*
	 * get my ip number
	 */
	skt = (struct socket *) mapskt(sknum);
	myip = skt->tcpout.i.ipsource;
	/*
	 * full port number
	 */
	sprintf(printline,"PORT %d,%d,%d,%d,%d,%d\r\n",
		*(myip+0) & 0xFF, *(myip+1) & 0xFF,
		*(myip+2) & 0xFF, *(myip+3) & 0xFF,
		(port>>8) & 0xFF,      port & 0xFF);
#ifdef	DEBUGOPTION
if(debug&0x02) {
		printf(printline);
}
#endif
	/*
	 * send PORT command
	 */
	skwrite(ftpcskt,printline,strlen(printline));
	skenque(ftpcskt,1);
	/*
	 * get response
	 */
#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("ftplstn(): before ftpreplies() call \r\n");
}
#endif
	rcode = ftpreplies(&rcode);
#ifdef	DEBUGOPTION
if(debug&(0x08|0x10)) {
	printf("return from ftpreplies()\r\n");
}
#endif
	/*
	 * socket number
	 */
	if(rcode == TRUE) {
		return(sknum);
	} else {
		skrelease(sknum,1);
		return(-1);
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                  