/* scrnAC.c */

/*
 * Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "suspnd.h"
#include "termio.h"

#include "fmtdat.h"
#include "vt1xx.h"

extern	char *cstate[];

scrnA(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #A)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	row++;

	sprintf(s,
	"    begin = [%06.6o]", skt);
	fmtplc(s,row++);

	sprintf(s,
	"    end   = [%06.6o]", ((int) skt) + sizeof(struct socket) - 1);
	fmtplc(s,row++);

	sprintf(s,
	"    size  = %-4.4d bytes    sktid = %d",
		sizeof(struct socket), skt->sktid);
	fmtplc(s,row++);

	row = 5;
	sprintf(s,
	"	sktport			= %u", skt->sktport);
	fmtplc(s,row++);

	sprintf(s,
	"	skfport			= %u", skt->skfport);
	fmtplc(s,row++);

	sprintf(s,
	"	hostname[%06.6o]	= %s", &skt->hostname,skt->hostname);
	fmtplc(s,row++);

	sprintf(s,
	"	request [%06.6o]	= %s", &skt->request,skt->request);
	fmtplc(s,row++);

	sprintf(s,
	"	struct window in	[%06.6o]  size = %4.4d bytes",
		&skt->in, sizeof(struct window));
	fmtplc(s,row++);

	sprintf(s,
	"	struct window out	[%06.6o]  size = %4.4d bytes",
		&skt->out, sizeof(struct window));
	fmtplc(s,row++);

	sprintf(s,
	"	TCPKT  tcpout           [%06.6o]  size = %4.4d bytes",
		&skt->tcpout, sizeof(TCPKT));
	fmtplc(s,row++);

	sprintf(s,
	"	struct pseudotcp tcps	[%06.6o]  size = %4.4d bytes",
		&skt->tcps, sizeof(struct pseudotcp));
	fmtplc(s,row++);

	sprintf(s,
	"		credit		= %d", skt->credit);
	fmtplc(s,row++);

	sprintf(s,
	"		sendsize	= %d", skt->sendsize);
	fmtplc(s,row++);

	sprintf(s,
	"		rto		= %d", skt->rto);
	fmtplc(s,row++);

	sprintf(s,
	"	struct twin session	[%06.6o]  size = %4.4d bytes",
		&skt->session, sizeof(struct twin));
	fmtplc(s,row++);

	sprintf(s,
	"	struct machinfo *mpp	= %06.6o", skt->mpp);
	fmtplc(s,row++);

	sprintf(s,
	"	struct machinfo mach	[%06.6o]  size = %4.4d bytes",
		&skt->mach, sizeof(struct machinfo));
	fmtplc(s,row++);

	sprintf(s,
	"		sname  [%06.6o]	= %s", &skt->sname,&skt->sname);
	fmtplc(s,row++);

	sprintf(s,
	"		hname  [%06.6o]	= %s", &skt->hname,&skt->hname);
	fmtplc(s,row++);

#if ts$sys
	sprintf(s,
	"	Associated Job Number	= %d", skt->jobnum);
#endif
#if rt$sys
	sprintf(s,
	"	Associated Job Number	= %o", skt->jobnum & 0x0E);
#endif
	fmtplc(s,row++);
}

scrnB(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct machinfo *m;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	m = &skt->mach;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #B)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	row = 2;
	sprintf(s,
	"struct machinfo mach [%06.6o]	size = %4.4d bytes",
		&skt->mach, sizeof(struct machinfo));
	fmtplc(s,row++);

	row = 4;
	sprintf(s,
	"	sname	[%06.6o]	= %s", m->sname, m->sname);
	fmtplc(s,row++);

	sprintf(s,
	"	hname	[%06.6o]	= %s", m->hname, m->hname);
	fmtplc(s,row++);

	sprintf(s,
	"	hostip  . . . . . . . . = %d.%d.%d.%d",
		m->hostip[0]&255, m->hostip[1]&255,
		m->hostip[2]&255, m->hostip[3]&255);
	fmtplc(s,row++);

	sprintf(s,
	"	gateway . . . . . . . . = %4.4d", m->gateway);
	fmtplc(s,row++);

	sprintf(s,
	"	nameserv  . . . . . . . = %4.4d", m->nameserv);
	fmtplc(s,row++);

	sprintf(s,
	"	delete  . . . . . . . . = %4.4d", m->delete);
	fmtplc(s,row++);

	sprintf(s,
	"	halfdup . . . . . . . . = %4.4d", m->halfdup);
	fmtplc(s,row++);

	sprintf(s,
	"	crmap . . . . . . . . . = %4.4d", m->crmap);
	fmtplc(s,row++);

	sprintf(s,
	"	port  . . . . . . . . . = %4.4d", m->port);
	fmtplc(s,row++);

	sprintf(s,
	"	mno . . . . . . . . . . = %4.4d", m->mno);
	fmtplc(s,row++);

	sprintf(s,
	"	mstat . . . . . . . . . = %4.4d", m->mstat);
	fmtplc(s,row++);

	sprintf(s,
	"	retrans . . . . . . . . = %4.4d", m->retrans);
	fmtplc(s,row++);

	sprintf(s,
	"	conto . . . . . . . . . = %4.4d", m->conto);
	fmtplc(s,row++);

	sprintf(s,
	"	window  . . . . . . . . = %4.4d", m->window);
	fmtplc(s,row++);

	sprintf(s,
	"	maxseg  . . . . . . . . = %4.4d", m->maxseg);
	fmtplc(s,row++);

	sprintf(s,
	"	mtu . . . . . . . . . . = %4.4d", m->mtu);
	fmtplc(s,row++);
}

scrnC(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register struct twin *tw;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	tw = &skt->session;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #C)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	row = 2;
	sprintf(s,
	"struct twin session [%06.6o]	size = %4.4d bytes",
		&skt->session, sizeof(struct twin));
	fmtplc(s,row++);

	row = 4;
	sprintf(s,
	"linemode [%06.6o] = %s", tw->linemode, tw->linemode);
	fmtplc(s,row++);

	row++;

	sprintf(s,
	"	capfp [%06.6o] = %06.6o,  capfil [%06.6o] = %s",
		&tw->capfp, tw->capfp, &tw->capfil, tw->capfil);
	fmtplc(s,row++);

	row++;

	sprintf(s,
	"	termtype	= %s", tw->termtype);
	fmtplc(s,row++);

	row++;

	sprintf(s,
"	pnum   = %5.5d,		telstate = %5.5d,	substate  = %5.5d,",
		tw->pnum, tw->telstate, tw->substate);
	fmtplc(s,row++);

	sprintf(s,
"	binary = %5.5d,		igoahead = %5.5d,	ugoahead  = %5.5d,",
		tw->binary, tw->igoahead, tw->ugoahead);
	fmtplc(s,row++);

	sprintf(s,
"	echo   = %5.5d,		halfdup  = %5.5d,	crfollow  = %5.5d,",
		tw->echo, tw->halfdup, tw->crfollow);
	fmtplc(s,row++);

	sprintf(s,
"	bksp   = %5.5d,		del      = %5.5d,	lmflag    = %5.5d,",
		tw->bksp, tw->del, tw->lmflag);
	fmtplc(s,row++);

	sprintf(s,
"	capon  = %5.5d,		termsent = %5.5d,	termstate = %5.5d,",
		tw->capon, tw->termsent, tw->termstate);
	fmtplc(s,row++);

	sprintf(s,
"	rows   = %5.5d,		width    = %5.5d",
		tw->rows, tw->width);
	fmtplc(s,row++);

	row++;

	sprintf(s,
"	slc[0]  =%5.5d,	slc[5]  =%5.5d,	slc[10] =%5.5d,	slc[15] =%5.5d,",
		tw->slc[0], tw->slc[5], tw->slc[10], tw->slc[15]);
	fmtplc(s,row++);

	sprintf(s,
"	slc[1]  =%5.5d,	slc[6]  =%5.5d,	slc[11] =%5.5d,	slc[16] =%5.5d,",
		tw->slc[1], tw->slc[6], tw->slc[11], tw->slc[16]);
	fmtplc(s,row++);

	sprintf(s,
"	slc[2]  =%5.5d,	slc[7]  =%5.5d,	slc[12] =%5.5d,	slc[17] =%5.5d,",
		tw->slc[2], tw->slc[7], tw->slc[12], tw->slc[17]);
	fmtplc(s,row++);

	sprintf(s,
"	slc[3]  =%5.5d,	slc[8]  =%5.5d,	slc[13] =%5.5d,	slc[18] =%5.5d,",
		tw->slc[3], tw->slc[8], tw->slc[13], tw->slc[16]);
	fmtplc(s,row++);

	sprintf(s,
"	slc[4]  =%5.5d,	slc[9]  =%5.5d,	slc[14] =%5.5d",
		tw->slc[4], tw->slc[9], tw->slc[14]);
	fmtplc(s,row++);
}

          