/* lpqrm.c */

#define	LPQRMMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vlpqrm.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "cliutl.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "rcdlck.h"
#include "datime.h"
#include "inicli.h"
#include "usrblk.h"
#include "suspnd.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();		/* (txt) print text */
extern	int	dosess();		/* session loop */
extern	int	lpdsess();		/* setup LPD session */
extern	VOID	lpdresp();		/* (s) response to client */
extern	VOID	lsterr();		/* error lister */
extern	int	rtresp();		/* keyboard response */
extern	VOID	lpd();			/* (code) process LPD commands */
extern	VOID	rcvbyte();		/* receive a byte from net */
extern	VOID	rcvdata();		/* receive response data */
extern	VOID	sndcfA();		/* send cfA date */
extern	VOID	snddfA();		/* send dfA data */
extern	int	getword();		/* (string,word) extract a word */
extern	VOID	strlwr();		/* (st) convert to lower case */
extern	int	chkusr();		/* check username / password */
extern	VOID	*new();			/* (n) allocate n bytes */
extern	int	lpdsequence();		/* get next LPD sequence */
extern	VOID	savcfA();		/* save a line cfA text */
extern	VOID	dmpcfA();		/* deallocate space for cfA text */
extern	VOID	sizcfA();		/* Compute size of cfA text */
#endif

extern	char	*stptok();		/* (p,t,l,d) stop on token */
extern	char	*stpblk();		/* (ch) strip blanks */
extern	char	*rdcfA();		/* read a line of cfA text */

/*
 * List of LPQRM states
 */

#define	RCVBYTE		(-1)
#define	RCVDATA		(-2)
#define	SNDCFA		(-3)
#define	SNDDFA		(-4)

#define	WAITING		(0)

#define	LPQRM		(0)
#define	LPC		(1)	/* LPC States */
#define	LPCEND		(2)
#define	LPQ		(3)	/* LPQ States */
#define	LPQEND		(4)
#define	LPR		(5)	/* LPR States */
#define	    LPR1	(-51)
#define	    LPR2	(-52)
#define	    LPR3	(-53)
#define	    LPR4	(-54)
#define	LPREND		(6)
#define	    LPRABORT	(-61)
#define	LPRM		(7)	/* LPRM States */
#define	LPRMEND		(8)

#define	LOOPING		(9)
#define	DONE		(10)

/*
 * LPD Definitions
 */

#define	PRNTJOB		(1)
#define	RCVPJOB		(2)
#define	SNDQSHRT	(3)
#define	SNDQLONG	(4)
#define	RMVJOB		(5)

#define	RCV_ABORT	(1)
#define	RCV_CFA		(2)
#define	RCV_DFA		(3)

#define	C_CLASS		('C')
#define	C_HOST		('H')
#define	C_INDENT	('I')
#define	C_JOB		('J')
#define	C_BANNER	('L')
#define	C_MAIL		('M')
#define	C_SOURCE	('N')
#define	C_USER		('P')
#define	C_QUEUE		('Q')
#define	C_SLINK		('S')
#define	C_TITLE		('T')
#define	C_ULINK		('U')
#define	C_WIDTH		('W')
#define	C_ZOPT		('Z')
#define	C_RTROFF	('1')
#define	C_ITROFF	('2')
#define	C_BTROFF	('3')
#define	C_STROFF	('4')
#define	C_CIF		('c')
#define	C_DVI		('d')
#define	C_PRINT		('f')
#define	C_PLOT		('g')
#define	C_BUPLOT	('k')
#define	C_CONTROL	('l')
#define	C_DITROFF	('n')
#define	C_POSTSCRIPT	('o')
#define	C_PR		('p')
#define	C_FORTRAN	('r')
#define	C_TROFF		('t')
#define	C_RASTER	('v')
#define	C_PALLADIUM	('z')

/*
 *	Defines
 */

#define	TIMEOUT		(600)	/* approximately 5 minutes */
#define	QUEWAIT		(20)	/* approximately 10 seconds */

/*
 *	Global Variables For RLPD Control Channel
 */

static int
	looptime = 0;		/* loop time */
	again = 0,		/* looping flag */
	lpdcskt = -1,		/* socket for incoming RLPD */
	mflag = 0,		/* monitor processing */
	rcvpos = 0,		/* receive position */
	ackbyte = 0,		/* LPD ACK/NAK byte */
	timeout = 0,		/* Inactivity timeout counter */
	tcpport = 0,		/* Force TCP To Port */
	option = LPQRM,		/* program option */
	pswdreqd = 1,		/* password required */
	rcnt = 0,		/* number of characters to/from control */
	rfstate = WAITING,	/* state of the control channel */
	retstate = WAITING;	/* to emulate a subroutine call */

/*
 *	Global Buffers / Pointers
 */

#define BLOCKSIZE	(512)
#define BUFFERS		(128)
#define	GETWORD		(80)
#define	LISTSIZE	(4)

static char
	rcvstr[BUFFERS],		/* receive data */
	scratch[BUFFERS],		/* scratch string */
	expfl[BUFFERS],			/* expanded file name */
	defpath[BUFFERS],		/* default path */
	remhost[GETWORD],		/* remote host */
	quename[GETWORD],		/* default printer queue */
	username[USERPASSLEN+2],	/* current user name */
	password[USERPASSLEN+2];	/* password */

char	xs[BLOCKSIZE];			/* data buffer */
					/* dumby buffer for TSXUTL.C */

/*
 *	Various LPQRM variables
 */

static int
	cfAseq = 0,		/* cfA sequence number */
	dfAseq = 0,		/* dfA sequence number */
	sndqlong = 0,		/* LPQ SNDQLONG flag */
	lprcpy = 1,		/* print copies */
	lprindent = 0,		/* indentation */
	lprwidth = 0,		/* width */
	lprmail = 0;		/* mail */

static	char
	lprhost[GETWORD],	/* host */
	lprque[GETWORD],	/* queue */
	lprfile[GETWORD],	/* file */
	lprjob[GETWORD],	/* job */
	lprtitle[GETWORD],	/* title */
	lprclass[GETWORD],	/* class */
	lprbanner[GETWORD],	/* banner */
	lpropt[GETWORD];	/* printing options */

struct	lnkdtxt {
	struct	lnkdtxt	*next;
	char		*line;
};

struct	lnkdtxt			/* beginning of control list */
	*cfA = NULL;
struct	lnkdtxt			/* internal scanning pointer */
	*nxtcfA = NULL;

static	char			/* text line from control list */
	cfAstr[BLOCKSIZE];

static	long
	cfAcnt = 0L,		/* number of bytes in cfA */
	dfAcnt = 0L;		/* number of bytes in dfA */

static char *			/* RLPD configuration file */
	lpdcfl = "TCP:lpdqrm.cfg";
static FILE *			/* RLPD configuration file handle */
	lpdcfh = NULL;

static	char			/* control file name */
	cfAfl[BUFFERS];

static	char
	dfAfl[BUFFERS];		/* data file name */
static	FILE
	*dfAfh = NULL;		/* data file handle */

static char *			/* Password File */
	pswdfl[BUFFERS];

static	char	list[LISTSIZE][GETWORD];

/*
 * Debugging options
 *
 *	bit 0	(0x01)	event printing
 *	bit 1	(0x02)	dosess() events
 *	bit 2	(0x04)	lpd()
 */

static char *lpqrmtxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  LPQRM [?] [-d level] [-ipq argument] [-e] -o opt [opt arguments]",
       "	?               List the Help Text and Exit LPQRM",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() event printing",
       "		4 -	enable LPD() printing",
#else
       "  LPQRM [?] [-inpq argument] [-e] -o opt [opt arguments]",
       "	?               List the Help Text and Exit LPQRM",
#endif
       "	e		Enable Monitoring of LPQRM Transactions",
       "	i  IP Address	Remote Server Name / IP Address",
       "	n  Port Number	Remote Server Port Number",
       "	q  Queue Name	Remote Server Printer Queue",
       "	p  filespec	Configuration File",
       "	o  lpc	[?]	Start printer queue",
       "	   lpq	[?]	Get printer queue status",
       "	   lpr	[?]	Submit a job to a printer queue",
       "	   lprm	[?]	Remove a job from a printer queue",
       "",
       "	The -o opt argument must preceed the opt specific options.",
       "",
	0
       };

static char *lpctxt[] = {
       "",
       "  LPC [?] [-SP argument]",
       "	?               List the LPC Help Text and Exit LPQRM",
       "	P  Queue Name	Remote Host Printer Queue",
       "	S  IP Address	Remote Host Name / IP Address",
       "",
       0
       };

static char *lpqtxt[] = {
       "",
       "  LPQ [?] [-SP# argument] [-l]",
       "	?               List the LPQ Help Text and Exit LPQRM",
       "	#  n		Repeat query time in seconds",
       "	l		Long form of queue status",
       "	P  Queue Name	Remote Host Printer Queue",
       "	S  IP Address	Remote Host Name / IP Address",
       "",
       0
       };

static char *lprtxt[] = {
       "",
       "  LPR [?] [-SPIW# argument] [-flr] [filespec]",
       "	?               List the LPR Help Text and Exit LPQRM",
       "	#  n		# of copies to print (1-5)",
       "	P  Queue Name	Remote Host Printer Queue",
       "	S  IP Address	Remote Host Name / IP Address",
       "	f		ASCII Plain Text (default)",
       "	l		ASCII With Controls",
       "	r		Fortran Carriage Control",
       "	I  n		Indentation (f option only)",
       "	W  n		Page Width (flr options only)",
       "",
       "	Other Options:",
       "	1234cdghnoptvz	UNIX(tm) Options",
       "	M		Mail Option",
       "",
       "	C	Class		J	Job",
       "	L	Banner		T	Title",
       "",
       0
       };

static char *lprmtxt[] = {
       "",
       "  LPRM [?] [-SP argument] job [job [...]]",
       "	?               List the LPRM Help Text and Exit LPQRM",
       "	P  Queue Name	Remote Host Printer Queue",
       "	S  IP Address	Remote Host Name / IP Address",
       "",
       0
       };

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}

main(argc,argv)
int argc;
char *argv[];
{
	int ev,l;
	register int i,j,k;
	char c;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * Initialize some parameters
	 */
	remhost[0] = '\0';
	quename[0] = '\0';

	/*
	 * parse arguments
	 */
/*1*/	for(i=1,l=0; i<argc; i++) {
/*2*/		if(argv[i][0] == '?') {
		    switch(option) {
		    case LPQRM:
			printtxt(lpqrmtxt);
			break;

		    case LPC:
			printtxt(lpctxt);
			break;

		    case LPQ:
			printtxt(lpqtxt);
			break;

		    case LPR:
			printtxt(lprtxt);
			break;

		    case LPRM:
			printtxt(lprmtxt);
			break;

		    default:
			break;
		    }
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
/*3*/		    while((c = argv[j][k]) != '\0') {
/*4*/	switch(option) {
	case LPQRM:	/* Options before -o opt */
		switch(c) {
		/*
		 * Hidden option to bypass username/password
		 */
		case 'b':
			pswdreqd = 0;
			break;
#ifdef	DEBUGOPTION
		case 'd':	/* debug, optional level */
			if(sscanf(argv[++i],"%d",&debug) <= 0)
				debug = -1;
			break;
#endif
		case 'e':	/* enable LPQRM monitoring */
			mflag = 1;
			break;

		case 'i':	/* Remote Server IP Address */
			strcpy(remhost,argv[++i]);
			break;

		case 'n':	/* Remote Server Port Address */
			if (sscanf(argv[++i],"%d",&tcpport) <= 0)
				tcpport = 0;
			break;

		case 'o':	/* Program option selection */
			/*
			 * Must have one of the following
			 * options as the first argument:
			 *	lpc	start printer queue
			 *	lpq	get printer queue status
			 *	lpr	submit a print job
			 *	lprm	delete a print job
			 */
			strlwr(argv[++i]);
			if (streq(argv[i],"lpc")) {
				option = LPC;
			} else
			if (streq(argv[i],"lpq")) {
				option = LPQ;
			} else
			if (streq(argv[i],"lpr")) {
				option = LPR;
			} else
			if (streq(argv[i],"lprm")) {
				option = LPRM;
			} else {
				printtxt(lpqrmtxt);
				exit(1);
			}
			break;

		case 'p':	/* Configuration File */
			lpdcfl = argv[++i];
			break;

		case 'q':	/* Remote Server Queue Name */
			strcpy(quename,argv[++i]);
			break;
#if ts$sys
		/*
		 * This is a 'hidden' option for setting the
		 * the default subdirectory base 'ld' unit
		 * and setting the maximum subdirectory nesting
		 *	note:	subdbase + subdnest <= 8
		 */
		case 's':
			sscanf(argv[++i],"%d",&subdbase);
			sscanf(argv[++i],"%d",&subdnest);
			break;
#endif
		default:
			break;
		}
		break;

	case LPC:
		switch(c) {
		case 'P':	/* Remote Server Queue Name */
			strcpy(quename,argv[++i]);
			break;

		case 'S':	/* Remote Server IP Address */
			strcpy(remhost,argv[++i]);
			break;

		default:	/* unknown option */
			printf(
			"Unrecognized option -%c ignored\r\n", c);
			break;
		}
		break;

	case LPQ:
		switch(c) {
		case '#':	/* looptime value */
			if (sscanf(argv[++i],"%d",&looptime) <= 0) {
				looptime  = 0;
			} else {
				if (looptime < 5)
					looptime = 5;
				if (looptime > 30)
					looptime = 30;
				looptime *= 2;
			}
			break;

		case 'l':	/* use SNDQLONG form */
			sndqlong = 1;
			break;

		case 'P':	/* Remote Server Queue Name */
			strcpy(quename,argv[++i]);
			break;

		case 'S':	/* Remote Server IP Address */
			strcpy(remhost,argv[++i]);
			break;

		default:	/* unknown option */
			printf(
			"Unrecognized option -%c ignored\r\n", c);
			break;
		}
		break;

	case LPR:
		switch(c) {
		case '#':	/* # of copies */
			if (sscanf(argv[++i],"%d",&lprcpy) <= 0) {
				lprcpy  = 1;
			}
			if (lprcpy > 5)
				lprcpy = 5;
			break;

		default:	/* all other options */
		case C_RTROFF:
		case C_ITROFF:
		case C_BTROFF:
		case C_STROFF:
		case C_CIF:
		case C_DVI:
		case C_PRINT:
		case C_PLOT:
		case C_BUPLOT:
		case C_CONTROL:
		case C_DITROFF:
		case C_POSTSCRIPT:
		case C_PR:
		case C_FORTRAN:
		case C_TROFF:
		case C_RASTER:
		case C_PALLADIUM:
			strncat(lpropt,&argv[j][k],1);
			break;

		case 'C':	/* Class Name */
			strcpy(lprclass,argv[++i]);
			break;

		case 'I':	/* Indentation */
			if (sscanf(argv[++i],"%d",&lprindent) <= 0) {
				lprindent = 0;
			}
			if (lprindent < 0 || lprindent > 40)
				lprindent = 0;
			break;

		case 'J':	/* Job Name */
			strcpy(lprjob,argv[++i]);
			break;

		case 'L':	/* Banner */
			strcpy(lprbanner,argv[++i]);
			break;

		case 'M':	/* Mail */
			lprmail = 1;
			break;

		case 'P':	/* Queue Name */
			strcpy(quename,argv[++i]);
			break;

		case 'S':	/* Remote Server IP Address */
			strcpy(remhost,argv[++i]);
			break;

		case 'T':	/* Title */
			strcpy(lprtitle,argv[++i]);
			break;

		case 'W':	/* Width */
			if (sscanf(argv[++i],"%d",&lprwidth) <= 0) {
				lprwidth = 0;
			}
			if (lprwidth < 0 || lprwidth > 216)
				lprwidth = 0;
			break;
		}
		break;

	case LPRM:
		switch(c) {
		case 'P':	/* Remote Server Queue Name */
			strcpy(quename,argv[++i]);
			break;

		case 'S':	/* Remote Server IP Address */
			strcpy(remhost,argv[++i]);
			break;

		default:	/* unknown option */
			printf(
			"Unrecognized option -%c ignored\r\n", c);
			break;
		}
		break;

	default:
		break;
/*4*/	}
			k++;
/*3*/		    }
/*2*/		} else
		if (l < LISTSIZE) {
			strcpy(list[l],argv[i]);
			strlwr(list[l]);
			l++;
		}
/*1*/	}

	/*
	 * Try to access the configuration file
	 */
	if(NULL == (lpdcfh = rtopen(lpdcfl,"r",0,0))) {
		kb_puts("Configuration File Required\r\n");
		kb_puts("\r\nEscaping from LPQRM\r\n");
		exit(1);
	}

	/*
	 * First line is sequence number
	 */
	fgetss(scratch,sizeof(scratch)-1,lpdcfh);

	/*
	 * Second line is temporary file directory
	 */
	fgetss(scratch,sizeof(scratch)-1,lpdcfh);

	/*
	 * Third line is password file directory
	 */
	if (NULL != fgetss(scratch,sizeof(scratch)-1,lpdcfh)) {
		if (!getword(scratch,pswdfl)) {
			strcpy(pswdfl,"PAS:paswrd.fil");
		}
	}
	rtclose(lpdcfh);

	if (option == LPQRM) {
		printtxt(lpqrmtxt);
		exit(1);
	}

	if (quename[0] == '\0') {
		strcpy(quename,"lp");
	}

	if (remhost[0] == '\0') {
		if (question(remhost,sizeof(remhost),"Remote LPD Server: ")) {
			if (!fndbrk)
				kb_puts("\r\nRemote LPD Server Required\r\n");
			kb_puts("\r\nEscaping from LPQRM\r\n");
			exit(1);
		}
	}

	if (tcpport) {
		sprintf(scratch," %d",tcpport);
		strcat(remhost,scratch);
	}

	/*
	 * Input Required Parameters
	 */
	switch(option) {
	case LPC:
		break;

	case LPQ:
		break;

	case LPR:
		/*
		 * Test Username (password not required)
		 */
		if (pswdreqd) {
			pswdreqd = 0;
			if (chkusr()) {
				if (!fndbrk)
				    kb_puts("\r\n?-LPR-User Required\r\n");
				kb_puts("\r\nEscaping from LPQRM\r\n");
				exit(1);
			}
		}

		/*
		 * File To Print
		 */
		if (question(list[0],GETWORD,"File To Print: ")) {
			if (!fndbrk)
			    kb_puts("\r\n?-LPR-File Required\r\n");
			kb_puts("\r\nEscaping from LPQRM\r\n");
			exit(1);
		}
		break;

	case LPRM:
		/*
		 * Agent Required
		 */
		if (pswdreqd) {
		    if (question(username,sizeof(list[0]),"Username: ")) {
			if (!fndbrk)
				kb_puts("\r\n?-LPRM-Username Required\r\n");
			kb_puts("\r\nEscaping from LPQRM\r\n");
			exit(1);
		    }
		}
		/*
		 * Job Name / File Required
		 */
		if (list[0][0] == '\0') {
		    if (question(list[0],sizeof(list[0]),"Remove Job: ")) {
			if (!fndbrk)
				kb_puts("\r\n?-LPRM-Job Required\r\n");
			kb_puts("\r\nEscaping from LPQRM\r\n");
			exit(1);
		    }
		}
		break;

	default:
		break;
	}

	/*
	 * Set Up Path
	 */
	gethome(defpath);
	cd(defpath);

	/*
	 * Initialize various things
	 */
loop:	again = 0;
	timeout = 0;
	rfstate = WAITING;
	retstate = WAITING;
	Snetinit();

	/*
	 *  Open a connection to the machine named.
	 *  Start up all of the configuration on the connection.
	 */
	lpdcskt = lpdsess(remhost);

	if(lpdcskt<0) {
		kb_puts("\r\nLPQRM Session Failed\r\n");
		exit(1);
	} else {
		while(!fndbrk && !again && ev != -1) {
			ev = dosess();
			if(ev==0)
				suspnd(0);
		}

		skclose(lpdcskt);
		skrelease(lpdcskt,1);

		suspnd(0);
		errhandle();

		if(fndbrk) {
			kb_puts("\r\n^C\r\n");
		} else
		if(again) {
			goto loop;
		}

		cd("dk:");

		kb_puts("\r\nEscaping from LPQRM\r\n");
		exit(0);
	}
}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving message events
 */
int dosess()
{
	int  cl,ev,dat;

	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev = Sgetevent(SCKTCLASS | CONCLASS | USERCLASS |
			ERRCLASS | MSGCLASS | ABORTCLASS, &cl, &dat);
	if(ev!=0) {

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("dosess(): cl = %d, ev = %d, dat = %u\r\n", cl,ev,dat);
}
#endif

	  switch(cl) {
	    case CONCLASS:
	      /*
	       * LPD Connection socket
	       */
	      lpd(ev);
	      break;

	    case MSGCLASS:	/* messages */
	    case ERRCLASS:	/* error message */
	      kb_puts(skerrstring(ev));
	      kb_nline();
	      break;

	    case ABORTCLASS:	/* abort */
	      switch(ev) {
		case CLIENT:
		  kb_puts("\r\nLPQRM session aborted by TCPIP\r\n");
		  Stmrset(ABORTCLASS,EXITABORT,dat,5);

		case USERABORT:
		  if(skrelease(dat,0) < 0) {
		    return(-1);
		  } else {
		    skclose(dat);
		    Stmrset(ABORTCLASS,USERABORT,dat,1);
		  }
		  break;

		case EXITABORT:
		  return(-1);
		  break;

		default:
		  break;
	      }
	      break;

	    default:
	      break;
	  }
	} else {
	  lpd(0);
	}

	return(ev);
}

/*
 *  lpdsess
 *  Start an LPD session to the named machine
 */

int lpdsess(str)
char *str;
{
	register struct socket *skt;
	register int port,sknum;

	/*
	 * Request a TCPIP socket
	 */
	sknum = socket(0);
	if(sknum<0)
		return(-1);
	
	/*
	 * Specify the connection type
	 */
	skt = (struct socket *) mapskt(sknum);
	skt->sktport = HLPD;

	/*
	 * Force the source port to be from
	 * a privileged port (721 - 731)
	 */
	port = skt->in.port;
	port = port % 11;
	port += 721;
	skt->skfport = port;

	/*
 	 * Request a connection
	 */
	connect(sknum,str);

	return(sknum);
}

/*
 * Dump response to client
 */
VOID lpdresp(s)
register char *s;
{
	skwrite(lpdcskt, s, strlen(s));
	skwrite(lpdcskt, "\n", 1);
	skenque(lpdcskt, 1);
	if(mflag) {
		kb_puts(s);
		kbprintf("  {%d}\r\n", strlen(s)+1);
	}
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * General looping question routine
 * loops until a response is given
 *	returns 1 on an aborted input
 *	   else 0
 */
int question(cstr,clen,qstr)
char *cstr,*qstr;
int clen;
{
	while(!(*(stpblk(cstr)))) {
		/*
		 * get arg from user
		 */
		kb_puts(qstr);
		if(rtresp(cstr,clen))
			return(1);
		}
	return(0);
}

/*
 * Routine to get a keyboard response
 *	returns 1 on an abort
 *	   else 0
 */
int rtresp(st,ln)
char *st;
int ln;
{
	return((keygets(st,ln,1)==-1) ? 1 : 0);
}

/*
 * keygets
 *
 * read a line from the keyboard
 * returns -1 if keyboard input aborted
 * or non-zero on success
 */

int keygets(str,lim,echo)
register char *str;	/* where to put the line */
int lim,echo;		/* max chars to read, echo? */
{
	register char *save;
	register int c;

	save = str;		/* beginning of line */
	*save = '\0';

	if(fndbrk) {
		kb_puts("^C\r\n");
		return(-1);
	}

	while(1) {
		/*
		 * build string from keyboard
		 */
		c = kb_gets(str,lim,echo);
		if(1 <= c && c <= 31) {
			kb_nline();
			return(strlen(save));
		}
		/*
		 * check for abort
		 */
		if(fndbrk) {
			*save = '\0';
			kb_puts("^C\r\n");
			return(-1);
		}
		suspnd(0);
	}
}

/*
 *	Remote Printer Query
 */
VOID lpd(code)
int code;
{
	register int i,j;
	register char *s;
	struct socket *skt;

	timeout += 1;

#ifdef	DEBUGOPTION
if(debug&0x04) {
	if (rfstate) {
		printf("lpd(%d): rfstate = %d\r\n",
			code,rfstate);
	}
}
#endif

	switch(rfstate) {
	case WAITING:
		switch(code) {
		case CONOPEN:
			Stmrunset(ABORTCLASS,CLIENT,lpdcskt);

			/*
			 * Get Hostname without Domain
			 */
			skt = (struct socket *) mapskt(lpdcskt);
			strcpy(lprhost,skt->hostname);
			if ((s = strchr(lprhost,'.')) != NULL)
				*s = '\0';

			rfstate = option;
			break;

		case CONCLOSE:
			kb_puts("Connection Refused by Remote Server\r\n");
			rfstate = DONE;
			break;

		case CONFAIL:
			kb_puts("Failed to Connect to Remote Server\r\n");
			rfstate = DONE;
			break;

		default:
			break;
		}
		break;

	case LOOPING:
		break;

	case LPC:
		/*
		 * Log Session
		 */
		sprintf(scratch,
	/*Log*/
	"LPC: %s", quename
	/*Log*/
		);
		logsession(lpdcskt,scratch);

		/*
		 * Send LPC Command
		 */
		sprintf(scratch,"%c%s", PRNTJOB,quename);
		lpdresp(scratch);
		kbprintf("?-LPC-Starting Queue '%s'\r\n", quename);
		rfstate = DONE;
		break;

	case LPQ:
		/*
		 * Log Session
		 */
		sprintf(scratch,
	/*Log*/
	"LPQ: %s", quename
	/*Log*/
		);
		logsession(lpdcskt,scratch);

		/*
		 * Send LPQ Command
		 */
		s = sprintf(scratch,"%c%s",
			sndqlong ? SNDQLONG : SNDQSHRT,quename);
		for (i=0; i < LISTSIZE && list[i][0] != '\0'; i++) {
			s = sprintf(s," %s", list[i]);
		}
		lpdresp(scratch);

		rcvdata(LPQEND);
		break;

	case LPQEND:
		if (looptime) {
			if (timeout > looptime) {
				again = 1;
				rfstate = LOOPING;
				retstate = LOOPING;
			}
		} else {
			rfstate = DONE;
		}
		break;

	case LPR:
		/*
		 * Log Session
		 */
		sprintf(scratch,
	/*Log*/
	"LPR: %s", quename
	/*Log*/
		);
		logsession(lpdcskt,scratch);

		/*
		 * Send LPR Command
		 */
		sprintf(scratch,"%c%s", RCVPJOB,quename);
		lpdresp(scratch);

		rcvbyte(LPR1);
		break;

	case LPR1:
		if (ackbyte) {
			rfstate = DONE;
			break;
		}

		/*
		 * Local File Name
		 */
		sprintf(dfAfl,list[0]);
		expand(expfl,lclfile(dfAfl));

		/*
		 * Find Number of Bytes
		 */
		if ((dfAfh = rtopen(dfAfl,"r",0,0)) == NULL) {
			kbprintf("?-LPR-Unable to open file %s\r\n", expfl);
			rfstate = LPRABORT;
			break;
		} else {
			dfAcnt = 0L;
			while (fgetss(xs,sizeof(xs)-2,dfAfh) != 0) {
				dfAcnt = dfAcnt + strlen(xs) + 1;
			}
			rtclose(dfAfh);
		}

		/*
		 * Create dfA File Name
		 */
		dfAseq = lpdsequenc();
		sprintf(lprfile,"dfA%03d%s", dfAseq,lprhost);

		/*
		 * Send Receive Data File Command
		 */
		sprintf(scratch,"%c%ld %s", RCV_DFA,dfAcnt,lprfile);
		lpdresp(scratch);

		rcvbyte(LPR2);
		break;

	case LPR2:
		if (ackbyte) {
			rfstate = LPRABORT;
			break;
		}

		/*
		 * Send Data File
		 */
		snddfA(LPR3);
		break;

	case LPR3:
		if (ackbyte) {
			rfstate = LPRABORT;
			break;
		}

		/*
		 * Create cfA File Name
		 */
		cfAseq = lpdsequenc();
		sprintf(lprfile,"cfA%03d%s", cfAseq,lprhost);

		/*
		 * Set all defaults
		 */
		if (lprque[0] == '\0')				/*Q*/
			strcpy(lprque,"lp");
		if (lpropt[0] == '\0')				/*f*/
			strcpy(lpropt,"f");

		/*
		 * Write Control Data
		 */
		sprintf(cfAstr,"H%s", lprhost);			/*H*/
		savcfA(cfAstr);
		if (username[0] != 0) {
			sprintf(cfAstr,"P%s", username);	/*P*/
		} else {
			sprintf(cfAstr,"P%s", lprhost);
		}
		savcfA(cfAstr);
		if (lprjob[0] != '\0') {			/*J*/
			sprintf(cfAstr,"J%s", lprjob);
			savcfA(cfAstr);
		}
		if (lprclass[0] != '\0') {			/*C*/
			sprintf(cfAstr,"C%s", lprclass);
			savcfA(cfAstr);
		}
		if (lprindent) {				/*I*/
			sprintf(cfAstr,"I%d", lprindent);
			savcfA(cfAstr);
		}
		if (lprwidth) {					/*W*/
			sprintf(cfAstr,"W%d", lprwidth);
			savcfA(cfAstr);
		}
		if (lprbanner[0] != '\0') {			/*L*/
			sprintf(cfAstr,"L%s", lprbanner);
			savcfA(cfAstr);
		}
		if (lprtitle[0] != '\0') {			/*T*/
			sprintf(cfAstr,"T%s", lprtitle);
			savcfA(cfAstr);
		}
		sprintf(cfAstr,"N%s", expfl);			/*N*/
		savcfA(cfAstr);
		if (lprmail) {					/*M*/
			sprintf(cfAstr,"MdfA%03d%s", dfAseq,lprhost);
			savcfA(cfAstr);
		}
		for (i=0; i < lprcpy; i++) {			/*?*/
			for (j=0; j < strlen(lpropt); j++) {
				sprintf(cfAstr,"%cdfA%03d%s",
					lpropt[j],dfAseq,lprhost);
				savcfA(cfAstr);
			}
		}
		sprintf(cfAstr,"UdfA%03d%s", dfAseq,lprhost);	/*U*/
		savcfA(cfAstr);

		/*
		 * Find Number of Bytes in cfA
		 */
		sizcfA();

		/*
		 * Send Receive Control File Command
		 */
		sprintf(scratch,"%c%ld %s", RCV_CFA,cfAcnt,lprfile);
		lpdresp(scratch);

		rcvbyte(LPR4);
		break;

	case LPR4:
		if (ackbyte) {
			rfstate = LPRABORT;
			break;
		}

		/*
		 * Send cfA Data
		 */
		sndcfA(LPREND);
		break;

	case LPREND:
		if (ackbyte) {
			rfstate = LPRABORT;
			break;
		}

		rfstate = DONE;
		break;

	case LPRABORT:
		sprintf(scratch,"%c", RCV_ABORT);
		lpdresp(scratch);

		rfstate = DONE;
		break;

	case LPRM:
		/*
		 * Log Session
		 */
		sprintf(scratch,
	/*Log*/
	"LPRM: %s", quename
	/*Log*/
		);
		logsession(lpdcskt,scratch);

		/*
		 * Send LPRM Command
		 */

		s = sprintf(scratch,"%c%s", RMVJOB,quename);
		if (pswdreqd) {
			s = sprintf(s," %s", username);
		} else {
			s = sprintf(s," %s", lprhost);
		}
		for (i=0; i < LISTSIZE && list[i][0] != '\0'; i++) {
			s = sprintf(s," %s", list[i]);
		}
		lpdresp(scratch);

		rfstate = DONE;
		break;

	/*
	 *
	 * Command Processors Follow
	 *
	 */

	case RCVBYTE:
		rcvbyte(0);
		break;

	case RCVDATA:
		rcvdata(0);
		break;

	case SNDCFA:
		sndcfA(0);
		break;

	case SNDDFA:
		snddfA(0);
		break;

	default:
	case DONE:
		rcnt = -1;
		break;
	}

	if((rcnt < 0) || (timeout > TIMEOUT)) {

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("lpd(%d): rfstate = %d, rcnt = %d\r\n",
		code,rfstate,rcnt);
}
#endif
		rcnt = 0;

		dmpcfA();

		if (dfAfh)
			rtclose(dfAfh);

		if(lpdcskt >= 0) {
			sksendwait(lpdcskt,(long) SENDWAIT);
			skclose(lpdcskt);
			lpdcskt = skrelease(lpdcskt,1);
		}

		fndbrk = 1;
	}
}

VOID
rcvbyte(i)
int i;
{
	/*
	 * Initialize for receiving a single byte
	 */
	if (i) {
		rfstate = RCVBYTE;
		retstate = i;
		ackbyte = 0;
		timeout = 0;
		return;
	}

	/*
	 * subroutine to wait for a single octet
	 */
	if (0 < (rcnt = skread(lpdcskt,&ackbyte,1))) {
		skdeque(lpdcskt);
		suspnd(-1);
		if (ackbyte)
			ackbyte = 1;

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rcvbyte(): byte = %d\r\n", ackbyte);
}
#endif

		rfstate = retstate;
		timeout = 0;
	}
}

VOID
rcvdata(i)
int i;
{
	register int icnt;

	/*
	 * Initialize for receiving data
	 */
	if (i) {
		rfstate = RCVDATA;
		retstate = i;
		rcvpos = 0;
		rcvstr[0] = '\0';
		timeout = 0;
		return;
	}

	/*
	 * subroutine to wait for end of line
	 */
	icnt = 0;
	while(	0 < (rcnt = skread(lpdcskt,&rcvstr[rcvpos],1))) {
		icnt = 1;
		if(rcvstr[rcvpos] == '\n') {
			/*
			 * find end of string
			 */
			while (	(rcvstr[rcvpos] < 33) &&
				(rcvpos >= 0) )
				rcvpos--;
			/*
			 * put in terminator
			 */
			rcvstr[++rcvpos] = '\0';
			kbprintf("%s\r\n", rcvstr);
			rcvpos = 0;
			break;
		} else {
			if(rcvpos < sizeof(rcvstr)-1)
				rcvpos += rcnt;
		}
	}
	if (icnt) {
		skdeque(lpdcskt);
		suspnd(-1);
		timeout = 0;
	}
	if (rcnt < 0) {
		rcnt = 0;
		if(lpdcskt >= 0) {
			skclose(lpdcskt);
			lpdcskt = skrelease(lpdcskt,1);
		}
		rfstate = retstate;
	}
}

VOID
sndcfA(i)
int i;
{
	register int icnt;

	/*
	 * Initialize for sending control file
	 */
	if (i) {
		rfstate = SNDCFA;
		retstate = i;
		timeout = 0;
		ackbyte = 0;
		nxtcfA = cfA;
		return;
	}

	/*
	 * subroutine to send control data
	 */
	icnt = 0;
	while ((rcnt = skroom(lpdcskt)) > 0 && rcnt > sizeof(cfAstr)) {
		if (rdcfA(0) != NULL) {
			lpdresp(cfAstr);
			icnt = 1;
		} else {
			skwchar(lpdcskt,ackbyte);
			rcvbyte(retstate);
			break;
		}
	}

	if (icnt) {
		skenque(lpdcskt,1);
		suspnd(-1);
		timeout = 0;
	}
}

VOID
snddfA(i)
int i;
{
	register int icnt;

	/*
	 * Initialize for sending data file
	 */
	if (i) {
		rfstate = SNDDFA;
		retstate = i;
		timeout = 0;
		ackbyte = 0;

		dfAfh = rtopen(dfAfl,"r",0,0);
		return;
	}

	/*
	 * subroutine to send file data
	 */
	icnt = 0;
	while ((rcnt = skroom(lpdcskt)) > 0 && rcnt > sizeof(xs)) {
		if (fgetss(xs,sizeof(xs)-2,dfAfh) != 0) {
			lpdresp(xs);
			icnt = 1;
		} else {
			rtclose(dfAfh);
			dfAfh = NULL;
			skwchar(lpdcskt,ackbyte);
			rcvbyte(retstate);
			break;
		}
	}

	if (icnt) {
		skenque(lpdcskt,1);
		suspnd(-1);
		timeout = 0;
	}
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */


int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len GETWORD
		 */
		q = stptok(p, word, GETWORD-1, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

/*
 *  chkusr
 *
 *  Check the password file for the user/password
 *  combination. An inaccessable password file
 *  results in an invalid return.
 *
 *  If the user/password are validated and
 *  the user has the rquired privelege,
 *  then a valid return is made.
 *
 *  Returns valid(0)/invalid(1)
 */
int chkusr()
{
	FILE *fp;
	struct userblock user;
	char command[GETWORD];
	char word[GETWORD];

	username[0] = '\0';
	password[0] = '\0';
	/*
	 * username
	 */
	if(question(command,GETWORD,"Username: "))
		return(1);
	getword(command,word);
	strncat(username,word,USERPASSLEN);
	strlwr(username);
	/*
	 * password
	 */
	if (pswdreqd) {
		if(!(*stpblk(command))) {
			kb_puts("Password: ");
			if(keygets(command,GETWORD,0) == -1)
				return(1);
		}
		getword(command,word);
		strncat(password,word,USERPASSLEN);
		strlwr(password);
	}
	/*
	 * Check username / password file
	 */
	if(NULL==(fp = rtopen(pswdfl,"rn",0,0))) {
		return(1);
	}
	while (NULL != fread(&user,sizeof(struct userblock),1,fp)) {
		/*
		 * does username / password check ?
		 */
		if(!strncmp(username,&user.username,USERPASSLEN) &&
				(user.userflag[0]&PASSNOTREQUIRED ||
				!pswdreqd ||
				Scompass(password,&user.password))
			) {
			rtclose(fp);
			/*
			 * User valid
			 */
			return(0);
		}
	}
	kb_puts("Invalid Username / Password.\r\n");
	rtclose(fp);
	return(1);
}

/*
 *  Scompass ( ps, en )
 *
 *  Compute and check the encrypted password
 */
int Scompass(ps,en)
register char *ps,*en;
{
	register int i,ck;
	char *p,c;

	ck = 0;
	p = ps;
	/*
	 * checksum the string
	 */
	while (*p)
		ck += *p++;
	c = ck;
	/*
	 * XOR with checksum
	 */
	i = USERPASSLEN;
	while (i--) {
		if((((*ps ^ c)|32)&127)!=*en)
			return(0);
		/*
		 * increment checksum to hide length
		 */
		if(*ps) {
			ps++;
		} else {
			c++;
		}
		en++;
	}
	return(1);
}

/*
 * new
 *
 * Allocate space
 * Abort if out of space
 */

VOID * new(n)
unsigned int n;
{
	register VOID *p;

	if ((p = (VOID *) malloc(n)) == NULL) {
		fprintf(stderr, "Out of space!\r\n");
		skclose(lpdcskt);
		skrelease(lpdcskt,1);
		exit(1);
	}

	return (p);

}

/*
 * lpdsequence
 *
 * Return the current RLPD sequence number
 * or 0 if the file could not be opened.
 */
static char lpdblock[512];	/* RLPD sequence block */

int lpdsequence()
{
	FILE *fp;
	char seqstr[8];
	int seqnum;

	/*
	 * The RLPD sequence file must be locked to ensure
	 * no other process has simultaneous access to
	 * the file while the file is being updated.
	 * If TSX+ is not sysgened for shared-file
	 * record locking then record locking does not occur.
	 */
	if((fp = rtopen(lpdcfl,"rn",0,0)) == NULL)
		return(0);
	frcdlock(0,fp);
	frcdread(&lpdblock,0,fp);
	seqnum = 0;
	seqstr[0] = '\0';
	strncat(seqstr,lpdblock,3);
	sscanf(seqstr,"%d",&seqnum);
	++seqnum;
	if ((seqnum <= 0) || (seqnum > 999))
		seqnum = 1;
	sprintf(seqstr,"%03d",seqnum);
	strncpy(lpdblock,seqstr,3);
	frcdwrite(&lpdblock,0,fp);
	frcdunlock(0,fp);
	rtclose(fp);
	return(seqnum);
}

/*
 * savcfA
 *
 * Save the cfA Control text into memory as
 * a linked structure of null terminated text lines.
 */

int
savcfA(s)
char *s;
{
	struct lnkdtxt *newcfA;
	char *newline;

	newcfA  = (struct lnkdtxt *) new (sizeof(struct lnkdtxt));
	newline = (char *) new (strlen(s) + 1);
	strcpy(newline,s);
	if (cfA == NULL) {
		cfA = newcfA;
	} else {
		nxtcfA->next = newcfA;
	}
	nxtcfA = newcfA;
	nxtcfA->next = NULL;
	nxtcfA->line = newline;
}

/*
 * dmpcfA
 *
 * Free allocation for cfA data
 */

VOID
dmpcfA()
{
	if (cfA == NULL)
		return;

	while (cfA != NULL) {
		nxtcfA = cfA;
		cfA = cfA->next;
		free(nxtcfA->line);
		free(nxtcfA);
	}
}

/*
 * rdcfA
 *
 * Get the next configuration data line from
 * the linked list of null terminated cfA text lines
 */

char *
rdcfA(i)
int i;
{
	if (i)
		nxtcfA = cfA;

	if (nxtcfA != NULL) {
		strcpy(cfAstr,nxtcfA->line);
		nxtcfA = nxtcfA->next;
		return(cfAstr);
	} else {
		return(NULL);
	}
}

/*
 * sizcfA
 *
 * Compute size of cfA data
 * (including LF for each line)
 */

VOID
sizcfA()
{
	register struct lnkdtxt *lp;

	lp = cfA;
	cfAcnt = 0L;
	while (lp != NULL) {
		cfAcnt = cfAcnt + strlen(lp->line) + 1;
		lp = lp->next;
	}
}

                                                                                                                                               