/* stask.h */

/*
 * size of timer queue
 */
#define NTIMES 3

/*
 * timer queue of events which will be placed
 * into the event queue when the time is up.
 */
struct StmrQ {
	int	eclass,		/* event queue data */
		event,
		idata,
		next;		/* next item in list */
	long	when;		/* when timer is to go off */
};

#ifdef	GLOBALDATA

struct	StmrQ	Stq[NTIMES];

int	Stfirst,
	Stfree;			/* pointers for timer queue */

long	recent = 0;

#else

extern	struct	StmrQ	Stq[NTIMES];
extern	int	Stfirst,
		Stfree;		/* pointers for timer queue */
extern	long	recent;

#endif


extern	VOID	Stask();	/* manages timer queue */
extern	int	Stmrset();	/* (cl,ev,dat,t) set a timer event */
extern	int	Stmrunset();	/* (cl,ev,d) remove matching timer events */
extern	int	Sgetevent();	/* (msk,cl,dat) get event */
                                                                                                                                                                                              