/* stask.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "stask.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  Stask
 *
 *  A higher level version of net sleep -- manages the timer queue.
 *  Always call this in your main loop.
 */
VOID Stask()
{
	register long t;
	register int i;

	/*
	 * Check the timer queue to see if something should be posted
	 * First check for timer wraparound
	 */
	t = cticks(NULL);
	if(t<recent) {
		i = Stfirst;
		while(i>=0) {
			Stq[i].when -= WRAPTIME;
			i = Stq[i].next;
		}
	}
	recent = t;

	/*
	 * Q is not empty and timer is going off
	 */
	while (Stfirst >= 0 && t > Stq[Stfirst].when) {
		i = Stfirst;
		skptevent(Stq[i].eclass,Stq[i].event,Stq[i].idata);
		/*
		 * remove from q
		 */
		Stfirst = Stq[Stfirst].next;
		Stq[i].next = Stfree;
		/*
		 * add to free list
		 */
		Stfree = i;
	}
}

/*
 *  Stmrset
 *
 *  Set an async timer which is checked in Stask -- when time elapses
 *  sticks an event in the network event queue
 *
 *  class, event, dat is what gets posted when howlong times out.
 */
int Stmrset(class,event,dat,howlong)
int class,event,dat,howlong;
{
	register int i,j,jlast;
	int retval;
	long gooff;

	retval = 0;
	gooff = cticks(NULL)+howlong*TICKSPERSEC;
	/*
	 * queue is full, post first event
	 */
	if(Stfree < 0) {
		Stfree = Stfirst;
		Stfirst = Stq[Stfirst].next;
		Stq[Stfree].next = -1;
		skptevent(
			Stq[Stfree].eclass,
			Stq[Stfree].event,
			Stq[Stfree].idata);
		retval = -1;
	  }
	/*
	 * event to occur at that time
	 */
	Stq[Stfree].idata = dat;
	Stq[Stfree].event = event;
	Stq[Stfree].eclass = class;
	Stq[Stfree].when = gooff;
	/*
	 * remove from free list
	 */
	i = Stfree;
	Stfree = Stq[i].next;
	if(Stfirst < 0) {
		/*
		 * if no queue yet anchor active q
		 */
		Stfirst = i;
		Stq[i].next = -1;
	}
	else 
		/*
		 * goes first on list at beginning of list
		 */
		if(gooff < Stq[Stfirst].when) {
			Stq[i].next = Stfirst;
			Stfirst = i;
		} else {
			/*
			 * goes in middle
			 * search q from beginning
			 */
			j = jlast = Stfirst;
			while (gooff >= Stq[j].when&&j >= 0) {
				jlast = j;
				j = Stq[j].next;
			}
			/*
			 * insert in q
			 */
			Stq[i].next = j;
			Stq[jlast].next = i;
		}
	return(retval);
}

/*
 *  Stmrunset
 *
 *  Remove all timer events from the queue
 *  that match the class/event/dat.
 */
int Stmrunset(class,event,dat)
int class,event,dat;
{
	register int i,ilast,retval;

	retval = ilast = -1;
	i = Stfirst;
	/*
	 * search list
	 */
	while (i >= 0 ) {
		if(Stq[i].idata == dat &&
		   Stq[i].eclass == class &&
		   Stq[i].event == event) {
			/*
			 * found at least one
			 */
			retval = 0;
			if(i == Stfirst) {
				/*
				 * first one matches
				 * attach to free list
				 */
				Stfirst = Stq[i].next;
				Stq[i].next = Stfree;
				Stfree = i;
				i = Stfirst;
				/*
				 * start list over
				 */
				continue;
			} else {
				/*
				 * remove this entry
				 * attach to free list
				 */
				Stq[ilast].next = Stq[i].next;
				Stq[i].next = Stfree;
				Stfree = i;
				i = ilast;
			}
		}
		ilast = i;
		i = Stq[i].next;
	}
	return(retval);
}

/*
 *  Sgetevent
 *
 *  Gets events from the network and filters those for session related
 */
int Sgetevent(mask,retclass,retdat)
int mask;
register int *retclass,*retdat;
{
	register int retval;

	/*
	 * session event
	 */
	if(retval = skgtevent(SCLASS,retclass,retdat)) {
		switch (retval) {
			case UDPTO:	/* name server not responding */
				domto(*retdat);
				break;

			case RETRYCON:
				/*
				 * connection open yet?
				 */
				if(0 < nt2open(*retdat))
					/*
					 * 5 is a kludge
					 */
					Stmrset(SCLASS,RETRYCON,*retdat,5);
				break;

			default:
				break;
		}
	}
	/*
	 * allow net
	 */
	ntsleep(0);
	/*
	 * allow timers
	 */
	Stask();

	/*
	 * CONCLASS has the next highest priority
	 */
	if(CONCLASS & mask) {
		if((retval = skgtevent(CONCLASS,retclass,retdat)) != 0) {
			/*
			 * kill this timer
			 */
			if(retval == CONOPEN) {
				Stmrunset(CONCLASS,CONFAIL,*retdat);
			}
			return(retval);
		}
	}

	/*
	 * Remaining Classes
	 */
	if(!(retval = skgtevent(mask,retclass,retdat)))
		return(0);

	if((*retdat==997) && (retval==UDPDATA) && (*retclass==USERCLASS)) {
		udpdom();
	} else  {
		/*
		 * let higher layer have it
		 */
		return(retval);
	}
	return(0);
}
                                                                                                                                                                                                                                                                                                                                                                                                                            