/* ntopen.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"

/*
 *  Snetopen
 *
 *  Sends a TCP open call to the machine specified in the socket sknum.
 *  Uses port 'tport'.  
 */
int Snetopen(sknum,tport)
register int sknum;
int tport;
{
	register struct socket *skt;
	register struct machinfo *m;
	int i,j;

	skt = (struct socket *) mapskt(sknum);
	m = skt->mpp;

	if(!m || m->mstat < HAVEIP)
		return(-1);

	/*
	 * First setup retransmit time
	 */
	i = m->retrans;
	if(i < 2*TICKSPERSEC)
		i = 2*TICKSPERSEC;
	/*
	 * do the open call
	 */
	j = ntxopen(sknum,m->hostip,tport,i,m->mtu,m->maxseg,m->window);
	if(j >= 0) {
		Stmrset(CONCLASS,CONFAIL,sknum,m->conto);
		Stmrset(SCLASS,RETRYCON,sknum,i/TICKSPERSEC);
	}
	return(j);
}

/*
 *  ntxopen
 *
 *  Open a network socket for the user to *machine* using port *service*.
 *  The rest of the parameters are self-explanatory.
 *
 *  Note: Most parameters have been initialized
 *  by makesocket() for TCP connections, all others
 *  are zero.
 */
int ntxopen(sknum,machine,service,rto,mtu,mseg,mwin)
register int sknum;
char *machine;
unsigned int service,rto,mtu,mseg,mwin;
{
	register struct socket *skt;
	register int i;
	unsigned int seg;
	char destip[4];
	char *pc,*hiset;

	/*
	 *  make a copy of the ip number that we are trying for
	 */
	movebytes(destip,machine,4);
	/*
	 *  check the IP number and don't allow broadcast addresses
	 */
	if((destip[3]&0xFF)==0xFF || !destip[3]) {
		printf("%d.%d.%d.%d\r\n",
			destip[0] & 0xFF, destip[1] & 0xFF,
			destip[2] & 0xFF, destip[3] & 0xFF);
		skposterr(505);
		return(-4);
	}

	/*
	 *  get the hardware address for that host, or use the one
	 *  for the gateway all handled by 'ntdlayer' by ARPs.
	 */
	pc = ntdlayer(destip);
	/*
	 * cannot connect to local machine
	 */
	if(pc==NULL) {
		skposterr(504);
		return(-2);
	}

	/*
	 * set up socket structure after call to ntdlayer
	 */
	skt = (struct socket *) mapskt(sknum);
	/*
	 * copy the ip number that we are trying for
	 */
	movebytes(skt->tcpout.i.ipdest,destip,4);
	movebytes(skt->tcps.dest,destip,4);
	/*
	 * load ether address
	 */
	movebytes(skt->tcpout.d.dest,pc,DADDLEN);

	/*
	 * starting retrans timeout
	 */
	if(rto>MINRTO)
		skt->rto = rto;

	/*
	 * largest packet space we have
	 */
	if(mtu<nnmtu)
		skt->sendsize = mtu;

	/*
	 * buffer size is the limit
	 */
	if(mwin<nnwin)
		skt->credit = mwin;

	/*
	 * don't bother to ARP
	 */
	i = cachelook(nnipnum,0,0);
	/*
	 * if it is not -1, we are in trouble
	 */
	if(i >= 0)	{
		hiset = (char *)arpc[i].hrd;
		pc = skerrstring(-1);
		sprintf(pc,
"Conflict with Ethernet hardware address: %02x-%02x-%02x-%02x-%02x-%02x",
			hiset[0] & 0xFF, hiset[1] & 0xFF, hiset[2] & 0xFF,
			hiset[3] & 0xFF, hiset[4] & 0xFF, hiset[5] & 0xFF);
		skposterr(-1);
		skposterr(102);
		ntclose(sknum);
		return(-3);
	}

	/*
	 * try to make the connection,  we will get an event notification
	 * later if it connects.  Timeouts must be done at a higher layer.
	 */

	/*
	 * Set flags and state
	 */
	skt->tcpout.t.flags = TSYN;
	skt->state = SSYNS;
	/*
	 * set service port
	 */
	skt->tcpout.t.dest = intswap(service);
	skt->out.port = sktlist[sknum].outport = service;
	movebytes(sktlist[sknum].remoteip,destip,4);
	/*
	 * allow from port to be forced
	 */
	i = skt->skfport;
	if(i) {
		skt->tcpout.t.source = intswap(i);
		skt->in.port = sktlist[sknum].inport = i;
	}
	/*
	 * install maximum segment size other than default maximum
	 */
	seg = intswap(mseg);
	movebytes((char *)&skt->tcpout.x.options[2],(char *)&seg,2);

	tcpsend(skt,4);
	skt->tcpout.t.hlen = 20<<2;
	skt->out.nxt += 1;
	return(sknum);
}

/*
 *  nt2open
 *
 *  Send out repeat SYN on a connection which is not open yet.
 *  This checks to make sure if it is actually needed.
 *  Timing is handled at a higher layer.
 *
 *  Returns 1 if the state is still at SYNS other wise 0
 *  if connection is proceeding.
 */
int nt2open(sknum)
register int sknum;
{
	register struct socket *skt;

	/*
	 * check validity
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt == -1)
		return(-1);

	if(skt->state != SSYNS)
		return(0);
	/*
	 * The connection has not proceeded to further states,
	 * try retransmission
	 */
	skt->out.nxt--;
	skt->tcpout.t.hlen = 24<<2;
	tcpsend(skt,4);
	skt->tcpout.t.hlen = 20<<2;
	skt->out.nxt++;
	return(1);
}

/*
 *  ntlisten
 *
 *  Listen to a TCP port number and make the connection automatically when
 *  the SYN packet comes in.  The TCP layer will notify the higher layers
 *  with a CONOPEN event.
 *
 *  example usage : ntlisten ( sknum )
 *
 *  Returns<0 if error 
 *
 *  Note: Most parameters have been initialized
 *  by makesocket() for TCP connections, all others
 *  are zero.
 */
int ntlisten(sknum)
register int sknum;
{
	register struct socket *skt;

	skt = (struct socket *) skvalid(sknum);
	if(skt == -1)
		return(-1);

	if(skt->sktport) {
		/*
		 * Use specified port number
		 */
		skt->in.port = sktlist[sknum].inport = skt->sktport;
		skt->tcpout.t.source = intswap(skt->sktport);
	}

	/*
	 * Set socket state
	 */
	skt->state = SLISTEN;
	/*
	 * return the socket port number
	 */
	return(skt->sktport = skt->in.port);
}

                              