/* ftpsb.h */

/*
 * Internal/External routines
 */

extern	VOID	ftpsbi();	/* FTPL startup code that may be overlayed */
extern	int	ftpgets();	/* (str,lim,echo) read line from keyboard */
extern	VOID	ftpexit();	/* (i) exit from ftp */
extern	int	dumpcon();	/* dump connection to screen */
extern	VOID	filter();	/* (cnt) filter telnet options */
extern	int	askq();		/* (cstr,clen,qstr) pose a question */
extern	int	ftpresp();	/* (s,len) response function for tsxutl */
extern	int	toggle();	/* (cstr,wstr,flag,on,off) toggle flags */
extern	VOID	ftppid();   /* (routine,cmdno,command) ftppi() dispatcher */
extern	VOID	ftppi();	/* (command) protocol interpreter */
extern	VOID	ftppi1();	/* (cmdno,command) subcommand processor 1 */
extern	VOID	ftppi2();	/* (cmdno,command) subcommand processor 2 */
extern	VOID	ftppi3();	/* (cmdno,command) subcommand processor 3 */
extern	VOID	ftppi4();	/* (cmdno,command) subcommand processor 4 */
extern	VOID	ftppi5();	/* (cmdno,command) subcommand processor 5 */
extern	VOID	ftppi6();	/* (cmdno,command) subcommand processor 6 */
extern	VOID	ftppi7();	/* (cmdno,command) subcommand processor 7 */
extern	int	setmode();	/* (mode,filnam) set mode, return old mode */
extern	int	ftpopen();	/* (dst,port) open FTP connection */
extern	int	ftppod();	/* (routine) ftpport() dispatcher */
extern	int	ftpport();	/* prepare port */
extern	int	ftpcnct();	/* open FTP data connection */
extern	int	ftplstn();	/* listen for FTP data connection */
extern	int	ftpdod();	/* (routine,st) ftpdo() dispatcher */
extern	int	ftpdo();	/* (s,filnam) do a command */
extern	int	ftpdo1();	/* (st) subcommand processor 1 */
extern	int	ftpdo2();	/* (st) subcommand processor 2 */
extern	int	ftpdo3();	/* (st) subcommand processor 3 */
extern	int	ftpreplies();	/* (rcode) get response to server */
extern	int	ftpabort();	/* (how) abort FTP */
extern	int	rgetline();	/* get line from remote server */
extern	VOID	userftpd();	/* FTP recieve and send file functions */
extern	int	getword();	/* (s,word) remove word from string */
extern	int	finduniq();	/* (nam,lst,lstsz) find unique string */
extern	int	checkevent();	/* process server events */
extern	char *	rmtfile();	/* (s) convert to file spec string */
extern	VOID	strlwr();	/* (s) convert string to lower case */
extern	char	*stptok();	/* (p,word,ilen,delim) stop on token */
extern	char	*stpblk();	/* (s) skip spaces and tabs */
extern	VOID	printtxt();	/* (s) printout text */

/*
 * Definitions
 */

#define DBUGTRUE	-1

#define	FASCII		 0
#define FIMAGE		 1

#define FALSE		 0
#define TRUE		 1
#define SUCCESS		 2
#define HAVEDATA	 4
#define ERROR	   	-1
#define NONE	   	-2
#define ABORT	   	-3
#define INCOMPLETE	-4
#define AMBIGUOUS	-5

/*
 * READSIZE is the system BLOCK SIZE
 * BUFFERS must be an integral multiple of READSIZE
 * xs[] must be at least 1 byte larger than READSIZE
 */

#define READSIZE	512		/* how much to read */
#define BUFFERS		READSIZE	/* size of buffer */

/*
 * FTPSB Specific Data
 */

#ifdef	FTPSBMASTER

int	xp = 0,			/* general pointer */
	towrite = 0,		/* file transfer pointer */
	len = 0,		/* file transfer length */
	ftpcskt = -1,		/* current command port */
	ftpdskt = -1,		/* current data port */
	ftpstate = 0,		/* state for background process */
	ftpfilemode = FASCII,	/* file open mode for transfer */
	finished = TRUE,	/* file transfer complete flag */
	tfrabtf = 0,		/* transfer abort flag */
	verbose = 1,		/* informative messages */
	bell = 0,		/* sound bell */
	hash = 0,		/* hash mark printing */
	hashnum = 0,		/* number of hash marks printed */
	hashcnt = 0,		/* hash mark counter */
	sendport = 1,		/* to send ports or not */
	linked = 0,		/* not connected */
	passive = 0;		/* to request passive mode or not */

unsigned int
	iosize = 0;		/* transfer size in 512 byte blocks */

long	start,			/* transfer start time */
	tbytes;			/* number of bytes transferred */

FILE	*ftpfh = NULL;		/* file pointer for ftp transfers */

char	destname[50]={0,0};	/* who to connect to */
char	ftpcommand[80];		/* command to execute */
char	s[82];			/* line from other side */
char	xs[BUFFERS+2];		/* buffer space for file transfer */

#else

extern	int
	xp,			/* general pointer */
	towrite,		/* file transfer pointer */
	len,			/* file transfer length */
	ftpcskt,		/* current command port */
	ftpdskt,		/* current data port */
	ftpstate,		/* state for background process */
	ftpfilemode,		/* file open mode for transfer */
	finished,		/* file transfer complete flag */
	tfrabtf,		/* transfer abort flag */
	verbose,		/* informative messages */
	bell,			/* sound bell */
	hash,			/* hash mark printing */
	hashnum,		/* number of hash marks printed */
	hashcnt,		/* hash mark counter */
	sendport,		/* to send ports or not */
	linked,			/* not connected */
	passive;		/* to request passive mode or not */

extern	unsigned int
	iosize;			/* transfer size in 512 byte blocks */

extern	long
	start,			/* transfer start time */
	tbytes;			/* number of bytes transferred */

extern	FILE *ftpfh;		/* file pointer for ftp transfers */

extern	char destname[50];	/* who to connect to */
extern	char ftpcommand[80];	/* command to execute */
extern	char s[82];		/* line from other side */
extern	char xs[BUFFERS+2];	/* buffer space for file transfer */

#endif
                                                                                                                                                                                                                                      