/* ftppi.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"

extern	ftppil();

/*
 * FTP PI
 *
 * Protocol interpreter for user interface commands
 * Will permit any command to be abbreviated uniquely.
 * Recognizes commands, translates them to the protocol commands to be
 * sent to the other server, and uses userftpd to do data transfers.
 */

int ftppi(command)
register char *command;
{
	register int cmdno;
	int ivalue;
	char cmdname[50];

	/*
	 * print command
	 */
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("command: %s\r\n",command);
}
#endif
	/*
	 * get command number
	 */
	if(!getword(command,cmdname))
		 return;
	/*
	 * removes first word from command
	 */
	strlwr(cmdname);
	cmdno = finduniq(cmdname,ftp_cmdlist,NCMDS);
	/*
	 * search cmdlist for prefix
	 */
	if(cmdno == AMBIGUOUS) {
		kb_puts("?Ambiguous command\r\n");
		return;
	}
	/*
	 * not a prefix of any command
	 */
	if(cmdno == NONE) {
		kb_puts("?-Invalid command\r\n");
		return;
	}
	/*
	 * process commands
	 */
	switch(cmdno) {
	case OPEN:		/* open connection to host */
		if(linked) {
			kb_puts("Already connected.\r\n");
			return;
		}
		if(askq(command,79,"To: "))
			return;
		/*
		 * host name
		 */
		getword(command,destname);
		/*
		 *  Open a connection to the machine named.
		 */
		if(ftpopen(destname,HFTP) == FALSE)
			return;
		/*
		 * response from other end
		 */
		ftpreplies(&ivalue);
#ifdef	DEBUGOPTION
if(debug&0x10) {
		printf("return from ftpreplies()\r\n");
}
#endif
		if(tstbrk()) {
			return;
		}
		linked = TRUE;
		strcpy(command,"user");
		ftppi(command);
		return;

	case QMARK:
	case HELP:
	case BELL:
	case BYE:
	case QUIT:
	case DEBUG:
	case NDEBUG:
		ovrlay(ftppil,ftppi1,2,cmdno,command);
		return;

	case HASH:
	case PASSIVE:
	case SENDPORT:
	case VERBOSE:
	case VERSION:
		ovrlay(ftppil,ftppi2,2,cmdno,command);
		return;

	case STATUS:
		ovrlay(ftppil,ftppi3,2,cmdno,command);
		return;

	default:	/* The other commands valid only if connected */
		if(!linked) {
			kb_puts("Not connected.\r\n");
			return;
		}
		switch(cmdno) {
		case ASCII:
		case BINARY:
		case CD:
		case CLOSE:
		case DEL:
		case RM:
			ovrlay(ftppil,ftppi4,2,cmdno,command);
			return;
		
		case DIR:
		case LS:
		case GET:
		case RECV:
		case MKDIR:
			ovrlay(ftppil,ftppi5,2,cmdno,command);
			return;
		
		case PUT:			
		case SEND:
		case PWD:
		case QUOTE:
		case REMOTEHELP:
		case RENAME:
			ovrlay(ftppil,ftppi6,2,cmdno,command);
			return;
		
		case RMDIR:
		case SYSTEM:
		case TYPE:
		case USER:
			ovrlay(ftppil,ftppi7,2,cmdno,command);
			return;
		
		default:	/* unknown command */
#ifdef	DEBUGOPTION
	printf("***Program error: Unknown command no: %d\r\n",cmdno);
#endif
			return;
		}
	}
}

                                                                                                                                                                                                                                                                                                                                                                                    