/* ftpcnt.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"


/*
 * ftpcnct
 *
 * Client Opens Connections
 */
int ftpcnct()
{
	register struct socket *skt;
	register char *p;
	char st[24];
	int i,rcode,sknum;
	int ip[4],port[2];
	long stime;

	/*
	 * send PASV command
	 */
	skwrite(ftpcskt,"PASV\r\n",6);
	skenque(ftpcskt,1);
	/*
	 * get response
	 */
#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("ftpcnct(): before ftpreplies() call \r\n");
}
#endif
	i = ftpreplies(&rcode);
#ifdef	DEBUGOPTION
if(debug&(0x08|0x10)) {
	printf("return from ftpreplies()\r\n");
}
#endif
	if(i != TRUE || rcode != 227) {
		return(-1);
	}
	/*
	 * Scan upto PORT Data
	 */
	p = s+4;
	while(*p < '0' || *p > '9') {
		if(*p++ == 0) {
			return(-1);
		}
	}
	/*
	 * full port number
	 */
	if(sscanf(	p,
			"%d,%d,%d,%d,%d,%d",
			ip+0,ip+1,ip+2,ip+3,
			port+0,port+1
							) != 6) {
		return(-1);
	}
	/*
	 * Create socket for data connection
	 */
	sknum = socket();
	if(sknum == -1)
		return(-1);

	/*
	 * Connecting to
	 */
	sprintf(	st,
			"%d.%d.%d.%d #%u",
			ip[0], ip[1], ip[2], ip[3],
			(port[0]<<8) + port[1]
		);
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("%s\r\n",st);
}
#endif
	connect(sknum,st);
	/*
	 * Wait for connection to open
	 */
	stime = cticks(NULL);
	while(elapsed(stime) < 300L) {
		ntsleep(0);
		if(!sktest(sknum)){
			return(sknum);
		}
		suspnd(0);
	}
	skrelease(sknum,1);
	return(-1);
}
                                                                                                                                                                                                             