/* evtdef.h */

/*
 *  Events for event processing.
 */
#define USERCLASS	0x0001	/* user program will accept these events */
#define     UDPDATA 	1	/* UDP data has arrived on listening port */
#define     DOMOK	2	/* domain name ready */
#define     DOMFAIL 	3	/* domain name lookup failed */

#define ICMPCLASS	0x0002	/* ICMP in netsleep will look for these */
#define     IREDIR	1	/* ICMP redirect */

#define ERRCLASS	0x0004	/* the user may read these errors */

#define SCLASS		0x0008	/* the background server will take these */
#define     UDPTO 	1	/* UDP request from DOMAIN timed out, */
#define     RETRYCON 	2	/* retry connection packet, might be lost */

#define CONCLASS	0x0010	/* the application manages connections */
#define     CONOPEN	1	/* connection has opened */
#define     CONDATA	2       /* data is available on this connection */
#define     CONCLOSE	3	/* the other side has closed connection */
#define     CONFAIL	4	/* connection open attempt has failed */

#define	SCKTCLASS	0x0020	/* socket calls to TCPIP */
#define	    REQSCKT	1	/* request a connection socket */
#define	    USRSCKT	2	/* response to request for socket */

#define	TCPCLASS	0x0040	/* session calls to TCPIP */
#define	    REQCONNECT	1	/* request a connection */
#define	    REQLISTEN	2	/* request to listen */
#define	    CLOSING	3	/* initiate closing sequence */
#define	    DEQUEUE	4	/* dequeue data read */
#define	    ENQUEUE	5	/* enqueue data written */
#define	    LOGSESSION	6	/* log the session to TCPIP */

#define	MSGCLASS	0x0080	/* the user may read these messages */

#define	ABORTCLASS	0x0100	/* external abort message */
#define	    SERVER	1	/* abort the server */
#define	    CLIENT	2	/* abort clients */
#define     USERABORT	3	/* user abort sequencing */
#define     EXITABORT	4	/* exit abort sequencing */

#define	SCKTABORT	0x0200	/* abort a connection socket */
				/* event is requesters job number */
				/* data is the socket number */

/*
 * The following allow processes to attach to a service
 */
#define	SRVCATTACH	0x0400	/* attach to service call to TCPIP */
				/* event is service port number */
				/* data is -jobnum of service routine */

#define	SRVCCLASS	0x0800	/* response to attach request */
#define	    ATTACHED	1	/* attached to service */

#define	SRVCABORT	0x1000	/* service abort */
				/* event is service port number */
				/* data is -jobnum of service routine */

/*
 * The following allows the activation of a tasker service
 */
#define	TASKCLASS	0x2000	/* detached task */
#define	    STARTJOB	1	/* start task */
				/* event is task action */
				/* data is taskid from configuration */
                                                                                                                                                                                                                                                                                                                                                                                     