/* vt1xx:h */

/*
 *	VT1xx screen definitions
 */

#define SCRNW	80		/* screen width */

#define SCRNTP	 0		/* ypos for top    line of edit area */
#define SCRNBT	23		/* ypos for bottom line of edit area */
#define STATUS	 0		/* ypos for status/command-input line */

#define SCRNL	24		/* screen length */


/* ---------------------------------------------------------- */
/* Definitions for various parameters */

#define ERR	(-1)
#define END	(-2)

#define EOS	0
#define OK	1

#define NO	0
#define YES	1

/* ---------------------------------------------------------- */
/* Definitions for the Keypad */

			/* zero not allowed */
#define	SELECT	 (-1)
#define	CUT	 (-2)
#define	APPEND	 (-3)
#define	FNDNXT	 (-4)
#define	GOLD	 (-5)
#define HELP	 (-6)
#define	ENTER	 (-7)
#define	SCRLL	   8	/* backspace = 8 */
#define TAB	   9	/* horizontal tab = 9 */
#define LF	  10	/* linefeed = 10 */
#define	SCRLU	  11	/* vertical tab = 11 */
#define FF	  12	/* formfeed = 12 */
#define CR	  13	/* carriage return = 13 */
#define	CHAR	(-14)
#define	WORD	(-15)
#define	LINE	(-16)
#define	DELC	(-17)
#define	DELW	(-18)
#define	DELL	(-19)
#define EOL	(-20)
#define	CTRLU	  21	/* ^U  */
#define ADVANCE	(-22)
#define CTRLW	  23	/* ^W  */
#define	SECTION	(-24)
#define	PAGE	(-25)
#define	CTRLZ	  26	/* ^Z  */
#define	ESCAPE	  27	/* esc character */
#define SCRLD	(-28)
#define	SCRLR	(-29)
#define BACKUP	(-30)
#define ERROR	(-31)
			/* characters 32-126 are valid */
#define	SPACEKEY  32	/* space character */
#define DELETE	 127	/* delete to left of cursor */
#define	CRLF	0x7F	/* internal line termination */

/* ---------------------------------------------------------- */


extern	char	outbuf[];
extern	int	outz;

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	int	syscin();

extern	VOID	escout();	/* (s) char *s; */
extern	VOID	outpos();	/* (x,y) int x,y; */
extern	VOID	outarg();	/* (ones) int ones; */
extern	int	outrev();
extern	int	outnorm();
extern	VOID	outzset();	/* (z) int z; */
extern	VOID	outclr();
extern	VOID	outdeol();
extern	VOID	outekp();
extern	VOID	outdkp();
extern	VOID	outscroll();	/* (top,bot) int top,bot; */
extern	VOID	outsup();	/* (top,bot) int top,bot; */
extern	VOID	outsdn();	/* (top,bot) int top,bot; */
extern	VOID	outscan();
extern	VOID	outblk();
#endif
                                             