/* mailbx.h */

struct	mailrecord {
	unsigned int	mailid;
	unsigned int	mailtmp;
	int		unused[126];
	char		read[128];
	char		rcvd[128];
};

extern struct mailrecord mailidx;

#define	SET_RCVD	(0x0001)
#define	CLR_RCVD	(0x0002)
#define	SET_READ	(0x0004)
#define	CLR_READ	(0x0008)

#define	CLR_MLID	(0x1000)
#define	CLR_MLTMP	(0x2000)

#define	SET_MLID	(0x0100)
#define	INC_MLID	(0x0200)
#define	SET_MLTMP	(0x0400)
#define	INC_MLTMP	(0x0800)

/*
 *	The mail record contains:
 *
 *		(1)	mailid		File extension number of the last
 *					received mail message for this
 *					user. This id is used as the file
 *					extension for the incoming mail
 *					and is within the range 1 to 999.
 *
 *		(2)	mailtmp		File extension number of the last
 *					mail message written from within
 *					MAIL. This id is used as the file
 *					extension for the outgoing mail
 *					and is within the range 1 to 999.
 *					This temporary file is normally
 *					deleted after a successful mail
 *					transfer.
 *
 *		(3)	rcvd[128]	Bit array of received messages,
 *					each bit (numbered 1 to 999)
 *					indicates if a message has been
 *					received.
 *
 *		(4)	read[128]	Bit array of read messages,
 *					each bit (numbered 1 to 999)
 *					indicates if a message has been
 *					read.
 *
 *	When mail is received by RSMTP the mailid is updated and
 *	the corresponding bit is set in the rcvd[] bit array and
 *	cleared in the read[] array.
 *
 *	When mail is read by MAIL the corresponding bit in the
 *	read[] bit array is set.
 *
 *	When the mail file is deleted by MAIL then the corresponding
 *	bits in rcvd[] and read[] will be cleared.
 *
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	int	modidx();
extern	int	makidx();
extern	int	clridx();
#endif
                                                                           