/* dfault.h */

/*
 *  define number of sockets
 */
#define	LSCKTS		 2	/* lclskt.mac supports upto 32 */
#define	GSCKTS		 8	/* gblskt.mac supports upto 32 */
#define	MSCKTS		32	/* maximum number of sockets */

/*
 *  define number of regions
 */
#define	REGIONS		1	/* gblskt.mac supports upto 1 */

/*
 *   Defines which have to do with Ethernet defaults.
 *
 *   The endrvr receive buffers have been set for packets
 *   with a maximum length of 1518. bytes.  Thus MAXSEG
 *   must be limited to 1460 bytes of data for a TCP packet.
 */
#define DADDLEN 	6		/* 6-byte ether address */
#define	LOWWATER	1024		/* low water mark for input queue */
#define HIWATER		2048		/* high water mark for output queue */
#define	HASHSIZE	1024		/* hash mark increment */
#define	NITEMS		6		/* Out of Order Packet Reassembly */
#define QUEUESIZE 	3010		/* input/output queue length */
#define MINWNDOSIZE	128		/* minumum window size limit */
#define DEFWINDOW 	512		/* default window size */
#define MAXWNDOSIZE	3009		/* maximum window size limit */
#define MINSEG		128		/* minimum mseg transfer size(in) */
#define DEFSEG		512		/* default mseg transfer size(in) */
#define MAXSEG		1460		/* maximum mseg transfer size(in) */
#define TMINSIZE	128		/* minimum mtu packet size(out) */
#define TSENDSIZE 	512		/* default mtu packet size(out) */
#define TMAXSIZE 	1460		/* maximum mtu packet size(out) */
#define UMAXLEN 	512		/* maximum upd packet length */
#define ICMPMAX 	300 		/* maximum icmp packet length */
#define	MINPCNT		1		/* minimum packets per transq */
#define	MAXPCNT		5		/* maximum packets per transq */

/*
 *  timing intervals in ticks (unless noted).
 */
#define TICKSPERSEC	   60
#define WRAPTIME      5184000L		/* ticks in a 24 hour period */

#define POKEINTERVAL	 1800
#define MAXRTO  	  300
#define MINRTO 		   20
#define ARPTIMEOUT	    5		/* in seconds */
#define	DOMTIMEOUT	    5		/* in seconds */
#define DLAYTIMEOUT	   15		/* in seconds */
#define CACHETO        216000L
#define	RELEASETIME	  150		/* RELEASETIME  <  WAITTIME */
#define WAITTIME	  300		/* WAITTIME     <  SENDWAIT */
#define	SENDWAIT	  600		/* SENDWAIT     <  LASTTIME */
#define LASTTIME 	 1200		/* LASTTIME                 */
#define CONNWAITTIME	   20		/* in seconds */
#define	ATTACHTIMEOUT	   15		/* in seconds */
#define RESPNDTIMEOUT	  900		/* TCPIP response timeout */

#define	UDPTTL		  120		/* 'time to live' in router hops */
#define	TCPTTL		  120		/* 'time to live' in router hops */

#define CACHELEN 	   10
#define	DOMRETRY	    2

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    