/* rgoph.c */

#define	RGOPHMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vrgoph.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "cliutl.h"
#include "cticks.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "inicli.h"
#include "suspnd.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	int	dosess();	/* rgoph spinner */
extern	int	getword();	/* (string,word) extract a word */
extern	VOID	printtxt();	/* (txt) print text */
extern	int	setgoph();	/* setup to receive incoming GOPHER request */
extern	int	strmatch();	/* caseless string compare */
extern	VOID	rgophresp();	/* (s) send response to net */
extern	VOID	rgophd();	/* (code) rgoph function decoder */
#endif

extern	char	*stptok();	/* (p,t,i,d) stop on token */
extern	char	*stpblk();	/* (ch) skip to chars */

/*
 *	Defines
 */

/*
 * READSIZE is the system BLOCK SIZE
 * BUFFERS must be an integral multiple of READSIZE
 */

#define BUFFERS		8192
#define	READSIZE	512
#define	RSPSTRING	512
#define GENBUFR		128

/*
 * Transfer Delay Time Limits
 */

#define	MINTFRDLY	3
#define	MAXTFRDLY	15

/*
 *	Global Variables For RGOPH Control Channel
 */

static int
	aflag = 0,		/* Attach to Service Flag */
	rflag = 0,		/* RGOPH restart flag */
	gophcskt = -1,		/* socket for incoming gopher */
	mflag = 0,		/* monitor processing */
	waitpos = 0,		/* marker for gathering strings from net */
	rfstate = 0,		/* state of the control channel */
	retstate = 0,		/* to emulate a subroutine call */
	rcnt = 0,		/* transfer count */
	finished = TRUE,	/* file transfer flag */
	itemtype = 0,		/* file transfer type */
	gophfh = NULL,		/* file handle for gopher data */
	tfrdly = 0,		/* transfer suspend time */
	xp = 0,			/* general array index */
	towrite = 0;		/* file -> net  counter */

int	zflag = 0;		/* inactivity timeout flag */

long	izaptime = 0L;		/* inactivity zap time in ticks */


/*
 *	Global Buffers / Pointers
 */

char	xs[BUFFERS];		/* buffer space for file transfer */

static char
	command[GENBUFR],	/* command string */
	rsp[RSPSTRING],		/* response string */
	scratch[GENBUFR];	/* scratch string */

static char *
	gophpath = NULL;	/* GOPHER path and HOME file */

static char
	filespec[GENBUFR],	/* file specification string */
	homefile[GENBUFR];	/* Gopher Home file name */

/*
 * Debugging options
 *
 *	bit 0	(0x01)	debug internal events
 *	bit 1	(0x02)	debug dosess
 *	bit 2	(0x04)	debug rgophd()
 */

#if ts$sys
static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       " RGOPH [?] [-d level] [-p filespec] [-z s] [-aerv]",
       "	?		List the Help Text and Exit RGOPH",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() printing",
       "		4 -	enable rgophd() printing",
#else
       " RGOPH [?] [-p filespec] [-z s] [-aerv]",
       "	?		List the Help Text and Exit RGOPH",
#endif
       "	a		Attach to Service",
       "	e		Enable Monitoring of all RGOPH Transactions",
       "	p		Specify the Master GOPHER File",
       "	r		Restart RGOPH after Disconnect",
       "	v		Verbose Mode",
       "	z  s		Inactivity Timeout in seconds",
       "",
       0
       };
#endif

#if rt$sys
static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       " RGOPH [?] [-d level] [-p filespec] [-z s][ [-erv]",
       "	?		List the Help Text and Exit RGOPH",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() printing",
       "		4 -	enable rgophd() printing",
#else
       " RGOPH [?] [-p filespec] [-z s] [-erv]",
       "	?		List the Help Text and Exit RGOPH",
#endif
       "	e		Enable Monitoring of all RGOPH Transactions",
       "	p		Specify the Master GOPHER File",
       "	r		Restart RGOPH after Disconnect",
       "	v		Verbose Mode",
       "	z  s		Inactivity Timeout in seconds",
       "",
       0
       };
#endif

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}


main(argc,argv)
int argc;
char *argv[];
{
	int ev,i,j,k;
	register char c;
	register struct socket *skt;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * Verbose Mode Off
	 */
	kb_prnt = 0;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    kb_prnt = 1;
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#if ts$sys
			case 'a':	/* attach to service */
				aflag = 1;
				break;
#endif
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = -1;
				break;
#endif
			case 'e':	/* enable RGOPH monitoring */
				mflag = 1;
				break;

			case 'p':	/* GOPHER Directory */
				gophpath = argv[++i];
				break;

			case 'r':	/* enable RGOPH restarting */
				rflag = 1;
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
			case 'v':	/* verbose mode on */
				kb_prnt = 1;
				break;

			case 'z':	/* inactivity timeout flag */
				sscanf(argv[++i],"%d",&zflag);
				izaptime = 60L * zflag;
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		}
	}

#ifdef	DEBUGOPTION
	if (debug)
		kb_prnt = 1;
#endif

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 *  Start listening to the GOPHER port
	 */
	while(((gophcskt = setgoph()) < 0) && !fndbrk) {
		/*
		 * Could not get a socket, wait 5 seconds
		 */
		suspnd(300);
	}

	while(!fndbrk && ev != -1) {
		ev = dosess();
		if(ev==0)
			suspnd(0);
	}

	if(fndbrk) 
		kb_puts("\r\n^C\r\n");

	skclose(gophcskt);
	skrelease(gophcskt,1);

	suspnd(0);
	errhandle();

	cd("dk:");

	kb_puts("\r\nEscaping from RGOPH\r\n");
	exit(0);
}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving message events
 */
int dosess()
{
	int  cl,ev,dat;

	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev = Sgetevent(SCKTCLASS | CONCLASS | USERCLASS |
			ERRCLASS | MSGCLASS | ABORTCLASS, &cl, &dat);
	if(ev!=0) {

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("dosess(): cl = %d, ev = %d, dat = %u\r\n", cl,ev,dat);
}
#endif

	  switch(cl) {
	    case CONCLASS:
	      /*
	       * RGOPH Connection socket
	       */
	      rgophd(ev);
	      break;

	    case MSGCLASS:	/* messages */
	    case ERRCLASS:	/* error message */
	      kb_puts(skerrstring(ev));
	      kb_nline();
	      break;

	    case ABORTCLASS:	/* abort */
	      switch(ev) {
		case CLIENT:
		  /*
		   * disable automatic restart
		   */
		  rflag = 0;
		  kb_puts("\r\nRGOPH session aborted by TCPIP\r\n");
		  Stmrset(ABORTCLASS,EXITABORT,dat,5);

		case USERABORT:
		  if(skrelease(dat,0) < 0) {
		    return(-1);
		  } else {
		    skclose(dat);
		    Stmrset(ABORTCLASS,USERABORT,dat,1);
		  }
		  break;

		case EXITABORT:
		  return(-1);
		  break;

		default:
		  break;
	      }
	      break;

	    default:
	      break;
	  }
	} else {
	  rgophd(0);
	}

	return(ev);
}

/*
 *	set up to receive connection for gopher commands
 */
int setgoph()
{
	int sknum;

	rfstate = 0;		/* state of the control channel */
	retstate = 0;		/* to emulate a subroutine call */
	rcnt = 0;		/* number of characters from control */

	/*
	 * Set the default directory
	 */
	cd("dk:");

	/*
	 * Initialize various things
	 */
	Snetinit();

	/*
	 * aflag = 1	indicates attach mode
	 * aflag = 0	indicates listen mode
	 */
	if(aflag) {
		/*
		 * Attach job to connection opened by TCPIP
		 */
		sknum = attach(0,HGOPH);
		if(sknum==-1) {
			fndbrk++;
			return(-1);
		} else {
			Stmrset(ABORTCLASS,CLIENT,sknum,CONNWAITTIME);
		}
	} else {
		/*
		 * Create socket for control connection
		 */
		sknum = socket(0);
		if(sknum==-1)
			return(-1);
		/*
		 * default port
		 */
		listen(sknum,HGOPH);
	}
	return(sknum);
}

/*
 * Dump response to client
 */
VOID rgophresp(s)
register char *s;
{
	skwrite(gophcskt, s, strlen(s));
	skwrite(gophcskt, "\r\n", 2);
	skenque(gophcskt, 1);
	if(mflag) {
		kb_puts(s);
		kbprintf("  {%d}\r\n", strlen(s)+2);
	}
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * This routine is a dumby routine for TSXUTL.C
 * It should never be called, but returns a 1 [ABORT]
 */
int rtresp()
{
	kb_puts("rtresp: This dumby routine should never be called");
	return(1);
}

/*
 *	Remote GOPHER Server
 */
VOID rgophd(code)
int code;
{
	char *p;
	char word[80];
	int i,icnt;

	if(gophcskt < 0)
		return;

	switch(rfstate) {
		case 0:
			switch(code) {
			case CONOPEN:
				Stmrunset(ABORTCLASS,CLIENT,gophcskt);
				/*
				 * Enable Timeout
				 */
				cticks(&skquetime);
				/*
				 * Verify GOPHER Path
				 */
				if((gophpath == NULL) ||
				  ((p = setpath(gophpath)) == NULL)) {
					sprintf(rsp,
	/*Net*/
	"3Gopher Service Unavailable\t\t"
	/*Net*/
						);
					rgophresp(rsp);
					rcnt = -1;
					break;
				}
				/*
				 * Save GOPHER Path and HOME File Name
				 */
				strcpy(homefile,p);
				getpath(filespec);

				retstate = 1;
				rfstate = 50;
				waitpos = 0; 
				rcnt = 0;
				break;

			case CONCLOSE:
				rcnt = -1;
				break;

			case CONFAIL:
				rcnt = -1;
				break;

			default:
				break;
			}
			break;

		case 1:

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rgophd(%d): %s\r\n", code,command);
}
#endif

			/*
			 * interpret GOPHER command
			 */
			if(getword(command,word) == FALSE) {
				strcpy(filespec,homefile);
				/*
				 * Log Session
				 */
				sprintf(scratch,
	/*Log*/
	"RGOPH"
	/*Log*/
					);
				logsession(gophcskt,scratch);
				/*
				 * Open Gopher List File
				 */
				if((gophfh=rtopen(filespec,"r",0,0))==NULL) {
					sprintf(rsp,
	/*Net*/
	"3Gopher Service Unavailable\t\t"
	/*Net*/
						);
					rgophresp(rsp);
					rgophresp(".");
					rcnt = -1;
					break;
				}
				/*
				 * Transfer Master Gopher List
				 */
	while(fgetss(xs,sizeof(xs),gophfh) && !streq(xs,".")) {
		if(*xs && *xs != '#') {
			if((*xs != '\t') && (*xs != ' ')) {
				rsp[0] = *xs;
				rsp[1] = '\0';
				icnt  = 0;
			} else {
				strcat(rsp,"\t");
				icnt += 1;
			}
			getword(xs+1,scratch);
			strcat(rsp,scratch);
			if(icnt == 3) {
				rgophresp(rsp);
				icnt = 0;
			}
		}
	}
				rtclose(gophfh);
				rgophresp(".");
				rcnt = -1;
				break;
			}

			/*
			 * Menu List
			 */
			if(word[strlen(word)-1] == '/') {
				strcpy(filespec,homefile);
				/*
				 * Open Gopher List File
				 */
				if((gophfh=rtopen(filespec,"r",0,0))==NULL) {
					sprintf(rsp,
	/*Net*/
	"3Gopher Service Unavailable\t\t"
	/*Net*/
						);
					rgophresp(rsp);
					rgophresp(".");
					rcnt = -1;
					break;
				}
				/*
				 * Scan Master Gopher List
				 *
				 * Return Menu items
				 */
	while(fgetss(xs,sizeof(xs),gophfh)) {
		if(*xs && *xs != '#' && *xs != '\t' && *xs != ' ') {
			if(strmatch(word,xs)) {
	while(fgetss(xs,sizeof(xs),gophfh) && !streq(xs,".")) {
		if(*xs && *xs != '#') {
			if(*xs != '\t' && *xs != ' ') {
				rsp[0] = *xs;
				rsp[1] = '\0';
				icnt  = 0;
			} else {
				strcat(rsp,"\t");
				icnt += 1;
			}
			getword(xs+1,scratch);
			strcat(rsp,scratch);
			if(icnt == 3) {
				rgophresp(rsp);
				icnt = 0;
			}
		}
	}
	break;
			}
		}
	}
				rtclose(gophfh);
				rgophresp(".");
				rcnt = -1;
				break;
			}

			/*
			 * Retrieve File
			 */
			strcpy(filespec,homefile);
			/*
			 * Open Gopher List File
			 */
			if((gophfh=rtopen(filespec,"r",0,0))==NULL) {
				sprintf(rsp,
	/*Net*/
	"3Gopher List File Not Found"
	/*Net*/
					);
				rgophresp(rsp);
				rgophresp(".");
				rcnt = -1;
				break;
			}
			/*
			 * Verify File Request
			 */
			while(fgetss(xs,sizeof(xs),gophfh)) {
				if(*xs && *xs != '#') {
					if(*xs != '\t' && *xs != ' ') {
						itemtype = xs[0];
					} else {
						getword(xs,scratch);
						if(strmatch(word,scratch)) {
							break;
						}
					}
				}
			}
			rtclose(gophfh);

			if(!strmatch(word,scratch)) {
				sprintf(rsp,
	/*Net*/
	"File %s access is denied.", word
	/*Net*/
					);
				rgophresp(rsp);
				rgophresp(".");
				rcnt = -1;
				break;
			}

			/*
			 * check file type
			 */
			switch(itemtype) {
			default:
				if((gophfh=rtopen(word,"r",0,0))==NULL) {
					sprintf(rsp,
	/*Net*/
	"Ascii File %s not found.", word
	/*Net*/
					);
					rgophresp(rsp);
					rgophresp(".");
					rcnt = -1;
				} else {
					/*
					 * ready for ascii data
					 */
					finished = FALSE;
					rfstate = 20;
				}
				break;

			case '5':
			case '9':
			case 'g':
			case 'I':
				if((gophfh=rtopen(word,"rn",0,0))==NULL) {
					sprintf(rsp,
	/*Net*/
	"Binary File %s not found.", word
	/*Net*/
					);
					rgophresp(rsp);
					rcnt = -1;
				} else {
					/*
					 * ready for binary data
					 */
					finished = FALSE;
					towrite = 0;
					xp = 0;
					tfrdly = MINTFRDLY;
					rfstate = 21;
				}
				break;
			}
			break;
				
		case 20:
			/*
			 * transfer ascii file to the
			 * other host via gopher request
			 * file is already open=gophfh
			 */
			rsp[0] = '\.';
			while(finished == FALSE &&
			      skroom(gophcskt) > LOWWATER &&
			      !sktest(gophcskt)) {
				if (fgetss(rsp+1,RSPSTRING-2,gophfh)!=NULL) {
					if(rsp[1] != '\.') {
						rgophrsp(rsp+1);
					} else {
						rgophrsp(rsp);
					}
				} else {
					finished = TRUE;
				}
			}
			/*
			 * done if:  the file
			 * is all read from disk
			 * and all sent or other side
			 * has ruined connection
			 */
			if((finished == TRUE) || sktest(gophcskt)) {
				if(gophfh != NULL) {
					rtclose(gophfh);
					gophfh = NULL;
				}
				rgophrsp(".");
				rfstate = 22;
			}
			break;

		case 21:
			/*
			 * the data transfer process is a cooperative
			 * task performed by this program and TCPIP.
			 * this test sequence attempts to maximize the
			 * the transfer rate by adjusting the process
			 * suspension time during the data transfer
			 */
			if(skqued(gophcskt)) {
				if(tfrdly<MAXTFRDLY) tfrdly++;
			} else {
				if(tfrdly>MINTFRDLY) --tfrdly;
			}

			/*
			 * transfer binary file to the
			 * other host via gopher request
			 * file is already open=gophfh
			 */
			if(towrite <= xp && finished == FALSE) {
				/*
				 * need to read again
				 */
				for(p=xs,i=0; i<BUFFERS; i+=READSIZE) {
				    if(rcnt = fread(p,1,READSIZE,gophfh)) {
					p += rcnt;
				    } else {
					finished = TRUE;
					break;
				    }
				}
				towrite = p - xs;
				xp = 0;
			}
			rcnt = towrite - xp;
			if(rcnt > 0) {
				rcnt = skwrite(gophcskt,&xs[xp],rcnt);
			}
			if(rcnt > 0) {
				/*
				 * write successful
				 * adjust counts and queue data
				 */
				xp += rcnt;
				skenque(gophcskt,0);
			}
			/*
			 * done if:  the file
			 * is all read from disk
			 * and all sent or other side
			 * has ruined connection
			 */
			if((towrite <= xp && finished == TRUE) ||
			    sktest(gophcskt)) {
				if(gophfh != NULL) {
					rtclose(gophfh);
					gophfh = NULL;
				}
				rfstate = 22;
			} else {
				if(skqued(gophcskt)) {
					suspnd(tfrdly);
				}
				suspnd(-1);
				break;
			}

		case 22:
			/* send done
			 * wait for other side to accept
			 * everything and then start close
			 */
			if(0 >= skenque(gophcskt,1) || sktest(gophcskt)) {
				rcnt = -1;
			}
			break;

		case 50:
			/*
			 * subroutine to wait
			 * for a particular character
			 */
			icnt = 0;
			while(0<(rcnt=skread(gophcskt,&command[waitpos],1))) {
				icnt = 1;
				if(command[waitpos] == '\n') {
					rfstate = retstate;
					/*
					 * find end of string
					 */
					while (	(command[waitpos] < 33) &&
						(waitpos >= 0) )
						waitpos--;
					/*
					 * put in terminator
					 */
					command[++waitpos] = '\0';
				} else {
					if(waitpos < GENBUFR-1)
						waitpos += rcnt;
				}
			}
			if (icnt) {
				skdeque(gophcskt);
				suspnd(-1);
			}
			break;

		default:
			break;
	}

	/*
	 * Process Inactivity Timeout
	 */
	if((rfstate != 0) &&
	   (zflag != 0) &&
	   (skquetime != 0L) &&
	   (elapsed(skquetime) > izaptime)) {
		rcnt = -1;
	}

	if(rcnt < 0) {

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rgophd(%d): rfstate = %d, rcnt = %d\r\n",
		code,rfstate,rcnt);
}
#endif
		if(gophfh != NULL) {
			rtclose(gophfh);
			gophfh = NULL;
		}
		if(gophcskt >= 0) {
			sksendwait(gophcskt,(long) SENDWAIT);
			skclose(gophcskt);
			gophcskt = skrelease(gophcskt,1);
		}
		if(rflag && !aflag) {
			/*
			 *  Start listening to the GOPHER port
			 */
			while((gophcskt = setgoph()) < 0 && !fndbrk) {
				/*
				 * Could not get a socket, wait 5 seconds
				 */
				suspnd(300);
			}
		} else {
			fndbrk = 1;
		}
	}
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

static int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len 79
		 */
		q = stptok(p, word, 79, "\t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

static char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
 
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
 
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

/*
 * strmatch
 *
 * caseless string compare
 */
int strmatch(s,t)
register char *s,*t;
{
	register int i,j;

	j = strlen(s);
	for(i=0; i<=j; i++) {
		if(tolower(*s++) != tolower(*t++))
			return(0);
	}
	return(1);
}

                       