/* mmail.c */

#define	MMAILMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vmmail.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "mailpi.h"
#include "cliutl.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "inicli.h"
#include "suspnd.h"
#include "usrblk.h"
#include "rcdlck.h"
#include "mailbx.h"
#include "datime.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();
extern	int	finduniq();
extern	int	toggle();
extern	VOID	prnthelp();
extern	int	mailpi();
extern	VOID	more();
extern	int	question();
extern	int	rtresp();
extern	int	tstbrk();
extern	int	loadpath();
extern	VOID	lcd();
extern	VOID	ldelete();
extern	VOID	ldelfil();
extern	VOID	lls();
extern	VOID	lmkdir();
extern	VOID	lprotect();
extern	VOID	setfilp();
extern	VOID	lrename();
extern	VOID	newname();
extern	VOID	lrmdir();
extern	VOID	rmdir();
extern	VOID	lunprotect();
extern	VOID	clrfilp();
extern	VOID	lsterr();
extern	int	mailgets();
extern	int	getword();
extern	int	checkusps();
extern	int	Scompass();
extern	VOID	strlwr();
extern	int	strmatch();
extern	VOID	getinfo();
extern	int	wrtmsg();
extern	int	mailmesg();
#endif

extern	char	*stptok();
extern	char	*stpblk();

/*
 *	Defines
 */
#define FALSE		 0
#define TRUE		 1
#define ERROR	   	-1
#define NONE	   	-2
#define ABORT	   	-3
#define INCOMPLETE	-4
#define AMBIGUOUS	-5

/*
 *	Global Variables For MAIL Control Channel
 */

int	pswdreqd = 1;		/* password required */

int	fromtty = 1;		/* tty / file input flag */

int	prompt = 1,		/* prompt for answer */
	wild = 1,		/* wild cards enabled */
	uflag = 0,		/* username / password flag */
	msgcnt = 0,		/* number of unread mail messages */
	msgflag = 0,		/* created message flag */
	mailer = 0;		/* mailer task number */

/*
 *	Global Buffers / Pointers
 */

#define GENBUFR		(200)
#define	INFO_LEN	(80)
#define	BUFFERS		(512)
#define	HDR_R		(0x0001)
#define	HDR_D		(0x0002)
#define	HDR_F		(0x0004)
#define	HDR_M		(0x0008)
#define	HDR_T		(0x0010)
#define	HDR_S		(0x0020)

struct mesginfo {
	char	rcvd[INFO_LEN];
	char	date[INFO_LEN];
	char	from[INFO_LEN];
	char	mesgid[INFO_LEN];
	char	to[INFO_LEN];
	char	subject[INFO_LEN];
	char	filename[INFO_LEN];
	char	expanded[INFO_LEN];
};

struct mesginfo
	header;			/* message header information */

struct userblock
	user;			/* usernames / passwords / mailboxes */

char	xs[BUFFERS];		/* TSXUTL.C buffer */
				/* used by file copy */

char	ml_cmnd[GENBUFR],		/* command string */
	scratch[GENBUFR],		/* scratch string */
	filespec[GENBUFR],		/* current file filespec */
	mailspec[GENBUFR],		/* mailbox file filespec */
	hostname[GENBUFR],		/* host name */
	username[USERPASSLEN+2],	/* username */
	password[USERPASSLEN+2],	/* password */
	mailpath[DIRPATHLEN+2],		/* mailbox path */
	uspspath[DIRPATHLEN+2],		/* path returned by checkusps */
	defpath[GENBUFR],		/* default path */
	pathname[GENBUFR];		/* space to keep path name */

char *	pass = "PAS:paswrd.fil";	/* password file */

char	fromfile[20] = "";		/* command file */

FILE	*fromfp = NULL;			/* command file */

/*
 * Debugging options
 *
 *	bit 0	(0x01)	debug internal events
 *	bit 1	(0x02)	debug mailpi()
 *	bit 2	(0x04)	debug checkusps()
 */

#if ts$sys
char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  MMAIL [?] [-d level] [-fp filespec] [-t n] [-h]",
       "	?               List the Help Text and Exit MMAIL",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable mailpi() printing",
       "		4 -	enable checkusps printing",
#else
       "  MMAIL [?] [-fp filespec] [-t n] [-h]",
       "	?               List the Help Text and Exit MMAIL",
#endif
       "	f  filename	Command File",
       "	h		Help list",
       "	p  filename	Specify the Password Filespec",
       "	t  n		MAILER Delivery Task Number",
       "",
       0
       };
#endif

#if rt$sys
char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  MMAIL [?] [-d level] [-fp filespec] [-h]",
       "	?               List the Help Text and Exit MMAIL",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable mailpi() printing",
       "		4 -	enable checkusps printing",
#else
       "  MMAIL [?] [-fp filespec] [-h]",
       "	?               List the Help Text and Exit MMAIL",
#endif
       "	f  filename	Command File",
       "	h		Help list",
       "	p  filename	Specify the Password Filespec",
       "",
       0
       };
#endif

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}


main(argc,argv)
int argc;
char *argv[];
{
	register int i,j,k;
	char c;
	int sktnum;
	struct socket *skt;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
			/*
			 * This is a 'hidden' option for bypassing
			 * the password processing.
			 */
			case 'b':	/* bypass password processing */
				pswdreqd = 0;
				break;
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = -1;
				break;
#endif
			case 'f':	/* noninteractive, filename */
				fromtty = FALSE;
				strcpy(fromfile,argv[++i]);
				if(fromfile[0]) {
		   		    fromfp = fopen(fromfile,"r");
		   		    if(fromfp == NULL) {
					printf(
					"Could not open command file: %s\r\n",
					fromfile);
					exit(0);
		   		    }
				}
				break;

			case 'h':	/* help listing */
				mailpi("?");
				break;

			case 'p':	/* password file */
				pass = argv[++i];
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
#if ts$sys
			case 't':	/* MAILER Task Number */
				if(sscanf(argv[++i],"%d",&mailer) <= 0)
					mailer = 0;;
				break;
#endif
			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		}
	}

	/*
	 * Set default directory
	 */
	gethome(defpath);

	/*
	 * Get Host Name
	 */
	Snetinit();

	if ((sktnum = socket(0)) != -1) {
		skt = (struct skt *) mapskt(sktnum);
		strcpy(hostname,skt->hostname);
		skrelease(sktnum,1);
	}

	strcpy(ml_cmnd,"user");

	while(1) {
		if(*ml_cmnd) {
			/*
			 * if command available, execute it
			 */
			mailpi(ml_cmnd);
		}
		/*
		 * prompt
		 */
		kb_puts("mail> ");
		/*
		 * read cmd from user
		 */
		mailgets(ml_cmnd,sizeof(ml_cmnd),1);
	}
}

/*
 * finduniq:
 *
 * find name that is a unique prefix of one of the entries in
 * a list.  Return position of the entry,
 * NONE if none, AMBIGUOUS if more than one.
 */

int finduniq(name,list,listsize)
char *name, *list[];
int listsize;
{
	register int i,j,ilen;

	j = NONE;
	ilen = strlen(name);
	strlwr(name);
	for(i=0; i<listsize; i++) {
		/*
		 * prefix
		 */
		if(!strncmp(name,list[i],ilen)) {
			if(ilen == strlen(list[i]))
				/*
				 * exact match
				 */
				return(i+1);
			if(j != NONE) {
				/*
				 * more than one match
				 */
				j = AMBIGUOUS;
			} else {
				/*
				 * note prefix found
				 */
				j = i+1;
			}
	  	}
	}
	/*
	 * prefix
	 */
	return(j);
}

/*
 * The general toggle flag routine
 */
int toggle(cstr,wstr,tflag,onstr,offstr)
char *cstr,*wstr,*onstr,*offstr;
register int *tflag;
{
	if(getword(cstr,wstr)) {
		strlwr(wstr);
		if(!strcmp(wstr,"off")) {
			*tflag = FALSE;
		} else
		if(!strcmp(wstr,"on")) {
			*tflag = TRUE;
		} else {
			*tflag = !*tflag;
		}
	} else {
		*tflag = !*tflag;
	}
	if(*tflag) {
		kb_puts(onstr);
	} else {
		kb_puts(offstr);
	}
	return(TRUE);
}

/*
 * Print help text string
 */
VOID prnthelp(n)
int n;
{
	char txt[80];
	FILE *mcmdfp;
	register int i;

	if( n>=1 && n<=NCMDS+1) {
		if((mcmdfp = fopen("TCP:maicmd.txt","r")) != NULL) {
			for(i=0; fgetss(txt,80,mcmdfp)!=NULL && i<n; i++) {
				;
			}
			fclose(mcmdfp);
			if(i == n) {
				kbprintf("%s\r\n", txt);
				return;
			}
		}
	}
	kb_puts("Help not available\r\n");
}
				
/*
 * MAIL PI
 *
 * Protocol interpreter for user interface commands
 * Will permit any command to be abbreviated uniquely.
 */

int mailpi(command)
char *command;
{
	register int i,j,k;
	int ivalue,l,m;
	int cmdno,lcnt,sprompt;
	char word[INFO_LEN];
	char answer[20];
	char *p;
	FILE *inp,*oup;

	/*
	 * print command
	 */
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("command: %s\r\n",command);
}
#endif
	/*
	 * get command number
	 */
	if(!getword(command,word))
		 return;
	/*
	 * removes first word from command
	 */
	cmdno = finduniq(word,mail_cmdlist,NCMDS);
	/*
	 * search cmdlist for prefix
	 */
	if(cmdno == AMBIGUOUS) {
		kb_puts("?-Ambiguous command\r\n");
		return;
	}
	/*
	 * not a prefix of any command
	 */
	if(cmdno == NONE) {
		kb_puts("?-Invalid command\r\n");
		return;
	}

	/*
	 * process commands
	 */
	if( !uflag	&&
		(
		cmdno==COPY	||
		cmdno==DELETE	||
		cmdno==DIR	||
		cmdno==INDEX	||
		cmdno==LAST	||
		cmdno==LIST	||
		cmdno==MAIL	||
		cmdno==NEWMAIL	||
		cmdno==READ	||
		cmdno==SCAN	||
		cmdno==SEND
		)
			) {
		kb_puts("Username / Password required.\r\n");
		return;
	}
	switch(cmdno) {
	case BYE:
	case EXIT:
	case QUIT:
		/*
		 * Reset subdirectory specifications
		 */
		cd("dk:");

		kb_puts("\r\nEscaping from MMAIL\r\n");
		exit(0);
		break;

	case COPY:
		/*
		 * Message Number
		 */
		if(question(command,100,"Copy Mail Message #: "))
			break;

		getword(command,word);
		sscanf(word,"%d", &ivalue);
		j = ivalue;

		if(j<1 || j>999) {
			kbprintf("\r\nInvalid Mail Index: #%d\r\n\r\n", j);
			break;
		}

		if(question(command,100,"To File: "))
			break;

		/*
		 * Mail Box Filespec
		 */
		sprintf(mailspec,"%-.6s.%03d", username,j);

		/*
		 * Create a unique file name for temporary mail data
		 */
		sprintf(filespec,"wf:mailbx.%03d", tljobn);

		/*
		 * Load directory path
		 */
		if(loadpath(mailpath))
			break;

		if((inp = rtopen(mailspec,"r",0,0)) == NULL) {
			kbprintf("\r\nNo Mail Message #%d\r\n\r\n", j);
			break;
		} else {
			/*
			 * Open mail file
			 */
			if((oup = fopen(filespec, "wn")) == NULL) {
				rtclose(inp);
				kbprintf("Unable to Create File\r\n\r\n");
				break;
			}
			/*
			 * copy mail to a temporary file
			 */
			while(fgetss(xs,BUFFERS,inp)) {
				xs[BUFFERS-1] = '\0';
				fprintf(oup,"%s\r\n",xs);
			}		
			fclose(oup);
			rtclose(inp);
		}

		/*
		 * Load directory path
		 */
		if(loadpath(defpath))
			break;

		if((inp = fopen(filespec,"r")) == NULL) {
			kbprintf("Unable to Read Temporary File\r\n\r\n");
			break;
		} else {
			/*
			 * Open new file
			 */
			if((oup = rtopen(command,"wn",0,0)) == NULL) {
				kbprintf("Unable to Create File\r\n\r\n");
				fclose(inp);
				break;
			}
			/*
			 * copy mail to a new file
			 */
			while(fgetss(xs,BUFFERS,inp)) {
				xs[BUFFERS-1] = '\0';
				fprintf(oup,"%s\r\n",xs);
			}		
			rtclose(oup);
			fclose(inp);
		}

		/*
		 * Delete temporary file
		 */
		delete(filespec);
		break;

#ifdef	DEBUGOPTION
	case DEBUG:	/* turn on/off debugging, optional level */
		if(sscanf(command,"%d",&i)>0) {
			debug = i;
			kbprintf("Debugging on(debug=%d).\r\n",debug);
		} else {
			toggle(command,word,&debug,
				"Debugging on.\r\n",
				"Debugging off.\r\n");
		}
		return;
#else
	case DEBUG:	/* no debugging */
		kb_puts("Debugging not available.\r\n");
		return;
#endif

	case DELETE:
		/*
		 * Message Number
		 */
		if(question(command,100,"Mail Message #: "))
			break;
		sscanf(command,"%d", &ivalue);
		j = ivalue;

		if(j<1 || j>999) {
			kbprintf("\r\nInvalid Mail Message #%d\r\n\r\n", j);
			break;
		}

		kbprintf("Delete mail file #%d ? ", j);
		if(rtresp(answer,sizeof(answer)))
			break;

		strlwr(answer);
		if(strchr(answer,'y') == NULL)
			break;

		if(loadpath(mailpath))
			break;

		sprintf(mailspec,"%-.6s.%03d", username,j);
		delfil(0,mailspec,0,0);
		lsterr();
		modidx(username,j,CLR_RCVD|CLR_READ);
		break;

	case HOME:	/* go to home directory */
		kbprintf("Home  directory is --> %s\r\n", gethome(defpath));
		cd(defpath);
		lsterr();
		break;

	case INDEX:
		/*
		 * Load directory path
		 */
		if(loadpath(mailpath))
			break;
		/*
		 * List all received mail
		 */
		mailspec[0] = '\0';
		for(i=1,lcnt=0,m=mailidx.mailid; i<1000; i++) {
			if(++m > 999)
				m = 1;
			if(mailidx.rcvd[m >> 3] & (1 << (m & 0x0007))) {
				sprintf(mailspec,"%-.6s.%03d", username,m);
				if((inp = rtopen(mailspec,"r",0,0)) == NULL) {
					modidx(username,m,CLR_RCVD|CLR_READ);
				} else {
					more(&lcnt,7);
					getinfo(HDR_F|HDR_S|HDR_D,inp);
					kbprintf(
	"#%3.3d  %-36.36s %-.40s\r\n", m, header.from, header.date
						);
					kbprintf(
	  "      %-.72s\r\n\r\n", header.subject
						);
					rtclose(inp);
				}
			}
			if(tstbrk()) {
				kb_puts("___ Index Listing Aborted ___\r\n");
				break;
			}
		}
		if(mailspec[0] == '\0')
			kb_puts("\r\nNo Received Mail\r\n\r\n");
		break;

	case INTERACTIVE:	/* turn on interactive prompting */
	case NONINTERACTIVE:	/* turn off interactive prompting */
	case PROMPT:		/* interactive prompting */
		if(cmdno == INTERACTIVE)
			prompt = FALSE;		/* will be toggled */
		if(cmdno == NONINTERACTIVE)
			prompt = TRUE;		/* will be toggled */
		toggle(command,word,&prompt,
			"Interactive mode on.\r\n",
			"Interactive mode off.\r\n");
		break;

	case LPWD:		/* local working directory */
		*command = '\0';

	case LCD:		/* change local directory */
		/*
		 * Load directory path
		 */
		if(loadpath(defpath))
			break;

		if(*(stpblk(command))) {
			lcd(command);
			getpath(defpath);
		}
		/*
		 * current directory
		 */
		kbprintf("Local directory is --> %s\r\n", defpath);
		return;

	case LRENAME:		/* local RENAME */
		/*
		 * Load directory path
		 */
		if(loadpath(defpath))
			break;

		if(question(command,100,"From: "))
			return;
		getword(command,&scratch[0]);
		if(question(command,100,"To:   "))
			return;
		getword(command,&scratch[100]);
		lrename();
		return;

	case LDELETE:		/* local DEL */
	case LDIR:		/* local DIR */
	case LLS:		/* local DIR */
	case LMKDIR:		/* local MKDIR */
	case LPROTECT:		/* local PROTECT */
	case LRMDIR:		/* local RMDIR */
	case LTYPE:		/* local TYPE */
	case LUNPROTECT:	/* local UNPROTECT */
		/*
		 * Load directory path
		 */
		if(loadpath(defpath))
			break;
		/*
		 * Preprocessing
		 */
		if(!*(stpblk(command))) {
			switch(cmdno) {
			case LDELETE:
			case LPROTECT:
			case LTYPE:
			case LUNPROTECT:
				if(question(command,100,"File(s): "))
					return;
				break;

			case LDIR:
			case LLS:
				lls(command);
				tstbrk();
				return;

			case LRMDIR:
			case LMKDIR:
				if(question(command,100,"Directory(s): "))
					return;
				break;
			}
		}
		/*
		 * for each arg
		 */
		while(!tstbrk() && getword(command,word)) {
			/*
			 * for each name
			 */
			switch(cmdno) {
			case LDELETE:
				ldelete(word);
				break;

			case LDIR:
			case LLS:
				lls(word);
				break;

			case LMKDIR:
				lmkdir(word);
				break;

			case LPROTECT:
				lprotect(word);
				break;

			case LRMDIR:
				lrmdir(word);
				break;

			case LTYPE:
				if((inp = rtopen(word,"r",0,0)) != NULL) {

				kbprintf("\r\nFile %s\r\n\r\n", word);
				while(   fgetss(scratch,
						sizeof(scratch)-1,
						inp) != NULL
						&& !tstbrk()) {
					kbprintf("%s\r\n", scratch);
				}
				rtclose(inp);

				} else {

				kbprintf("\r\nFile %s not found\r\n", word);

				}
				kb_puts("\r\n");
				break;

			case LUNPROTECT:
				lunprotect(word);
				break;

			}
		}
		return;

	case DIR:
	case LIST:
		/*
		 * Load directory path
		 */
		if(loadpath(mailpath))
			break;

		sprintf(ml_cmnd,"newmail");
		mailpi(ml_cmnd);
		if(!msgcnt)
			break;

		/*
		 * List all unread mail
		 */
		mailspec[0] = '\0';
		for(i=0,lcnt=0,m=mailidx.mailid; i<1000; i++) {
			if(++m > 999)
				m = 1;
			k = m >> 3;
			l = 1 << (m & 0x0007);
			if(mailidx.rcvd[k] & ~mailidx.read[k] & l) {
				sprintf(mailspec,"%-.6s.%03d", username,m);
				if((inp = rtopen(mailspec,"r",0,0)) == NULL) {
					modidx(username,m,CLR_RCVD|CLR_READ);
				} else {
					more(&lcnt,20);
					getinfo(HDR_F|HDR_S,inp);
					kbprintf(
	"#%3.3d  %-36.36s %-.40s\r\n", m, header.from, header.subject
						);
					rtclose(inp);
				}
			}
			if(tstbrk()) {
				kb_puts("___ Dir Listing Aborted ___\r\n");
				break;
			}
		}
		if(mailspec[0] == '\0')
			kb_puts("No Unread Mail\r\n");
		break;

	case LAST:
		/*
		 * Load directory path
		 */
		if(loadpath(mailpath))
			break;

		/*
		 * Scan for last mail message
		 */
		for (m=mailidx.mailid,i=0; m>0 && !i; --m) {
			if (mailidx.rcvd[m >> 3] & (1 << (m & 0x0007))) {
				sprintf(mailspec,"%-.6s.%03d", username,m);
				if((inp = rtopen(mailspec,"r",0,0)) == NULL) {
					modidx(username,m,CLR_RCVD|CLR_READ);
				} else {
					rtclose(inp);
					i = m;
				}
			}
		}
		for (m=999; m>mailidx.mailid && !i; --m) {
			if (mailidx.rcvd[m >> 3] & (1 << (m & 0x0007))) {
				sprintf(mailspec,"%-.6s.%03d", username,m);
				if((inp = rtopen(mailspec,"r",0,0)) == NULL) {
					modidx(username,m,CLR_RCVD|CLR_READ);
				} else {
					rtclose(inp);
					i = m;
				}
			}
		}

		if (i) {
			sprintf(ml_cmnd,"read %d",i);
			mailpi(ml_cmnd);
		} else {
			kb_puts("No Mail Messages\r\n");
		}
		break;

	case MAIL:		/* go to mail directory */
		kbprintf("Mail  directory is --> %s\r\n", mailpath);
		lcd(mailpath);
		getpath(defpath);
		break;

	case QMARK:
	case HELP:
		if(!command[0]) {
			kb_puts(
			"These valid commands may be abbreviated:\r\n");
			/*
			 * display command list
			 */
			scratch[0] = '\0';
			for(i=0,j=0; i<NCMDS; i++) {
				/*
				 * skip blank elements
				 */
				if(mail_cmdlist[i] == NULL)
					continue;
				/*
				 * get word from list
				 */
				if(j%5 != 4) {
					sprintf(word,"%-16s",
						mail_cmdlist[i]);
					strcat(scratch,word);
				} else {
					sprintf(word,"%s\r\n",
						mail_cmdlist[i]);
					strcat(scratch,word);
					kb_puts(scratch);
					scratch[0] = '\0';
				}
				j++;
			}
			/*
			 * last line
			 */
			if(scratch[0] != '\0') {
				kb_puts(scratch);
				kb_nline();
			}
			/*
			 * print filespec note
			 */
			kb_nline();
			rtusage();
		} else {
			/*
			 * help for specific commands
			 */
			while(getword(command,word)) {
				/*
				 * which command ?
				 */
				i = finduniq(word,mail_cmdlist,NCMDS);
				if(i == AMBIGUOUS) {
				    /*
				     * non-unique command name
				     */
	kbprintf("?-Ambiguous help command %s\r\n", word);
				} else {
				    /*
				     * no such command
				     */
				    if(i == NONE) {
	kbprintf("?-Invalid help command %s\r\n",word);
				    } else {
					/*
					 * display help string
					 */
					prnthelp(i);
				    }
				}
			}
		}
		return;

	case READ:
		if(*command) {
			/*
			 * Use argument first
			 */
			j = 0;
		} else {
			/*
			 * Check for unread mail
			 */
			for(i=0,j=0,m=mailidx.mailid; i<1000; i++) {
				if(++m > 999)
					m = 1;
				k = m >> 3;
				l = 1 << (m & 0x0007);
				if(mailidx.rcvd[k] & ~mailidx.read[k] & l) {
					j = m;
					break;
				}
			}
		}
		if(!j) {
			/*
			 * Message Number
			 */
			if(question(command,100,"Mail Message #: "))
				break;
			sscanf(command,"%d", &ivalue);
			j = ivalue;
		}
		if(j<1 || j>999) {
			kbprintf("\r\nInvalid Mail Message #%d\r\n\r\n", j);
			break;
		}
		/*
		 * Load directory path
		 */
		if(loadpath(mailpath))
			break;
		/*
		 * Read selected mail file
		 */
		sprintf(mailspec,"%-.6s.%03d", username,j);
		if((inp = rtopen(mailspec,"r",0,0)) == NULL) {
			kbprintf("\r\nNo Mail Message #%d\r\n\r\n", j);
			modidx(username,j,CLR_RCVD|CLR_READ);
		} else {
			kbprintf("\r\nMail Message #%d  [%s]\r\n",j,mailspec);
			lcnt = 0;
			while(fgetss(scratch,sizeof(scratch)-1,inp)!=NULL &&
					!tstbrk()) {
				more(&lcnt,20);
				kbprintf("%s\r\n", scratch);
			}
			rtclose(inp);
			modidx(username,j,SET_RCVD|SET_READ);
		}
		break;

	case SCAN:
		kb_puts("Scanning  ...\r\n");

		/*
		 * Load directory path
		 */
		if(loadpath(mailpath))
			break;

		/*
		 * Clear All Entries
		 */
		clridx(username,CLR_RCVD|CLR_READ);

		/*
		 * Scan For Mail Files
		 */
		sprintf(mailspec,"%-.6s.*", username);
		p = firstname(mailspec);
		while (p != NULL) {
			rtparse(p);
			if (sscanf(rtext(),"%03d",&ivalue) == 1) {
				modidx(username,ivalue,SET_RCVD);
			}
			p = nextname();
		}
		break;

	case SEND:
		/*
		 * Check for a filespec
		 */
		getword(command,header.filename);
		command[0] = '\0';
		loadpath(defpath);
		if(header.filename[0] != '\0') {
			if(strchr(header.filename,':')) {
				expand(	header.expanded,
					header.filename);
			} else {
				expand(	header.expanded,
					rtfile(header.filename,getdef()));
			}
			if((inp = rtopen(header.filename,"rn",0,0)) == NULL) {
				kbprintf("No file %s\r\n", header.expanded);
				break;
			} else {
				rtclose(inp);
			}
		}

		/*
		 * Received:
		 */
		sprintf(header.rcvd,"%s  (%s%s)",
			hostname, vrstxt[1]+1, vrstxt[2]);

		/*
		 * Date:
		 */
		strcpy(header.date,datime());

		/*
		 * From:
		 */
		strcpy(header.from,username);

		/*
		 * To:
		 */
		if(question(command,INFO_LEN,"To: "))
			break;
		getword(command,header.to);

		/*
		 * Subject:
		 */
		kb_puts("Subject: ");
		if(rtresp(header.subject,INFO_LEN))
			break;

		/*
		 * Message
		 */
		if(wrtmsg())
			break;

		/*
		 * Send the Mail
		 */
		mailmesg();

		/*
		 * Load Mail Path
		 */
		if(loadpath(mailpath))
			break;

		/*
		 * Ask about temporary file
		 */
		if(msgflag) {
			kbprintf("?-MAIL-Message saved in file %s\r\n",
				header.expanded);
			sprompt = prompt;
			prompt = TRUE;
			kb_puts("?-MAIL-");
			delfil(0,header.filename,1,0);
			lsterr();
			prompt = sprompt;
			msgflag = 0;
		}

		/*
		 * Reload mailidx
		 */
		sprintf(mailspec,"%-.6s.idx", username);
		if((inp = rtopen(mailspec,"rn",0,0)) != NULL) {
			fread(&mailidx,sizeof(mailidx),1,inp);
			rtclose(inp);
		}

		/*
		 * Reload Default Path
		 */
		loadpath(defpath);

		break;

	case STATUS:		/* display status info */
		kbprintf("User id: %s\r\n", username);
#ifdef	DEBUGOPTION
		if(debug) {
			kbprintf("Debugging on.(Debug=%d)\r\n",debug);
		} else {
			kb_puts("Debugging off.\r\n");
		}
#endif
		if(wild) {
			kb_puts("Filename wildcards enabled.\r\n");
		} else {
			kb_puts("Filename wildcards disabled.\r\n");
		}
		if(prompt) {
			kb_puts("Interactive prompting on.\r\n");
		} else {
			kb_puts("Interactive prompting off.\r\n");
		}
		break;

	case USER:
		uflag = 0;
		/*
		 * username
		 */
		if(question(command,100,"Username: "))
			break;
		getword(command,word);
		username[0] = '\0';
		strncat(username,word,USERPASSLEN);
		strlwr(username);
		/*
		 * password
		 */
		if(!(*stpblk(command))) {
			if(pswdreqd) {
				kb_puts("Password: ");
				if(mailgets(command,100,0) == ABORT)
					break;
			}
		}
		getword(command,word);
		password[0] = '\0';
		strncat(password,word,USERPASSLEN);
		strlwr(password);
		/*
		 * Check username / password
		 */
		if(!checkusps(username,password,pswdreqd)) {
			kb_puts("Invalid Username / Password.\r\n");
			break;
		}
		/*
		 * Check Mail privileges
		 */
		if(!(user.userflag[1] & (LSMTP_PRIV | RSMTP_PRIV))) {
			kb_puts("No Privilege for MAIL.\r\n");
		}
		strcpy(mailpath,uspspath);
		uflag = 1;

	case NEWMAIL:
		msgcnt = 0;
		/*
		 * Load directory path
		 */
		if(loadpath(mailpath))
			break;
		/*
		 * Report number of messages waiting to be read
		 */
		sprintf(mailspec,"%-.6s.idx", username);
		if((inp = rtopen(mailspec,"rn",0,0)) == NULL) {
			kb_puts("\r\nNo Mail\r\n\r\n");
			/*
			 * Create index file if not opened
			 */
			if(!makidx(username)) {
				kb_puts(
				"?-MAIL-Failed to create index file\r\n");
			}
		} else {
			fread(&mailidx,sizeof(mailidx),1,inp);
			rtclose(inp);
			for(i=0; i<1000; i++) {
				k = i >> 3;
				l = 1 << (i & 0x0007);
				if(mailidx.rcvd[k] & ~mailidx.read[k] & l) {
					msgcnt += 1;
				}
			}
			if(!msgcnt) {
				kb_puts("\r\nNo Mail\r\n\r\n");
			} else {
				kbprintf("\r\n%d New Mail Message%s\r\n\r\n",
				msgcnt , (msgcnt==1) ? "" : "s");
			}
		}
		break;

	case VERSION:		/* display current MAIL version */
		printtxt(vrstxt);
		return;

	case WILD:	/* wildcard expansion */
		toggle(command,word,&wild,
			"Wildcards enabled.\r\n",
			"Wildcards disabled.\r\n");
		break;

	default:
		break;
	}
}

/*
 * more
 */
VOID more(i,j)
int *i,j;
{
	*i += 1;
	if(*i%j == 0) {
		kb_puts(  "  ... more ... <CR>");
		while(!fndbrk && tt_inp()!='\015') {
			suspnd(0);
		}
		kb_puts("\r                   \r");
	}
}

/*
 * General looping question routine
 * loops until a response is given
 *	returns 1 on ABORT
 *	   else 0
 */
int question(cstr,clen,qstr)
char *cstr,*qstr;
int clen;
{
	while(!(*(stpblk(cstr)))) {
		/*
		 * get arg from user
		 */
		kb_puts(qstr);
		if(rtresp(cstr,clen))
			return(1);
		}
	return(0);
}

/*
 * Routine to get a keyboard response
 *	returns 1 on ABORT
 *	   else 0
 */
int rtresp(st,ln)
char *st;
int ln;
{
	return((mailgets(st,ln,1)==ABORT) ? 1 : 0);
}

/*
 * tstbrk
 *
 * if fndbrk is set then:
 *	(1)	terminate command file mode
 *	(2)	return(1)
 * else
 *		return(0)
 */
int tstbrk()
{
	if(fndbrk) {
		if(fromfp != NULL) {
			fclose(fromfp);
			fromfp = NULL;
			fromtty = TRUE;
			kb_puts("\r\nCommand File Input Aborted\r\n");
		}
		fndbrk = 0;
		return(1);
	} else {
		return(0);
	}
}

/*
 * loadpath
 *
 * load the directory path if required
 */
int loadpath(str)
char *str;
{
	char str2[94];

	if(!streq(str,getpath(str2))) {
		if(cd(str)) {
			lsterr();
			cd(str2);
			return(1);
		}
	}
	return(0);
}

/*
 *	Various routines that interface with the
 *	TSXUTL.C utilities.
 */

VOID lcd(st)
register char *st;
{
	char path[100];

	getpath(path);
	if(cd(st)) {
		lsterr();
		cd(path);
		lsterr();
	}
}

VOID ldelete(st)
char *st;
{
	VOID ldelfil();

	dispatch(ldelfil,st);
}

VOID ldelfil(st)
char *st;
{
	delfil(0,st,prompt,wild);
}

VOID lls(st)
char *st;
{
	int dspdir();

	dispatch(dspdir,st);
}

VOID lmkdir(st)
char *st;
{
	int mkdir();

	dispatch(mkdir,st);
}

VOID lprotect(st)
char *st;
{
	VOID setfilp();

	dispatch(setfilp,st);
}

VOID setfilp(st)
char *st;
{
	setclrp(st,1,wild);
}

VOID lrename()
{
	VOID newname();

	dispatch(newname,&scratch[0]);
}

VOID newname(st)
char *st;
{
	rename(st,&scratch[100],fromtty&&prompt,wild);
}

VOID lrmdir(st)
char *st;
{
	VOID rmdir();

	dispatch(rmdir,st);
}

VOID rmdir(st)
char *st;
{
	delfil(1,st,prompt,wild);
}

VOID lunprotect(st)
char *st;
{
	VOID clrfilp();

	dispatch(clrfilp,st);
}

VOID clrfilp(st)
char *st;
{
	setclrp(st,0,wild);
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * mailgets
 *
 * read a line from the keyboard
 * returns ABORT if keyboard input aborted
 * or non-zero on success
 */

int mailgets(str,lim,echo)
register char *str;	/* where to put the line */
int lim,echo;		/* max chars to read, echo? */
{
	register char *save;
	register int c;

	save = str;		/* beginning of line */
	*save = '\0';
	lim -= 1;

	if(tstbrk()) {
		kb_puts("^C\r\n");
		return(ABORT);
	}
	if(!fromtty) {
		if(fromfp != NULL) {
			if(fgetss(str,lim,fromfp) != NULL) {
				str[lim] = '\0';
				if(echo) {
					kb_puts(str);
					kb_nline();
				}
			} else {
				fclose(fromfp);
				fromfp = NULL;
				fromtty = TRUE;
				kb_puts("[EOF]\r\n");
			}
			return(strlen(str));
		} else {
			fromtty = TRUE;
		}
	}
	while(1) {
		/*
		 * build string from keyboard
		 */
		c = kb_gets(str,lim,echo);
		if(1 <= c && c <= 31) {
			kb_nline();
			return(strlen(save));
		}
		/*
		 * check for abort
		 */
		if(tstbrk()) {
			*save = '\0';
			kb_puts("^C\r\n");
			return(ABORT);	
		}
		suspnd(0);
	}
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len 79
		 */
		q = stptok(p, word, 79, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

/*
 *  checkusps ( us, ps, pflag )
 *
 *  Check the password file for the user/password
 *  combination. An inaccessable password file
 *  results in an invalid return.
 *
 *  If the user/password are validated then
 *  the mail directory is accessed else the
 *  default directory is accessed. An inaccessable
 *  mail and default directory results in an invalid return.
 *
 *  Returns valid(1)/invalid(0)
 */
int checkusps(us,ps,pflag)
char *us,*ps;
int pflag;
{
	FILE *fp;
	
	if(NULL==(fp = rtopen(pass,"rn",0,0))) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): password file not found: %s\r\n", pass);
}
#endif
		return(0);
	}
	while (NULL != fread(&user,sizeof(struct userblock),1,fp)) {
		/*
		 * does username / password check ?
		 */
		if(!strncmp(us,&user.username,USERPASSLEN) &&
				(!pflag ||
				user.userflag[0]&PASSNOTREQUIRED ||
				Scompass(ps,&user.password))
			) {
			rtclose(fp);
			/*
			 * User found
			 */
			getpath(pathname);
			/*
			 * Set Users Mailbox Directory
			 */
			if(user.mailbox.path[0]!='\0' &&
				!cd(&user.mailbox.path)) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): mailbox directory: %s\r\n", user.mailbox.path);
}
#endif
				getpath(uspspath);
				cd(pathname);
				return(1);
			} else
			/*
			 * Set Users default directory
			 */
			if(user.defdir.path[0]!='\0' &&
				!cd(&user.defdir.path)) {
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): default directory: %s\r\n", user.defdir.path);
}
#endif
				getpath(uspspath);
				cd(pathname);
				return(1);
			}
			cd(pathname);
			return(0);
		}
	}
	rtclose(fp);
#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("checkusps(): Username not found.\r\n");
}
#endif
	return(0);
}

/*
 *  Scompass ( ps, en )
 *
 *  Compute and check the encrypted password
 */
int Scompass(ps,en)
register char *ps,*en;
{
	register int i,ck;
	char *p,c;

	ck = 0;
	p = ps;
	/*
	 * checksum the string
	 */
	while (*p)
		ck += *p++;
	c = ck;
	/*
	 * XOR with checksum
	 */
	i = USERPASSLEN;
	while (i--) {
		if((((*ps ^ c)|32)&127)!=*en)
			return(0);
		/*
		 * increment checksum to hide length
		 */
		if(*ps) {
			ps++;
		} else {
			c++;
		}
		en++;
	}
	return(1);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

int strmatch(s,t)
register char *s,*t;
{
	register int i,j;

	j = strlen(s);
	for(i=0; i<j; i++) {
		if(tolower(*s++) != tolower(*t++))
			return(0);
	}
	return(1);
}


VOID getinfo(gt,fp)
register int gt;
FILE *fp;
{
	char scr[INFO_LEN];

	header.rcvd[0]    = '\0';
	header.date[0]    = '\0';
	header.from[0]    = '\0';
	header.mesgid[0]  = '\0';
	header.to[0]      = '\0';
	header.subject[0] = '\0';

	while(gt && (fgetss(scr,INFO_LEN-1,fp) != NULL)) {
		if((gt&HDR_R) && strmatch("Received: ",scr)) {
			strncpy(header.rcvd,scr,INFO_LEN-1);
			header.rcvd[INFO_LEN-1] = '\0';
			gt &= ~HDR_R;
		} else
		if((gt&HDR_D) && strmatch("Date: ",scr)) {
			strncpy(header.date,scr,INFO_LEN-1);
			header.date[INFO_LEN-1] = '\0';
			gt &= ~HDR_D;
		} else
		if((gt&HDR_F) && strmatch("From: ",scr)) {
			strncpy(header.from,scr,INFO_LEN-1);
			header.from[INFO_LEN-1] = '\0';
			gt &= ~HDR_F;
		} else
		if((gt&HDR_M) && strmatch("Message-Id: ",scr)) {
			strncpy(header.mesgid,scr,INFO_LEN-1);
			header.mesgid[INFO_LEN-1] = '\0';
			gt &= ~HDR_M;
		} else
		if((gt&HDR_T) && strmatch("To: ",scr)) {
			strncpy(header.to,scr,INFO_LEN-1);
			header.to[INFO_LEN-1] = '\0';
			gt &= ~HDR_T;
		} else
		if((gt&HDR_S) && strmatch("Subject: ",scr)) {
			strncpy(header.subject,scr,INFO_LEN-1);
			header.subject[INFO_LEN-1] = '\0';
			gt &= ~HDR_S;
		}
	}
}

/*
 * wrtmsg
 *
 * write the message to a unique file
 */
int wrtmsg()
{
	FILE *fp;
	register int idx;

	msgflag = 0;

	if(header.filename[0] != '\0') {
		return(0);
	}

	/*
	 * Load mail directory path and update index file
	 */
	if(loadpath(mailpath)) {
		kb_puts("?-MAIL-Unable to Set Mail Path\r\n");
		return(1);
	}

	idx = modidx(username,0,INC_MLTMP);
	if(!idx) {
		kb_puts("?-MAIL-Failed to update index file\r\n");
		return(1);
	}

	sprintf(header.filename,"%s%-.4sml.%03d", getdef(), username, idx);
	expand(header.expanded,header.filename);

	if((fp = rtopen(header.filename,"wn",0,0)) != NULL) {
		kbprintf("Message file %s opened\r\n", header.expanded);
		kb_puts("Enter Message: [last line is '.<CR>']\r\n");
	} else {
		kbprintf("Unable to open message file %s\r\n",
			header.expanded);
		return(1);
	}

	while(!rtresp(scratch,sizeof(scratch))) {
		if(streq(scratch,".")) {
			rtclose(fp);
			msgflag = 1;
			return(0);
		}
		fprintf(fp,"%s\r\n", scratch);
	}

	rtclose(fp);
	delfil(0,header.filename,1,0);
	lsterr();
	return(1);
}

int
mailmesg()
{
	register FILE *inp,*oup;
	register int idx;

	if((inp = rtopen(header.filename,"r",0,0)) == NULL) {
		kbprintf("?-MAIL-Unable to open message file %s\r\n",
				header.expanded);
		return(1);
	}

	/*
	 * Create a unique file name for temporary mail data
	 */
	sprintf(filespec,"wf:mailbx.%03d", tljobn);

	/*
	 * Open mail file
	 */
	if((oup = fopen(filespec, "wn")) == NULL) {
		rtclose(inp);
		kb_puts("?-MAIL-Unable to Create Temporary File\r\n");
		return(1);
	}

	/*
	 * Write the Header
	 */
	fprintf(oup,"Received: by %s\r\n", header.rcvd);
	fprintf(oup,"Date: %s\r\n", header.date);
	fprintf(oup,"From: %s\r\n", header.from);
	fprintf(oup,"Message-Id: %s\r\n", header.expanded);
	fprintf(oup,"To: %s\r\n", header.to);
	fprintf(oup,"Subject: %s\r\n", header.subject);
	fprintf(oup,"\r\n");
	/*
	 * Copy message to the temporary file
	 */
	while(fgetss(xs,BUFFERS,inp)) {
		xs[BUFFERS-1] = '\0';
		fprintf(oup,"%s\r\n",xs);
	}		
	fclose(oup);
	rtclose(inp);

	/*
	 * Load local mail directory path and update index file
	 */
	if(loadpath(mailpath)) {
		kb_puts("?-MAIL-Unable to Set Mail Path\r\n");
		delete(filespec);
		return(1);
	}

	if (!(idx = modidx(username,0,INC_MLTMP))) {
		kb_puts("?-MAIL-Failed to update index file\r\n");
		return(1);
	}

	if((inp = fopen(filespec,"r")) == NULL) {
		kb_puts("?-MAIL-Unable to Read Temporary File\r\n");
		delete(filespec);
		return(1);
	}

	/*
	 * Open new file
	 */
	sprintf(mailspec,"ml%-.4s.%03d", username, idx);
	if((oup = rtopen(mailspec,"wn",0,0)) == NULL) {
		kb_puts("?-MAIL-Unable to Create File\r\n");
		fclose(inp);
		return(1);
	}

	/*
	 * copy mail to a new file
	 */
	while(fgetss(xs,BUFFERS,inp)) {
		xs[BUFFERS-1] = '\0';
		fprintf(oup,"%s\r\n",xs);
	}		
	rtclose(oup);
	fclose(inp);

	/*
	 * Delete temporary file
	 */
	delete(filespec);

	/*
	 * Activate MAILER
	 */
	cl_xmit(TASKCLASS,STARTJOB,mailer);

	return(0);
}

                                     