/* lprint.c */

#define	LPRINTMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vlprnt.h"
#include "dfault.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "rcdlck.h"
#include "inicli.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();		/* (txt) print text */
extern	VOID	lsterr();		/* error lister */
extern	int	response();		/* dumby routine for TSXUTL.C */
extern	int	getword();		/* (string,word) extract a word */
extern	VOID	strlwr();		/* (st) convert to lower case */
extern	int	checkque();		/* compare cfA with queue list */
extern	VOID	scncfA();		/* (fp) scan info from cfA file */
extern	int	ldcfA();		/* load cfA file into memory */
extern	VOID	dmpcfA();		/* deallocate space for cfA data */
extern	int	ldcfg();		/* load cfg file into memory */
extern	VOID	dmpcfg();		/* deallocate space for cfg data */
extern	VOID	new();			/* (n) allocate n bytes */
extern	int	c_print();		/* prepare src and dst files */
extern	int	outc();			/* (c,dfh) output a character */
#endif

extern	int	f_passall();		/* (sfh,dfh) printing filter */
extern	int	f_print();		/* (sfh,dfh) printing filter */
extern	int	f_control();		/* (sfh,dfh) printing filter */
extern	int	f_fortran();		/* (sfh,dfh) printing filter */

extern	char	*stptok();		/* (p,t,l,d) stop on token */
extern	char	*stpblk();		/* (ch) stop on block */
extern	char	*quefile();		/* build the queue output filespec */
extern	char	*rdcfA();		/* read next line from cfA data */
extern	char	*rdcfg();		/* read next line from cfg data */

/*
 * List of LPD options
 */

#define	C_CLASS		('C')
#define	C_HOST		('H')
#define	C_INDENT	('I')
#define	C_JOB		('J')
#define	C_BANNER	('L')
#define	C_MAIL		('M')
#define	C_SOURCE	('N')
#define	C_USER		('P')
#define	C_QUEUE		('Q')
#define	C_SLINK		('S')
#define	C_TITLE		('T')
#define	C_ULINK		('U')
#define	C_WIDTH		('W')
#define	C_ZOPT		('Z')
#define	C_RTROFF	('1')
#define	C_ITROFF	('2')
#define	C_BTROFF	('3')
#define	C_STROFF	('4')
#define	C_CIF		('c')
#define	C_DVI		('d')
#define	C_PRINT		('f')
#define	C_PLOT		('g')
#define	C_BUPLOT	('k')
#define	C_CONTROL	('l')
#define	C_DITROFF	('n')
#define	C_POSTSCRIPT	('o')
#define	C_PR		('p')
#define	C_FORTRAN	('r')
#define	C_TROFF		('t')
#define	C_RASTER	('v')
#define	C_PALLADIUM	('z')

/*
 *	Global Buffers / Pointers
 */

#define	BLOCKSIZE	(512)
#define BUFFERS		(128)
#define	STRLEN		(80)

char	xs[BLOCKSIZE];		/* copying buffer */
				/* dumby buffer for TSXUTL.C */

int	debug;			/* debugging variable */

int	tljobn;			/* local job number */
				/* required by TSXUTL.C */

static
	tflag = 0;		/* timed print check flag */

static char
	scratch[BUFFERS];	/* scratch string */

static char			/* LPRINT temporary file directory */
	lpddir[BUFFERS];

static char *			/* LPRINT configuration file */
	lpdcfl = "TCP:lpdqrm.cfg";
static FILE *			/* LPRINT configuration file handle */
	lpdcfh = NULL;

static	char			/* control file name */
	cfAfl[BUFFERS];
static	FILE			/* control file handle */
	*cfAfh = NULL;

static	char			/* data file name */
	dfAfl[BUFFERS];
static	FILE			/* data file handle */
	*dfAfh = NULL;

static	char			/* queue output file name */
	quefl[BUFFERS];

static	char			/* source file name */
	srcfl[BUFFERS];
static	FILE			/* source file handle */
	*srcfh = NULL;

static	char			/* destination file name */
	dstfl[BUFFERS];
static	FILE			/* destination file handle */
	*dstfh = NULL;

static	char			/* temporary file name */
	tmpfl[BUFFERS];
static	FILE			/* temporary file handle */
	*tmpfh = NULL;

static	char			/* expanded filespec */
	expfl[BUFFERS];

struct	lnkdtxt {
	struct	lnkdtxt	*next;
	char		*line;
};

struct	lnkdtxt			/* beginning of configuration list */
	*cfg = NULL;
struct	lnkdtxt			/* internal scanning pointer */
	*nxtcfg = NULL;

static	char			/* text line from cfg file */
	cfgstr[STRLEN];

struct	lnkdtxt			/* beginning of cfA list */
	*cfA = NULL;
struct	lnkdtxt			/* internal scanning pointer */
	*nxtcfA = NULL;

static	char			/* text line from cfA file */
	cfAstr[STRLEN];

struct	cinfo {
	char	que[STRLEN];
	char	host[STRLEN];
	char	user[STRLEN];
	char	src[STRLEN];
	char	file[STRLEN];
	char	zopt[STRLEN];
	int	indent;
	int	width;
};

static	struct	cinfo	cfAinfo;

struct	qinfo {
	char	que[STRLEN];
	char	host[STRLEN];
	char	user[STRLEN];
	char	dev[STRLEN];
};

static	struct	qinfo	queinfo;

/*
 * Debugging options
 *
 *	bit 0	(0x01)	checkque()
 *	bit 1	(0x02)	quefile()
 *	bit 2	(0x04)	scncfA()
 *	bit 3	(0x08)	c_print()
 */

static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  LPRINT [?] [-d level] [-p filespec] [-t n] [-v]",
       "	?               List the Help Text and Exit LPRINT",
       "	d  level	Debug Level",
       "	        1 -	enable checkque printing",
       "	        2 -	enable quefile printing",
       "	        4 -	enable scncfA printing",
       "	        8 -	enable c_print printing",
#else
       "  LPRINT [?] [-p filespec]",
       "	?               List the Help Text and Exit LPRINT",
#endif
       "	p  filespec	Specify the Configuration Filespec",
       "	t  n (minutes)	Continuous Scanning Time Interval",
	"	v		Verbose Mode",
       "",
       0
       };

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}


main(argc,argv)
int argc;
char *argv[];
{
	char c;
	register int i,j,k;

	/*
	 * Get Job Number
	 */
	tljobn = lcljob();

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * Verbose Mode Off
	 */
	kb_prnt = 0;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    kb_prnt = 1;
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = -1;
				break;
#endif
			case 'p':	/* configuration file */
				lpdcfl = argv[++i];
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
			case 't':	/* time scan interval */
				sscanf(argv[++i],"%d",&tflag);
				if ((tflag < 0) || (tflag > 60))
					tflag = 0;
				break;

			case 'v':	/* verbose mode on */
				kb_prnt = 1;
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		}
	}

#ifdef	DEBUGOPTION
	if (debug)
		kb_prnt = 1;
#endif

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	do {
		lpscan();

		if (tflag) {
			for(i=0; i<tflag && !fndbrk; i++) {
				suspnd((int) 60*TICKSPERSEC);
			}
		}

	} while (tflag && !fndbrk);

	if(fndbrk) 
		kb_puts("\r\n^C\r\n");

	cd("dk:");

	kb_puts("\r\nEscaping from LPRINT\r\n");
	exit(0);
}


VOID lpscan()
{
	register char *p;
	register int i,skip;

	/*
	 * Load Configuration File
	 */
	if (!ldcfg()) {
		kb_puts("\r\nLPDQRM Configuration File Required\r\n");
		tflag = 0;
		return;
	}

	/*
	 * First line is sequence number
	 * Second line is temporary file directory
	 */
	if ((rdcfg(1) == NULL) || (rdcfg(0) == NULL)) {
		kb_puts("\r\nLPDQRM Configuration File Error\r\n");
		tflag = 0;
		return;
	}

	if (!getword(cfgstr,lpddir)) {
		strcpy(lpddir,"sy:");
	}

	/*
	 * Go to LPDQRM file directory
	 */
/*1*/	if (!cd(lpddir)) {

	skip = 0;
/*2*/	while(((p = firstname("cfA.*")) != NULL) && !fndbrk) {

	/*
	 * Skip over files
	 */
	for (i=0; i<skip; i++) {
		p = nextname();
	}
	if (p == NULL)
		break;

	/*
	 * Save File Name
	 */
	strcpy(cfAfl,p);

	/*
	 * Get LPD information
	 */
	ldcfA(filiop());
	lastname();

	/*
	 * Verify Queue Entry
	 */
/*3*/	if(!checkque()) {
		/*
		 * Delete all associated files if
		 * queue, host, and user are not valid.
		 */
		delfA();
	} else {
		/*
		 * Scan cfA file performing printing
		 */
		if (scncfA()) {
			/*
			 * If some error occurred while printing
			 * then skip and try again later.
			 */
			skip += 1;
		} else {
			/*
			 * Delete control file when successful
			 */
			delete(cfAfl);
		}
/*3*/	}

/*2*/	}

/*1*/	}
	/*
	 * Deallocate space
	 */
	dmpcfA();
	dmpcfg();
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * This routine is a dumby routine for TSXUTL.C
 * It should never be called, but returns a 1 [ABORT]
 */
int rtresp()
{
	kb_puts("rtresp: This dumby routine should never be called");
	return(1);
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len STRLEN
		 */
		q = stptok(p, word, STRLEN-1, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

/*
 *  checkque ()
 *
 *  Scan the cfA data for queue/host/user/source-file information.
 *  Check the configuration data for a queue/host/user match.
 *  An unknown queue results in an invalid return.
 *
 *  Returns valid(1)/invalid(0)
 */
int checkque()
{
	char word[STRLEN];

	/*
	 * Scan cfA for queue, host, user, and a single source file
	 */
	cfAinfo.que[0]  = '\0';
	cfAinfo.host[0] = '\0';
	cfAinfo.user[0] = '\0';
	cfAinfo.src[0]  = '\0'; cfAinfo.src[1]  = '\0';

	nxtcfA = cfA;
	while (rdcfA(0) != NULL) {
		strlwr(cfAstr+1);
		switch(cfAstr[0]) {
		case C_QUEUE:		/* 'Q' */
			strcpy(cfAinfo.que,cfAstr+1);
			break;

		case C_HOST:		/* 'H' */
			strcpy(cfAinfo.host,cfAstr+1);
			break;

		case C_USER:		/* 'P' */
			strcpy(cfAinfo.user,cfAstr+1);
			break;

		case C_SOURCE:		/* 'N' */
			if (   (cfAinfo.src[0] == '\0') &&
			       (cfAinfo.src[1] == '\0')) {
				strcpy(cfAinfo.src,cfAstr+1);
			} else {
				cfAinfo.src[0] = '\0';
				cfAinfo.src[1] = '\1';
			}
			break;

		default:
			break;
		}
	}

	/*
	 * First line is sequence number
	 */
	getword(rdcfg(1),word);

#ifdef	DEBUGOPTION
if(debug&0x01) {
	printf("checkque(): sequence number = '%s'\r\n", word);
}
#endif
	/*
	 * Second line is temporary file directory
	 */
	getword(rdcfg(0),word);

#ifdef	DEBUGOPTION
if(debug&0x01) {
	printf("checkque(): file directory  = '%s'\r\n", word);
}
#endif
	/*
	 * Third line is password file directory
	 */
	getword(rdcfg(0),word);

#ifdef	DEBUGOPTION
if(debug&0x01) {
	printf("checkque(): paswrd = '%s'\r\n", word);
}
#endif
	/*
	 * Subsequent lines are queue lists
	 */
	while (NULL != rdcfg(0)) {

#ifdef	DEBUGOPTION
if(debug&0x01) {
	printf("checkque(): cfA = '%s'  '%s'  '%s'\r\n",
		cfAinfo.que,cfAinfo.host,cfAinfo.user);
	printf("%s\r\n", cfgstr);
}
#endif
		/*
		 * Get queue/host/user/device information
		 */
		strlwr(cfgstr);
		getword(cfgstr,queinfo.que);
		getword(cfgstr,queinfo.host);
		getword(cfgstr,queinfo.user);
		getword(cfgstr,queinfo.dev);

		if(streq(cfAinfo.que,queinfo.que)) {
			if (streq("*",cfAinfo.host) ||
			    streq("*",queinfo.host) ||
			    streq(cfAinfo.host,queinfo.host)) {
				if (streq("*",cfAinfo.user) ||
				    streq("*",queinfo.user) ||
				    streq(cfAinfo.user,queinfo.user)) {
					/*
					 * Queue found
					 */
					return(1);
				}
			}
		}		
	}
	return(0);
}

/*
 * scncfA
 *
 * Read printing jobs from a cfA file
 * and perform required operations in sequence.
 */

VOID scncfA()
{
	register int fail,skip;

/*
 *	These were read by checkque()
 *
 *	cfAinfo.que[0]  = '\0';
 *	cfAinfo.host[0] = '\0';
 *	cfAinfo.user[0] = '\0';
 *	cfAinfo.src[0]  = '\0';
 */
	cfAinfo.file[0] = '\0';
	cfAinfo.zopt[0] = '\0';
	cfAinfo.indent	= 0;
	cfAinfo.width	= 132;

	fail = 0;
	skip = 0;
	nxtcfA = cfA;
	while (rdcfA(0) != NULL) {

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("scncfA(): %s\r\n", cfAstr);
}
#endif

		strlwr(cfAstr+1);
		switch(cfAstr[0]) {
		case C_PRINT:		/* 'f' */

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("scncfA(): calling c_print(f_print)\r\n");
}
#endif

			strcpy(cfAinfo.file,cfAstr+1);
			fail += c_print(f_print);
			break;

		case C_CONTROL:		/* 'l' */

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("scncfA(): calling c_print(f_control)\r\n");
}
#endif

			strcpy(cfAinfo.file,cfAstr+1);
			fail += c_print(f_control);
			break;

		case C_FORTRAN:		/* 'r' */

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("scncfA(): calling c_print(f_fortran)\r\n");
}
#endif

			strcpy(cfAinfo.file,cfAstr+1);
			fail += c_print(f_fortran);
			break;

		case C_RTROFF:		/* '1' */
		case C_ITROFF:		/* '2' */
		case C_BTROFF:		/* '3' */
		case C_STROFF:		/* '4' */
		case C_CIF:		/* 'c' */
		case C_DVI:		/* 'd' */
		case C_PLOT:		/* 'g' */
		case C_BUPLOT:		/* 'k' */
		case C_DITROFF:		/* 'n' */
		case C_POSTSCRIPT:	/* 'o' */
		case C_PR:		/* 'p' */
		case C_TROFF:		/* 't' */
		case C_RASTER:		/* 'v' */
		case C_PALLADIUM:	/* 'z' */

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("scncfA(): calling c_print(f_passall)\r\n");
}
#endif

			strcpy(cfAinfo.file,cfAstr+1);
			fail += c_print(f_passall);
			break;

		case C_ULINK:		/* 'U' */
			strcpy(cfAinfo.file,cfAstr+1);
			if (!fail) {
				strcpy(dfAfl,rtfile(cfAinfo.file,cfAfl));
				delete(dfAfl);

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("scncfA(): dfA file %s deleted\r\n", expand(expfl,dfAfl));
}
#endif

			} else {
				skip = 1;
				fail = 0;
			}
			break;

		case C_ZOPT:		/* 'Z' */
			strcpy(cfAinfo.zopt,cfAstr+1);
			break;

		case C_INDENT:		/* 'I' */
			if (sscanf(cfAstr+1,"%d", &cfAinfo.indent) <= 0) {
				cfAinfo.indent = 0;
			} else {
				if (cfAinfo.indent < 0 || cfAinfo.indent > 40)
					cfAinfo.indent = 0;
			}
			break;

		case C_WIDTH:		/* 'W' */
			if (sscanf(cfAstr+1,"%d", &cfAinfo.width) <= 0) {
				cfAinfo.width = 216;
			} else {
				if (cfAinfo.width < 0 || cfAinfo.width > 216)
					cfAinfo.width = 216;
			}
			break;

		case C_CLASS:		/* 'C' */
		case C_JOB:		/* 'J' */
		case C_BANNER:		/* 'L' */
		case C_MAIL:		/* 'M' */
		case C_SLINK:		/* 'S' */
		case C_TITLE:		/* 'T' */
		default:
			break;
		}
	}
	return(skip);
}

/*
 * quefile
 *
 * Build an Output Filespec
 */

char *
quefile()
{
	register char *s,*t;
	char ext[4];
	char name[8];

	/*
	 * Scan supplied File Specification
	 */
	rmtfile(queinfo.dev);
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("quefile(): queinfo.dev = '%s'\r\n", queinfo.dev);
}
#endif

	/*
	 * File Name
	 */
	if (*(s = rtname()) == '\0') {
		rmtfile(cfAinfo.src);
		if (*(s = rtname()) == '\0') {
			if (streq(queinfo.host,"*")) {
				if (cfAinfo.host[0] != '\0') {
					s = cfAinfo.host;
				} else
				if (cfAinfo.user[0] != '\0') {
					s = cfAinfo.user;
				} else {
					s = "cfAdfA";
				}
			} else
			if (streq(queinfo.user,"*")) {
				if (cfAinfo.user[0] != '\0') {
					s = cfAinfo.user;
				} else
				if (cfAinfo.host[0] != '\0') {
					s = cfAinfo.host;
				} else {
					s = "cfAdfA";
				}
			} else {
				if (cfAinfo.host[0] != '\0') {
					s = cfAinfo.host;
				} else
				if (cfAinfo.user[0] != '\0') {
					s = cfAinfo.user;
				} else {
					s = "cfAdfA";
				}
			}
		}
	}
	sprintf(name,"%-.6s",s);
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("quefile(): name = '%s'\r\n", name);
}
#endif

	/*
	 * File Extension
	 */
	if (*(s = rtext()) == '\0') {
		rmtfile(dfAfl);
		s = rtext();
	}
	sprintf(ext,"%-.3s",s);
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("quefile(): ext = '%s'\r\n", ext);
}
#endif

	/*
	 * Scan Path
	 */
	s = strcpy(quefl,queinfo.dev);
	while(
		(t = strrchr(s,':')) != NULL ||
		(t = strrchr(s,'/')) != NULL ||
		(t = strrchr(s,'\\')) != NULL
	) { s = ++t; }

	/*
	 * Add Name and Extension
	 */
	sprintf(s,"%s.%s", name,ext);
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("quefile(): quefl = '%s'\r\n", quefl);
}
#endif
	return(quefl);
}

/*
 * ldcfg
 *
 * Load the LPDQRM Configuration file into memory as
 * a linked structure of null terminated text lines.
 *
 * Return 1 on success, 0 if cfg file not found.
 */

int
ldcfg()
{
	register FILE *fp;
	register struct lnkdtxt *newcfg;
	register char *newline;
	char str[STRLEN];

	if ((fp = rtopen(lpdcfl,"r",0,0)) == NULL) {
		return(0);
	}
	while (fgetss(str, sizeof(str)-1, fp) != NULL) {
		newcfg  = (struct lnkdtxt *) new (sizeof(struct lnkdtxt));
		newline = (char *) new (strlen(str) + 1);
		strcpy(newline,str);
		if (cfg == NULL) {
			cfg = newcfg;
		} else {
			nxtcfg->next = newcfg;
		}
		nxtcfg = newcfg;
		nxtcfg->next = NULL;
		nxtcfg->line = newline;
	}
	rtclose(fp);
	return(1);
}

/*
 * dmpcfg
 *
 * Free allocation for cfg data
 */

VOID
dmpcfg()
{
	if (cfg == NULL)
		return;

	while (cfg != NULL) {
		nxtcfg = cfg;
		cfg = cfg->next;
		free(nxtcfg->line);
		free(nxtcfg);
	}
}

/*
 * rdcfg
 *
 * Get the next configuration data line from
 * the linked list of null terminated cfg text lines
 */

char *
rdcfg(i)
int i;
{
	if (i)
		nxtcfg = cfg;

	if (nxtcfg != NULL) {
		strcpy(cfgstr,nxtcfg->line);
		nxtcfg = nxtcfg->next;
		return(cfgstr);
	} else {
		return(NULL);
	}
}

/*
 * ldcfA
 *
 * Load the cfA Control file into memory as
 * a linked structure of null terminated text lines.
 *
 * Return 1 on success, 0 if cfg file not found.
 */

int
ldcfA(fp)
register FILE *fp;
{
	register struct lnkdtxt *newcfA;
	register char *newline;
	char str[STRLEN];

	/*
	 * Deallocate old cfA data
	 */
	dmpcfA();

	while ((fp != NULL) && (fgetss(str, sizeof(str)-1, fp) != NULL)) {
		newcfA  = (struct lnkdtxt *) new (sizeof(struct lnkdtxt));
		newline = (char *) new (strlen(str) + 1);
		strcpy(newline,str);
		if (cfA == NULL) {
			cfA = newcfA;
		} else {
			nxtcfA->next = newcfA;
		}
		nxtcfA = newcfA;
		nxtcfA->next = NULL;
		nxtcfA->line = newline;
	}
}

/*
 * dmpcfA
 *
 * Free allocation for cfA data
 */

VOID
dmpcfA()
{
	if (cfA == NULL)
		return;

	while (cfA != NULL) {
		nxtcfA = cfA;
		cfA = cfA->next;
		free(nxtcfA->line);
		free(nxtcfA);
	}
}

/*
 * rdcfA
 *
 * Get the next configuration data line from
 * the linked list of null terminated cfg text lines
 */

char *
rdcfA(i)
int i;
{
	if (i)
		nxtcfA = cfA;

	if (nxtcfA != NULL) {
		strcpy(cfAstr,nxtcfA->line);
		nxtcfA = nxtcfA->next;
		return(cfAstr);
	} else {
		return(NULL);
	}
}

/*
 * delfA
 *
 * Delete all files associated with this control file
 */

VOID
delfA()
{
	char word[STRLEN];

	delete(cfAfl);
	nxtcfA = cfA;
	while (rdcfA(0) != NULL) {
		if (islower(cfAstr[0]) ||
		    isdigit(cfAstr[0]) ||
		   (cfAstr[0] == 'U')) {
			getword(cfAstr+1,word);
			strcpy(dfAfl,rtfile(word,cfAfl));
			delete(dfAfl);
		}
	}
}

/*
 * new
 *
 * Allocate space
 * Abort if out of space
 */

VOID * new(n)
unsigned int n;
{
	register VOID *p;

	if ((p = (VOID *) malloc(n)) == NULL) {
		fprintf(stderr, "Out of space!\r\n");
		exit(1);
	}
	return (p);
}

/*
 * outc
 *
 * Output a character
 */
int
outc(c,dfh)
char c;
FILE *dfh;
{
	return((putc(c, dfh) == EOF) ? 1 : 0);
}

/*
 * f_passall
 *
 * Copy image to output
 */
int
f_passall(sfh,dfh)
FILE *sfh,*dfh;
{
	int cnt;

	while (cnt = fread(xs,sizeof(xs),1,sfh)) {
		if(!fwrite(xs,cnt,1,dfh)) {
			return(1);
		}
	}
	return(0);
}

/*
 * f_print
 *
 * Print File as Plain Text.
 * Control Characters other than
 * BS, HT, LF, FF, and CR are discarded.
 *
 */
int
f_print(sfh,dfh)
FILE *sfh,*dfh;
{
	char c;
	register char *s;
	register int i,linpos;
	int e;

	e = 0;
	while (fgetss(xs,sizeof(xs)-1,sfh) != NULL) {
		for (i=0,linpos=0; i < cfAinfo.indent; i++) {
			if (linpos < cfAinfo.width) {
				e |= outc('\ ', dfh);
			}
			linpos += 1;
		}
		s = xs;
		while ((c = *s++) != '\0') {
			if (c < 32) {
				switch(c) {
				case  8:	/* BS */
					if (linpos > 0) {
						if (linpos < cfAinfo.width)
							e |= outc(c, dfh);
						linpos -= 1;
					}
					break;

				case  9:	/* HT */
					do {
						if (linpos < cfAinfo.width)
							e |= outc('\ ', dfh);
						linpos += 1;
					} while ((linpos-cfAinfo.indent) % 8);
					break;

				case 10:	/* LF */
				case 12:	/* FF */
					e |= outc(c, dfh);
					break;

				case 13:	/* CR */
					e |= outc(c, dfh);
					linpos = 0;
					break;

				default:
					break;
				}
			} else {
				if (linpos < cfAinfo.width) {
					e |= outc(c, dfh);
					linpos += 1;
				}
			}
		}
		e |= outc('\r', dfh);
		e |= outc('\n', dfh);
	}
	return(e);
}

/*
 * f_control
 *
 * Print File Without Control Character Filtering
 */
int
f_control(sfh,dfh)
FILE *sfh,*dfh;
{
	register char c;
	register char *s;
	register int linpos;
	int e;

	e = 0;
	while (fgetss(xs,sizeof(xs)-1,sfh) != NULL) {
		linpos = 0;
		s = xs;
		while ((c = *s++) != '\0') {
			if (c < 32) {
				switch(c) {
				case  8:	/* BS */
					if (linpos > 0) {
						e |= outc(c, dfh);
						linpos -= 1;
					}
					break;

				case  9:	/* HT */
					do {
						if (linpos < cfAinfo.width)
							e |= outc('\ ', dfh);
						linpos += 1;
					} while (linpos % 8);
					break;

				case 10:	/* LF */
				case 12:	/* FF */
					e |= outc(c, dfh);
					break;

				case 13:	/* CR */
					e |= outc(c, dfh);
					linpos = 0;
					break;

				default:
					e |= outc(c, dfh);
					break;
				}
			} else {
				if (linpos < cfAinfo.width)
					e |= outc(c, dfh);
				linpos += 1;
			}
		}
		e |= outc('\r', dfh);
		e |= outc('\n', dfh);
	}
	return(e);
}

/*
 * f_fortran
 *
 * Print File as FORTRAN Carriage Control Text.
 *
 * ' '	- advances one line
 * '0'	- advances two lines
 * '-'	- advances three lines
 * '1'	- advances to top of next page
 * '+'	- no advance
 * '$'	- advance one line, no carriage return at end of line
 */
int
f_fortran(sfh,dfh)
FILE *sfh,*dfh;
{
	char c;
	register char *s;
	register int linpos,endchar;
	int e;

	e = 0;
	while (fgetss(xs,sizeof(xs)-1,sfh) != NULL) {
		endchar = 0;
		c = xs[0];
		switch(c) {
		case '-':
			e |= outc('\n', dfh);
		case '0':
			e |= outc('\n', dfh);
		case '$':
		case 32:
		default:
			e |= outc('\n', dfh);
			break;

		case '1':
			e |= outc('\r', dfh);
			linpos = 0;
			break;

		case '+':
			break;
		}
		endchar = c;
		s = xs+1;
		while ((c = *s++) != '\0') {
			if (c < 32) {
				switch(c) {
				case  8:	/* BS */
					if (linpos > 0) {
						e |= outc(c, dfh);
						linpos -= 1;
					}
					break;

				case  9:	/* HT */
					do {
						if (linpos < cfAinfo.width)
							e |= outc('\ ', dfh);
						linpos += 1;
					} while (linpos % 8);
					break;

				case 10:	/* LF */
				case 12:	/* FF */
					e |= outc(c, dfh);
					break;

				case 13:	/* CR */
				default:
					e |= outc(c, dfh);
					linpos = 0;
					break;
				}
			} else {
				if (linpos < cfAinfo.width)
					e |= outc(c, dfh);
				linpos += 1;
			}
		}
		if (endchar == '$') {
			e |= outc('\r', dfh);
		}
	}
	return(e);
}

/*
 * c_print
 *
 * Prepare source and destination files
 * Call printing filter
 *
 * Return  1 if cannot write temporary file
 * Return  1 if cannot write to output
 * Return  0 if dfA does not exist
 * Return  0 if dfA file copied to output
 */

int
c_print(call)
int (*call) ();
{
	register char *s;
	register int srcmode,dstmode,status;

	srcfl[0] = '\0';
	dstfl[0] = '\0';
	tmpfl[0] = '\0';

	srcmode = 0;
	dstmode = 0;

	/*
	 * Go to LPD directory
	 */
	cd(lpddir);

	/*
	 * Destination Mode is 1 if subdirectory specified
	 */
	s = quefile();
	strcpy(dstfl,s);
	if (strchr(s,'\\') != NULL || strchr(s,'/') != NULL)
		dstmode = 1;

	/*
	 * The dfA file may have been deleted by LPQRM / LLPQRM
	 */
	strcpy(dfAfl,rtfile(cfAinfo.file,cfAfl));
	strcpy(srcfl,dfAfl);
	expand(expfl,dfAfl);
	if ((dfAfh = rtopen(dfAfl,"rn",0,0)) == NULL) {

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): dfA file %s not found\r\n", expfl);
}
#endif

		return(0);
	}
	/*
	 * Source Mode is 1 if subdirectory specified
	 */
	s = lpddir;
	if (strchr(s,'\\') != NULL || strchr(s,'/') != NULL)
		srcmode = 1;

	/*
	 * The 'Z' option is from the local LLPQRM LPR
	 */
	if (cfAinfo.zopt[0] != '\0') {
		/*
		 * The queued dfA file is a dumby
		 */
		rtclose(dfAfh);
		/*
		 * Open the local file
		 */
		strcpy(srcfl,cfAinfo.zopt);
		strcpy(expfl,cfAinfo.zopt);
		if ((dfAfh = rtopen(cfAinfo.zopt,"rn",0,0)) == NULL) {

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): Local file %s not found\r\n" ,expfl);
}
#endif

			return(0);
		}
		/*
		 * Source Mode is 1 if subdirectory specified
		 */
		s = srcfl;
		if (strchr(s,'\\') != NULL || strchr(s,'/') != NULL) {
			srcmode = 1;
		} else {
			srcmode = 0;
		}
	}

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): srcmode = %d, srcfl = %s\r\n", srcmode,expfl);
	printf("c_print(): dstmode = %d, dstfl = %s\r\n", dstmode,dstfl);
}
#endif

	/*
	 * If the source and destinations are in
	 * subdirectories then a temporary file is used
	 */
	if (srcmode && dstmode) {
		/*
		 * Build Temporary File Name
		 */
		sprintf(tmpfl,"wf:lprint.%03d",tljobn);

		/*
		 * Copy File to the temporary file
		 */
		if ((tmpfh = fopen(tmpfl,"wn")) == NULL) {
			rtclose(dfAfh);

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): Unable to open file %s\r\n", tmpfl);
}
#endif

			return(1);
		}
		status = 0;
		while (fread(xs,sizeof(xs),1,dfAfh) != 0) {
			if(!fwrite(xs,sizeof(xs),1,tmpfh)) {
				status = 1;
				break;
			}
		}
		rtclose(dfAfh);
		if(fclose(tmpfh) | status) {
#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): Error writing file %s\r\n", tmpfl);
}
#endif
			return(1);
		}
		/*
		 * Update modes and files
		 */
		srcmode = 0;
		strcpy(srcfl,tmpfl);
	} else {
		rtclose(dfAfh);
	}

#ifdef	DEBUGOPTION
if(debug&0x08) {
	if (tmpfl[0] != '\0')
		printf("c_print(): temporary:   tmpfl = %s\r\n", tmpfl);
}
#endif

	if (dstmode) {
		if ((dstfh = rtopen(dstfl,"wn",0,0)) == NULL) {

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): Unable to open device/file %s\r\n", dstfl);
}
#endif

			if (tmpfl[0] != '\0')
				delete(tmpfl);
			return(1);
		}
	} else {
		if ((dstfh = fopen(dstfl,"wn",0,0)) == NULL) {

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): Unable to open device/file %s\r\n", dstfl);
}
#endif

			if (tmpfl[0] != '\0')
				delete(tmpfl);
			return(1);
		}
	}
	if (srcmode) {
		srcfh = rtopen(srcfl,"r",0,0);
	} else {
		srcfh = fopen(srcfl,"r");
	}

	/*
	 * Call the Filter
	 */
	status = (*call) (srcfh,dstfh);

	srcmode ? rtclose(srcfh) : fclose(srcfh);
	status |= dstmode ? rtclose(dstfh) : fclose(dstfh);

	/*
	 * Delete Temporary File
	 */

	if (tmpfl[0] != '\0') {
		delete(tmpfl);

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("c_print(): tmpfl = %s deleted\r\n", tmpfl);
}
#endif

	}
	return(status);
}

                                                                                                            