.comment;progrm.tsx

.chapter;Program Options

The various client/server/utility program startup options are
outlined and typical startup command files listed.

.header level 1;TCPIP

The network server program TCPIP.SAV provides the software interface
between the Ethernet device handler and the client/server programs
in the TCP/IP Package.  The network server program handles the
processing of various network packets and services (TCP, IP, UDP,
BOOTP, ARP, RARP, and DOMAIN name lookup).

The TCPIP.SAV program may be started interactively (usually for diagnostic
purposes) with the following options:
.sk
.tp 3
.lit
TCPIP [?] [-f filename]
	?		List this Help Text and Exit TCPIP
	f  filename	Configuration File
.end lit
.sk 2
The startup command file TCPIP.COM deassigns all devices and then
assigns the network server device EN to be the DEQNA/DELQA
device EQ or the DEUNA/DELUA device EU.
Four EN units are used by TCPIP, three are used to receive
IP(EN0:), ARP(EN1:), and RARP(EN2:) packets and one is used
to transmit(EN3:) all packet types.
.sk
.tp 17
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	assign eq0: en0:
	assign eq1: en1:
	assign eq2: en2:
	assign eq3: en3:
	run/single TCP:tcpip
	^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The TCPIP program is usually started at TSX-Plus startup using the
file DETACH.TSX:
.sk
.tp 1
.lit
	detach sy:tcpip.com
.end lit

The TCPIP.SAV program requires the configuration file TCP:TCPIP.CFG which
defines all the parameters required to configure the network server.
Typical configuration parameters are detailed in the following
configuration file:

.pg
.lm 0
.lit
#
#  Example host file for TCP/IP server
#
#  This file is free form
#  Separators are any char <32, 'space' and '='
#  Comments are preceeded by #
#
#  The form is keyword=value for each parameter.
#  The first set of parameters refer to the whole program's defaults.
#  These parameter values can be in any order.
#  Following this are the individual machine specs.
#  If the first machine is name "default", then it contains default
#  values for the rest of the machines.
#
#	These options are specified for this host machine:
#
#	myname=____.____.____	# my internet name
#	myip=___.___.___.___	# host machines's IP number
#	    =BOOTP		# to use BOOTP to get host info
#	    =RARP		# to use RARP to get IP number
#	netmask=___.___.___.___	# subnetting mask
#	domain=____.____	# default domain for lookup
#	nndomto=____		# timeout for domain lookups
#	nnretry=____		# number of retries for lookup
#	nnarpto=____		# timeout for ARPs
#	nndto=____		# timeout for data layer
#	nnpkt=____		# TCPIP upper limit packets per transq
#				# nnpkt=1, requires ACK for each packet
#	nnwin=____		# TCPIP upper limit window size
#	nnseg=____		# TCPIP upper limit input segment size
#	nnmtu=____		# TCPIP upper limit output transfer size
#	service=___,___,_____	# TCPIP services specification
#	task=___,___,_____	# TCPIP task specification
#	logsession=__________	# TCPIP session logging filespec
#
.end lit
.lm 8
.pg
.lm 0
.lit
#
#	These are the options which may be specified for each
#	individual machine specification:
#
#	name=____		# name of session (required)
#	host=____		# full name of host computer
#	hostip=___.___.___.___	# IP number of host
#	port=____		# specify initial connection port
#	nameserver=____		# name server level
#	gateway=____		# gateway level
#	retrans=____		# initial retransmit timeout
#	contime=____		# opening connection timeout
#	mwin=____		# advertized window size for this host
#	mseg=____		# maximum advertized input segment size
#	mtu=____		# maximum output transfer size
#	delete=backspace	# value to use for character deletion
#	crmap=4.3BSDCRNUL	# for 4.3BSD null CR
#	duplex=half		# for half duplex TELNET connections
#	copyfrom=____		# copy parameters from this name
#
myname=machine.domain.name
myip=192.3.2.100	# required, this machine's IP number
netmask=255.255.255.0	# subnetting mask
domain="domain.name"	# domain name search path

			# affects machines on your local network
nnwin=2920		# limit advertized window (nnwin == mwin)
nndomto=5		# domain timeout
nnretry=4		# number of retries
nnarpto=2		# arp timeout in seconds
nnpkt=2			# send only 2 packet(s) per transq

.end lit
.lm 8
.pg
.lm 0
.lit
#  The following line specifies the TCPIP logging file
#  which will contain information for each session
#  started:	TELNET / RTELNT / FTP / RFTP / CNCT / RCNCT /
#		MAIL / RSMTP
#		RPOP3 / MAILER / MMAIL
#		RLPD / LPRINT / LPQRM / LLPQRM
#		NTSND
#		RHTTP
#		RGOPH

# logsession=LOG:tcpip.log[100]

#  The following are services supported by TCPIP.
#  Each entry contains the listen port, maximum number of
#  sessions and the name of the command file to initiate
#  the service.

service=21,2,TCP:rftp.srv	# remote ftp server
service=23,2,TCP:rtelnt.srv	# remote telnet server
service=25,2,TCP:rsmtp.srv	# remote smtp server
service=27,2,TCP:rcnct.srv	# remote cnct server
service=70,2,TCP:rgoph.srv	# remote gopher server
service=80,4,TCP:rhttp.srv	# remote http server
service=110,2,TCP:rpop3.srv	# remote pop3 server (task: -t 1)
service=515,2,TCP:rlpd.srv	# remote lpd server  (task: -t 2)

#  The following specify the tasks that may be initiated by TCPIP.
#  Each entry contains the taskid number, timer interval in seconds
#  (zero means not an automatically started task), and the name
#  of the command file to initiate the service.  These tasks donot
#  have to be related to TCPIP programs, however a TCPIP program
#  can use the TASKCLASS to start a specific task. The selected
#  task will be scheduled by TCPIP and only one (1) copy of the
#  the task will be allowed to run.  Additional requests to start
#  the task will be queued as a single request to rerun the task
#  at the completion of the currently executing task.

task=1,0,TCP:mailer.srv	# mmail / pop3      mail delivery agent
task=2,0,TCP:lprint.srv	# rlpd / llpqrm     printing delivery agent
.end lit
.lm 8
.pg
.lm 0
.lit
#
#  Following are individual machine specifications
#  Gateways are used in the order that they appear in the file
#  Nameservers rotate, #1, #2, #3, #1, #2 when a request fails
#
#  The machine named "default" contains the fields which are
#  automatically filled in for later hosts
#
name=default		# Session name, "default" is a reserved name
			# Not a real machine, default parameters only
delete=delete		# Assume mostly non-UNIX connections

#  The following entries affect the tuning of
#	TCP connections to this host.
#  They should be set by the network administrator who is familiar
#	with the requirements of your specific network.

contime=12		# timeout in seconds to try connection
			#   before returning error to user
retrans=5		# starting retransmit time out in seconds
mtu=1460		# maximum transmit unit in bytes
			#   outgoing packet size, MAX=1460
mseg=1460		# largest segment we can receive
			#   whatever the hardware can take, MAX=1460
mwin=2920		# most bytes we can receive without ACK
			#   =TCP window size, MAX=3047
			#   larger isn't always better
#
#  Below this line, most of the communication parameters are obtained
#   from the "default" host entry.
#  Machine names, IP addresses, and special communication parameters
#   are present when needed.
#

name=mygateway		hostip=192.3.2.2
			gateway=1

name=nameserver		hostip=192.3.2.1
			nameserver=1

name=alpha		host=alpha.domain.name
			hostip=192.3.2.200

.end lit
.lm 8
.pg
.lm 0
.lit
#
# If during TCPIP startup you get the error Sreadhosts() error 2,
# you probably have exceeded the memory limits of the machine.
#
#	(1)	reduce the number of machine definitions above
#	(2) or	donot use session logging
#
# Sesion logging and Debugging should not be simultaneously enabled.
#
.end lit
.lm 8
.sk 2

The network server needs to know the ip address(number) of the
machine to which it is connecting.  If the TCPIP.CFG file does
not contain the named machines' ip number then it will make a
request to the specified name server to obtain the machines ip
number.  If a name server is not specified then the connection
cannot be made using the machines name (place the machines name
and ip address in the configuration file).  If the ip address is
given as the input to the client program rather than the name
then a domain name lookup is not required.

All changes to the configuration file will take effect at the
next startup of TCPIP.SAV.


.header level 1;SKTMON

The SKTMON program provides a diagnostic tool for observing the
state of all TCPIP connections.  SKTMON displays the current state
of network connections by showing the global regions through which
the TCPIP network server program and the client/server programs
communicate.  The program shows in detail the various network
packets, the incoming and outgoing data streams, and the status of
the network ethernet driver.

The startup command file contains an assignment to allow SKTMON to
access the status of the device driver:
.sk
.tp 2
.lit
	assign eq0: en0:
	run/single TCP:sktmon 0 ^1
.end lit


.header level 1;PASWRD

A password file (eg PASWRD.FIL) must be built if the local/remote
MAIL services are to be used or if remote network access (ie remote
FTP, TELNET, CNCT or printing services) must be restricted.
It is suggested that a
seperate password directory be created to hold the files PASWRD.SAV
and PASWRD.FIL.  This directory need be no larger than about 200
blocks.  The maximum number of user/password specifications is
limited by the program memory size to about 50.  The PASWRD.FIL
contains 1 block for each user/password specification.
The PASWRD.COM command file should be updated to reflect the
location of the password files.  A seperate directory allows
the exclusion of its access by remote FTP sessions, local users
or remote telnet sessions with appropriate TSX-PLUS access
rights may still access the password files.

Copy the file PASWRD.SAV (and optionally the supplied password
file PASWRD.FIL) to the created directory.  Modify the
PASWRD.COM file to access this subdirectory.

Initiating PASWRD.SAV with a file specification will open an
existing file or create the file if no existing file is found.
The PASWRD program screens will indicate all the options
and the file USRBLK.H illustrates the formats for the
directory/subdirectory/file specifications required by the
password program.

.note
The password for any added user must also be
specified, any user not requiring a password (ie an 'anonymous'
account) must have this password entered as a null string by
typing only a carriage return for the password.
.end note

To use the created password file be sure the program startup command
files have specified the correct path to the password file.

.note
The directory/subdirectory/file access rights are only used by the
remote FTP server.  Logins via TELNET or CNCT rely upon any security
features enabled in TSX-PLUS and not by the PASWRD.FIL specifications.
.end note


.header level 1;TELNET

The TELNET program allows the user to initiate a connection to a
remote host for a terminal session.  The startup options for
TELNET are:
.sk
.tp 4
.lit
TELNET destination [?] [-hp]
	?		List the Help Text and Exit TELNET
	h		List the Help Text and Open Connection
	p  filename	Specify the Password Filespec
.end lit
.sk 2
The destination host specification may be the host name or host
ip number.  If the connection is to be made to an alternate
port then follow the name/ip with the port number (decimal).

The TELNET program supports the following command line options
which are activated by the META character 'control A':
.sk
.lit
	M->C	open capture file
	M->D	close capture file
	M->F	FTP [internet address]
	M->H	this help screen
	M->I	type my internet address
	M->K	erase character
	M->O	abort output
	M->Q	are you there?
	M->R	toggle <CR> follow character
	M->S	skip to end of buffer
	M->T	toggle backspace/delete
	M->U	erase line
	M->X	close connection
	M->Y	interrupt process
	M->@	send a true null character

	 ^?	 abort Telnet session
.end lit

The startup command file TELNET.COM follows:
.sk
.tp 2
.lit
	run/single TCP:telnet
	-hbp PAS:/paswrd.dsk/paswrd.fil ^1 ^2 ^3 ^4 ^5 ^6
.end lit

.header level 1;RTELNT

RTELNT is a server program for remote TELNET sessions into TSX-Plus.
The program startup options are:
.sk
.tp 15
.lit
RTELNT [?] [-hmp filespec] [-acelrtvyz] [parameters]
	?	List the Help Text and Exit RTELNT
	a	Attach to Service
	c  i	CL line i is cross connected to TSX line j
	e	Enable Monitoring of all Transactions
	h	Specify the Help Filespec
	l  n	Number of CL/TSX line pairs
	m	Specify the Message Filespec
	p	Specify the Password Filespec
	r	Restart RTELNT after Disconnect
	t  j	TSX line j is cross connected to CL line i
	v	Verbose Mode
	y  s	Login Timeout in seconds
	z  s	Inactivity Timeout in seconds
.end lit
.sk 2
The program may be started interactively (for diagnostic purposes)
by the command file RTELNT.COM:
.sk
.tp 3
.lit
	run/single TCP:rtelnt
	-ctlpyz 0 3 1 PAS:/paswrd.dsk/paswrd.fil 15 600 ...
		... ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file RTELNT.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rtelnt
	-actlpyz 0 3 1 PAS:paswrd.fil 15 600
.end lit
.sk 2
The RTELNT help and message files are RTELNT.HLP and RTELNT.MSG respectively.
The h or m options may be used if these files are not on the TCP: device.
These files are created by the system manager and are not required.


.header level 1;CNCT

The CNCT program allows the user to initiate a connection to a
remote TSX-Plus host for a terminal session.  This program is the TELNET
program stripped of all TELNET negotiations and uses a non standard
TCP port (27).  The startup options for CNCT are:
.sk
.tp 9
.lit
CNCT destination [?] [-hp]
	?		List the Help Text and Exit CNCT
	h		List the Help Text and Open Connection
	p   filename	Specify the Password Filespec
.end lit
.sk 2
The destination host specification may be the host name or host
ip number.  If the connection is to be made to an alternate
port then follow the name/ip with the port number (decimal).

The CNCT program supports the following command line options
which are activated by the META character 'control A':
.sk
.lit
	M->C	open capture file
	M->D	close capture file
	M->F	FTP [internet address]
	M->H	this help screen
	M->I	type my internet address
	M->O	abort output
	M->Q	are you there?
	M->S	skip to end of buffer
	M->X	close connection
	M->Y	interrupt process

	 ^?	 abort CNCT session
.end lit
.sk 2
The startup command file CNCT.COM follows:
.sk
.tp 2
.lit
	run/single TCP:cnct
	-hbp PAS:/paswrd.dsk/paswrd.fil ^1 ^2 ^3 ^4 ^5 ^6
.end lit


.header level 1;RCNCT

RCNCT is a server program for remote CNCT sessions into TSX-Plus.
This program is the RTELNT program stripped of all TELNET
negotiations and uses a non standard TCP port (27).
The startup options for RCNCT are:
.sk
.tp 14
.lit
RCNCT [?] [-hmp filespec] [-acelrtvyz] [parameters]
	?	List the Help Text and Exit RCNCT
	a	Attach to Service
	c  i	CL line i is cross connected to TSX line j
	e	Enable Monitoring of all Transactions
	h	Specify the Help Filespec
	l  n	Number of CL/TSX line pairs
	m	Specify the Message Filespec
	p	Specify the Password Filespec
	r	Restart RCNCT after Disconnect
	t  j	TSX line j is cross connected to CL line i
	v	Verbose Mode
	y  s	Login Timeout in seconds
	z  s	Inactivity Timeout in seconds
.end lit
.sk 2
The program may be started interactively (for diagnostic purposes)
by the command file RCNCT.COM:
.sk
.tp 3
.lit
	run/single TCP:rcnct
	-ctlpyz 0 3 1 PAS:/paswrd.dsk/paswrd.fil 15 600 ...
		... ^1 ^2 ^3 ^4 ^5 ^6
.end lit

The program is normally invoked by the TCPIP network server program
by the command file RCNCT.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rcnct
	-actlpyz 0 3 1 PAS:paswrd.fil 15 600
.end lit
.sk 2
The RCNCT help and message files are RCNCT.HLP and RCNCT.MSG respectively.
The h or m options may be used if these files are not on the TCP: device.
These files are created by the system manager and are not required.


.header level 1;FTP

The FTP program provides reliable data transfer between cooperating
computer systems.  The FTP program startup options are:
.sk
.tp 11
.lit
FTP [?] [-f filename] [-p filename]
	[-ghinrv] [destination host]
	?		List this Help Text and Exit FTP
	f  filename	Command File
	g		Wildcard Expansion Disabled
	h		FTP Help List
	i		Interactive Prompting Off
	n		AutoLogin Disabled on Connect
	p  filename	Specify the Password Filespec
	r		Output Redirection Disabled
	v		Verbose Mode Disabled
.end lit
.sk 2
The destination host specification may be the host name or host
ip number.  If the connection is to be made to an alternate
port then follow the name/ip with the port number (decimal).

If the work file device, wf:, is not assigned then the program will
fail to execute the commands mget, mdel, or mls.

The FTP startup command file is:
.sk
.tp 2
.lit
	run/single TCP:ftp
	-hbp PAS:/paswrd.dsk/paswrd.fil ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The FTP program supports the following command line options:
.sk
.lit
?		print local help information
ascii		set ascii transfer type
bell		toggle command completed beep
bget		get a file in binary mode
binary		set binary transfer type
bput		put a file in binary mode
bye		terminate ftp session and exit
cd		change remote working directory
close		terminate ftp session
debug		toggle/set debugging mode
delete		delete remote file
			- inquires if prompting is on
dir		list contents of remote directory
get		receive file
hash		toggle printing `#' for each
			1024 bytes transferred
help		print local help information
home		set default directory to home
interactive	turn on prompting for multiple commands
lcd		change local working directory
ldelete		delete local files
ldir		list contents of local directory
lls		list contents of local directory
lmkdir		make a local directory
lprotect	set protection flag on local file
lpwd		show local working directory
lrename		rename a local file
lrmdir		remove a local directory
ls		list contents of remote directory
ltype		print a local file to the screen
lunprotect	clear protection flag on a local file
mdelete		delete multiple files
mdir		list contents of multiple remote directories
mget		get multiple files
mkdir		make directory on the remote machine
mls		list contents of multiple remote directories
mode		set file transfer mode
mput		send multiple files
noninteractive	turn off prompting on multiple commands
open		connect to remote ftp
passive		enable or disable passive transfer mode
prompt		toggle interactive prompting
			on multiple commands
protect		set protection flag on file
put		send one file
pwd		print working directory on remote machine
quit		terminate ftp session and exit
quote		send arbitrary ftp command
recv		receive file
remotehelp	get help from remote server
rename		rename remote file
rm		delete remote file
rmdir		remove directory on the remote machine
send		send one file
sendport	toggle use of PORT cmd for each data connection
status		show current status
struct		set file transfer structure
system		query remote system type
type		print a remote file to the screen
unprotect	clear protection flag on file
user		send new user information
verbose		toggle verbose mode
version		FTP-11 version displayed
wild		toggle wildcard expansion of local file names
>   <filespec>	redirect (m)dir or (m)ls response to a file
.end lit

  The commands bget, get, put, and send allow explicit renaming
of the files during the transfer by specifying the optional
destination file name:
.sk
.lit
	bget/get/put/send [source name] [destination name]
.end lit

.header level 1;FTPL

The FTPL program provides reliable data transfer between cooperating
computer systems.  FTPL is a stripped version of the FTP program for
use on smaller systems.  The FTPL program startup options are:
.sk
.tp 7
.lit
FTPL [?] [-p filename] [-ghinrv] [destination host]
	?		List this Help Text and Exit FTPL
	g		Wildcard Expansion Disabled
	h		FTPL Help List
	i		Interactive Prompting Off
	n		AutoLogin Disabled on Connect
	v		Verbose Mode Disabled
.end lit
.sk 2
The destination host specification may be the host name or host
ip number.  If the connection is to be made to an alternate
port then follow the name/ip with the port number (decimal).

If the work file device, wf:, is not assigned then the program will
fail to execute the commands mget, mdel, or mls.

The FTPL startup command file is:
.sk
.tp 2
.lit
	run/single TCP:ftpl
	-hb -p PAS:/paswrd.dsk/paswrd.fil ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The FTPL program supports the following command line options:
.sk
.lit
?		print local help information
ascii		set ascii transfer type
bell		toggle command completed beep
bget		get a file in binary mode
binary		set binary transfer type
bput		put a file in binary mode
bye		terminate ftp session and exit
cd		change remote working directory
close		terminate ftp session
debug		toggle/set debugging mode
delete		delete remote file
			- inquires if prompting is on
dir		list contents of remote directory
get		receive file
hash		toggle printing `#' for each
			1024 bytes transferred
help		print local help information
interactive	turn on prompting for multiple commands
ls		list contents of remote directory
mdelete		delete multiple files
mget		get multiple files
mkdir		make directory on the remote machine
mode		set file transfer mode
mput		send multiple files
noninteractive	turn off prompting on multiple commands
open		connect to remote ftp
passive		enable or disable passive transfer mode
prompt		toggle interactive prompting
			on multiple commands
put		send one file
pwd		print working directory on remote machine
quit		terminate ftp session and exit
quote		send arbitrary ftp command
recv		receive file
remotehelp	get help from remote server
rename		rename remote file
rm		delete remote file
rmdir		remove directory on the remote machine
send		send one file
sendport	toggle use of PORT cmd for each data connection
status		show current status
struct		set file transfer structure
system		query remote system type
type		print a remote file to the screen
user		send new user information
verbose		toggle verbose mode
version		FTP-11 version displayed
wild		toggle wildcard expansion of local file names
.end lit

  The commands bget, get, put, and send allow explicit renaming
of the files during the transfer by specifying the optional
destination file name:
.sk
.lit
	bget/get/put/send [source name] [destination name]
.end lit

.header level 1;RFTP

RFTP is a server program for remote FTP sessions into TSX-Plus.
The program startup options are:
.sk
.tp 12
.lit
RFTP [?] [-hmp filespec] [-aeruvyz]
	?               List the Help Text and Exit RFTP
	a		Attach to Service
	e		Monitor all RFTP Transactions
	h		Specify the Help Filespec
	m		Specify the Message Filespec
	p		Specify the Password Filespec
	r		Restart RFTP after Disconnect
	u		UNIX Style DIR Command
	v		Verbose Mode
	y  s		Login Timeout in seconds
	z  s		Inactivity Timeout in seconds
.end lit
.sk 2
The program may be started interactively (for diagnostic purposes)
by the command file RFTP.COM:
.sk
.tp 3
.lit
	run/single TCP:rftp
	-rpyz PAS:/paswrd.dsk/paswrd.fil 15 600 ...
		... ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file RFTP.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rftp
	-aspyz 0 4 PAS:paswrd.fil 15 600
.end lit
.sk 2
The RFTP help and message files are RFTP.HLP and RFTP.MSG respectively.
The h or m options may be used if these files are not on the TCP: device.
These files are created by the system manager and are not required.
The command file RFTHLP.COM uses the subdirectories utility LDISKS
to create a logical disk map for inclusion in the RFTP.HLP file.

The -u option specifies that the 'LIST' command returns a UNIX style
directory listing rather than the default RT-11 style directory format.
This format is useful if the remote systems are PC's using one of the
window oriented FTP utilities such as PROCOMM V3.0
(DataStorm Technologies).
These utilities use the unix access-rights
string to determine whether the entries are files or directories.
The general form for the UNIX style directory is:
.sk
.tp 2
.lit
-rwxrwxrwx   1 system  user       1536 12 Jan 96 file.ext
drwxrwxrwx   1 system  user     512000 01 Mar 96 subdir.dsk
.end lit
.sk 2


.header level 1;MAIL

The MAIL program provides local and internet mail services.
This program is recommended for systems not requiring a POP3
server.
The startup options for MAIL are:
.sk
.tp 7
.lit
MAIL [?] [-fp filespec] [-i IP Address] [-z s]
	?               List the Help Text and Exit MAIL
	f  filename	Command File
	h		Help list
	i  IP Address	Intermediate Host Name / IP Address
	p  filename	Specify the Password Filespec
	z  s		Connection Timeout in Seconds
.end lit
.sk 2
The Intermediate Host IP option provides a means of routing the internet
mail through another host machine.  The TSX-Plus MAIL program does not
support retry operations if the mail cannot be delivered, using an
intermediate host supporting retries will provide this feature to the
TSX-Plus MAIL system.  Permission to use a particular host as a MAIL
relay should be obtained from the hosts' system manager.
The option must be specified using the complete name (an IP address may
also be used).  A typical invocation follows:
.sk
.lit
	-i mail.domain.name
.end lit
.sk 2
The MAIL program is invoked from the command file MAIL.COM:
.sk
.tp 2
.lit
	run/single TCP:mail
	-hpz PAS:/paswrd.dsk/paswrd.fil 60 ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The MAIL program supports the following command line options:
.sk
.lit
?		print local help information
bye		terminate the MAIL program
copy		copy a message to a file
debug		toggle/set debugging mode
delete		delete a message
dir		list of unread mail messages
exit		terminate the MAIL program
hash		toggle printing `#' during transfers
help		print local help information
home		go to home (initial) directory
index		an index of received mail
interactive	turn on prompting on multiple commands
last		read most recent mail message
lcd		change local working directory
ldelete		delete local files
ldir		list contents of local directory
listmail	list of unread mail messages
lls		list contents of local directory
lmkdir		make a local directory
lprotect	set protection flag on local file
lpwd		show local working directory
lrename		rename a local file
lrmdir		remove a local directory
ltype		print a local file to the screen
lunprotect	clear protection flag on a local file
mail		go to mail directory
newmail		count number of new mail messages
noninteractive	turn off prompting on multiple commands
prompt		toggle interactive prompting
			on multiple commands
quit		terminate the MAIL program
read		read a mail message
scan		scan directory for all mail messages
send [filespec]	initiate the sending of a message
status		show current status
user		enter a new user/password access key
verbose		toggle verbose mode
version		MAIL-11 version displayed
wild		toggle wildcard expansion of local file names
.end lit
.sk 2
Mail is sent to a local user if only a name is specified and to a remote
machine if the user and IP address are specified.
.sk
Local:		username
.sk
Internet:	username@machine.domain.name
.sk 2

The MAIL programs MAIL.SAV, MMAIL.SAV, MAILER.SAV, RPOP3.SAV,
and RSMTP.SAV make use of the password
file to restrict access to the mail system.  A user may have
local and/or remote MAIL access (or no access) depending on
the password file parameters.

Incoming mail may be directed to a users' default directory or to
a specific mail directory (specified in the password file).  A
typical configuration is to create a mail directory, SY:MAIL.DSK,
and have mail subdirectories for each user.  Thus the path
SY:/MAIL/USER1/ specifies the users' unique mail directory and
should be specified in the password configuration.  The local mail
programs MAIL.SAV, MMAIL.SAV, and MAILER.SAV and the remote mail programs
RSMTP.SAV and RPOP3.SAV check
the password file to verify that the user has the privilege to
send or receive mail via the network and places any received
mail in the specified mail directory.  These programs will
use/create a mail index file in the mail directory which is
used to keep an index of all received mail.


.header level 1;MMAIL

The MMAIL program is a front end interface to the MAILER service.
This program is recommended for systems requiring a POP3 server.
The startup options for MMAIL are:
.sk
.tp 6
.lit
MMAIL [?] [-fp filespec] [-t n] [-h]
	?               List the Help Text and Exit MMAIL
	f  filename	Command File
	h		Help list
	p  filename	Specify the Password Filespec
	t  n		MAILER Delivery Task Number
.end lit
.sk 2
The MAILER delivery task number must be specified.  The task number
must be that specified in the TCPIP.CFG for the MAILER task.  The
MAILER task is started by MMAIL when mail is sent.

The MMAIL program is invoked from the command file MMAIL.COM:
.sk
.tp 2
.lit
	run/single TCP:mmail
	-hpt PAS:/paswrd.dsk/paswrd.fil 1 ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The MMAIL program supports the following command line options:
.sk
.lit
?		print local help information
bye		terminate the MMAIL program
copy		copy a message to a file
debug		toggle/set debugging mode
delete		delete a message
dir		list of unread mail messages
exit		terminate the SMAIL program
help		print local help information
home		go to home (initial) directory
index		an index of received mail
interactive	turn on prompting for multiple commands
last		read most recent mail message
lcd		change local working directory
ldelete		delete local files
ldir		list contents of local directory
listmail	list of unread mail messages
lls		list contents of local directory
lmkdir		make a local directory
lprotect	set protection flag on local file
lpwd		show local working directory
lrename		rename a local file
lrmdir		remove a local directory
ltype		print a local file to the screen
lunprotect	clear protection flag on a local file
mail		go to mail directory
newmail		count number of new mail messages
noninteractive	turn off prompting for multiple commands
prompt		toggle interactive prompting
			on multiple commands
quit		terminate the MAIL program
read		read a mail message
scan		scan directory for all mail messages
send [filespec]	initiate the sending of a message
status		show current status
user		enter a new user/password access key
version		SMAIL-11 version displayed
wild		toggle wildcard expansion of local file names
.end lit
.sk 2
Mail is sent to a local user if only a name is specified and to a remote
machine if the user and IP address are specified.
.sk
Local:		username
.sk
Internet:	username@machine.domain.name
.sk 2

The MAIL programs MAIL.SAV, MMAIL.SAV, MAILER.SAV, RPOP3.SAV,
and RSMTP.SAV make use of the password
file to restrict access to the mail system.  A user may have
local and/or remote MAIL access (or no access) depending on
the password file parameters.

Incoming mail may be directed to a users' default directory or to
a specific mail directory (specified in the password file).  A
typical configuration is to create a mail directory, SY:MAIL.DSK,
and have mail subdirectories for each user.  Thus the path
SY:/MAIL/USER1/ specifies the users' unique mail directory and
should be specified in the password configuration.  The local mail
programs MAIL.SAV, MMAIL.SAV, and MAILER.SAV and the remote mail programs
RSMTP.SAV and RPOP3.SAV check
the password file to verify that the user has the privilege to
send or receive mail via the network and places any received
mail in the specified mail directory.  These programs will
use/create a mail index file in the mail directory which is
used to keep an index of all received mail.


.header level 1;RPOP3

RPOP3 is a server program for remote access to the TSX-Plus mail
system via the extended POP3 protocol.  This server supports
the PC shareware packages PC Eudora and WinQVT/Net for Windows 3.x and NT in
particular and others using the POP3 protocol.
The program startup options are:
.sk
.tp 10
.lit
RPOP3 [?] [-p filespec] [-t n] [-z s] [-y s] [-aerv]
	?               List the Help Text and Exit RPOP3
	a		Attach to Service
	e		Enable Monitoring of
				RPOP3 Transactions
	p  filespec	Specify the Password Filespec
	r		Restart RPOP3 after Disconnect
	t  n		Task Number for Mail Delivery Agent
	v		Verbose Mode
	y  s		Login Timeout in seconds
	z  s		Inactivity Timeout in seconds
.end lit
.sk 2
The MAILER delivery task number must be specified.  The task number
must be that specified in the TCPIP.CFG for the MAILER task.  The
MAILER task is started by RPOP3 when mail is sent.

The program may be started interactively (for diagnostic purposes)
by the command file RPOP3.COM:
.sk
.tp 2
.lit
	run/single TCP:rpop3
	-rptyz PAS:/paswrd.dsk/paswrd.fil 1 15 600 ...
		... ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file RPOP3.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rpop3
	-aptyz PAS:paswrd.fil 1 15 600
.end lit

The MAIL programs MAIL.SAV, MMAIL.SAV, MAILER.SAV, RPOP3.SAV,
and RSMTP.SAV make use of the password
file to restrict access to the mail system.  A user may have
local and/or remote MAIL access (or no access) depending on
the password file parameters.

Incoming mail may be directed to a users' default directory or to
a specific mail directory (specified in the password file).  A
typical configuration is to create a mail directory, SY:MAIL.DSK,
and have mail subdirectories for each user.  Thus the path
SY:/MAIL/USER1/ specifies the users' unique mail directory and
should be specified in the password configuration.  The local mail
programs MAIL.SAV, MMAIL.SAV, and MAILER.SAV and the remote mail programs
RSMTP.SAV and RPOP3.SAV check
the password file to verify that the user has the privilege to
send or receive mail via the network and places any received
mail in the specified mail directory.  These programs will
use/create a mail index file in the mail directory which is
used to keep an index of all received mail.


.header level 1;MAILER

MAILER is a backend program for MMAIL and RPOP3 which provides
mail delivery to local users and remote destinations.  When MAILER
is activated it scans all user mail directories for files with names
similiar to ml________.nnn created by MMAIL or RPOP3.  These files are
routed to their respective destinations and then deleted.  If the
mail is not deliverable then the message is directed back to the
sender.
The program startup options are:
.sk
.tp 8
.lit
MAILER [?] [-p filespec] [-i IP-address] [-t n] [-z s] [-ev]
	?               List the Help Text and Exit MAILER
	e		Enable Monitoring of MAILER Transactions
	i  IP-address	Intermediate Host Name / IP Address
	p  filespec	Specify the Password Filespec
	t  n (minutes)	Continuous scanning time interval
	v		Verbose Mode
	z  s		Conection Timeout in Seconds
.end lit
.sk 2
The Intermediate Host IP option provides a means of routing the internet
mail through another host machine.  The TSX-Plus MAIL program does not
support retry operations if the mail cannot be delivered, using an
intermediate host supporting retries will provide this feature to the
TSX-Plus MAIL system.  Permission to use a particular host as a MAIL
relay should be obtained from the hosts' system manager.
The option must be specified using the complete name (an IP address may
also be used).  A typical invocation follows:
.sk
.lit
	-i mail.domain.name
.end lit
.sk 2
The program may be started interactively (for diagnostic purposes)
by the command file MAILER.COM:
.sk
.tp 2
.lit
	run/single TCP:mailer
	-p PAS:/paswrd.dsk/paswrd.fil ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file MAILER.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:mailer
	-piz PAS:paswrd.fil mail.domain.name 60
.end lit
.sk 2
The specification of device wf: is required by MAILER to temporarily
store local mail messages before writing the mail to the users
mail directories.  If wf: is undefined, inaccessable, or not initialized
then mail will not be delivered.

The MAIL programs MAIL.SAV, MMAIL.SAV, MAILER.SAV, RPOP3.SAV,
and RSMTP.SAV make use of the password
file to restrict access to the mail system.  A user may have
local and/or remote MAIL access (or no access) depending on
the password file parameters.

Incoming mail may be directed to a users' default directory or to
a specific mail directory (specified in the password file).  A
typical configuration is to create a mail directory, SY:MAIL.DSK,
and have mail subdirectories for each user.  Thus the path
SY:/MAIL/USER1/ specifies the users' unique mail directory and
should be specified in the password configuration.  The local mail
programs MAIL.SAV, MMAIL.SAV, and MAILER.SAV and the remote mail programs
RSMTP.SAV and RPOP3.SAV check
the password file to verify that the user has the privilege to
send or receive mail via the network and places any received
mail in the specified mail directory.  These programs will
use/create a mail index file in the mail directory which is
used to keep an index of all received mail.


.header level 1;RSMTP

RSMTP is a server program for remote MAIL into TSX-Plus.
The program startup options are:
.sk
.tp 10
.lit
RSMTP [?] [-hp filespec] [-z s] [-aerv]
	?               List the Help Text and Exit RSMTP
	a		Attach to Service
	e		Monitor all RSMTP Transactions
	h		Specify the Help Filespec
	p		Specify the Password Filespec
	r		Restart RSMTP after Disconnect
	t  n		Mail Delivery Task Number
	v		Verbose Mode
	z  s		Inactivity Timeout in Seconds
.end lit
.sk 2
The RSMTP help file RSMTP.HLP is of diagnostic use only.

The program may be started interactively (for diagnostic purposes)
by the command file RSMTP.COM:
.sk
.tp 2
.lit
	run/single TCP:rsmtp
	-rptz PAS:/paswrd.dsk/paswrd.fil 1 600 ...
		... ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file RSMTP.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rsmtp
	-aptz PAS:paswrd.fil 1 600
.end lit
.sk 2
The specification of device wf: is required by RSMTP to temporarily
store incoming mail messages before writing the mail to the users
mail directories.  If wf: is undefined, inaccessable, or not initialized
then incoming mail will not be delivered.

The MAIL programs MAIL.SAV, MMAIL.SAV, MAILER.SAV, RPOP3.SAV,
and RSMTP.SAV make use of the password
file to restrict access to the mail system.  A user may have
local and/or remote MAIL access (or no access) depending on
the password file parameters.

Incoming mail may be directed to a users' default directory or to
a specific mail directory (specified in the password file).  A
typical configuration is to create a mail directory, SY:MAIL.DSK,
and have mail subdirectories for each user.  Thus the path
SY:/MAIL/USER1/ specifies the users' unique mail directory and
should be specified in the password configuration.  The local mail
programs MAIL.SAV, MMAIL.SAV, and MAILER.SAV and the remote mail programs
RSMTP.SAV and RPOP3.SAV check
the password file to verify that the user has the privilege to
send or receive mail via the network and places any received
mail in the specified mail directory.  These programs will
use/create a mail index file in the mail directory which is
used to keep an index of all received mail.


.header level 1;LLPQRM

LLPQRM is the program which submits, controls and reports the status
of the local LPRINT daemon.  The program performs the functions
of LPC, LPQ, LPR, and LPRM.
The program startup options are:
.sk
.tp 10
.lit
LLPQRM [?] [-p filespec] [-t n] -o opt [opt arguments]
	?               List the Help Text and Exit LLPQRM
	p  filespec	LPD configuration file
	t  n		TCPIP Task Number for LPD Delivery Agent
	o  lpc	[?]	Start printer queue
	   lpq	[?]	Get printer queue status
	   lpr	[?]	Submit a job to a printer queue
	   lprm	[?]	Remove a job from a printer queue

	The -o opt argument must preceed the opt specific options.
.end lit
.sk 2
The LPRINT delivery task number must be specified.  The task number
must be that specified in the TCPIP.CFG for the LPRINT task.  The
LPRINT task is started by LLPQRM when a print job is queued by LPR
option or the print queue is started by the LPC option.

Program sub options are:
.sk
.tp 22
.lit
LPC [?]
	?               List the LPC Help Text and Exit LLPQRM

LPQ [?] [-#P argument]
	?               List the LPQ Help Text and Exit LLPQRM
	#  n		Repeat query time in seconds
	P  Queue Name	Printer Queue

LPR [?] [-#IPW argument] [-flr] [file to print]
	?               List the LPR Help Text and Exit LLPQRM
	#  n		# of copies to print (1-5)
	I  n		Indentation
	P  Queue Name	Printer Queue (default = lp)
	W  n		Page Width
	f		Plain Text Printing (default)
	l		No Control Character Processing
	r		Fortran Carriage Control Printing

LPRM [?] [-P argument] [file to remove from queue]
	?               List the LPRM Help Text and Exit LLPQRM
	P  Queue Name	Printer Queue
.end lit
.sk 2
Each of the options is invoked by a command file more indicative of its
intended function. (The "" around the TSX-Plus parameters _^1#-#_^6 are
required to insure that the case of the arguments are not changed.)


.header level 2;LLPC

LLPC.COM is the local start printer daemon command file.
.sk
.tp 2
.lit
	run/single TCP:llpqrm
	-pto TCP:lpdqrm.cfg 2 lpc "^1" "^2" "^3" "^4" "^5" "^6"
.end lit

.header level 2;LLPQ

LLPQ.COM is the local check printer queue status command file.
.sk
.tp 2
.lit
	run/single TCP:llpqrm
	-pto TCP:lpdqrm.cfg 2 lpq "^1" "^2" "^3" "^4" "^5" "^6"
.end lit

.header level 2;LLPR

LLPR.COM is the local print command file.
.sk
.tp 2
.lit
	run/single TCP:llpqrm
	-pto TCP:lpdqrm.cfg 2 lpr "^1" "^2" "^3" "^4" "^5" "^6"
.end lit

.header level 2;LLPRM

LLPRM.COM is the local remove queued print file command file.
.sk
.tp 2
.lit
	run/single TCP:llpqrm
	-pto TCP:lpdqrm.cfg 2 lprm "^1" "^2" "^3" "^4" "^5" "^6"
.end lit
.sk 2
.br
For a normal user:
.i -4
(1)#if the printer queue is not specified then all of the queues are
checked.
.i -4
(2)#If a file name is not specified then all queued files for this
user are checked and the user queried for each file to be deleted.
.sk
.br
For the special user 'system':
.i -4
(1)#if the printer queue is not specified then all of the queues are
checked.
.i -4
(2)#If a file name is not specified then all queued files for all
users are checked and the 'system' queried for each file to be deleted.
.i -4
(3)#If a username is entered, then all files for this user are checked and
'system' queried for each file deletion.
.i -4
(4)#If a filename is entered, then the specific file is checked and
'system' queried for file deletion.

.header level 1;RLPD

RLPD is a server program providing remote printing on the
TSX-Plus system printer.
The program startup options are:
.sk
.tp 8
.lit
RLPD [?] [-p filespec] [-t n] [-aer]
	?               List the Help Text and Exit RLPD
	a		Attach to Service
	e		Enable Monitoring of RLPD Transactions
	p  filespec	Specify the Configuration Filespec
	r		Restart RLPD after Disconnect
	t  n		TCPIP Task Number for
				RLPD Delivery Agent
.end lit
.sk 2
The LPRINT delivery task number must be specified.  The task number
must be that specified in the TCPIP.CFG for the LPRINT task.  The
LPRINT task is started by RLPD when a print job is received.

The program may be started interactively (for diagnostic purposes)
by the command file RLPD.COM:
.sk
.tp 2
.lit
	run/single TCP:rlpd
	-rpt TCP:lpdqrm.cfg 2 ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file RLPD.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rlpd
	-apt TCP:lpdqrm.cfg 2
.end lit


.header level 1;LPRINT

The program LPRINT is the backend printing daemon servicing
printing on the TSX-Plus system.  Print jobs submitted by remote
systems through the RLPD server and local print jobs submitted
through LLPQRM are processed by the LPRINT task.  RLPD and LLPQRM
write two files (cfa.nnn and dfa.nnn) into a temporary file
directory, cfa.nnn is the print control file and dfa.nnn is the
print data file.  At the completion of the printing job these
files are deleted.
.sk
The command options for LPRINT are:
.sk
.tp 5
.lit
LPRINT [?] [-p filespec] [-t n] [-v]
	?               List the Help Text and Exit LPRINT
	p  filespec	Specify the Configuration Filespec
	t  n (minutes)	Continuous Scanning Time Interval
	v		Verbose Mode
.end lit
.sk 2
.tp 12
The LLPQRM.CFG configuration file is of the following form:
.sk
.lit
001					; three digit sequence
sy2:\lpdtmp\				; temporary directory
sy0:\paswrd\paswrd.fil			; pass word file
lp	*	name	ls:		; line printer
dspcgc	*	name	hf:		; cgc graphics device
dspqbs	*	name	hg:		; qbs graphics device
file	*	name	sy3:\tmpwrk\	; write to a file
lp	pdp	*	ls:		; line printer
dspcgc	pdp	*	hf:		; cgc graphics device
dspqbs	pdp	*	hg:		; qbs graphics device
.end lit
.sk 2
The first line is a sequence number maintained by RLPD, LLPQRM, and
LPRINT.  The second line is the directory used for holding the
queued files until processed by LPRINT.  The third line references
the password file which may be used to check if the user exists.

.tp 7
The fourth and succeeding lines contain printing queues and their
access permissions.  The four entries are:
.sk
.lit
(1)	queue name
(2)	machine name (* is any)
(3)	user name (* is any)
(4)	device
.end lit
.sk 2
The data is copied to the specified printing device or
random access device using the name in the print control file
(cfa.nnn).

The program may be started interactively (for diagnostic purposes)
by the command file LPRINT.COM:
.sk
.tp 2
.lit
	run/single TCP:lprint
	-p TCP:lpdqrm.cfg ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file LPRINT.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:lprint
	-p TCP:lpdqrm.cfg
.end lit
.sk 2
The specification of device wf: is required by LPRINT to temporarily
store data files before writing the data to subdirectories.
If wf: is undefined, inaccessable, or not initialized
then data will not be copied.


.header level 1;LPQRM

LPQRM is the program which submits, controls and reports the status
of remote printer queues. The program performs the functions
of LPC, LPQ, LPR, and LPRM.
The program startup options are:
.sk
.tp 13
.lit
LPQRM [?] [-ipq argument] [-e] -o opt [opt arguments]
	?               List the Help Text and Exit LPQRM
	e		Enable Monitoring of LPQRM Transactions
	i  IP Address	Remote Server Name / IP Address
	n  Port Number	Remote Server Port Number
	q  Queue Name	Remote Server Printer Queue
	p  filespec	Configuration File
	o  lpc	[?]	Start printer queue
	   lpq	[?]	Get printer queue status
	   lpr	[?]	Submit a job to a printer queue
	   lprm	[?]	Remove a job from a printer queue

	The -o opt argument must preceed the opt specific options.
.end lit
.sk 2
Program sub options are:
.sk
.tp 35
.lit
LPC [?] [-SP argument]
	?               List the LPC Help Text and Exit LPQRM
	P  Queue Name	Remote Host Printer Queue
	S  IP Address	Remote Host Name / IP Address

LPQ [?] [-SP# argument] [-l]
	?               List the LPQ Help Text and Exit LPQRM
	#  n		Repeat query time in seconds
	l		Long form of queue status
	P  Queue Name	Remote Host Printer Queue
	S  IP Address	Remote Host Name / IP Address

LPR [?] [-SPIW# argument] [-flr] [filespec]
	?               List the LPR Help Text and Exit LPQRM
	#  n		# of copies to print (1-5)
	P  Queue Name	Remote Host Printer Queue
	S  IP Address	Remote Host Name / IP Address
	f		ASCII Plain Text (default)
	l		ASCII With Controls
	r		Fortran Carriage Control
	I  n		Indentation (f option only)
	W  n		Page Width (flr options only)

	Other Options:
	1234cdghnoptvz	UNIX(tm) Options
	M		Mail Option

	C	Class		J	Job
	L	Banner		T	Title

LPRM [?] [-SP argument] job [job [...]]
	?               List the LPRM Help Text and Exit LPQRM
	P  Queue Name	Remote Host Printer Queue
	S  IP Address	Remote Host Name / IP Address
.end lit
.sk 2
Each of the options is invoked by a command file more indicative of its
intended function. (The "" around the TSX-Plus parameters _^1#-#_^6 are
required to insure that the case of the arguments are not changed.)


.header level 2;LPC

LPC.COM is the remote start printer daemon command file.
.sk
.tp 2
.lit
run/single TCP:lpqrm
-po TCP:lpdqrm.cfg lpc "^1" "^2" "^3" "^4" "^5" "^6"
.end lit

.header level 2;LPQ

LPQ.COM is the remote check printer queue status command file.
.sk
.tp 2
.lit
run/single TCP:lpqrm
-po TCP:lpdqrm.cfg lpq "^1" "^2" "^3" "^4" "^5" "^6"
.end lit

.header level 2;LPR

LPR.COM is the remote print command file.
.sk
.tp 2
.lit
run/single TCP:lpqrm
-po TCP:lpdqrm.cfg lpr "^1" "^2" "^3" "^4" "^5" "^6"
.end lit

.header level 2;LPRM

LPRM.COM is the remote remove queued print file command file.
.sk
.tp 2
.lit
run/single TCP:lpqrm
-po TCP:lpdqrm.cfg lprm "^1" "^2" "^3" "^4" "^5" "^6"
.end lit


.header level 1;NTSND

NTSND is a program for transferring data to a remote printer
without any translation (good for binary files).  This program
supports products such as the Emulex NETJET for the HP 4Si/Mx printer.
The command options are:
.sk
.tp 6
.lit
NTSND [?] [-inpq argument] file [file [...]]
	?               List the Help Text and Exit NTSND
	i  IP Address	Remote Server Name / IP Address
	n  Port Number	Remote Server Port Number
	p  filespec	Password File
	q		Query for File Name
.end lit
.sk 2
The NTSND program is invoked from the command file NTSND.COM:
.sk
.tp 2
.lit
run/single TCP:ntsnd
-bp PAS:/paswrd/paswrd.fil ^1 ^2 ^3 ^4 ^5 ^6
.end lit

.header level 1;RHTTP

RHTTP is an HTTP/0.9 server supporting only simple request and response
formats for GET, HEAD, and POST methods.  The POST method always
responds as unimplemented.  HTTP transfers are always in BINARY format
except for files of type HTM, DOC, TXT, and LST which are in ASCII
format. The command options are:
.sk
.tp 9
.lit
RHTTP [?] [-p filespec] [-z s] [-aerv]
	?		List the Help Text and Exit RHTTP
	a		Attach to Service
	e		Enable Monitoring of all
				RHTTP Transactions
	p		Specify the HTTP Directory and Home File
	r		Restart RHTTP after Disconnect
	v		Verbose Mode
	z  s		Inactivity Timeout in seconds
.end lit
.sk 2

The HTTP directory and home file must be specified, using the -p option.
The directory path is used as the base directory for all HTTP accesses.

The program may be started interactively (for diagnostic purposes)
by the command file RHTTP.COM:
.sk
.tp 2
.lit
	mount ld0: dl1:/http.dsk
	assign ld0: HTP:
	run/single TCP:rhttp
	-rspz 1 2 HTP:/home.htm 30 ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file RHTTP.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld0: dl1:http.dsk
	assign ld0: HTP:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rhttp
	-aspz 1 2 HTP:/file.ext 30
.end lit
.sk 2

.note
The slashs, /.../, are required to delimit the HTTP base
directory.  If a device or (logical) device specification is used,
HTP:, then the slash is required after the colon.
.end note

All accesses to files outside the http directory are not permitted
and are reported as unauthorized.  Absolute references are not
allowed (e.g. dl1:/http.dsk/file.ext) even if they are in the http directory,
these are also reported as unauthorized. Use only relative paths
in file specifications to the http directory and subdirectories
(e.g. /subdir/file.ext). These requirements provide the most
security for http requests which require no password authentication.

The home file is an HTML file and should be written to reflect
the functionality of the browsers you wish to support with this
http server.


.header level 1;RGOPH

RGOPH is a simple Gopher server supporting transfers of text, binary,
and image files and linking to other network resources using basic
ASCII text constructs.  The command options are:
.sk
.tp 9
.lit
RGOPH [?] [-p filespec] [-z s] [-aerv]
	?		List the Help Text and Exit RGOPH
	a		Attach to Service
	e		Enable Monitoring of all
				RGOPH Transactions
	p		Specify the Master GOPHER File
	r		Restart RGOPH after Disconnect
	v		Verbose Mode
	z  s		Inactivity Timeout in seconds
.end lit
.sk 2
The Gopher master file must be specified, using the -p option.
The master file contains the access specifications for the gopher server. 
The format of the master file is described in the file RGOPH.CFG and
included here for reference:
.sk 2
.tp 32
.lit
#
# This is the Master Gopher List
#
# Each entry has the following format:
#<code><TAB>description
#      <TAB>file or list specification
#      <TAB>machine name or IP address
#      <TAB>port number
#
# End list with '.' and <CRLF>
#
# Common item types specified by <code> are:
#
#	0	item is a file
#	1	item is a directory
#	2	item is a CSO phone-book server
#	3	Error
#	4	item is a NINHEXed MacIntosh file
#	5	item is DOS archive of some sort
#	6	item is a UNIX uuencoded file
#	7	item is an Index-Search server
#	8	item points to a text-based telnet server
#	9	item is a binary file
#	+	item is a redundant server
#	T	item points to a text-based TN3270 session
#	g	item is a GIF format graphics file
#	I	item is some kind of image file
#
#	All references are described in RFC1436
#
.end lit
.sk 2
The master list contains file and list references which denote a
tree structure of accessible resources.  A typical master list
is shown here to clarify the specification.

The top level follows:
.sk 2
.tp 14
.lit
	0	About This GOPHER Site
		sy2:/gopher.dsk/rgoph.doc
		shop-pdp.kent.edu
		70
	1	TCP/IP Package For TSX-Plus, ...
		List1/
		shop-pdp.kent.edu
		70
	1	ASxxxx Assemblers and Linker
		List2/
		shop-pdp.kent.edu
		70
	.
.end lit
.sk 2
The 'List1/' (<code> = 1) specification indicates this is a
directory of subitems:
.sk 2
.tp 48
.lit
	#
	# Elements of List1/
	#
	List1/
	0	Abstract [2K]
		sy3:/tcpip.pkg/abstra.doc
		shop-pdp.kent.edu
		70
	0	Documentation [158K]
		sy3:/tcpip.pkg/manual.doc
		shop-pdp.kent.edu
		70
	9	Minimal  Package, Logical Disk Image, [300K]
		sy3:/tcpipm.dsk
		shop-pdp.kent.edu
		70
	9	Complete Package, Multilevel Logical ...
		sy3:/tcpip.pkg/tcpip.dsk
		shop-pdp.kent.edu
		70
	9	Disk1 of Package, RX02 Image [494K]
		sy3:/tcpip.pkg/tcpip.dsk/disk1.dsk
		shop-pdp.kent.edu
		70
	9	Disk2 of Package, RXO2 Image [494k]
		sy3:/tcpip.pkg/tcpip.dsk/disk2.dsk
		shop-pdp.kent.edu
		70
	9	Disk3 of Package, RXO2 Image [494k]
		sy3:/tcpip.pkg/tcpip.dsk/disk3.dsk
		shop-pdp.kent.edu
		70
	9	Disk4 of Package, RXO2 Image [494k]
		sy3:/tcpip.pkg/tcpip.dsk/disk4.dsk
		shop-pdp.kent.edu
		70
	9	Disk5 of Package, RXO2 Image [494k]
		sy3:/tcpip.pkg/tcpip.dsk/disk5.dsk
		shop-pdp.kent.edu
		70
	9	Disk6 of Package, RXO2 Image [494k]
		sy3:/tcpip.pkg/tcpip.dsk/disk6.dsk
		shop-pdp.kent.edu
		70
	9	Disk7 of Package, RXO2 Image [494k]
		sy3:/tcpip.pkg/tcpip.dsk/disk7.dsk
		shop-pdp.kent.edu
		70
.end lit

.tp 10
.lit
	9	Documentation Source, RX02 Image [494K]
		sy3:/tcpip.pkg/tcpip.dsk/tcpdoc.dsk
		shop-pdp.kent.edu
		70
	9	Current Updates, Logical Disk Image [988K]
		sy3:update.dsk
		shop-pdp.kent.edu
		70
	.
.end lit
.sk 2
The 'List2/' (<code> = 1) specification indicates the presence
of a second directory of available resources:
.sk 2
.tp 13
.lit
	#
	# Elements of List2/
	#
	List2/
	1	ASxxxx for PDP-11 and LSI-11 Computers
		List2.1/
		shop-pdp.kent.edu
		70
	1	ASxxxx for PC Compatible Computers
		List2.2/
		shop-pdp.kent.edu
		70
	.
.end lit
.sk 2
These elements also contain references to additional subdirectories
of resources.  Nesting to any level may be accomplished using this
syntax.  Ensure that all subdirectory references have unique names.
The use of 'xxxxx/' is not required, any unique character string
may be used to reference a subdirectory entry.
.sk 2
The program may be started interactively (for diagnostic purposes)
by the command file RGOPH.COM:
.sk
.tp 2
.lit
	run/single TCP:rgoph
	-rsp 0 4 TCP:rgoph.cfg ^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk 2
The program is normally invoked by the TCPIP network server program
by the command file RGOPH.SRV:
.sk
.tp 16
.lit
	deassign
	dismount ld0:
	dismount ld1:
	dismount ld2:
	dismount ld3:
	dismount ld4:
	dismount ld5:
	dismount ld6:
	dismount ld7:
	assign sy: wf:
	mount ld6: dl1:paswrd.dsk
	assign ld6: PAS:
	mount ld7: dl1:tsxtcp.dsk
	assign ld7: TCP:
	run/single TCP:rgoph
	-aspz 0 4 TCP:rgoph.cfg 600
.end lit


.header level 1;UTIL

The program UTIL is a compendium of various functions used to
perform useful operations on TSX-Plus subdirectories.  The command
options for UTIL are:
.sk
.tp 12
.lit
UTIL [?] [-cdlmnpqru] [file-spec(s)]
	?	List this Help Text and Exit UTIL

	c	change directory
	d	delete a file
	l	list a directory
	m	make a directory
	n	delete a directory
	p	set protection flag on a file
	q	disable query on delete
	r	rename a file
	u	clr protection flag on afile
.end lit
.sk 2
Each of the options is invoked by a command file more indicative of its
intended function.

.header level 2;LCD

Change directory command file LCD.COM:
.sk
.tp 3
.lit
	run/single TCP:util
	-sc 0 2 ^1
	@wf:cmdfil
.end lit


.header level 2;LDEL

Delete file command file LDEL.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-d ^1
.end lit


.header level 2;LDIR

List directory command file LDIR.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-l ^1
.end lit


.header level 2;LLS

List directory command file LLS.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-l ^1
.end lit


.header level 2;LMKDIR

Make a subdirectory command file LMKDIR.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-m ^1
.end lit


.header level 2;LPRO

Set protection flag command file LPRO.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-p ^1
.end lit


.header level 2;LRENAM

Rename a file command file LRENAM.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-r ^1 ^2
.end lit


.header level 2;LRMDIR

Remove a subdirectory command file LRMDIR.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-n ^1
.end lit


.header level 2;LUNP

Clear protection flag command file LUNP.COM:
.sk
.tp 2
.lit
	run/single TCP:util
	-u ^1
.end lit


.header level 1;LDISKS

The LDISKS program generates a subdirectory map for each device specified
and optionally outputs the result to a file.
.sk
.tp 3
.lit
LDISKS [?] [-f filename] [dev1] [dev2] ...
	?		List this Help Text and Exit LDISKS
	f  filename	Output File Name
.end lit
.sk 2
The command file LDISKS.COM allows arbitrary input parameters:
.sk
.tp 2
.lit
	run TCP:ldisks
	^1 ^2 ^3 ^4 ^5 ^6
.end lit

An example of its use is:
.sk
.lit
	LDISKS -f disk.map du2:
.end lit
.sk 2
The output file disk.map would look like:
.sk
.lit
Logical Subdirectories for du2:

      du2:
        `--> maclib[ 2000]
        `--> pictur[ 6000]
        `-->    phd[14000]
        `--> paswrd[  500]
        `-->   mail[ 1000]
                  `--> baldwi[  500]
                  `-->  guest[  200]
                  `--> anonym[  200]

.end lit


.header level 1;ABRTCP

ABRTCP is a program which attempts to gracefully abort the TCPIP system.
All TCP/IP connections are closed, all client(s)/server(s) are requested
to abort, and the TCPIP server closes.  The program is invoked from
the command file ABRTCP.COM:
as:
.sk
.tp 1
.lit
	run/single TCP:abrtcp
.end lit


.header level 1;ABRTJB

ABRTJB is a program which attempts to gracefully abort a specific
TCP/IP client/server program.  The program is invoked from the command
file ABRTJB.COM:
.sk
.tp 2
.lit
	run/single TCP:abrtjb
	^1 ^2 ^3 ^4 ^5 ^6
.end lit
.sk
and may request from 1 to 6 jobs be aborted.  The job aborts are sent
to the TCPIP server program which closes any open connections associated
with the job and sends an abort request to the specified job.  This program
will not abort the TCPIP server program.

                                                                                                                                                                                                                                                                                                                                                                                                                                                      