/* usrftp.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"


/*
 * checkevent
 *
 * get and process network events
 * returns ABORT on an abort, HAVEDATA if data available
 * on command connection, NONE if connection lost.
 * TRUE if no relevant event.
 */

int checkevent()
{
	int cl,ev,dat;

	/*
	 * check for abort
	 */
	if(tstbrk())
		return(ABORT);
	/*
	 * do ftp stuff
	 */
	userftpd();
	/*
	 * look for events
	 */
	ev =  Sgetevent(USERCLASS  | CONCLASS  | SCKTCLASS |
			TCPCLASS   | MSGCLASS  | ERRCLASS  |
			ABORTCLASS | SCKTABORT | SRVCCLASS |
			SRVCATTACH | SRVCABORT | TASKCLASS,
			&cl, &dat);
	if(ev) {
	    switch(cl) {
		case ERRCLASS:		/* error messages */
		case MSGCLASS:		/* messages */
		    if( ev<100 || errmsg ) {
			kb_puts(skerrstring(ev));
			kb_nline();
		    }
		    break;

		case CONCLASS:		/* connection */
		    if(dat == ftpcskt) {
			switch(ev) {
			    case CONDATA:
				/*
				 * data has arrived
				 */
				return(HAVEDATA);

			    case CONCLOSE:
				/*
				 * connection lost
				 */
				skclose(ftpdskt);
				skclose(ftpcskt);
				linked = FALSE;
				return(NONE);

			     default:
				break;
			}
			break;
		    }
		    break;

		default:
		    break;
	    }
	}
	return(TRUE);
}

/*
 * userftpd
 *
 *  FTP receive and send file functions
 */

VOID userftpd()
{
	register char *p;
	register char *q;
	register int fcnt;
	int ei,ef,i;
	long etime,ri,rf;

#ifdef	DEBUGOPTION
if(debug&0x40) {
	if(ftpstate) {
		printf("userftpd(%d):", ftpstate);
	}
}
#endif
	fcnt = 0;
	switch(ftpstate) {
	default:	/* unknown */
		break;

	case 40:	/* start LIST */
		if(sktest(ftpdskt))
			break;
		/*
		 * Initialize parameters
		 */
		tbytes = 0L;
		/*
		 * connection made
		 */
		start = cticks(NULL);
		ftpstate = 41;

	case 41:
		/*
		 * Override  Suspensions During Transfers
		 */
		suspnd(-1);

		fcnt = skread(ftpdskt,xs,READSIZE);
		if(fcnt>0) {
			skdeque(ftpdskt);
			xs[fcnt] = '\0';
			kb_puts(xs);
			tbytes += fcnt;
		}
#ifdef	DEBUGOPTION
if(debug&0x40)	{
		printf(" fcnt %d\r\n",fcnt);
}
#endif
		break;

	case 30:	/* receive */
		if(sktest(ftpdskt))
			break;
		/*
		 * Initialize parameters
		 */
		len = 0;
		xp = 0;
		hashcnt = 0;
		hashnum = 0;
		tbytes = 0L;
		/*
		 * connection made
		 */
		start = cticks(NULL);
		ftpstate = 31;

	case 31:
		/*
		 * Override  Suspensions During Transfers
		 */
		suspnd(-1);

		/*
		 * file has already been opened,
		 * take everything from the connection
		 * and place into the open file: ftpfh
		 */
		/*
		 * wait until xs is full
		 * before writing to disk
		 */
		if(len <= 0) {
			if(xp) {
			    if(ftpfh != NULL)
				if(!fwrite(xs,1,xp,ftpfh)) {
					tfrabtf = 1;
				}
			    xp = 0;
			}
			/*
			 * expected or desired len to go
			 */
			len = BUFFERS;
		}
		/*
		 * how much to read
		 */
		if(len < BUFFERS) {
			i = len;
		} else {
			i = BUFFERS;
		}
		fcnt = skread(ftpdskt,&xs[xp],i);
#ifdef	DEBUGOPTION
if(debug&0x40) {
		printf(" len=%d, xp=%d, fcnt=%d", len,xp,fcnt);
}
#endif
		/*
		 * adjust counts
		 */
		if(fcnt>0) {
			skdeque(ftpdskt);
			len -= fcnt;
			xp += fcnt;
			hashcnt += fcnt;
			tbytes += fcnt;
		}
		/*
		 * connection closed
		 */
		if(fcnt<0) {
			/*
			 * write last block
			 */
			if(xp) {
			    if(ftpfh != NULL)
				if(!fwrite(xs,1,xp,ftpfh)) {
					tfrabtf = 1;
				}
			    xp = 0;
			}
		}
		/*
		 * hash mark printing
		 */
		hashprint();
		break;

	case 20:	/* send */
		if(sktest(ftpdskt))
			break;
		/*
		 * Initialize parameters
		 */
		finished = FALSE;
		towrite = 0;
		xp = 0;
		hashcnt = 0;
		hashnum = 0;
		tbytes = 0L;
		/*
		 * connection made
		 */
		start = cticks(NULL);
		ftpstate = 21;

	case 21:
		/*
		 * Override  Suspensions During Transfers
		 */
		suspnd(-1);

		/*
		 * transfer file(s) to the
		 * other host via ftp request
		 * file is already open=ftpfh
		 */
		if(towrite <= xp && finished == FALSE) {
			/*
			 * need to read again
			 */
			for(p=xs,i=0; i<BUFFERS; i+=READSIZE) {
			    if((iosize != 0) &&
				(fcnt = fread(p,1,READSIZE,ftpfh))) {
				p += fcnt;
				--iosize;
			    } else {
				finished = TRUE;
				fclose(ftpfh);
				ftpfh = NULL;
				break;
			    }
			}
			fcnt = p - xs;
			if(ftpfilemode == FASCII) {
			    for (p=q=xs,i=0; i<fcnt; i++) {
				if (!(*p++ = *q++)) {
				    --p;
				}
			    }
			    fcnt = p - xs;
			}
			towrite = fcnt;
			xp = 0;
		}

		fcnt = towrite - xp;
		if(fcnt>0) {
			fcnt = skwrite(ftpdskt,&xs[xp],fcnt);
		}
		if(fcnt>0) {
			/*
			 * write successful
			 * queue data and adjust counts
			 */
			skenque(ftpdskt,0);
			xp += fcnt;
			hashcnt += fcnt;
			tbytes += fcnt;
		}
#ifdef	DEBUGOPTION
if(debug&0x40) {
		printf(" finished=%d, fcnt=%d, xp=%d, towrite=%d",
			finished,fcnt,xp,towrite);
}
#endif
		/*
		 * hash mark printing
		 */
		hashprint();
		/*
		 * done if:  the file
		 * is all read from disk
		 * and all sent or other side
		 * has ruined connection
		 */
		if((towrite <= xp && finished == TRUE) || sktest(ftpdskt)) {
			ftpstate = 22;
		} else {
			break;
		}

	case 22:
		/* send done
		 * wait for other side to accept
		 * everything and then start close
		 */
		if(0 >=skenque(ftpdskt,1) || sktest(ftpdskt)) {
			fcnt = -1;
		}
		break;
	}
#ifdef	DEBUGOPTION
if(debug&0x40) {
	if(ftpstate) {
		printf("\r\n");
	}
}
#endif
	/*
	 * after processing from connection,
	 * if the connection is closed,
	 * reset up shop.
	 */
	if(fcnt < 0) {
		/*
		 * transfer finished / connection lost
		 */
		if(ftpfh != NULL) {
			/*
			 * close file
			 */
			if(fclose(ftpfh)) {
				tfrabtf = 1;
			}
			ftpfh = NULL;
		}
		/*
		 * Hash Mark Printing
		 */
		if(hash && hashnum)
			kb_nline();
		/*
		 * check transfer abort flag
		 */
		if(tfrabtf) {
			kb_puts("Write Error, File Truncated\r\n");
		}
		/*
		 * done
		 */
		ftpstate = 0;
		tfrabtf = 0;
		fcnt = 0;
		/*
		 * how long to transfer
		 */
		if(verbose) {
			/*
			 * Time calculation
			 */
			etime = elapsed(start);
			ei = etime/TICKSPERSEC;
			if(!ei) {
				ei = 1;
				ef = 0;
				etime = TICKSPERSEC;
			} else {
			/*	ei = ei;	*/
				ef = (10L*(etime%TICKSPERSEC))/TICKSPERSEC;
			/*	etime = etime;	*/
			}
			/*
			 * Rate calculation
			 */
			if(tbytes > 30000000L) {
				ri = (tbytes/etime)*TICKSPERSEC;
			} else {
				ri  = (tbytes*TICKSPERSEC)/etime;
			}
			rf  = ri%1000L;
			ri /= 1000L;

			kbprintf(
	"Transferred %ld bytes in %d.%d seconds (%ld.%03ld kbytes/sec)\r\n",
				tbytes,ei,ef,ri,rf);
		}
		/*
		 * close connection
		 */
		skclose(ftpdskt);
		if(bell)
			kb_out(7);
	}
	/*
	 * Release socket when closed
	 */
	if(ftpdskt >= 0 && ftpstate == 0) {
#ifdef	DEBUGOPTION
if(debug&0x40) {
		printf("userftpd : ftpdskt=%d, state=%d\r\n",
			ftpdskt,skstate(ftpdskt));
}
#endif
		ftpdskt = skrelease(ftpdskt,0);
	}
}

/*
 * Hash Mark Printing
 */
VOID hashprint()
{
	while(hash && hashcnt >= HASHSIZE) {
		hashcnt -= HASHSIZE;
		if(++hashnum >= 75) {
			kb_puts("#\r\n");
			hashnum = 0;
		} else {
			kb_out('#');
		}
	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                            