/* rtfile.c */

#include <stdio.h>
#include <string.h>

#include "rtfile.h"

/*
 *  rtfile
 *
 *  Build a file specification from
 *  the user specification s and from
 *  the default specification d.
 */
char *rtfile(s,d)
register char	*s;
register char	*d;
{
	/*
	 * Set up file spec
	 */
	rtparse(s);

	/*
	 * Fill in with the user supplied default filespec
	 */
	rtdefault(d);

	/*
	 * Return the complete filespec
	 */
	return(rtstring());
}

/*
 *  rtwfile
 *
 *  Build a wild card file specification from
 *  the user specification s and from
 *  the default specification d.
 */
char *rtwfile(s,d)
register char	*s;
register char	*d;
{
	/*
	 * Set up file spec
	 */
	rtparse(s);

	/*
	 * Wild card optional fields
	 */
	rtwild();

	/*
	 * Fill in with the user supplied default filespec
	 */
	rtdefault(d);

	/*
	 * Return the complete filespec
	 */
	return(rtstring());
}

/*
 *  rtparse
 *
 *  Parse the supplied file specification
 *  into the dev, name, extension, and allocation fields.
 */
VOID rtparse(s)
register char *s;
{
	register char	*t;
	int c,i;

	rt_file.dev[0]  = '\0';
	rt_file.name[0] = '\0';
	rt_file.dot     = 0;
	rt_file.ext[0]  = '\0';
	rt_file.alloc	= 0;
	if((s==NULL) || (*s=='\0'))
		return;

	strncpy(rt_file.string,s,ISTRING);
	rt_file.string[ISTRING] = '\0';

	if (t = strchr(rt_file.string,'[')) {
		*t++ = '\0';
		if(*t) {
			i = sscanf(t, strchr(t,'-') ? "%d%1s" : "%u%1s",
				&rt_file.alloc, &c);
			if((i!=2) || (c!=']'))
				rt_file.alloc = 0;
		}
	}
	if (t = strchr(rt_file.string,'.')) {
		*t++ = '\0';
		rt_file.dot = 1;
		if(*t) {
			rtscan(rt_file.ext,t,RTEXT);
			rt_file.ext[RTEXT] = '\0';
		}
	}
	if (t = strchr(rt_file.string,':')) {
		*t++ = '\0';
		if(*t) {
			rtscan(rt_file.name,t,RTNAME);
			rt_file.name[RTNAME] = '\0';
		}
		if(*rt_file.string) {
			rtscan(rt_file.dev,rt_file.string,RTDEV);
			rt_file.dev[RTDEV] = '\0';
		}
	} else {
		if(*rt_file.string) {
			rtscan(rt_file.name,rt_file.string,RTNAME);
			rt_file.name[RTNAME] = '\0';
		}
	}
}

/*
 *  rtdefault
 *
 *  Fill all unspecified fields of the
 *  file specification from the string.
 */
VOID rtdefault(s)
register char *s;
{
	char str[ISTRING+1];
	register char *t;

	if((s==NULL) || (*s=='\0'))
		return;

	strncpy(str,s,ISTRING);
	str[ISTRING] = '\0';

	if (t = strchr(str,'[')) {
		*t++ = '\0';
	}
	if (t = strchr(str,'.')) {
		*t++ = '\0';
		if (*t && !rt_file.dot && !rt_file.ext[0]) {
			rtscan(rt_file.ext,t,RTEXT);
			rt_file.ext[RTEXT] = '\0';
		}
	}
	if (t = strchr(str,':')) {
		*t++ = '\0';
		if(*t && !rt_file.name[0]) {
			rtscan(rt_file.name,t,RTNAME);
			rt_file.name[RTNAME] = '\0';
		}
		if(str[0] && !rt_file.dev[0]) {
			rtscan(rt_file.dev,str,RTDEV);
			rt_file.dev[RTDEV] = '\0';
		}
	} else {
		if(str[0] && !rt_file.name[0]) {
			rtscan(rt_file.name,str,RTNAME);
			rt_file.name[RTNAME] = '\0';
		}
	}
}

/*
 *  rtstring
 *
 *  Combine the file specification fields
 *  into a file specification string.
 */
char *rtstring()
{
	rt_file.string[0] = '\0';
	if (rt_file.dev[0]!='\0') {
		strcat(rt_file.string,rt_file.dev);
		strcat(rt_file.string,":");
	}
	strcat(rt_file.string,rt_file.name);
	strcat(rt_file.string,".");
	if(rt_file.ext[0]!='\0') {
		strcat(rt_file.string,rt_file.ext);
	} else {
		strcat(rt_file.string,"   ");
	}
	if(rt_file.alloc)
		sprintf(&rt_file.string[strlen(rt_file.string)],
			"[%u]", rt_file.alloc);
	return(rt_file.string);
}

/*
 *  rtwild
 *
 *  Fill unspecified fields with wild cards
 */
int rtwild()
{
	if (rt_file.name[0]=='\0') {
		strcpy(rt_file.name,"*");
	}
	if (rt_file.ext[0]=='\0' && !rt_file.dot) {
		strcpy(rt_file.ext,"*");
	}

	rtstring();
	return(iswild(rt_file.string));
}

/*
 * Is it wild ?
 */
int iswild(str)
register char *str;
{
	if (strchr(str,'*') || strchr(str,'%') || strchr(str,'?'))
		return(1);
	return(0);
}

/*
 *  rtdev
 *
 *  Return pointer to dev string
 */
char *rtdev()
{
	return(rt_file.dev);
}

/*
 *  rtname
 *
 *  Return pointer to name string
 */
char *rtname()
{
	return(rt_file.name);
}

/*
 *  rtext
 *
 *  Return pointer to extension string
 */
char *rtext()
{
	return(rt_file.ext);
}

/*
 *  rtalloc
 *
 *  Return allocation value
 */
unsigned int rtalloc()
{
	return(rt_file.alloc);
}

/*
 *  rtscan
 *
 *  Scan and copy the string
 */
static VOID rtscan(s,t,n)
register char	*s;
register char	*t;
int n;
{
	register int c;
	int i;

	for(i=0; i<n; i++) {
		c = *t++;
		if(isalnum(c)) {
			*s++ = c;
		} else
		if( c=='*' || c=='%' || c=='?' ) {
			*s++ = c;
		} else
		if( c=='$' || c=='_' || c=='-' ) {
			*s++ = 'x';
		} else {
			*s = '\0';
			return;
		}
	}
}

/*
 * Remote filespec
 */
char *rmtfile(st)
char *st;
{
	register char *t,*u;

	/*
	 * discard device spec and any subdirectories
	 */
	t = st;
	while(
		(u = strrchr(t,':')) != NULL ||
		(u = strrchr(t,'/')) != NULL ||
		(u = strrchr(t,'\\')) != NULL
	) { t = ++u; }

	rtparse(t);
	sprintf(rt_file.string,"%s.%s", rtname(),rtext());
	return(rt_file.string);
}
                                                                                                                                                                                                                                                                                                                                                                        