/* net.c */

/*
 *  Includes
 */

#include <stdio.h>
#include <string.h>

#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "hdrchk.h"
#include "endrvr.h"
#include "termio.h"
#include "cticks.h"
#include "suspnd.h"

/*
 *  demux
 *
 *  find the packets in the buffer, determine their lowest level
 *  packet type and call the correct interpretation routines
 *
 *  the 'all' parameter tells demux whether it should attempt to empty
 *  the input packet buffer or return after the first packet is dealt with.
 *
 *  returns the number of packets demuxed
 */
int demux(all)
int all;
{
	register unsigned int getcode;
	register int nmuxed;
	register DLAYER *firstlook;

	nmuxed = 0;
	/*
	 * while all flag is on
	 */
	do {
		/*
		 * where packet is
		 */
		firstlook = (DLAYER *) enrecv();
		if(firstlook!=NULL) {
			nmuxed++;
			/*
			 * where does it belong?
			 */
			getcode = firstlook->type;
			/*
			 * what to do with it?
			 */
			switch(getcode) {
				case EARP:
				case ERARP:
#ifdef	DEBUGOPTION
if(ndebug&0x02) {
					if(getcode==EARP) {
						tt_puts("<a>");
					} else {
						tt_puts("<r>");
					}
}
#endif
					/*
					 * handle ARP packet
					 */
					arpinterpret((ARPKT *)firstlook);
					break;

				case EIP:
#ifdef	DEBUGOPTION
if(ndebug&0x02) {
					tt_puts("<i>");
}
#endif
					ipinterpret((IPKT *)firstlook);
					break;

				default:
#ifdef	DEBUGOPTION
if(ndebug&0x02) {
					tt_puts("<g>");
}
#endif
					break;
			}
			/*
			 * free packet
			 */
			enupdate();
		}
		else 
			all = 0;
	}	while(all);
	return(nmuxed);		/* no packets anymore */
}

/*
 *  dlsend
 *
 *  usage:
 *	err = dlsend(ptr,size)
 *	err=0 for successful, non-zero error code otherwise
 *	ptr is to a dlayer packet header
 *	size is the number of bytes total
 *
 *  Ethernet addresses are resolved at higher levels because they will only
 *  need to be resolved once per logical connection, instead of once per
 *  packet.  Not too layer-like, but hopefully modular.
 *
 */
int dlsend(ptr,size)
register DLAYER *ptr;
register unsigned size;
{
	register int ret;
	
	/*
	 * send it out, pass back return code
	 * enxmit checks for   64 < size < 1518
	 */
	ret = enxmit((char *)ptr,size);
	/*
	 * automatic, immediate retry once
	 */
	if(ret) {
		if(ret = enxmit((char *)ptr,size))
			skposterr(100);
	}
	return(ret);
}

VOID dlshut()
{
	enclose();
}

/*
 *  ntdlayer
 *
 *  get data layer address for insertion into outgoing packets.
 *  searches based on ip number.  If it finds the address, ok, else . . .
 *
 *  Checks to see if the address is on the same network.  If it is,
 *  then ARPs the machine to get address.  Forces pause between sending
 *  arps to guarantee not saturating network.
 *
 *  If not on the same network, it needs the ether address of a 
 *  gateway.  Searches the list of machines for a gateway flag.
 *  Returns the first gateway found with an Ethernet address. 
 *
 *  Returns NULL if not here, or pointer to ether address if here.
 *  If we don't have it, this also sends an ARP request so that the
 *  next time we are called, the ARP reply may be here by then.
 */
char *ntdlayer(tipnum)
register char *tipnum;
{
	long start,t;
	register char *pc;

	/*
	 * some seconds time out
	 */
	start = cticks(NULL);
	t = nndto*TICKSPERSEC;
	pc = NULL;
	while(	((pc = getdlayer(tipnum)) == NULL) &&
		(elapsed(start) < t) && !fndbrk) {
		/*
		 * can't have deadlock
		 */
		suspnd(0);
		ntsleep(0);
	}
	return(pc);
}

/*
 *  ntshut ()
 *
 *  Shut down the hardware.  This tries to close any active
 *  connections and then turn off the hardware ( via dlshut )
 */
VOID ntshut()
{
	register int sknum;

	for(sknum=0; sknum<LSCKTS && sktlist[sknum].region; sknum++) 
			ntclose(sknum);
	ntsleep(1);
	dlshut();
}

/*
 *  ntsleep
 *
 *  sleep, while demuxing packets, so we don't miss anything
 */
int ntsleep(n)
int n;
{
	int nmux;
	register int redir,sknum;
	long start,t,el;
	register struct socket *skt;


	redir = 0;

	start = cticks(NULL);
	t = n*TICKSPERSEC;

	do {
		/*
		 * demux all packets
		 */
		nmux = demux(1);
		/*
		 *  if there were packets in the incoming packet buffer,
		 *  then more might have arrived while we were processing
		 *  them.  This gives absolute priority to packets coming
		 *  in from the network.
		 */
		if(nmux)
			continue;
		/*
		 *  Check each socket to see if action is necessary.
		 *  This now sends all Ack packets, due to p->lasttime
		 *  being set to 0L.  Waiting for nmux==0 for sending
		 *  ACKs makes sure that the network has a much higher
		 *  priority and reduces the number of unnecessary ACKs.
		 */
		for(sknum=0; sknum<LSCKTS && sktlist[sknum].region; sknum++) {
			skt = (struct socket *) mapskt(sknum);
			if(skt->state>SLISTEN) {
				if(skt->out.lasttime==0L) {
#ifdef	DEBUGOPTION
if(ndebug&0x08) {
	printf("ntsleep:lasttime==0L sknum=%d\r\n", sknum);
}
#endif
					/*
					 * takes care of all ACKs
					 */
					transq(skt);
				} else
				if((skt->state==SEST) &&
					(skt->out.rdptr!=skt->out.wtptr)) {
					/*
					 *  if a retransmission
					 *  timeout occurs,
					 *  exponential back-off.
					 *  This number returns
					 *  toward the correct value
					 *  by the RTT measurement
					 *  code in ackcheck.
					 */
					el = elapsed(skt->out.lasttime);
					if(el > skt->rto) {
#ifdef	DEBUGOPTION
if(ndebug&0x08) {
	printf("ntsleep:timeout sknum=%d\r\n", sknum);
}
#endif
					    if(skt->rto<MAXRTO)
						/*
						 * double it
						 */
						skt->rto<<=1;
					    skt->out.nxt = skt->out.ack;
					    transq(skt);
				  	}
				}
				el = elapsed(skt->out.lasttime);
				if(el>POKEINTERVAL) {
				    if(skt->state==SEST) {
#ifdef	DEBUGOPTION
if(ndebug&0x08) {
	printf("ntsleep:pokeinterval sknum=%d\r\n", sknum);
}
#endif
					skt->out.nxt = skt->out.ack;
					transq(skt);
				    } else
				    if(skt->state>SEST) {
#ifdef	DEBUGOPTION
if(ndebug&0x08) {
	printf("ntsleep:pokeinterval sknum=%d\r\n", sknum);
}
#endif
					ntclose(sknum);
				    }
				}
			}
		}
		/*
		 * reset flag for next demux
		 */
		redir = 0;
		/*
		 * suspend on long waits
		 */
		if(n) {
			suspnd(60);
		}
	} while(elapsed(start) < t);
	/*
	 * will demux once, even for sleep(0)
	 */
	return(nmux);
}

/*
 *  ntusend ( machine, port, retport, buffer, n )
 *
 *  Send some data out in a udp packet ( uses the preinitialized
 *  data in the port packet *ulist.udpout* )
 *
 *  Returns 0 on ok send, non-zero for an error
 *
 */
int ntusend(machine,port,retport,buffer,n)
register char *machine,*buffer;
unsigned int port,retport;
register int n;
{
	int ulen;
	char *pc;

	if(n>UMAXLEN)
		n = UMAXLEN;
	/*
	 *  make sure that we have the right dlayer address
	 */
	if(!comparen(machine,ulist.udpout.i.ipdest,4)) {
		pc = ntdlayer(machine);
		if(pc==NULL) 
			return(-2);
		movebytes(ulist.udpout.d.dest,pc,DADDLEN);
		movebytes(ulist.udpout.i.ipdest,machine,4);
		movebytes(ulist.tcps.dest,machine,4);
	}
	ulist.udpout.u.dest = intswap(port);
	ulist.udpout.u.source = intswap(retport);
	ulist.tcps.tcplen = ulist.udpout.u.length =
		intswap(n+sizeof(UDPLAYER));
	movebytes(ulist.udpout.data,buffer,n);
	/*
	 *  put in checksum
	 */
	ulist.udpout.u.check = 0;
	ulist.udpout.u.check =
		tcpcheck((char *)&ulist.tcps,
		(char *)&ulist.udpout.u,n+sizeof(UDPLAYER));
	/*
	 *   iplayer for send
	 */
	ulist.udpout.i.tlen = intswap(n+sizeof(IPLAYER)+sizeof(UDPLAYER));
	ulist.udpout.i.identity = intswap(nnipident++);
	ulist.udpout.i.check = 0;
	ulist.udpout.i.check = ipcheck((char *)&ulist.udpout.i,10);
	ulen = sizeof(DLAYER) + sizeof(IPLAYER) + sizeof(UDPLAYER) + n;
	/*
	 *  send it
	 */
#ifdef	DEBUGOPTION
if(ndebug&0x44) {
	dmpfil("udpout",&ulist.udpout,ulen);
}
#endif
	return(dlsend((DLAYER *)&ulist.udpout,ulen));
}

/*
 *  sdusend ( machine, port, retport, buffer, n )
 *
 *  For Domain Overlay
 */
int sdusend(machine,port,retport,buffer,n)
char *machine,*buffer;
unsigned int port,retport;
int n;
{
	register int ret;

	ret = ntusend(machine,port,retport,buffer,n);
	sdom();
	return(ret);
}

/*
 *  tcpsend
 *
 *  transmits a TCP packet.
 *
 *   For IP:
 *      sets identity,check,totallen
 *   For TCP:
 *      sets seq and window from port information,
 *	fills in the pseudo header and computes the checksum.
 *      Assumes that all fields not filled in here are filled in by the
 *      calling proc or were filled in by makesocket().
 *      (see all inits in protinit)
 */
int tcpsend(skt,dlen)
register struct socket *skt;
register int dlen;
{
	register int tcplen;

	/*
	 * set current in.size
	 */
	skt->in.size = quespace(&skt->in);

	/*
	 * do IP header first
	 */
	skt->tcpout.i.identity = intswap(nnipident++);
	skt->tcpout.i.tlen =
		intswap(sizeof(struct iph)+sizeof(struct tcph) + dlen);
	/*
	 * install checksum
	 */
	skt->tcpout.i.check = 0;
	skt->tcpout.i.check = ipcheck((char *)&skt->tcpout.i,10);

	/*
	 * do TCP header
	 */
	skt->tcpout.t.seq = longswap(skt->out.nxt);
	/*
	 * if the port has some credit limit, use it instead of large
	 * window buffer.  Generally demanded by hardware limitations.
	 */
	if(skt->credit < skt->in.size)
		skt->tcpout.t.window = intswap(skt->credit);
	else
		skt->tcpout.t.window = intswap(skt->in.size);
	/*
	 * prepare pseudo-header for checksum
	 */
	skt->tcps.tcplen = intswap(dlen+sizeof(TCPLAYER));
	skt->tcpout.t.check = 0;
	skt->tcpout.t.check = tcpcheck((char *)&skt->tcps,
		(char *)&skt->tcpout.t,dlen+sizeof(struct tcph));
	skt->out.lasttime = cticks(NULL);
	tcplen = sizeof(DLAYER) + sizeof(IPLAYER) + sizeof(TCPLAYER) + dlen;

#ifdef	DEBUGOPTION
if(ndebug&0x104) {
	dmpfil("tcpout",(DLAYER *)&skt->tcpout,tcplen);
}
#endif
	return(dlsend((DLAYER *)&skt->tcpout,tcplen));
}

                                           