/* ftppi6.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"

VOID ftppi6(cmdno,command)
register int cmdno;
register char *command;
{
	register int i;
	char cmndline[82];
	char word[50];

	switch(cmdno) {
	case PUT:			
	case SEND:		/* put file */
		if(askq(command,79,"File: "))
			return;
		/*
		 * put file
		 */
		sprintf(cmndline,"STOR %s",command);
		ftpdo(cmndline);
		return;

	case PWD:
		i = verbose;
		verbose = TRUE;
		/*
		 * try XPWD
		 */
		if(ftpdo("XPWD") != ERROR) {
			verbose = i;
			return;
		}
		kb_puts("Trying again...\r\n");
		/*
		 * else try PWD
		 */
		ftpdo("PWD");
		verbose = i;
		return;

	case QUOTE:
		if(askq(command,79,"Command: "))
			return;
		/*
		 * send command
		*/
		ftpdo(command);
		return;

	case REMOTEHELP:	/* get help */
		i = verbose;
		verbose = TRUE;
		if(*(stpblk(command))) {
			/*
			 * for specific command
			 */
			sprintf(cmndline,"HELP %s",command);
			ftpdo(cmndline);
		} else {
			ftpdo("HELP");
		}
		verbose = i;
		return;

	case RENAME:		/* rename remote file */
		if(askq(command,79,"From: "))
			return;
		getword(command,word);
		/*
		 * send rename from name
		 */
		sprintf(cmndline,"RNFR %s",word);
		if(ftpdo(cmndline) != INCOMPLETE)
			return;
		if(askq(command,79,"To: ")) {
			ftpdo("ABOR");
			return;
		}
		/*
		 * send rename to name
		 */
		sprintf(cmndline,"RNTO %s",command);
		ftpdo(cmndline);
		return;

	default:
		return;
	}
}
                                                                                                                                                                                               