/* cncti.c */

/*
 *  Includes
 */
#include <string.h>
#include <stdio.h>

#include "vrsion.h"
#include "vcntsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "sktlib.h"
#include "inierr.h"
#include "confgs.h"
#include "kbdutl.h"


#define	ABORT	(-3)


/*
 * Internal/Internal Definitions
 */
extern	char	*hlptxt[];
extern	char	parsedat[80];			/* parsing data */
extern	int	keygets();	/* (str,lim,echo) get line from keyboard */


static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  CNCTSB destination [?] [-eh] [-d level] [-f filename] [-n level]",
       "	?		List the Help Text and Exit CNCTSB",
       "	d   level	Debug Level",
       "		1 -	enable event printing",
#else
       "  CNCTSB destination [?] [-eh] [-f filename]",
       "	?		List the Help Text and Exit CNCTSB",
#endif
       "	e		Enable Error Message Printing",
       "	f  filename     Configuration File",
       "	h		List the Help Text and Open Connection",
#ifdef	DEBUGOPTION
       "	n   level	Network Debug Level",
       "		1 -	enable ARP cache event printing",
       "		2 -	enable packet type printing",
       "		4 -	enable general packet dumping to disk",
       "		8 -	enable ntsleep process printing",
       "	       16 -	enable transq sequence printing",
       "	       32 -	enable arp/rarp packet dumping to disk",
       "	       64 -	enable udp packet dumping to disk",
       "	      128 -	enable icmp packet dumping to disk",
       "	      256 -	enable tcp packet dumping to disk",
       "			Enter level as sum of debug values",
#endif
       "",
	0
	};


/*
 * CNCTSB Startup Code That May Be Overlayed
 */
VOID cncti(argc,argv)
int argc;
char *argv[];
{
	int c;
	register int i,j,k;

	/*
	 * Error Initialization
	 */
	inierr();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * parse arguments
	 */
	parsedat[0] = '\0';
	for(i=1; i<argc; i++) {
		if(argv[i][0]=='?') {
			printtxt(usetxt);
			printtxt(hlptxt);
			exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = DBUGTRUE;
				break;
#endif
			case 'e':	/* error message printing */
				errmsg = 1;
				break;

			case 'f':	/* configuration file name */
				strcpy(Smachfile,argv[++i]);
				break;

			case 'h':	/* display help */
				printtxt(hlptxt);
				break;
#ifdef	DEBUGOPTION
			case 'n':	/* network debug, optional level */
				if(sscanf(argv[++i],"%d",&ndebug) <= 0)
					ndebug = DBUGTRUE;
				break;
#endif
			default:	/* unknown option */
				printf("Unrecognized option %s ignored\r\n",
					&argv[i][0]);
				break;
			}
			k++;
		    }
		} else {
			if(parsedat[0]!='\0')
				strncat(parsedat," ",79);
			strncat(parsedat,argv[i],79);
		}
	}
	if (*parsedat == '\0') {
		kb_puts("Enter machine name/address -->> ");
		if (keygets(parsedat,sizeof(parsedat),1) == ABORT) {
			exit(0);
		}
	}

#ifdef	DEBUGOPTION
	if(debug)
		printf("Debug = %u\r\n", debug);
	if(ndebug)
		printf("Network Debug = %u\r\n", ndebug);
#endif

	/*
	 * Configure Network
	 */
	netini();

	/*
	 * Initialize kb handler
	 * Set the break character to ^?
	 */
	kb_init(0x1F);

}
                                    