/* argutl.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"


/*
 * The general toggle flag routine
 */
int toggle(cstr,wstr,tflag,onstr,offstr)
char *cstr,*wstr,*onstr,*offstr;
register int *tflag;
{
	if(getword(cstr,wstr)) {
		strlwr(wstr);
		if(!strcmp(wstr,"off")) {
			*tflag = FALSE;
		} else
		if(!strcmp(wstr,"on")) {
			*tflag = TRUE;
		} else {
			*tflag = !*tflag;
		}
	} else {
		*tflag = !*tflag;
	}
	if(*tflag) {
		kb_puts(onstr);
	} else {
		kb_puts(offstr);
	}
	return(TRUE);
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;
#ifdef	DEBUGOPTION
if(debug&0x80) {
	printf("getword: string is %s\r\n",string);
}
#endif
	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '!') {
		/*
		 * ! is a word
		 */
		word[0] = *p;
		word[1] = '\0';
		strcpy(string,++p);
		return(TRUE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			kb_puts("Missing \". Assumed at end of string.\r\n");
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len 50
		 */
		q = stptok(p, word, 50, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

/*
 * finduniq:
 *
 * find name that is a unique prefix of one of the entries in
 * a list.  Return position of the entry,
 * NONE if none, AMBIGUOUS if more than one.
 */

int finduniq(name,list,listsize)
char *name, *list[];
int listsize;
{
	register int i,j,ilen;

	j = NONE;
	ilen = strlen(name);
	for(i=0; i<listsize; i++) {
		/*
		 * prefix
		 */
		if(!strncmp(name,list[i],ilen)) {
			if(ilen == strlen(list[i]))
				/*
				 * exact match
				 */
				return(i+1);
			if(j != NONE) {
				/*
				 * more than one match
				 */
				j = AMBIGUOUS;
			} else {
				/*
				 * note prefix found
				 */
				j = i+1;
			}
	  	}
	}
	/*
	 * prefix
	 */
	return(j);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
 
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
 
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}
                                                                                                                                                                                                                                