/* sktl06.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  skgtevent
 *
 *  Retrieves the next event (and clears it) which matches bits in
 *  the given mask.  Returns the event number or 0 on no event present.
 *  Also returns the exact class and the associated integer in reference
 *  parameters.
 *
 *  The way the queue works:
 *	There is always a dummy record pointed to by nnelast.
 *	When data is put into the queue, it goes into nnelast,
 *	then nnelast looks around for another empty one to obtain.
 *	It looks at nnefree first, then bumps one from nnefirst if necessary.
 *	When data is retrieved, it is searched from nnefirst to nnelast.
 *	Any freed record is appended to nnefree.
 */
int skgtevent(mask,retclass,retdat)
register int mask;
int *retclass,*retdat;
{
	register int i,j;

	i = nnefirst;
	j = 0;
	while(i!=nnelast) {
		if(mask&nnq[i].eclass) {
			if(i==nnefirst) {
				/*
				 * step nnefirst
				 */
				nnefirst = nnq[nnefirst].next;
			} else {
				/*
				 * bypass record i
				 */
				nnq[j].next = nnq[i].next;
			}
			nnq[i].next = nnefree;
			/*
			 * install in free list
			 */
			nnefree = i;
#ifdef	DEBUGOPTION
if(debug&0x01) {
	printf("event: class=0x%x, event=%d, data=%d, idx=%d\r\n",
		nnq[i].eclass, nnq[i].event, nnq[i].idata, i);
}
#endif
			*retdat = nnq[i].idata;
			*retclass = nnq[i].eclass;
			return(nnq[i].event);
		}
		j = i;
		i = nnq[i].next;
	}
	return(0);
}
                                                                                                                                                                                                                                                                                                  