/* shost4.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "mapskt.h"
#include "bytprc.h"
#include "confgs.h"

extern	shost4();

/*
 *  Sgethost
 *
 *  get host by name
 *  Given the name of a host machine, search our database to see if we
 *  have that host ip number.  Search first the name field, and then the
 *  hostname field.  If the IP # is given, returns a ptr to the
 *  default machine record with that IP # installed.
 *  Returns the pointer to a valid record, or NULL if the IP # cannot
 *  be deciphered.
 */
struct machinfo *Sgethost(sknum,machine)
int sknum;
register char *machine;
{
	int i,j,k,l;
	char ipto[4],myipnum[4],xmask[4];
	long hnum;
	register struct socket *skt;
	register struct machinfo *mhost;

	mhost = NULL;
	/*
	 *  First, check for the '.' character which means we should
	 *  use the current netmask to build an IP number for the local
	 *  network. Take the host number, install it in the ipto[] array.
	 *  Then mask in my IP number's network portion to build the final
	 *  IP address.
	 */
	if(machine[0]=='.') {
		/*
		 * on my local network
		 */
		skgtip(myipnum);
		/*
		 * mask of network portion of IP #
		 */
		skgtmask(xmask);
		/*
		 * host number for local network
		 */
		sscanf(&machine[1],"%ld",&hnum);
		for(i=3; i>=0; i--) {
			if(xmask[i]) {
				ipto[i] = myipnum[i];
			} else {
				ipto[i] = hnum & 0xFFL;
				hnum >>= 8;
			}
		}
	} else
	/*
	 *  next, is it an IP number?  We take it if the number is in four
	 *  parts, separated by periods.
	 */
	if(4==sscanf(machine,"%d.%d.%d.%d",&i,&j,&k,&l)) {
		/*
		 * given ip num
		 */
		ipto[0] = (char)i;
		ipto[1] = (char)j;
		ipto[2] = (char)k;
		ipto[3] = (char)l;
	} else {
	/*
	 *  lastly, it must be a name, first check the local host table
	 *  A first number of 127 means that it doesn't have an IP number, but
	 *  is in the table(strange occurrence)
	 */
		/*
		 * look it up
		 */
		mhost = (struct machinfo *)
			ovrlay(shost4,Shostlook,2,sknum,machine);
		if(mhost==NULL) {
			skposterr(805);
			return(NULL);
		}
		if(mhost->mstat<HAVEIP) {
			skposterr(806);
			return(NULL);
		}
	}
	skt = (struct socket *) mapskt(sknum);
	skt->mpp = &skt->mach;
	if(mhost) {
		movebytes(&skt->mach,mhost,sizeof(struct machinfo));
	} else {
		mhost = (struct machinfo *)
			ovrlay(shost4,Shostlook,2,-1,"default");
		/*
		 * set up internal parameters after loading defaults
		 */
		movebytes(&skt->mach,mhost,sizeof(struct machinfo));
		movebytes(&skt->mach.hostip,ipto,4);
		skt->mach.mstat = HAVEIP;
	}
	/*
	 * load names
	 */
	skt->mach.sname = skt->sname;
	if(skt->sname[0]=='\0')
		strncpy(skt->sname,mhost->sname,sizeof(skt->sname)-1);
	skt->mach.hname = skt->hname;
	if(skt->hname[0]=='\0')
		strncpy(skt->hname,mhost->hname,sizeof(skt->hname)-1);
	/*
	 * port number
	 */
	skt->mach.port = skt->sktport;

	return(&skt->mach);
}

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  