/* hstdef.h */

/*
 *  Host and local machine configuration information.
 */

/*
*  Linked list of structures which describe other machines.
*  Arranged one per session with unique session names.
*/
typedef struct machinfo {
	char 	*sname,		/* pointer to name of session */
		*hname,		/* pointer to name of that machine */
		hostip[4],	/* IP number of this machine */
		gateway,	/* gateway preference, start with 1 */
		nameserv,	/* nameserver preference, start with 1 */
		delete,		/* character deletion value */
		halfdup,	/* half duplex required */
		crmap;		/* Strange Berkeley 4.3 CR mode needed */
	int	port,		/* TCP port number to access, */
				/* telnet = 23 / ftp = 21 / other... */
		mno,		/* machine number for reference */
		mstat,		/* status of this machine entry */
		retrans,	/* initial retrans timeout */
		conto,		/* time out in seconds to wait for connect */
		window,		/* window, will be checked against buffers */
		maxseg,		/* maximum receivable segment size */
		mtu;		/* maximum transfer unit MTU (out) */
	struct machinfo *next;	/* surprise, its a linked list! */
				/* within a socket = NULL */
};

/*
 * 4.3BSDCRNUL Definition
 */
#define	BSDCRNUL	(-1)

/*
 *  status fields for mstat, what do we know about that machine?
 */
#define NOIP	1	/* we don't have IP number */
#define UDPDOM	3	/* there is a UDP request pending on it */
/*
 *  The next 20 numbers are reserved for UDPDOM
 */
#define HAVEIP	50	/* at least we have the # */
#define HFILE	70	/* we have IP number from host file */
#define DOM	71	/* we have an IP number from DOMAIN */
/*
 *   Configuration information
 */
typedef struct config {
char	netmask[4],	/* subnetting mask being used */
	havemask,	/* do we have a netmask? */
	myipnum[4],	/* what is my IP #? */
	me[70],		/* my name description (first 69 chars) */
	*defdom;	/* default domain */
int	nstype;		/* nameserver = 1-domain / 2-IEN-116 */
};

                                                                                         