/* ftpsbi.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "confgs.h"
#include "ftppi.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "ftpsb.h"

/*
 * Debugging options
 *
 *	bit 0	(0x01)	enable event printing
 *	bit 1	(0x02)	enable command printing
 *	bit 2	(0x04)	debug ftpdo()
 *	bit 3	(0x08)	debug ftpport()
 *	bit 4	(0x10)	debug ftpreplies()
 *	bit 5	(0x20)	debug rgetline()
 *	bit 6	(0x40)	debug userftpd()
 *	bit 7	(0x80)	debug getword()
 */

static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
"   FTPSB [?] [-ehv] [-d level] [-f filename] [-n level] [destination host]",
       "	?		List this Help Text and Exit FTPSB",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable command printing",
       "		4 -	enable ftpdo() printing",
       "		8 -	enable ftpport() printing",
       "	       16 -	enable ftpreplies printing",
       "	       32 -	enable rgetline() printing",
       "	       64 -	enable userftpd() printing",
       "	      128 -	enable getword() printing",
#else
"   FTPSB [?] [-ehv] [-f filename] [destination host]",
       "	?		List this Help Text and Exit FTPSB",
#endif
       "	e		Enable Error Message Printing",
       "	f  filename     Configuration File",
       "	h		FTPSB Help List",
#ifdef	DEBUGOPTION
       "	n   level	Network Debug Level",
       "		1 -	enable ARP cache event printing",
       "		2 -	enable packet type printing",
       "		4 -	enable general packet dumping to disk",
       "		8 -	enable ntsleep process printing",
       "	       16 -	enable transq sequence printing",
       "	       32 -	enable arp/rarp packet dumping to disk",
       "	       64 -	enable udp packet dumping to disk",
       "	      128 -	enable icmp packet dumping to disk",
       "	      256 -	enable tcp packet dumping to disk",
       "			Enter level as sum of debug values",
#endif
       "	v		Verbose Mode Disabled",
       "",
	0
	};


/*
 * FTPSB Startup Code That May Be Overlayed
 */
ftpsbi(argc,argv)
int argc;
char *argv[];
{
	int c;
	register int i,j,k;

	/*
	 * Initialize
	 */
	inierr();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * initialize destination host name
	 */
	destname[0] = '\0';

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = DBUGTRUE;
				break;
#endif
			case 'e':	/* error message printing */
				errmsg = 1;
				break;

			case 'f':	/* configuration file name */
				strcpy(Smachfile,argv[++i]);
				break;

			case 'h':	/* help listing */
				ftppi("?");
				break;
#ifdef	DEBUGOPTION
			case 'n':	/* network debug, optional level */
				if(sscanf(argv[++i],"%d",&ndebug) <= 0)
					ndebug = DBUGTRUE;
				break;
#endif
			case 'v':	/* verbose mode disabled */
				verbose = FALSE;
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		} else {
			/*
			 * destination host
			 */
			if(destname[0] != '\0')
				strncat(destname," ",49);
			strncat(destname,argv[i],49);
		}
	}

#ifdef	DEBUGOPTION
	if(debug)
		printf("Debug = %u\r\n", debug);
	if(ndebug)
		printf("Network Debug = %u\r\n", ndebug);
#endif

	/*
	 * Initialize various things,
	 */
	netini();
}
                                                                                                                                                                          