/* ftpa.c */

#define FTPMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vftp.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "cliutl.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "usrblk.h"
#include "inicli.h"
#include "cticks.h"
#include "suspnd.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	int	ftpgets();	/* (str,lim,echo) read line from keyboard */
extern	VOID	ftpexit();	/* (i) exit from ftp */
extern	int	dumpcon();	/* dump connection to screen */
extern	VOID	filter();	/* (cnt) filter telnet options */
extern	int	question();	/* (cstr,clen,qstr) pose a question */
extern	int	ftpresp();	/* (s,len) response function for tsxutl */
extern	VOID	lcd();		/* (s) change local directory */
extern	VOID	ldelete();	/* (s) delete a local file */
extern	VOID	ldelfil();	/* (s) subroutine of ldelete */
extern	VOID	lls();		/* (s) list local directory */
extern	VOID	lmkdir();	/* (s) make a local directory */
extern	VOID	lprotect();	/* (s) set protection flag on local file */
extern	VOID	setfilp();	/* (s) subroutine of lprotect */
extern	VOID	lunprotect();	/* (s) clr protection flag on a local file */
extern	VOID	clrfilp();	/* (s) subroutine of lunprotect */
extern	VOID	lsterr();	/* print error string from tsxutl */
extern	int	toggle();	/* (cstr,wstr,flag,on,off) toggle flags */
extern	VOID	ftppi();	/* (command) protocol interpreter */
extern	int	setmode();	/* (mode,filnam) set mode, return old mode */
extern	int	ftpopen();	/* (lpnum,dst,port) open FTP connection */
extern	int	ftpport();	/* prepare port */
extern	int	ftpcnct();	/* open FTP data connection */
extern	int	ftplstn();	/* listen for FTP data connection */
extern	int	ftpdo();	/* (s,filnam) do a command */
extern	int	ftpreplies();	/* (rcode) get response to server */
extern	int	ftpabort();	/* (how) abort FTP */
extern	int	rgetline();	/* get line from remote server */
extern	VOID	userftpd();	/* FTP recieve and send file functions */
extern	int	getword();	/* (s,word) remove word from string */
extern	int	checkoredir();	/* (cmnd,filnam) check redirected output */
extern	int	finduniq();	/* (nam,lst,lstsz) find unique string */
extern	int	checkevent();	/* process server events */
extern	int	getnname();	/* (s,word) get next name from list */
extern	VOID	strlwr();	/* (s) convert string to lower case */
extern	int	chkusr();	/* check username / password */
extern	int	Scompass();	/* (ps,en) compare passwords */
extern	VOID	printtxt();	/* (s) printout text */
#endif

extern	FILE *	opncap();	/* (filspc,mode) open the capture file */
extern	char	*stptok();	/* (p,word,ilen,delim) stop on token */
extern	char	*stpblk();	/* (s) skip spaces and tabs */

/*
 * Debugging options
 *
 *	bit 0	(0x01)	enable event printing
 *	bit 1	(0x02)	enable command printing
 *	bit 2	(0x04)	debug ftpdo()
 *	bit 3	(0x08)	debug ftpport()
 *	bit 4	(0x10)	debug ftpreplies()
 *	bit 5	(0x20)	debug rgetline()
 *	bit 6	(0x40)	debug userftpd()
 *	bit 7	(0x80)	debug getword()
 *	bit 8	(0x100)	debug getnname()
 */

#define DBUGTRUE	-1

char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "   FTP [?] [-d level] [-f filename] [-p filename]",
       "	   [-ghinrv] [destination host]",
       "	?		List this Help Text and Exit FTP",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable command printing",
       "		4 -	enable ftpdo() printing",
       "		8 -	enable ftpport() printing",
       "	       16 -	enable ftpreplies printing",
       "	       32 -	enable rgetline() printing",
       "	       64 -	enable userftpd() printing",
       "	      128 -	enable getword() printing",
       "	      256 -	enable getnname() printing",
#else
       "   FTP [?] [-f filename] [-p filename]",
       "	   [-ginrv] [destination host]",
       "	?		List this Help Text and Exit FTP",
#endif
       "	f  filename	Command File",
       "	g		Wildcard Expansion Disabled",
       "	h		FTP Help List",
       "	i		Interactive Prompting Off",
       "	n		AutoLogin Disabled on Connect",
       "	p  filename	Specify the Password Filespec",
       "	r		Output Redirection Disabled",
       "	v		Verbose Mode Disabled",
       "",
	0
	};


#define	FASCII		 0
#define FIMAGE		 1

#define FALSE		 0
#define TRUE		 1
#define SUCCESS		 2
#define HAVEDATA	 4
#define ERROR	   	-1
#define NONE	   	-2
#define ABORT	   	-3
#define INCOMPLETE	-4
#define AMBIGUOUS	-5

				/* password file */
char	*pass = "PAS:paswrd.fil";
				/* capture file */
char	*capfil = "wf:capfil.000";

int	pswdreqd = 1,		/* password required */
	xp = 0,			/* general pointer */
	towrite = 0,		/* file transfer pointer */
	len = 0,		/* file transfer length */
	ftpcskt = -1,		/* current command port */
	ftpdskt = -1,		/* current data port */
	ftpstate = 0,		/* state for background process */
	ftpfilemode = FASCII,	/* file open mode for transfer */
	finished = TRUE,	/* file transfer complete flag */
	tfrdly = 0,		/* transfer suspend time */
	tfrabtf = 0,		/* transfer abort flag */
	hash = 0,		/* hash mark printing */
	hashnum = 0,		/* number of hash marks printed */
	hashcnt = 0,		/* hash mark counter */
	linked = 0,		/* not connected */
	sendport = 1,		/* to send ports or not */
	passive = 0,		/* to request passive mode or not */
	verbose = 1,		/* informative messages */
	redirect = 1,		/* ouput redirection enabled */
	capture = FALSE,	/* capture list flag */
	redout = FALSE,		/* redirected output specified flag */
	redocap = FALSE,	/* redirected output capture flag */
	bell = 0,		/* sound bell */
	autologin = 1,		/* login on connect */
	prompt = 1,		/* check on multiple commands */
	fromtty = TRUE,		/* default input from tty */
	fildev = 1,		/* file oriented devices */
	wild = 1;		/* expand wildcards */

unsigned int
	iosize = 0;		/* transfer size in 512 byte blocks */

long	start,			/* transfer start time */
	tbytes;			/* number of bytes transferred */

FILE *fromfp = NULL;		/* file pointer for input command file */
FILE *ftpfh = NULL;		/* file pointer for ftp transfers */
FILE *capfp = NULL;		/* capture file for multiple commands */
FILE *redfp = NULL;		/* capture file for redirected commands */

/*
 * Transfer Delay Time Limits
 */

#define	MINTFRDLY	3
#define	MAXTFRDLY	15

/*
 * READSIZE is the system BLOCK SIZE
 * BUFFERS must be an integral multiple of READSIZE
 * xs[] must be at least 1 byte larger than READSIZE
 */

#ifdef	DEBUGOPTION
#define BUFFERS		1024	/* size of buffer */
#else
#define BUFFERS		2048	/* size of buffer */
#endif

#define READSIZE	512	/* how much to read */
#define	GBUFSIZE	200	/* general buffer size */

char destname[50]={0,0};	/* who to connect to */
char ftpcommand[GBUFSIZE];	/* command to execute */
char printline[GBUFSIZE];	/* line to display */
char s[GBUFSIZE];		/* line from other side */
char spathp[GBUFSIZE];		/* save path buffer p */
char spathq[GBUFSIZE];		/* save path buffer q */
char xs[BUFFERS];		/* buffer space for file transfer */


/*
 * main - main procedure.  Displays opening message, parses arguments,
 *	  initializes network, reads user commands and executes them, and
 *	  cleans up.
 */

char fromfile[20] = "";

main(argc,argv)
int argc;
char *argv[];
{
	register int i,j,k,c;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * initialize destination host name
	 */
	destname[0] = '\0';

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
			case 'v':	/* verbose mode disabled */
				verbose = FALSE;
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
			case 'r':	/* turn off output redirection */
				redirect = FALSE;
				break;

			case 'p':	/* password file */
				pass = argv[++i];
				break;

			case 'n':	/* do not login on connect */
				autologin = FALSE;
				break;

			case 'i':	/* interactive prompting off */
				prompt = FALSE;
				break;

			case 'h':	/* help listing */
				ftppi("?");
				break;

			case 'g':	/* wildcard expansion off */
				wild = FALSE;
				break;

			case 'f':	/* noninteractive, filename */
				fromtty = FALSE;
				strcpy(fromfile,argv[++i]);
				if(fromfile[0]) {
		   		    fromfp = fopen(fromfile,"r");
		   		    if(fromfp == NULL) {
					kbprintf(
					"Could not open command file: %s\r\n",
					fromfile);
					exit(0);
		   		    }
				}
				break;

#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = TRUE;
				break;
#endif
			/*
			 * This is a 'hidden' option for bypassing
			 * the password processing.
			 */
			case 'b':	/* bypass password processing */
				pswdreqd = 0;
				break;

			default:	/* unknown option */
				kbprintf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		} else {
			/*
			 * destination host
			 */
			if(destname[0] != '\0')
				strncat(destname," ",49);
			strncat(destname,argv[i],49);
		}
	}

	/*
	 * Initialize various things,
	 */
	Snetinit();

	/*
	 * Create a unique file name for capture file
	 */
	sprintf(capfil,"wf:capfil.%03d", tljobn);

	/*
	 * Test Username / Password
	 */
	if(pswdreqd) {
		if(chkusr()) {
			kb_puts("\r\nEscaping from FTP\r\n");
			exit(0);
		}
	}

	if(destname[0])
		/*
		 * if destination specified, connect to it
		 */
		sprintf(ftpcommand,"open %s",destname);

	while(1) {
		if(*ftpcommand) {
			/*
			 * if command available, execute it
			 */
			ftppi(ftpcommand);
#ifdef	DEBUGOPTION
if(debug&0x02) {
			printf("after returning from ftppi()\r\n");
}
#endif
		}
		/*
		 * prompt
		 */
		kb_puts("ftp> ");
		/*
		 * read cmd from user
		 */
		ftpgets(ftpcommand,sizeof(ftpcommand),1);
	}
}

/*
 * General looping question routine
 * loops until a response is given
 *	returns 1 on ABORT
 *	   else 0
 */
int question(cstr,clen,qstr)
char *cstr,*qstr;
int clen;
{
	while(!(*(stpblk(cstr)))) {
		/*
		 * get arg from user
		 */
		kb_puts(qstr);
		if(rtresp(cstr,clen))
			return(1);
	}
	return(0);
}

/*
 * Routine to get a keyboard response
 *	returns 1 on ABORT
 *	   else 0
 */
int rtresp(st,ln)
char *st;
int ln;
{
	return((ftpgets(st,ln,1)==ABORT) ? 1 : 0);
}

/*
 * tstbrk
 *
 * if fndbrk is set then:
 *	(1)	terminate command file mode
 *	(2)	return(1)
 * else
 *		return(0)
 */
int tstbrk()
{
	if(fndbrk) {
		if(fromfp != NULL) {
			fclose(fromfp);
			fromfp = NULL;
			fromtty = TRUE;
			kb_puts("\r\nCommand File Input Aborted\r\n");
		}
		fndbrk = 0;
		return(1);
	} else {
		return(0);
	}
}

/*
 * ftpgets
 *
 * read a line from the keyboard
 * returns ABORT if keyboard input aborted
 * or non-zero on success
 */
int ftpgets(str,lim,echo)
register char *str;	/* where to put the line */
int lim,echo;		/* max chars to read, echo? */
{
	register char *save;
	register int c;

	save = str;		/* beginning of line */
	*save = '\0';
	lim -= 1;

	if(tstbrk()) {
		kb_puts("^C\r\n");
		return(ABORT);
	}
	if(!fromtty) {
		if(fromfp != NULL) {
			if(fgetss(str,lim,fromfp) != NULL) {
				str[lim] = '\0';
				if(echo) {
					kb_puts(str);
					kb_nline();
				}
			} else {
				fclose(fromfp);
				fromfp = NULL;
				fromtty = TRUE;
				kb_puts("[EOF]\r\n");
			}
			return(strlen(str));
		} else {
			fromtty = TRUE;
		}
	}
	while(1) {
		/*
		 * build string from keyboard
		 */
		c = kb_gets(str,lim,echo);
		if(1 <= c && c <= 31) {
			kb_nline();
			return(strlen(save));
		}
		/*
		 * check for abort
		 */
		if(tstbrk()) {
			*save = '\0';
			kb_puts("^C\r\n");
			return(ABORT);	
		}
		/*
		 * check event queue
		 */
		checkevent();
		suspnd(0);
	}
}

/*
 * ftpexit
 *
 * exit from ftp
 */
VOID ftpexit(i)
int i;
{
	if(i == ABORT) {
		kb_puts("\r\nFTP session aborted by TCPIP\r\n");
	} else {
		while(linked && (checkevent() != ABORT)) {
			suspnd(0);
		}
	}

	/*
	 * Close all connections
	 */
	skclose(ftpcskt);
	skrelease(ftpcskt,1);
	skclose(ftpdskt);
	skrelease(ftpdskt,1);

	rtclose(ftpfh);

	suspnd(0);
	errhandle();

	/*
	 * Reset subdirectory specifications
	 */
	cd("dk:");

	kb_puts("\r\nEscaping from FTP\r\n");
	exit(0);
}

/*
 * dumpcon
 *
 * take everything from a connection and send it to the screen
 * return -1 on closed connection, else 0, 1 if paused
 */
int dumpcon()
{
	register int cnt;

	/*
	 * get some from queue
	 */
	do {
		cnt = skread(ftpcskt,s,GBUFSIZE);
		if(cnt>0) {
			skdeque(ftpcskt);
			/*
			 * display on screen, etc.
			 */
			filter(cnt);
		}
	} while(cnt>0);
	/*
	 * 0 normally, -1 if connection closed
	 */
	return(cnt);
}


/*
 * filter
 *
 * filter telnet options on incoming data
 */
VOID filter(cnt)
int cnt;
{
	register int i;

#ifdef	DEBUGOPTION
if(debug&0x100) {
	printf("filter(): cnt=%d \r\n",cnt);
}
#endif
	/*
	 * put on screen
	 */
	for(i=0; i<cnt; i++) {
		if(s[i] & 128) {
			/*
			 * if over ASCII 128 show as number
			 */
			kbprintf(" %d ", s[i]&0xFF);
		} else {
			kb_out(s[i]);
		}
	}

#ifdef	DEBUGOPTION
if(debug&0x100) {
	printf("filter(): leaving \r\n");
}
#endif
}

/*
 *	Various routines that interface with the
 *	TSXUTL.C utilities.
 */
VOID lcd(st)
register char *st;
{
	char path[100];

	getpath(path);
	if(cd(st)) {
		lsterr();
		cd(path);
		lsterr();
	}
}

VOID ldelete(st)
char *st;
{
	VOID ldelfil();

	dispatch(ldelfil,st);
}

VOID ldelfil(st)
char *st;
{
	delfil(0,st,prompt,wild);
}

VOID lls(st)
char *st;
{
	int dspdir();

	dispatch(dspdir,st);
}

VOID lmkdir(st)
char *st;
{
	int mkdir();

	dispatch(mkdir,st);
}

VOID lprotect(st)
char *st;
{
	VOID setfilp();

	dispatch(setfilp,st);
}

VOID setfilp(st)
char *st;
{
	setclrp(st,1,wild);
}

VOID lrename()
{
	VOID newname();

	dispatch(newname,&xs[0]);
}

VOID newname(st)
char *st;
{
	rename(st,&xs[100],fromtty&&prompt,wild);
}

VOID lrmdir(st)
char *st;
{
	VOID rmdir();

	dispatch(rmdir,st);
}

VOID rmdir(st)
char *st;
{
	delfil(1,st,prompt,wild);
}

VOID lunprotect(st)
char *st;
{
	VOID clrfilp();

	dispatch(clrfilp,st);
}

VOID clrfilp(st)
char *st;
{
	setclrp(st,0,wild);
}

VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * The general toggle flag routine
 */
int toggle(cstr,wstr,tflag,onstr,offstr)
char *cstr,*wstr,*onstr,*offstr;
register int *tflag;
{
	if(getword(cstr,wstr)) {
		strlwr(wstr);
		if(!strcmp(wstr,"off")) {
			*tflag = FALSE;
		} else
		if(!strcmp(wstr,"on")) {
			*tflag = TRUE;
		} else {
			*tflag = !*tflag;
		}
	} else {
		*tflag = !*tflag;
	}
	if(*tflag) {
		kb_puts(onstr);
	} else {
		kb_puts(offstr);
	}
	return(TRUE);
}

/*
 * Print help text string
 */
VOID prnthelp(n)
register int n;
{
	char txt[80];
	FILE *fcmdfp;
	register int i;

	if( n>=1 && n<=NCMDS+1) {
		if((fcmdfp = fopen("TCP:ftpcmd.txt","r")) != NULL) {
			for(i=0; fgetss(txt,80,fcmdfp)!=NULL && i<n; i++) {
				;
			}
			fclose(fcmdfp);
			if(i == n) {
				kbprintf("%s\r\n", txt);
				return;
			}
		}
	}
	kb_puts("Help not available\r\n");
}
				

/*
 * FTP PI
 *
 * Protocol interpreter for user interface commands
 * Will permit any command to be abbreviated uniquely.
 * Recognizes commands, translates them to the protocol commands to be
 * sent to the other server, and uses userftpd to do data transfers.
 */
int ftppi(command)
char *command;
{
	register int cmdno,i,j,curfilemode;
	int ivalue;
	char cmdname[50],cmndline[100],word[50];
	char line[100],answer[20],ofilename[50];
	char *p,*q;
	FILE *fp;

	/*
	 * print command
	 */
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("command: %s\r\n",command);
}
#endif
	/*
	 * get command number
	 */
	if(!getword(command,cmdname))
		 return;
	/*
	 * removes first word from command
	 */
	cmdno = finduniq(cmdname,ftp_cmdlist,NCMDS);
	/*
	 * search cmdlist for prefix
	 */
	if(cmdno == AMBIGUOUS) {
		kb_puts("?-Ambiguous command\r\n");
		return;
	}
	/*
	 * not a prefix of any command
	 */
	if(cmdno == NONE) {
		kb_puts("?-Invalid command\r\n");
		return;
	}
	/*
	 * check if command output redirected
	 */
	redocap = FALSE;
	redout = checkoredir(command,ofilename);
	/*
	 * process commands
	 */
	switch(cmdno) {
	case QMARK:
	case HELP:
		if(!command[0]) {
			kb_puts(
			"These valid commands may be abbreviated:\r\n");
			/*
			 * display command list
			 */
			printline[0] = '\0';
			for(i=0,j=0; i<NCMDS; i++) {
				/*
				 * skip if a blank entry
				 */
				if (ftp_cmdlst[i] == NULL)
					continue;
				/*
				 * get word from list
				 */
				if(j%5 != 4) {
					sprintf(word,"%-16s",ftp_cmdlist[i]);
					strcat(printline,word);
				} else {
					sprintf(word,"%s\r\n",ftp_cmdlist[i]);
					strcat(printline,word);
					kb_puts(printline);
					printline[0] = '\0';
				}
				j++;
			}
			/*
			 * last line
			 */
			if(printline[0] != '\0') {
				kb_puts(printline);
				kb_nline();
			}
			/*
			 * print redirection note
			 */
			prnthelp(NCMDS+1);
			/*
			 * print filespec note
			 */
			kb_nline();
			rtusage();
		} else {
			/*
			 * help for specific commands
			 */
			while(getword(command,word)) {
				/*
				* which command?
				*/
				i = finduniq(word,ftp_cmdlist,NCMDS);
				if(i == AMBIGUOUS) {
				    /*
				     * non-unique command name
				     */

		kbprintf("?-Ambiguous help command %s\r\n",word);

				} else {
				    /*
				     * no such command
				     */
				    if(i == NONE) {

		kbprintf("?-Invalid help command %s\r\n",word);

				    } else {
					/*
					 * display help string
					 */
					prnthelp(i);
				    }
				}
			}
		}
		return;

	case BELL:
		return(	toggle(command,word,&bell,
			"Bell mode on.\r\n",
			"Bell mode off.\r\n")
			);

	case BYE:
	case QUIT:
		if(linked) {
			ftpdo("QUIT");
			linked = 0;
		}
		/*
		 * exit FTP
		 */
		ftpexit(0);

#ifdef	DEBUGOPTION
	case DEBUG:	/* turn on/off debugging, optional level */
		if(sscanf(command,"%d",&ivalue)>0) {
			debug = ivalue;
			kbprintf("Debugging on(debug=%d).\r\n",debug);
		} else {
			toggle(command,word,&debug,
			"Debugging on.\r\n",
			"Debugging off.\r\n");
		}
		return;
#else
	case DEBUG:	/* no debugging */
		kb_puts("Debugging not available.\r\n");
		return;
#endif

	case WILD:	/* wildcard expansion */
		return(	toggle(command,word,&wild,
			"Wildcards enabled.\r\n",
			"Wildcards disabled.\r\n")
			);

	case HASH:	/* hash mark printing */
		return(	toggle(command,word,&hash,
			"Hash printing on (1024 bytes/hash mark).\r\n",
			"Hash printing off.\r\n")
			);

	case HOME:		/* go to home directory */
		kbprintf("Home directory is dk: --> %s\r\n", gethome(line));
		cd("dk:");
		lsterr();
		return;

	case INTERACTIVE:	/* turn on interactive prompting */
	case NONINTERACTIVE:	/* turn off interactive prompting */
	case PROMPT:		/* interactive prompting */
		if(cmdno == INTERACTIVE)
			prompt = FALSE;		/* will be toggled */
		if(cmdno == NONINTERACTIVE)
			prompt = TRUE;		/* will be toggled */
		return(	toggle(command,word,&prompt,
			"Interactive mode on.\r\n",
			"Interactive mode off.\r\n")
			);

	case LPWD:		/* local working directory */
		*command = '\0';

	case LCD:		/* change local directory */
		if(*(stpblk(command)))
			lcd(command);
		/*
		 * current directory
		 */
		kbprintf("Local directory is %s --> %s\r\n",
				getdef(), getpath(line));
		return;

	case LRENAME:		/* local RENAME */
		if(question(command,100,"From: "))
			return;
		getword(command,&xs[0]);
		if(question(command,100,"To:   "))
			return;
		getword(command,&xs[100]);
		lrename();
		return;

	case LDELETE:		/* local DEL */
	case LDIR:		/* local DIR */
	case LLS:		/* local DIR */
	case LMKDIR:		/* local MKDIR */
	case LPROTECT:		/* local PROTECT */
	case LRMDIR:		/* local RMDIR */
	case LTYPE:		/* local TYPE */
	case LUNPROTECT:	/* local UNPROTECT */
		/*
		 * Preprocessing
		 */
		if(!*(stpblk(command))) {
			switch(cmdno) {
			case LDELETE:
			case LPROTECT:
			case LTYPE:
			case LUNPROTECT:
				if(question(command,100,"File(s): "))
					return;
				break;

			case LDIR:
			case LLS:
				lls(command);
				tstbrk();
				return;

			case LRMDIR:
			case LMKDIR:
				if(question(command,100,"Directory(s): "))
					return;
				break;
			}
		}
		/*
		 * for each arg
		 */
		while(!tstbrk() && getword(command,word)) {
			/*
			 * for each name
			 */
			switch(cmdno) {
			case LDELETE:
				ldelete(word);
				break;

			case LDIR:
			case LLS:
				lls(word);
				break;

			case LMKDIR:
				lmkdir(word);
				break;

			case LPROTECT:
				lprotect(word);
				break;

			case LRMDIR:
				lrmdir(word);
				break;

			case LTYPE:
				if((fp = rtopen(word,"r",0,0)) != NULL) {

				kbprintf("\r\nFile %s\r\n\r\n", word);
				while(fgetss(line,sizeof(line)-1,fp)!=NULL &&
						!tstbrk()) {
					kbprintf("%s\r\n", line);
				}
				rtclose(fp);

				} else {

				kbprintf("\r\nFile %s not found\r\n", word);

				}
				kb_puts("\r\n");
				break;

			case LUNPROTECT:
				lunprotect(word);
				break;

			}
		}
		return;

	case OPEN:		/* open connection to host */
		if(linked) {
			kb_puts("Already connected.\r\n");
			return;
		}
		if(question(command,100,"To: "))
			return;
		/*
		 * host name
		 */
		getword(command,destname);
		/*
		 *  Open a connection to the machine named.
		 */
		if(ftpopen(0,destname,HFTP) == FALSE)
			return;
		/*
		 * response from other end
		 */
		ftpreplies(&ivalue);
#ifdef	DEBUGOPTION
if(debug&0x10) {
		printf("return from ftpreplies()\r\n");
}
#endif
		if(tstbrk()) {
			return;
		}
		linked = TRUE;
		if(autologin) {
			strcpy(command,"user");
			ftppi(command);
		}
		return;

	case PASSIVE:		/* request PASSIVE mode for transfer */
		return(	toggle(command,word,&passive,
			"Passive mode enabled.\r\n",
			"Passive mode disabled.\r\n")
			);

	case SENDPORT:		/* send PORT commands for each transfer */
		return(	toggle(command,word,&sendport,
			"Use of PORT commands on.\r\n",
			"Use of PORT commands off.\r\n")
			);

	case STATUS:		/* display status info */
		if(linked) {
			kbprintf("Connected to %s\r\n",destname);
		}
		if(ftpfilemode == FASCII) {
			kb_puts("Transfer mode is ascii.\r\n");
		} else {
			kb_puts("Transfer mode is binary.\r\n");
		}
		if(bell) {
			kb_puts("Bell on.\r\n");
		} else {
			kb_puts("Bell off.\r\n");
		}
#ifdef	DEBUGOPTION
		if(debug) {
			kbprintf("Debugging on.(Debug=%d)\r\n",debug);
		} else {
			kb_puts("Debugging off.\r\n");
		}
#endif
		if(wild) {
			kb_puts("Filename wildcards enabled.\r\n");
		} else {
			kb_puts("Filename wildcards disabled.\r\n");
		}
		if(hash) {
			kb_puts("Hash-mark printing on.\r\n");
		} else {
			kb_puts("Hash-mark printing off.\r\n");
		}
		if(prompt) {
			kb_puts("Interactive prompting on.\r\n");
		} else {
			kb_puts("Interactive prompting off.\r\n");
		}
		if(passive) {
			kb_puts("Passive mode enabled.\r\n");
		} else {
			kb_puts("Passive mode disabled.\r\n");
		}
		if(sendport) {
			kb_puts("Sending of PORT commands on.\r\n");
		} else {
			kb_puts("Sending of PORT commands off.\r\n");
		}
		if(verbose) {
			kb_puts("Verbose mode on.\r\n");
		} else {
			kb_puts("Verbose mode off.\r\n");
		}
		if(linked) {
			/*
			 * send STAT command
			 */
			kb_puts("\r\nRemote status:\r\n");
			i = verbose;
			verbose = TRUE;
			ftpdo("STAT");
			verbose = i;
		}
		return;

	case VERBOSE:		/* display informative messages */
		return(	toggle(command,word,&verbose,
			"Verbose mode on.\r\n",
			"Verbose mode off.\r\n")
			);

	case VERSION:		/* display current FTP version */
		printtxt(vrstxt);
		return;

	default:	/* The other commands valid only if connected */
		if(!linked) {
			kb_puts("Not connected.\r\n");
			return;
		}
		switch(cmdno) {
		case ASCII:		/* transfer mode */
			ftpdo("TYPE A");
			return;

		case BGET:		/* get file in binary mode */
			curfilemode = setmode(FIMAGE);
			if(question(command,100,"File: "))
				return;
			/*
			 * get file
			 */
			sprintf(cmndline,"RETR %s",command);
			fildev = 1;
			ftpdo(cmndline);
			setmode(curfilemode);
			return;

		case BINARY:		/* binary mode */
			ftpdo("TYPE I");
			return;

		case BPUT:		/* put file in binary mode */
		case BSEND:		/* send file in binary mode */
			curfilemode = setmode(FIMAGE);
			/*
			 * if no arg, get from user
			 */
			if(question(command,100,"File: "))
				return;
			sprintf(cmndline,"STOR %s",command);
			ftpdo(cmndline);
			setmode(curfilemode);
			return;

		case CD:		/* change remote directory */
			/*
			 * if no arg, get from user
			 */
			if(question(command,100,"To: "))
				return;
			getword(command,word);
			/*
			 * special case
			 */
			if(!strcmp(word,"..")) {
				/*
				 * if CDUP understood
				 */
				if(ftpdo("CDUP") != ERROR)
					return;
				kb_puts("Trying again...\r\n");
				/*
				 * try alternative
				 */
				if(ftpdo("XCUP") != ERROR)
					return;
				kb_puts("Trying again...\r\n");
		 	}
			/*
			 * else try usual CWD
			 */
			sprintf(cmndline,"CWD %s",word);
			if(ftpdo(cmndline) != ERROR)
				return;
			kb_puts("Trying again...\r\n");
			/*
			 * else try XCWD
			 */
			sprintf(cmndline,"XCWD %s",word);
			ftpdo(cmndline);
			return;

		case CLOSE:		/* drop connection */
			ftpdo("QUIT");
			linked = FALSE;
			/*
			 * Close Connections
			 */
			skclose(ftpcskt);
			ftpcskt = skrelease(ftpcskt,1);

			skclose(ftpdskt);
			ftpdskt = skrelease(ftpdskt,1);

			rtclose(ftpfh);
			ftpfh = NULL;

			return;

		case DEL:
		case RM:
			getword(command,word);
			if(question(word,100,"File: "))
				return;
			if(prompt) {
				/*
				 * check interactively
				 */
				kbprintf("Delete %s ? ",word);
				rtresp(answer,sizeof(answer));
				if(tolower(*(stpblk(answer))) != 'y')
					return;
			}
			sprintf(cmndline,"DELE %s",word);
			ftpdo(cmndline);
			return;			
		
		case DIR:		/* get list of remote files */
		case LS:
			if(redout == TRUE) {
				redfp = opnred(ofilename, "wn");
				if(redfp == NULL) {
					return;
				}
				redocap = TRUE;
			}
			curfilemode = setmode(FASCII);
			sprintf(cmndline,cmdno==DIR ? "LIST" : "NLST");
			if(getword(command,word)) {
				sprintf(&cmndline[4]," %s",word);
				if(redocap == TRUE) {
					fprintf(redfp, "\r\n%s\r\n", word);
				}
			}
			ftpdo(cmndline);
			setmode(curfilemode);
			if(redocap == TRUE) {
			    if(rtclose(redfp) != NULL) {
				kb_puts("Capture File Write Error\r\n");
			    }
			}
			return;

		case GET:
		case RECV:		/* get remote file */
			if(question(command,100,"File: "))
				return;
			sprintf(cmndline,"RETR %s",command);
			fildev = 1;
			ftpdo(cmndline);
			return;		

		case MDELETE:
			curfilemode = setmode(FASCII);
			if(question(command,100,"Files: "))
				return;
			/*
			 * for each arg
			 */
			while(getword(command,word) && !fndbrk) {
				if((capfp = opncap(capfil, "wn")) == NULL) {
					break;
				}
				if(wild) {
					capture = TRUE;
					sprintf(cmndline,"NLST %s",word);
					ftpdo(cmndline);
					capture = FALSE;
				} else {
					fprintf(capfp,"%s\n\r",word);
				}
				fclose(capfp);
				capfp = fopen(capfil, "rn");
				/*
				 * for each name
				 */
				while(getnname(word) && !fndbrk) {
				    if(prompt) {
					kbprintf("mdelete %s ? ",word);
					if(rtresp(answer,sizeof(answer))) {
						/*
						 * no more processing
						 */
						fndbrk = 1;
						break;
					}
					if(tolower(*(stpblk(answer))) != 'y')
						continue;
				    } else {
					kbprintf(
						"Deleting file %s\r\n", word);
				    }
				    sprintf(cmndline,"DELE %s",word);
				    if(ftpdo(cmndline) == ABORT) {
					fndbrk = 1;
					break;
				    }
				}
				if(capfp != NULL) {
					fclose(capfp);
					delete(capfil);
					capfp = NULL;
				}
			}
			setmode(curfilemode);
			return;

		case MDIR:		/* remote multiple DIR */
		case MLS:		/* remote multiple LS  */
			if(question(command,100,"Directories: "))
				return;
			if(redout == TRUE) {
				redfp = opnred(ofilename, "wn");
				if(redfp == NULL) {
					return;
				}
				redocap = TRUE;
			}
			curfilemode = setmode(FASCII);
			/*
			 * for each arg
			 */
			while(getword(command,word) && !fndbrk) {
				if(prompt) {
					kbprintf(cmdno==MDIR ?
					    "mdir %s ? " : "mls %s ? ", word);
					if(rtresp(answer,sizeof(answer))) {
						/*
						 * no more processing
						 */
						fndbrk = 1;
						break;
					}
					if(tolower(*(stpblk(answer))) != 'y')
						continue;
				    }
				/*
				 * DIR
				 */
				if(redocap == TRUE) {
					fprintf(redfp, "\r\n%s\r\n", word);
				}
				sprintf(cmndline,cmdno==MDIR ?
					"LIST %s" : "NLST %s",word);
				if(ftpdo(cmndline) == ABORT) {
					fndbrk = 1;
					break;
				}
			}
			setmode(curfilemode);
			if(redocap == TRUE) {
			    if(rtclose(redfp) != NULL) {
				kb_puts("Capture File Write Error\r\n");
			    }
			}
			return;

		case MGET:		/* get multiple files */
			if(question(command,100,"Files: "))
				return;
			/*
			 * for each arg
			 */
			while(getword(command,word) && !fndbrk) {
				if((capfp = opncap(capfil, "wn")) == NULL) {
					break;
				}
				if(wild) {
					curfilemode=setmode(FASCII);
					capture = TRUE;
					sprintf(cmndline,"NLST %s",word);
					ftpdo(cmndline);
					capture = FALSE;
					setmode(curfilemode);
				} else {
					fprintf(capfp,"%s\n\r",word);
				}
				fclose(capfp);
				capfp = fopen(capfil, "rn");
				/*
				 * for each name
				 */
				while(getnname(word) && !fndbrk) {
				    /*
				     * name may have special chars
				     */
				    q = rmtfile(word);
				    if(prompt) {
					kbprintf("%s as %s ? ", word,q);
					if(rtresp(answer,sizeof(answer))) {
						/*
						 * no more processing
						 */
						fndbrk = 1;
						break;
					}
					if(tolower(*(stpblk(answer))) != 'y')
						continue;
				    } else {
					kbprintf(
					    "getting %s as %s\r\n", word,q);
				    }
				    sprintf(cmndline,"RETR \"%s\"", word);
				    fildev = 1;
				    if(ftpdo(cmndline) == ABORT) {
					fndbrk = 1;
					break;
				    }
				}
				if(capfp != NULL) {
					fclose(capfp);
					delete(capfil);
					capfp = NULL;
				}
			}
			return;

		case MKDIR:		/* create directory */
			if(question(command,100,"Directory: "))
				return;
			/*
			 * try XMKD
			 */
			sprintf(cmndline,"XMKD %s",command);
			if(ftpdo(cmndline) != ERROR)
				return;
			kb_puts("Trying again...\r\n");
			/*
			 * else try MKD
			 */
			sprintf(cmndline,"MKD %s",command);
			ftpdo(cmndline);
			return;

		case MODE:		/* set stream mode */
			getword(command,word);
			strlwr(word);
			if(strncmp(word,"stream",strlen(word))) {
				kb_puts(
				"We only support stream mode, sorry.\r\n");
			} else {
				kb_puts("Mode is stream.\r\n");
			}
			return;

		case MPUT:		/* put multiple files */
		case MSEND:		/* send multiple files */
			if(question(command,100,"Files: "))
				return;
			/*
			 * save current path
			 */
			getpath(line);
			/*
			 * for each arg
			 */
			while(getword(command,word) && !fndbrk) {
			/*
			 * do subdirectory processing on each entry
			 */
			if((q = setpath(word)) != NULL) {
			/*
			 * save path and file name
			 */
			getpath(spathp);
			q = strcpy(spathq,q);
			/*
			 * restore path and change directory
			 */
			respath();
			cd(spathp);
			/*
			 * no names expanded yet
			 */
			p = NULL;
			/*
			 * for each name
			 */
  			do {
			    /*
			     * verify file exists / get first matching file
			     */
			    if((p = filnam(q,p,wild)) == NULL) {
				lsterr();
				continue;
			    }
			    expand(spathp,p);
			    if(prompt) {
				/*
				 * check
				 */
				kbprintf("%s ? ", spathp);
				if(rtresp(answer,sizeof(answer))) {
					/*
					 * no more processing
					 */
					fndbrk = 1;
					break;
				}
				if(tolower(*(stpblk(answer))) != 'y')
					continue;
			    } else {
				kbprintf("sending file %s\r\n", spathp);
			    }
			    /*
			     * name may have special chars
			     */
			    sprintf(cmndline,
				"STOR %s \"%s\"", p, rmtfile(p));
			    if(ftpdo(cmndline) == ABORT) {
				fndbrk = 1;
				break;
			    }
  			} while(p != NULL && wild && !fndbrk);
			lastname();

			}
			lsterr();
			respath();

			}
			/*
			 * restore current path
			 */
			cd(line);
			return;

		case PROTECT:		/* set protection flag */
			if(question(command,100,"File: "))
				return;
			/*
			 * set protection flag on a file
			 */
			sprintf(cmndline,"PSET %s",command);
			ftpdo(cmndline);
			return;

		case PUT:			
		case SEND:		/* put file */
			if(question(command,100,"File: "))
				return;
			/*
			 * put file
			 */
			sprintf(cmndline,"STOR %s",command);
			ftpdo(cmndline);
			return;

		case PWD:
			i = verbose;
			verbose = TRUE;
			/*
			 * try XPWD
			 */
			if(ftpdo("XPWD") != ERROR) {
				verbose = i;
				return;
			}
			kb_puts("Trying again...\r\n");
			/*
			 * else try PWD
			 */
			ftpdo("PWD");
			verbose = i;
			return;

		case QUOTE:
			if(question(command,100,"Command: "))
				return;
			/*
			 * send command
			*/
			ftpdo(command);
			return;
	
		case REMOTEHELP:	/* get help */
			i = verbose;
			verbose = TRUE;
			if(*(stpblk(command))) {
				/*
				 * for specific command
				 */
				sprintf(cmndline,"HELP %s",command);
				ftpdo(cmndline);
			} else {
				ftpdo("HELP");
			}
			verbose = i;
			return;

		case RENAME:		/* rename remote file */
			if(question(command,100,"From: "))
				return;
			getword(command,word);
			/*
			 * send rename from name
			 */
			sprintf(cmndline,"RNFR %s",word);
			if(ftpdo(cmndline) != INCOMPLETE)
				return;
			if(question(command,100,"To: ")) {
				ftpdo("ABOR");
				return;
			}
			/*
			 * send rename to name
			 */
			sprintf(cmndline,"RNTO %s",command);
			ftpdo(cmndline);
			return;
	
		case RMDIR:		/* remove remote dir */
			if(question(command,100,"Directory: "))
				return;
			/*
			 * try XRMD
			 */
			sprintf(cmndline,"XRMD %s",command);
			if(ftpdo(cmndline) != ERROR)
				return;
			kb_puts("Trying again...\r\n");
			/*
			 * try RMD
			 */
			sprintf(cmndline,"RMD %s",command);
			ftpdo(cmndline);
			return;
	
		case STRUCT:		/* set structure type - only file */
			getword(command,word);
			strlwr(word);
			if(strncmp(word,"file",strlen(word))) {
				kb_puts(
				"We only support file structure, sorry.\r\n");
			} else {
				kb_puts("Structure is file.\r\n");
			}
			return;
	
		case SYSTEM:		/* get remote system type */
			i = verbose;
			verbose = TRUE;
			ftpdo("SYST");
			verbose = i;
			return;
	
		case TYPE:		/* type a remote file */
			if(question(command,100,"File: "))
				return;
			getword(command,word);
			sprintf(cmndline,"RETR %s tt:tt.tt",word);
			fildev = 0;
			ftpdo(cmndline);
			return;		

		case UNPROTECT:		/* clear protection flag */
			if(question(command,100,"File: "))
				return;
			/*
			 * clear protection flag on a file
			 */
			sprintf(cmndline,"PCLR %s",command);
			ftpdo(cmndline);
			return;

		case USER:		/* login to remote machine */
			if(question(command,100,"Username: "))
				return;
			/*
			 * username
			 */
			sprintf(cmndline,"USER %s",command);
			if(ftpdo(cmndline) == TRUE)
				return;
			/*
			 * password
			 */
			kb_puts("Password: ");
			if(ftpgets(command,100,0) == ABORT)
				return;
			sprintf(cmndline,"PASS %s",command);
			if(ftpdo(cmndline) == INCOMPLETE) {
				/*
				 * if account needed
				 */
				*command = '\0';
				if(question(command,100,"Account: "))
					return;
				sprintf(cmndline,"ACCT %s",command);
				ftpdo(cmndline);
			}
			return;
		
		default:	/* unknown command */
			kbprintf(
			"***Program error: Unknown command no: %d\r\n",cmdno);
			break;
		}
	}
}

/*
 *  setmode
 *
 *  set the transfer mode
 *  and return old mode
 */
int setmode(mode)
int mode;
{
	register int cmode;

	cmode = ftpfilemode;
	switch(mode) {
	default:
		kb_puts("Invalid ftpfilemode, defaulting to ASCII\r\n");

	case FASCII:
		if (cmode != FASCII)
			ftpdo("TYPE A");
		break;

	case FIMAGE:
		if (cmode != FIMAGE)
			ftpdo("TYPE I");
		break;

	}
	return(cmode);
}
                                                                                                                                                                                                                                                                                                                                                   