/* util.c */

#define	UTILMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vutil.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "detach.h"
#include "lcljob.h"
#include "suspnd.h"


static char *usetxt[] = {
       "",
       "  UTIL [?] [-cdlmnpqru] [file-spec(s)]",
       "	?		List this Help Text and Exit UTIL",
       "	c		change directory",
       "	d		delete a file",
       "	l		list a directory",
       "	m		make a directory",
       "	n		delete a directory",
       "	p		set protection flag on a file",
       "	q		disable query on delete",
       "	r		rename a file",
       "	u		clr protection flag on afile",
       "	w		disable wild cards",
       "",
	0
	};


#define	ABORT		(-1)		/* abort value */

static	int	wflag = 1;		/* wild card flag */
static	int	pflag = 1;		/* prompting flag */

	int	tljobn;			/* local job number */
	char	xs[2048];		/* buffer space for mkdir */


main(argc,argv)
int argc;
char *argv[];
{
	char answer[100];
	int c;
	register int i,j,k;
	FILE *inp,*oup;

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * Get Job Number
	 */
	tljobn = lcljob();

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    printtxt(vrstxt);
		    printtxt(usetxt);
		    rtusage();
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
			case 'c':	/* change directory */
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,"Directory: "))
					break;
				if(!lcd(answer)) {

				delcmd = 0;
				wrtcmd(bldcmd("delete wf:cmdfil.com\r\n",0));
				sprintf(answer,"wf:jobnum.%03d", tljobn);
				if((inp = fopen(answer,"rn")) != NULL) {
					oup = fopen("wf:cmdfil.com","wn");
					while((c = getc(inp)) != EOF) {
						putc(c, oup);
					}
					fclose(oup);
					fclose(inp);
				}
				delete(answer);

				}
				break;

			case 'd':	/* delete a file */
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,"Delete File(s): "))
					break;
				ldelete(answer);
				break;

			case 'l':	/* list a directory */
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				lls(answer);
				break;

			case 'm':	/* make a directory */
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,
					"Create Directory(s): "))
					break;
				lmkdir(answer);
				break;

			case 'n':	/* delete a directory */
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,
					"Delete Directory(s): "))
					break;
				lrmdir(answer);
				break;

			case 'p':	/* set protect on a file */
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,"File(s): "))
					break;
				lprotect(answer);
				break;

			case 'q':	/* disable deletion prompting */
				pflag = !pflag;
				break;

			case 'r':	/* rename a file */
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,"Rename: "))
					break;
				strcpy(&xs[0],answer);

				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,"To:     "))
					break;
				strcpy(&xs[100],answer);
				lrename();
				break;

				/*
				 * This is a 'hidden' option for setting the
				 * the default subdirectory base 'ld' unit and
				 * setting the maximum subdirectory nesting
				 *	note:	subdbase + subdnest <= 8
				 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;

			case 'u':	/* clr protection on a file */	
				if(++i < argc) {
					strcpy(answer,argv[i]);
				} else {
					answer[0] = '\0';
				}
				if(question(answer,100,"File(s): "))
					break;
				lunprotect(answer);
				break;

			case 'w':	/* disable wild cards */
				wflag = !wflag;
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		} else {
			printf(
			"Unrecognized command <%s> ignored\r\n", argv[i]);
		}
	}
	cd("dk:");
	exit(0);
}

char *stpblk(ch)
register char *ch;
 
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

/*
 * General looping question routine
 * loops until a response is given
 *	returns 1 on ABORT
 *	   else 0
 */
static int question(cstr,clen,qstr)
char *cstr,*qstr;
int clen;
{
	while(!(*(stpblk(cstr)))) {
		/*
		 * get arg from user
		 */
		kb_puts(qstr);
		if(rtresp(cstr,clen))
			return(1);
		}
	return(0);
}

/*
 * Routine to get a keyboard response
 *	returns 1 on ABORT
 *	   else 0
 */
int rtresp(st,ln)
char *st;
int ln;
{
	return((utlgets(st,ln,1)==ABORT) ? 1 : 0);
}

/*
 * utlgets
 *
 * read a line from the keyboard
 * returns ABORT if keyboard input aborted
 * or non-zero on success
 */

int utlgets(str,lim,echo)
register char *str;	/* where to put the line */
int lim,echo;		/* max chars to read, echo? */
{
	register char *save, *ret;
	int c;

	save = str;		/* beginning of line */
	*save = '\0';

	if(fndbrk) {
		fndbrk = 0;
		*str = '\0';
		kb_puts("^C\r\n");
		return(ABORT);
	}
	while(1) {
		/*
		 * build string from keyboard
		 */
		c = kb_gets(str,lim,echo);
		if(1 <= c && c <= 31) {
			kb_puts("\r\n");
			return(strlen(save));
		}
		/*
		 * check for abort
		 */
		if(fndbrk) {
			*save = '\0';
			kb_puts("^C\r\n");
			fndbrk = 0;
			return(ABORT);	
		}
		suspnd(0);
	}
}

/*
 *	Various routines that interface with the
 *	TSXUTL.C utilities.
 */

static VOID lcd(st)
register char *st;
{
	cd(st);
	if(*errstr) {
		lsterr();
		return(1);
	}
	return(0);
}

static VOID ldelete(st)
char *st;
{
	VOID ldelfil();

	dispatch(ldelfil,st);
}

static VOID ldelfil(st)
char *st;
{
	delfil(0,st,pflag,wflag);
}

static VOID lls(st)
char *st;
{
	int dspdir();

	dispatch(dspdir,st);
}

static VOID lmkdir(st)
char *st;
{
	int mkdir();

	dispatch(mkdir,st);
}

static VOID lprotect(st)
char *st;
{
	VOID setfilp();

	dispatch(setfilp,st);
}

static VOID setfilp(st)
char *st;
{
	setclrp(st,1,wflag);
}

static VOID lrename()
{
	VOID newname();

	dispatch(newname,&xs[0]);
}

static VOID newname(st)
char *st;
{
	rename(st,&xs[100],pflag,wflag);
}

static VOID lrmdir(st)
char *st;
{
	VOID rmdir();

	dispatch(rmdir,st);
}

static VOID rmdir(st)
char *st;
{
	delfil(1,st,pflag,wflag);
}

static VOID lunprotect(st)
char *st;
{
	VOID clrfilp();

	dispatch(clrfilp,st);
}

static VOID clrfilp(st)
char *st;
{
	setclrp(st,0,wflag);
}

VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_puts("\r\n");
		errstr[0] = '\0';
	}
}

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}
                                                                                                                                                                                                     