/* llpqrm.c */

#define	LLPQRMMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vllpqr.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "cliutl.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "rcdlck.h"
#include "datime.h"
#include "inicli.h"
#include "usrblk.h"
#include "suspnd.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();	/* (txt) print text */
extern	int	question();	/* (cstr,clen,qstr) question routine */
extern	int	rtresp();	/* (st,ln) get response */
extern	int	keygets();	/* (str,lim,echo) get line from keyboard */
extern	VOID	lsterr();	/* error lister */
extern	int	getword();	/* (string,word) extract a word */
extern	VOID	strlwr();	/* (st) convert to lower case */
extern	int	chkusr();	/* check username / password */
extern	int	checkque();	/* (que,host,user) check queue list */
extern	VOID	getinfo();	/* (fp) get info from cfA file */
extern	VOID	questat();	/* get status of queue */
extern	int	quefiles();	/* queue the print files */
extern	VOID	rmvjob();	/* remove print jobs from queues */
extern	VOID	rmvfile();	/* (i,p) remove a dfA file from a queue */
#endif

extern	char	*stptok();	/* (p,t,l,d) stop on token */
extern	char	*stpblk();	/* (ch) stop on block */

/*
 * List of LPD Defines
 */

#define	LPQRM		(0)
#define	LPC		(1)
#define	LPQ		(2)
#define	LPR		(3)
#define	LPRM		(4)

#define	C_CLASS		('C')
#define	C_HOST		('H')
#define	C_INDENT	('I')
#define	C_JOB		('J')
#define	C_BANNER	('L')
#define	C_MAIL		('M')
#define	C_SOURCE	('N')
#define	C_USER		('P')
#define	C_QUEUE		('Q')
#define	C_SLINK		('S')
#define	C_TITLE		('T')
#define	C_ULINK		('U')
#define	C_WIDTH		('W')
#define	C_ZOPT		('Z')
#define	C_RTROFF	('1')
#define	C_ITROFF	('2')
#define	C_BTROFF	('3')
#define	C_STROFF	('4')
#define	C_CIF		('c')
#define	C_DVI		('d')
#define	C_PRINT		('f')
#define	C_PLOT		('g')
#define	C_BUPLOT	('k')
#define	C_CONTROL	('l')
#define	C_DITROFF	('n')
#define	C_POSTSCRIPT	('o')
#define	C_PR		('p')
#define	C_FORTRAN	('r')
#define	C_TROFF		('t')
#define	C_RASTER	('v')
#define	C_PALLADIUM	('z')

/*
 *	Global Buffers / Pointers
 */

#define	BLOCKSIZE	(512)
#define BUFFERS		(128)
#define	STRLEN		(80)
#define	LISTSIZE	(4)

static char
	scratch[BUFFERS],		/* scratch string */
	defpath[BUFFERS],		/* default directory path */
	expfl[BUFFERS],			/* expanded file name */
	hostname[STRLEN],		/* local host name */
	username[USERPASSLEN+2],	/* current username */
	password[USERPASSLEN+2];	/* current password */

char	xs[BLOCKSIZE];			/* data buffer */
					/* dumby buffer for TSXUTL.C */

/*
 *	Various variables
 */

static int
	option = LPQRM,		/* program option */
	pswdreqd = 1,		/* password required */
	looptime = 0,		/* repeat loop counter */
	cfAseq = 0,		/* cfA sequence number */
	dfAseq = 0,		/* dfA sequence number */
	lprcpy = 1,		/* print copies */
	lprindent = 0,		/* indentation */
	lprwidth = 0,		/* width */
	lprmail = 0;		/* mail */

static	char
	lprhost[STRLEN],	/* host */
	lprque[STRLEN],		/* queue */
	lprfile[STRLEN],	/* file */
	lprjob[STRLEN],		/* job */
	lprtitle[STRLEN],	/* title */
	lprclass[STRLEN],	/* class */
	lprbanner[STRLEN];	/* banner */
	lpropt[BUFFERS];	/* printing options */

static	int			/* printer agent task number */
	lprint = 0;

static char			/* LPD temporary file directory */
	lpddir[BUFFERS];
static char *			/* Password File */
	pswdfl[BUFFERS];

static char *			/* LPD configuration file */
	lpdcfl = "TCP:lpdqrm.cfg";
static FILE *			/* LPD configuration file handle */
	lpdcfh = NULL;

static	char			/* control file name */
	cfAfl[BUFFERS];
static	FILE			/* control file handle */
	*cfAfh = NULL;

static	char
	dfAfl[BUFFERS];		/* data file name */
static	FILE
	*dfAfh = NULL;		/* data file handle */

static	char
	tmpcfl[BUFFERS];	/* temporary cfA file */
static	FILE
	*tmpcfh = NULL;		/* temporary cfA file handle */

static	char
	lprfl[BUFFERS];		/* lpr file name */
static	FILE
	*lprfh = NULL;		/* lpr file handle */

struct	cinfo {
	char	que[STRLEN];
	char	host[STRLEN];
	char	user[STRLEN];
	char	src[LISTSIZE][STRLEN];
	char	file[LISTSIZE][STRLEN];
};

static	struct	cinfo	cfAinfo;

struct	qinfo {
	char	que[STRLEN];
	char	host[STRLEN];
	char	user[STRLEN];
};

static	struct	qinfo	queinfo;

static	char	list[LISTSIZE][STRLEN];

/*
 * Debugging options
 *
 *	bit 0	(0x01)	event printing
 *	bit 1	(0x02)	checkque()
 *	bit 2	(0x04)	questat()
 *	bit 3	(0x08)	rmvjob()
 */

#if ts$sys
static char *lpqrmtxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  LLPQRM [?] [-d level] [-p filespec] [-t n] -o opt [opt arguments]",
       "	?               List the Help Text and Exit LLPQRM",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable checkque() event printing",
       "		4 -	enable questat() printing",
       "		8 -	enable rmvjob() printing",
#else
       "  LLPQRM [?] [-p filespec] [-t n] -o opt [opt arguments]",
       "	?               List the Help Text and Exit LLPQRM",
#endif
       "	p  filespec	LPD configuration file",
       "	t  n		TCPIP Task Number for LPD Delivery Agent",
       "	o  lpc	[?]	Start printer queue",
       "	   lpq	[?]	Get printer queue status",
       "	   lpr	[?]	Submit a job to a printer queue",
       "	   lprm	[?]	Remove a job from a printer queue",
       "",
       "	The -o opt argument must preceed the opt specific options.",
       "",
	0
       };
#endif

#if rt$sys
static char *lpqrmtxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  LLPQRM [?] [-d level] [-p filespec] -o opt [opt arguments]",
       "	?               List the Help Text and Exit LLPQRM",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable checkque() event printing",
       "		4 -	enable questat() printing",
       "		8 -	enable rmvjob() printing",
#else
       "  LLPQRM [?] [-p filespec] -o opt [opt arguments]",
       "	?               List the Help Text and Exit LLPQRM",
#endif
       "	p  filespec	LPD configuration file",
       "	o  lpc	[?]	Start printer queue",
       "	   lpq	[?]	Get printer queue status",
       "	   lpr	[?]	Submit a job to a printer queue",
       "	   lprm	[?]	Remove a job from a printer queue",
       "",
       "	The -o opt argument must preceed the opt specific options.",
       "",
	0
       };
#endif

static char *lpctxt[] = {
       "",
       "  LPC [?]",
       "	?               List the LPC Help Text and Exit LLPQRM",
       "",
       0
       };

static char *lpqtxt[] = {
       "",
       "  LPQ [?] [-#P argument]",
       "	?               List the LPQ Help Text and Exit LLPQRM",
       "	#  n		Repeat query time in seconds",
       "	P  Queue Name	Printer Queue",
       "",
       0
       };

static char *lprtxt[] = {
       "",
       "  LPR [?] [-#IPW argument] [-flr] [file to print]",
       "	?               List the LPR Help Text and Exit LLPQRM",
       "	#  n		# of copies to print (1-5)",
       "	I  n		Indentation",
       "	P  Queue Name	Printer Queue (default = lp)",
       "	W  n		Page Width",
       "	f		Plain Text Printing (default)",
       "	l		No Control Character Processing",
       "	r		Fortran Carriage Control Printing",
       "",
       0
       };

static char *lprmtxt[] = {
       "",
       "  LPRM [?] [-P argument] [file to remove from queue]",
       "	?               List the LPRM Help Text and Exit LLPQRM",
       "	P  Queue Name	Printer Queue",
       "",
       0
       };

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}

main(argc,argv)
int argc;
char *argv[];
{
	char c,*s;
	register int i,j,k;
	int l,sktnum;
	struct socket *skt;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * Initialize other parameters
	 */
	lprque[0] = '\0';
	lpropt[0] = '\0';
	lprtitle[0] = '\0';

	/*
	 * parse arguments
	 */
/*1*/	for(i=1,l=0; i<argc; i++) {
/*2*/		if(argv[i][0] == '?') {
		    switch(option) {
		    case LPQRM:
			printtxt(lpqrmtxt);
			break;

		    case LPC:
			printtxt(lpctxt);
			break;

		    case LPQ:
			printtxt(lpqtxt);
			break;

		    case LPR:
			printtxt(lprtxt);
			break;

		    case LPRM:
			printtxt(lprmtxt);
			break;

		    default:
			break;
		    }
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
/*3*/		    while((c = argv[j][k]) != '\0') {
/*4*/	switch(option) {
	case LPQRM:	/* Options before -o opt */
		switch(c) {
		/*
		 * This is a 'hidden' option for bypassing
		 * the username/password requirement.
		 */
		case 'b':	/* bypass password processing */
			pswdreqd = 0;
			break;

#ifdef	DEBUGOPTION
		case 'd':	/* debug, optional level */
			if(sscanf(argv[++i],"%d",&debug) <= 0)
				debug = -1;
			break;
#endif

		case 'o':	/* Program option selection */
			/*
			 * Must have one of the following
			 * options as the first argument:
			 *	lpc	start printer queue
			 *	lpq	get printer queue status
			 *	lpr	submit a print job
			 *	lprm	delete a print job
			 */
			strlwr(argv[++i]);
			if (streq(argv[i],"lpc")) {
				option = LPC;
			} else
			if (streq(argv[i],"lpq")) {
				option = LPQ;
			} else
			if (streq(argv[i],"lpr")) {
				option = LPR;
			} else
			if (streq(argv[i],"lprm")) {
				option = LPRM;
			} else {
				printtxt(lpqrmtxt);
				exit(1);
			}
			break;

		case 'p':	/* configuration file */
			lpdcfl = argv[++i];
			break;
#if ts$sys
		/*
		 * This is a 'hidden' option for setting the
		 * the default subdirectory base 'ld' unit
		 * and setting the maximum subdirectory nesting
		 *	note:	subdbase + subdnest <= 8
		 */
		case 's':
			sscanf(argv[++i],"%d",&subdbase);
			sscanf(argv[++i],"%d",&subdnest);
			break;
#endif
#if ts$sys
		case 't':	/* task number */
			if(sscanf(argv[++i],"%d",&lprint) <= 0)
				lprint = 0;
			break;
#endif
		default:
			break;
		}
		break;

	case LPC:
		switch(c) {
		case 'P':	/* Server Queue Name */
			strcpy(lprque,argv[++i]);
			break;

		default:	/* unknown option */
			printf(
			"Unrecognized option -%c ignored\r\n", c);
			break;
		}
		break;

	case LPQ:
		switch(c) {
		case '#':	/* looptime value */
			if (sscanf(argv[++i],"%d",&looptime) <= 0) {
				looptime  = 0;
			} else {
				if (looptime < 5)
					looptime = 5;
				if (looptime > 30)
					looptime = 30;
				looptime *= 2;
			}
			break;

		case 'l':	/* long form (same as short) */
			break;

		case 'P':	/* Queue Name */
			strcpy(lprque,argv[++i]);
			break;

		default:	/* unknown option */
			printf(
			"Unrecognized option -%c ignored\r\n", c);
			break;
		}
		break;

	case LPR:
		switch(c) {
		case '#':	/* # of copies */
			if (sscanf(argv[++i],"%d",&lprcpy) <= 0) {
				lprcpy  = 1;
			}
			if (lprcpy > 5)
				lprcpy = 5;
			break;

		case C_RTROFF:
		case C_ITROFF:
		case C_BTROFF:
		case C_STROFF:
		case C_CIF:
		case C_DVI:
		case C_PRINT:
		case C_PLOT:
		case C_BUPLOT:
		case C_CONTROL:
		case C_DITROFF:
		case C_POSTSCRIPT:
		case C_PR:
		case C_FORTRAN:
		case C_TROFF:
		case C_RASTER:
		case C_PALLADIUM:
			strncat(lpropt,&argv[j][k],1);
			break;

		case 'C':	/* Class Name */
			strcpy(lprclass,argv[++i]);
			break;

		case 'I':	/* Indentation */
			if (sscanf(argv[++i],"%d",&lprindent) <= 0) {
				lprindent = 0;
			}
			if (lprindent < 0 || lprindent > 40)
				lprindent = 0;
			break;

		case 'J':	/* Job Name */
			strcpy(lprjob,argv[++i]);
			break;

		case 'L':	/* Banner */
			strcpy(lprbanner,argv[++i]);
			break;

		case 'M':	/* Mail */
			lprmail = 1;
			break;

		case 'P':	/* Queue Name */
			strcpy(lprque,argv[++i]);
			break;

		case 'T':	/* Title */
			strcpy(lprtitle,argv[++i]);
			break;

		case 'W':	/* Width */
			if (sscanf(argv[++i],"%d",&lprwidth) <= 0) {
				lprwidth = 0;
			}
			if (lprwidth < 0 || lprwidth > 216)
				lprwidth = 0;
			break;

		default:	/* unknown option */
			printf(
			"Unrecognized option -%c ignored\r\n", c);
			break;
		}
		break;

	case LPRM:
		switch(c) {
		case 'P':	/* Queue Name */
			strcpy(lprque,argv[++i]);
			break;

		default:	/* unknown option */
			printf(
			"Unrecognized option -%c ignored\r\n", c);
			break;
		}
		break;

	default:
		break;
/*4*/	}
			k++;
/*3*/		    }
/*2*/		} else
		if (l < LISTSIZE) {
			strcpy(list[l],argv[i]);
			strlwr(list[l]);
			l++;
		}
/*1*/	}

	if (option == LPQRM) {
		printtxt(lpqrmtxt);
		exit(1);
	}

	/*
	 * Get The Current Directory Path
	 */
	gethome(defpath);

	/*
	 * Get Host Name
	 */
	Snetinit();

	if ((sktnum = socket(0)) != -1) {
		skt = (struct socket *) mapskt(sktnum);
		strcpy(hostname,skt->hostname);
		strcpy(lprhost,skt->hostname);
		if ((s = strchr(lprhost,'.')) != NULL)
			*s = '\0';
		skrelease(sktnum,1);
	}

	/*
	 * Try to access the configuration file
	 */
	if(NULL == (lpdcfh = rtopen(lpdcfl,"r",0,0))) {
		kb_puts("Configuration File Required\r\n");
		kb_puts("\r\nEscaping from LLPQRM\r\n");
		exit(1);
	}

	/*
	 * First line is sequence number
	 */
	fgetss(scratch,sizeof(scratch)-1,lpdcfh);

	/*
	 * Second line is temporary file directory
	 */
	if (NULL != fgetss(scratch,sizeof(scratch)-1,lpdcfh)) {
		if (!getword(scratch,lpddir)) {
			strcpy(lpddir,"sy:");
		}
	}

	/*
	 * Third line is password file directory
	 */
	if (NULL != fgetss(scratch,sizeof(scratch)-1,lpdcfh)) {
		if (!getword(scratch,pswdfl)) {
			strcpy(pswdfl,"PAS:paswrd.fil");
		}
	}
	rtclose(lpdcfh);

	/*
	 * Change to LPD temporary file directory
	 */
	if (cd(lpddir)) {
		kbprintf("Unable to Change to Directory %s\r\n", lpddir);
		kb_puts("\r\nEscaping from LLPQRM\r\n");
		exit(1);
	}
			
	/*
	 * Perform LLPRM Functions
	 */
	switch(option) {
		case LPC:
			/*
			 * Activate Printing
			 */
			kb_puts("Local LPD Print Queues Started\r\n");
			cl_xmit(TASKCLASS,STARTJOB,lprint);
			break;

		case LPQ:
			/*
			 * Show Queue
			 */
			do {
				questat();
				for (i=0; i<looptime && !fndbrk; i++)
					suspnd(0);
			} while (looptime && !fndbrk);
			break;

		case LPR:
			/*
			 * Test Username (password not required)
			 */
			if (pswdreqd) {
				pswdreqd = 0;
				if (chkusr())
					break;
			} else {
				strcpy(username,lprhost);
			}

			/*
			 * File To Print
			 */
			if (question(list[0],STRLEN,"File To Print: "))
				break;

			/*
			 * Set all defaults
			 */
			if (lprque[0] == '\0')			/*Q*/
				strcpy(lprque,"lp");

			/*
			 * Check Queue
			 */
			if (!checkque(lprque,"*","*"))
				break;

			/*
			 * Queue the print files
			 */
			if (quefiles())
				cl_xmit(TASKCLASS,STARTJOB,lprint);
			break;

		case LPRM:
			/*
			 * Test Username / Password
			 */
			if (pswdreqd) {
				if (chkusr())
					break;
			} else {
				strcpy(username,lprhost);
			}
			rmvjob();
			break;

		default:
			break;
	}

	if(fndbrk) 
		kb_puts("\r\n^C\r\n");

	cd("dk:");

	kb_puts("\r\nEscaping from LLPQRM\r\n");
	exit(0);
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * General looping question routine
 * loops until a response is given
 *	returns 1 on abort
 *	   else 0
 */
static int question(cstr,clen,qstr)
char *cstr,*qstr;
int clen;
{
	while(!(*(stpblk(cstr)))) {
		/*
		 * get arg from user
		 */
		kb_puts(qstr);
		if(rtresp(cstr,clen))
			return(1);
		}
	return(0);
}

/*
 * Routine to get a keyboard response
 *	returns 1 on abort
 *	   else 0
 */
int rtresp(st,ln)
char *st;
int ln;
{
	return((keygets(st,ln,1)==-1) ? 1 : 0);
}

/*
 * keygets
 *
 * read a line from the keyboard
 * returns -1 if keyboard input aborted
 * or non-zero on success
 */

int keygets(str,lim,echo)
register char *str;	/* where to put the line */
int lim,echo;		/* max chars to read, echo? */
{
	register char *save;
	register int c;

	save = str;		/* beginning of line */
	*save = '\0';

	if(fndbrk) {
		kb_puts("^C\r\n");
		return(-1);
	}
	while(1) {
		/*
		 * build string from keyboard
		 */
		c = kb_gets(str,lim,echo);
		if(1 <= c && c <= 31) {
			kb_nline();
			return(strlen(save));
		}
		/*
		 * check for abort
		 */
		if(fndbrk) {
			*save = '\0';
			kb_puts("^C\r\n");
			return(-1);	
		}
		suspnd(0);
	}
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len STRLEN
		 */
		q = stptok(p, word, STRLEN-1, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

/*
 *  chkusr
 *
 *  Check the password file for the user/password
 *  combination. An inaccessable password file
 *  results in an invalid return.
 *
 *  If the user/password are validated and
 *  the user has the rquired privelege,
 *  then a valid return is made.
 *
 *  Returns valid(0)/invalid(1)
 */
int chkusr()
{
	FILE *fp;
	struct userblock user;
	char command[STRLEN];
	char word[STRLEN];

	username[0] = '\0';
	password[0] = '\0';
	/*
	 * username
	 */
	if(question(command,STRLEN,"Username: "))
		return(1);
	getword(command,word);
	strncat(username,word,USERPASSLEN);
	strlwr(username);
	/*
	 * password
	 */
	if (pswdreqd) {
		if(!(*stpblk(command))) {
			kb_puts("Password: ");
			if(keygets(command,STRLEN,0) == -1)
				return(1);
		}
		getword(command,word);
		strncat(password,word,USERPASSLEN);
		strlwr(password);
	}
	/*
	 * Check username / password file
	 */
	if(NULL==(fp = rtopen(pswdfl,"rn",0,0))) {
		return(1);
	}
	while (NULL != fread(&user,sizeof(struct userblock),1,fp)) {
		/*
		 * does username / password check ?
		 */
		if(!strncmp(username,&user.username,USERPASSLEN) &&
				(user.userflag[0]&PASSNOTREQUIRED ||
				!pswdreqd ||
				Scompass(password,&user.password))
			) {
			rtclose(fp);
			/*
			 * User valid
			 */
			return(0);
		}
	}
	kb_puts("Invalid Username / Password.\r\n");
	rtclose(fp);
	return(1);
}

/*
 *  Scompass ( ps, en )
 *
 *  Compute and check the encrypted password
 */
int Scompass(ps,en)
register char *ps,*en;
{
	register int i,ck;
	char *p,c;

	ck = 0;
	p = ps;
	/*
	 * checksum the string
	 */
	while (*p)
		ck += *p++;
	c = ck;
	/*
	 * XOR with checksum
	 */
	i = USERPASSLEN;
	while (i--) {
		if((((*ps ^ c)|32)&127)!=*en)
			return(0);
		/*
		 * increment checksum to hide length
		 */
		if(*ps) {
			ps++;
		} else {
			c++;
		}
		en++;
	}
	return(1);
}

/*
 *  checkque (que,host,user)
 *
 *  Check the configuration file for a queue/host/user match.
 *  An inaccessable configuration file results in an invalid return.
 *  An unknown queue results in an invalid return.
 *
 *  Returns valid(1)/invalid(0)
 */
int checkque(que,host,user)
char *que,*host,*user;
{
	char word[STRLEN];

	if(NULL == (lpdcfh = rtopen(lpdcfl,"r",0,0))) {
#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("checkque(): no lpdcfl: %s\r\n", lpdcfl);
}
#endif
		return(0);
	}
	/*
	 * First line is sequence number
	 */
	fgetss(scratch,sizeof(scratch)-1,lpdcfh);
	getword(scratch,word);

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("checkque(): sequence number = '%s'\r\n", word);
}
#endif
	/*
	 * Second line is temporary file directory
	 */
	fgetss(scratch,sizeof(scratch)-1,lpdcfh);
	getword(scratch,lpddir);

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("checkque(): lpddir = '%s'\r\n", lpddir);
}
#endif
	/*
	 * Third line is password file directory
	 */
	fgetss(scratch,sizeof(scratch)-1,lpdcfh);
	getword(scratch,word);

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("checkque(): paswrd = '%s'\r\n", word);
}
#endif
	/*
	 * Subsequent lines are queue lists
	 */
	while (NULL != fgetss(scratch,sizeof(scratch)-1,lpdcfh)) {

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("checkque(): lpd = '%s'  '%s'  '%s'\r\n", que,host,user);
	printf("%s\r\n", scratch);
}
#endif
		/*
		 * Get queue/host/user information
		 */
		strlwr(scratch);
		getword(scratch,queinfo.que);
		getword(scratch,queinfo.host);
		getword(scratch,queinfo.user);

		if(streq(que,queinfo.que)) {
			if (streq("*",host) ||
			    streq("*",queinfo.host) ||
			    streq(host,queinfo.host)) {
				if (streq("*",user) ||
				    streq("*",queinfo.user) ||
				    streq(user,queinfo.user)) {
					/*
					 * Queue found
					 */
					rtclose(lpdcfh);
					return(1);
				}
			}
		}		
	}
	rtclose(lpdcfh);
	return(0);
}

/*
 * lpdsequence
 *
 * Return the current RLPD sequence number
 * or 0 if the file could not be opened.
 */
static char lpdblock[512];	/* RLPD sequence block */

int lpdsequence()
{
	FILE *fp;
	char seqstr[8];
	int seqnum;

	/*
	 * The RLPD sequence file must be locked to ensure
	 * no other process has simultaneous access to
	 * the file while the file is being updated.
	 * If TSX+ is not sysgened for shared-file
	 * record locking then record locking does not occur.
	 */
	if((fp = rtopen(lpdcfl,"rn",0,0)) == NULL)
		return(0);
	frcdlock(0,fp);
	frcdread(&lpdblock,0,fp);
	seqnum = 0;
	seqstr[0] = '\0';
	strncat(seqstr,lpdblock,3);
	sscanf(seqstr,"%d",&seqnum);
	++seqnum;
	if ((seqnum <= 0) || (seqnum > 999))
		seqnum = 1;
	sprintf(seqstr,"%03d",seqnum);
	strncpy(lpdblock,seqstr,3);
	frcdwrite(&lpdblock,0,fp);
	frcdunlock(0,fp);
	rtclose(fp);
	return(seqnum);
}

/*
 * getinfo
 *
 * Read queue/host/user information from a cfA file
 */

VOID getinfo(fp)
FILE *fp;
{
	register int i;
	char scr[STRLEN];

	cfAinfo.que[0]  = '\0';
	cfAinfo.host[0] = '\0';
	cfAinfo.user[0] = '\0';
	for (i=0; i<LISTSIZE; i++) {
		cfAinfo.src[i][0]  = '\0';
		cfAinfo.file[i][0] = '\0';
	}

	while ((fp != NULL) && (fgetss(scr,STRLEN-1,fp) != NULL)) {
		strlwr(scr+1);
		switch(scr[0]) {
		case C_QUEUE:
			strcpy(cfAinfo.que,scr+1);
			break;

		case C_HOST:
			strcpy(cfAinfo.host,scr+1);
			break;

		case C_USER:
			strcpy(cfAinfo.user,scr+1);
			break;

		case C_SOURCE:
			for (i=0; i<LISTSIZE; i++) {
				if(cfAinfo.src[i][0] == '\0') {
					strcpy(cfAinfo.src[i],scr+1);
					break;
				} else {
					if (streq(cfAinfo.src[i],scr+1))
						break;
				}
			}
			break;

		case C_RTROFF:
		case C_ITROFF:
		case C_BTROFF:
		case C_STROFF:
		case C_CIF:
		case C_DVI:
		case C_PRINT:
		case C_PLOT:
		case C_BUPLOT:
		case C_CONTROL:
		case C_DITROFF:
		case C_POSTSCRIPT:
		case C_PR:
		case C_FORTRAN:
		case C_TROFF:
		case C_RASTER:
		case C_PALLADIUM:
			for (i=0; i<LISTSIZE; i++) {
				if(cfAinfo.file[i][0] == '\0') {
					strcpy(cfAinfo.file[i],scr+1);
					break;
				} else {
					if (streq(cfAinfo.file[i],scr+1))
						break;
				}
			}
			break;

		case C_CLASS:
		case C_INDENT:
		case C_JOB:
		case C_BANNER:
		case C_MAIL:
		case C_SLINK:
		case C_TITLE:
		case C_ULINK:
		case C_WIDTH:
		default:
			break;
		}
	}
}

/*
 * questat
 *
 * Report LPD Queue Status
 */

VOID questat()
{
	register char *p;
	int first,found;
	register int i,j;

	kb_puts(hostname);
	kb_nline();

	first = 0;
/*1*/	if (!cd(lpddir) && ((p = firstname("cfA.*")) != NULL)) {

/*2*/	do {
		getinfo(filiop());

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("cfA file   = %s\r\n", expand(expfl,p));
	printf("  Queue    = %s\r\n", cfAinfo.que);
	printf("  Host     = %s\r\n", cfAinfo.host);
	printf("  User     = %s\r\n", cfAinfo.user);
	for (i=0; i<LISTSIZE; i++) {
		if ((cfAinfo.src[i][0] != '\0') ||
		    (cfAinfo.file[i][0] != '\0')) {
			printf("    Source = %s\r\n", cfAinfo.src[i]);
			printf("    File   = %s\r\n", cfAinfo.file[i]);
		}
	}
}
#endif

		found = 0;
		if (lprque[0] == '\0' || streq(cfAinfo.que,lprque)) {
		    if (list[0][0] == '\0') {
			found = 1;
		    } else {
			for (i=0; i<LISTSIZE; i++) {
			    if (list[i][0] != '\0') {
				for (j=0; j<LISTSIZE; j++) {
				    if ((cfAinfo.src[j][0] != '\0') ||
					(cfAinfo.file[j][0] != '\0')) {
					if (streq(cfAinfo.user,list[i]) ||
					    streq(cfAinfo.src[j],list[i]) ||
					    streq(cfAinfo.file[j],list[i])) {
					    found = 1;
					}
				    }
				}
			    }
			}
		    }
		}
		if (found) {
			if (!first) {
				first = 1;
/*
"         111111111122222222223333333333444444444455555555556666666666777777
"123456789012345678901234567890123456789012345678901234567890123456789012345
 */
				kb_puts(
"queue     host                job/user       source                   file"
				); kb_nline();
				kb_puts(
"-----     ----                --------       ------                   ----"
				); kb_nline();
			}
			for (i=0; i<LISTSIZE; i++) {
				if ((cfAinfo.src[i][0] != '\0') ||
				    (cfAinfo.file[i][0] != '\0')) {
					kbprintf(
	"%-9.9s %-19.19s %-14.14s %-24.24s %-7.7s\r\n",
	cfAinfo.que,cfAinfo.host,cfAinfo.user,cfAinfo.src[i],cfAinfo.file[i]
					);
				}
			}
		}
/*2*/	} while ((p = nextname()) != NULL);

/*1*/	}

	if (!first) {
		kb_puts("LPD Queue is Empty.\r\n\r\n");
		looptime = 0;
	}
	kb_nline();
}

/*
 * quefiles
 *
 * Queue the files to print
 */

int
quefiles()
{
	register int i,j,k;
	int filcnt;

	/*
	 * Reset to Default Directory
	 */
	cd(defpath);

	/*
	 * Get a data file sequence number
	 * and create a unique file name
	 */
	cfAseq = lpdsequence();
	sprintf(tmpcfl,"wf:lprcfA.%03d", cfAseq);

	if ((tmpcfh = fopen(tmpcfl, "wn")) == NULL) {
		kbprintf(
		    "?-LPR-Unable to Create Control File %s\r\n\r\n",
			tmpcfl);
		return(0);
	}

	/*
	 * Set all defaults
	 */
	if (lprque[0] == '\0')			/*Q*/
		strcpy(lprque,"lp");
	if (lpropt[0] == '\0')			/*f*/
		strcpy(lpropt,"f");

	/*
	 * Write Control Lines
	 */
	fprintf(tmpcfh,"Q%s\r\n", lprque);
	fprintf(tmpcfh,"H%s\r\n", lprhost);
	fprintf(tmpcfh,"P%s\r\n", username);

	filcnt = 0;

	for (i=0; i < LISTSIZE && list[i][0] != '\0'; i++) {

		strcpy(lprfl,list[i]);
		if((lprfh = rtopen(lprfl,"r",0,0)) == NULL) {
			kbprintf(
			    "\r\n?-LPR-File %s Not Found\r\n\r\n",
				lprfl);
			continue;
		} else {
			/*
			 * Build File Strings
			 */
			strcpy(lprfile,rmtfile(list[i]));
			expand(expfl,rtfile(lprfile,getdef()));
			/*
			 * Close File
			 */
			rtclose(lprfh);
		}

		/*
		 * Load directory path
		 */
		if(cd(lpddir))
			continue;

		/*
		 * Get a data file sequence number
		 * and create a unique file name
		 */
		dfAseq = lpdsequence();
		sprintf(dfAfl,"%sdfA.%03d", getdef(),dfAseq);

		/*
		 * Open dumby dfA file
		 */
		if((dfAfh = fopen(dfAfl,"wn")) == NULL) {
			kbprintf(
			    "?-LPR-Unable to Create File %s\r\n\r\n",
				expand(expfl,dfAfl));
			continue;
		}
		fclose(dfAfh);

		/*
		 * Write control lines for this file
		 */
		filcnt += 1;

		if (lprjob[0] != '\0')					/*J*/
			fprintf(tmpcfh,"J%s\r\n", lprjob);
		if (lprclass[0] != '\0')				/*C*/
			fprintf(tmpcfh,"C%s\r\n", lprclass);
		if (lprindent)						/*I*/
			fprintf(tmpcfh,"I%d\r\n", lprindent);
		if (lprwidth)						/*W*/
			fprintf(tmpcfh,"W%d\r\n", lprwidth);
		if (lprbanner[0] != '\0')				/*L*/
			fprintf(tmpcfh,"L%s\r\n", lprbanner);
		if (lprtitle[0] != '\0')				/*T*/
			fprintf(tmpcfh,"T%s\r\n", lprtitle);
		fprintf(tmpcfh,"N%s\r\n", expfl);			/*N*/
		fprintf(tmpcfh,"Z%s\r\n", expfl);			/*Z*/
		if (lprmail)						/*M*/
			fprintf(tmpcfh,"MdfA.%03d\r\n", dfAseq);
		for (j=0; j < lprcpy; j++) {				/*?*/
			for (k=0; k < strlen(lpropt); k++)
				fprintf(tmpcfh,"%cdfA.%03d\r\n",
					lpropt[k],dfAseq);
		}
		fprintf(tmpcfh,"UdfA.%03d\r\n", dfAseq);		/*U*/
	}

	fclose(tmpcfh);
	if (!filcnt) {
		delete(tmpcfl);
		return(0);
	}

	/*
	 * Copy cfA file to LPD directory
	 */
	if((tmpcfh = fopen(tmpcfl,"rn")) == NULL) {
		kbprintf(
		    "?-LPR-Unable to Read Temporary File %s\r\n\r\n",
			tmpcfl);
			return(0);
	} else {
		/*
		 * Open new file
		 */
		sprintf(cfAfl,"%scfA.%03d", getdef(),cfAseq);
		if((cfAfh = fopen(cfAfl,"wn",0,0)) == NULL) {
			kbprintf(
			    "?-LPR-Unable to Create File %s\r\n\r\n",
				expand(expfl,cfAfl));
			fclose(tmpcfh);
			return(0);
		}
		/*
		 * copy data to a new file
		 */
		while (fread(xs,sizeof(xs),1,tmpcfh) != NULL) {
			if (!fwrite(xs,sizeof(xs),1,cfAfh)) {
				kbprintf(
				    "?-LPR-Error Copying File %s\r\n\r\n",
				    expand(expfl,cfAfl));
				fclose(tmpcfh);
				return(0);
			}
		}
		fclose(cfAfl);
		fclose(tmpcfh);
	}
	delete(tmpcfl);
	return(1);
}

/*
 * rmvjob
 *
 * Delete LPD Queued Files
 */

VOID rmvjob()
{
	char *p;
	register int i,j,skip;

/*1*/	if (!cd(lpddir)) {

	skip = 0;
/*2*/	while (((p = firstname("cfA.*")) != NULL) && !fndbrk) {

	    /*
	     * Skip Files
	     */
	    for (i=0; i < skip; i++) {
		p = nextname();
	    }
	    if (p == NULL)
		break;

	    /*
	     * Save File Name
	     */
	    strcpy(cfAfl,p);
	   
	    /*
	     * Get LPD information
	     */
	    getinfo(filiop());
	    lastname();
	    skip += 1;

#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("username   = %s\r\n", username);
	printf("quename    = %s\r\n", lprque);
	for (i=0; i<LISTSIZE; i++) {
		if (list[i][0] != '\0')
			printf("  List[%d] = %s\r\n", i, list[i]);
	}
	printf("cfA file   = %s\r\n", expand(expfl,cfAfl));
	printf("  Queue    = %s\r\n", cfAinfo.que);
	printf("  Host     = %s\r\n", cfAinfo.host);
	printf("  User     = %s\r\n", cfAinfo.user);
	for (i=0; i<LISTSIZE; i++) {
		if ((cfAinfo.src[i][0] != '\0') ||
		    (cfAinfo.file[i][0] != '\0')) {
			printf("    Source = %s\r\n", cfAinfo.src[i]);
			printf("    File   = %s\r\n", cfAinfo.file[i]);
		}
	}
}
#endif

	    if (lprque[0] == '\0' || streq(cfAinfo.que,lprque)) {
		if (strneq(cfAinfo.user,username,USERPASSLEN)) {
		    /*
		     * Any of the users' files
		     */
		    if (list[0][0] == '\0') {
			for (j=0; j < LISTSIZE; j++) {
			    if (cfAinfo.file[j][0] != '\0')
				rmvfile(j,cfAfl);
			}
		    /*
		     * For a User, delete specified file(s)
		     */
		    } else {
			for (i=0; i < LISTSIZE && list[i][0] != '\0'; i++) {
			    for (j=0; j < LISTSIZE; j++) {
				if (streq(cfAinfo.file[j],list[i]))
				    rmvfile(j,cfAfl);
			    }
			}
		    }
		} else
		if (strneq("system",username,USERPASSLEN)) {
		    /*
		     * Any of the users' files
		     */
		    if (list[0][0] == '\0') {
			for (j=0; j < LISTSIZE; j++) {
			    if (cfAinfo.file[j][0] != '\0')
				rmvfile(j,cfAfl);
			}
		    } else
		    /*
		     * For 'system' with 'user', delete all 'user' files
		     */
		    if (streq(cfAinfo.user,list[0])) {
			for (j=0; j < LISTSIZE; j++) {
			    if (cfAinfo.file[j][0] != '\0')
				rmvfile(j,cfAfl);
			}
		    /*
		     * For 'system' with file, delete specified file(s)
		     */
		    } else {
			for (i=0; i < LISTSIZE && list[i][0] != '\0'; i++) {
			    for (j=0; j < LISTSIZE; j++) {
				if (streq(cfAinfo.file[j],list[i]))
				    rmvfile(j,cfAfl);
			    }
			}
		    }
		}
	    }
/*2*/	}

/*1*/	}
}

/*
 * rmvfile
 *
 * Remove a dfA file
 */

VOID
rmvfile(i,p)
register int i;
char *p;
{
	register int j;

	if ((cfAfh = rtopen(cfAinfo.file[i],"r",0,0)) != NULL) {
		rtclose(cfAfh);

		kb_nline();
		kbprintf("cfA file   = %s\r\n", expand(expfl,p));
		kbprintf("  Queue    = %s\r\n", cfAinfo.que);
		kbprintf("  Host     = %s\r\n", cfAinfo.host);
		kbprintf("  User     = %s\r\n", cfAinfo.user);
		kbprintf("    Source = %s\r\n", cfAinfo.src[i]);
		kbprintf("    File   = %s\r\n", cfAinfo.file[i]);

		kb_puts("?-LPRM-");
		delfil(0,cfAinfo.file[i],1,0);
		lsterr();

		for (j=i+1; j<LISTSIZE; j++) {
			if (streq(cfAinfo.file[j],cfAinfo.file[i]))
				cfAinfo.file[j][0] = '\0';
		}
	}
}
                                                                                                   