{$I+,Y-}
program compress;


{
  Computer Detection of Typographical Errors
	Word Compression

  		Author : C. E. Chew
  		Date   : April 1985

 Link with base of 1000 octal.
}

const
  stringlength = 20;

  version = 'CMPRES  1.0  May 1985';
  cmpres = "CMPRES";

  debug = false;

  space = ' ';
  apostrophe = '''';
  semicolon = ';';
  nul = chr(0);
  lf = chr(10);

  inpx = 2;
  outx = 3;

type
  string = array [1..stringlength+1] of char;

var
  inp, out : text;
  prev, word : string;



procedure rerun; external;



function initialise:boolean;

begin
  initialise := false;
  if argc = 4 then begin
    reset(inp, argv[inpx]@, "WRD");
    rewrite(out, argv[outx]@, "DIC");
    prev[1] := nul;
    initialise := true
  end
end;



function getword(var w : string):boolean;

begin
  getword := false;
  if not eof(inp) then begin
    getword := true;
    readln(inp, w)
  end
end;



procedure putword(var w : string);

var
  ch : char;
  i, j : integer;

begin
  j := 0;
  repeat
    j := j + 1;
    ch := prev[j]
  until (ch <> w[j]) or (ch = nul);
  if ch <> w[j] then begin
    if j > 2 then
      write(out, chr((ord(space)-1) + j))
    else if j = 2 then
      write(out, prev[1]);
    ch := w[j];
    prev[j] := ch;
    while ch <> nul do begin
      write(out, ch);
      j := j + 1;
      ch := w[j];
      prev[j] := ch
    end;
    write(out, lf);
  end
end;



begin
  if not initialise then begin
    writeln(version);
    writeln;
    writeln('$options input output');
    writeln;
    writeln;
    rerun
  end
  else begin
    while getword(word) do
      putword(word)
  end
end.
                                                                                                                                                                                                                                                                                                                                       