{$I+,Y-}
program dictionary;


{
  Computer Detection of Typographical Errors
	Dictionary Builder

  		Author : C. E. Chew
  		Date   : April 1985

 Link with base of 2000 octal.
}

const
  stringlength = 20;

  version = 'DICTIO  1.0  May 1985';
  dictio = "DICTIO";

  debug = false;

  space = ' ';
  apostrophe = '''';
  semicolon = ';';
  nul = chr(0);
  lf = chr(10);

  wsize = 3000;

  inpx = 2;
  outx = 3;

type
  relation = (lt, le, eq, ge, gt, ne);
  string = array [1..stringlength+1] of char;

  wordarr = record
              word : string
            end;

  wordptr = @wordarr;

  wordrec = record
              word : array [0..maxint] of wordptr
            end;

var
  words : @wordrec;
  uniquewords, wordinx : integer;



procedure fatal(s,m:string); external;

function match(s1,s2:string):relation; external;

procedure rerun; external;



function initialise:boolean;

begin
  initialise := false;
  if argc = 4 then begin
    new(words, wsize);
    wordinx := -1;
    initialise := true
  end
end;



procedure scanwords;

var
  inp : text;
  i : integer;
  ch : char;
  firstonline : boolean;
  w : string;
  x : wordptr;

procedure getchar(var ch : char);

begin
  if eof(inp) then
    ch := nul
  else begin
    if firstonline then begin
      while inp@ = semicolon do
	readln(inp);
      firstonline := false
    end;
    if eoln(inp) then
      firstonline := true;
    read(inp, ch);
    if (ch >= 'A') and (ch <= 'Z') then
      ch := chr(ord(ch) + (ord('a') - ord('A')))
    else if ch < space then
      ch := space
  end
end;

begin
  reset(inp, argv[inpx]@, "WRD");
  firstonline := true;
  getchar(ch);
  while ch <> nul do begin
    if (ch < 'a') or (ch > 'z') then
      getchar(ch)
    else begin
      i := 0;
      while (((ch >= 'a') and (ch <= 'z')) or (ch = apostrophe))
	    and (i < stringlength) do begin
	if ch = apostrophe then
	  ch := '{';
	i := i + 1;
	w[i] := ch;
	getchar(ch)
      end;
      i := i + 1;
      w[i] := nul;
      new(x, i);
      repeat
	x@.word[i] := w[i];
	i := i - 1
      until i = 0;
      if debug then
	writeln('Word : ', x@.word);
      wordinx := wordinx + 1;
      if wordinx = wsize then
	fatal(dictio, "Word table overflow");
      words@.word[wordinx] := x
    end
  end
end;



procedure sortwords;

var
  xword : string;
  t : wordptr;
  k : integer;

procedure sorting(l, r : integer);

var
  i, j : integer;

begin
  i := l;
  j := r;
  xword := words@.word[(i+j) div 2]@.word;
  repeat
    while match(words@.word[i]@.word, xword) = lt do
      i := i + 1;
    while match(words@.word[j]@.word, xword) = gt do
      j := j - 1;
    if i < j then begin
      t := words@.word[i];
      words@.word[i] := words@.word[j];
      words@.word[j] := t
    end;
    if i <= j then begin
      i := i + 1;
      j := j - 1
    end
  until i > j;
  if l < j then
    sorting(l, j);
  if i < r then
    sorting(i, r)
end;

begin
  if wordinx > 0 then
    sorting(0, wordinx);
  if debug then begin
    writeln('Sorted List');
    for k := 0 to wordinx do
      writeln(words@.word[k]@.word)
  end
end;



procedure dumpwords;

var
  out : text;
  prev : string;
  ch : char;
  i, j : integer;

begin
  rewrite(out, argv[outx]@, "DIC");
  prev[1] := nul;
  uniquewords := 0;
  for i := 0 to wordinx do begin
    with words@.word[i]@ do begin
      j := 0;
      repeat
	j := j + 1;
	ch := prev[j]
      until (prev[j] <> word[j]) or (ch = nul);
      if prev[j] <> word[j] then begin
	uniquewords := uniquewords + 1;
	if j > 2 then
	  write(out, chr((ord(space)-1) + j))
	else if j = 2 then
	  write(out, prev[1]);
	ch := word[j];
	prev[j] := ch;
	while ch <> nul do begin
	  write(out, ch);
	  j := j + 1;
	  ch := word[j];
	  prev[j] := ch
	end;
	write(out, lf);
      end
    end
  end
end;



begin
  if not initialise then begin
    writeln(version);
    writeln;
    writeln('$options input output');
    writeln;
    writeln;
    rerun
  end
  else begin
    writeln('Scanning Word List');
    scanwords;
    writeln('Sorting Words');
    sortwords;
    writeln('Creating Dictionary');
    dumpwords;
    writeln(' Words Encountered : ', wordinx+1);
    writeln(' Unique Words      : ', uniquewords)
  end
end.
                                                                                                                                                               