/*
 *	cminit - this invokes the initialisation procedure for cmath
 */

#ifdef	DOCUMENTATION
title	cminit	cmath initialisation procedure
index	cmath initialisation
usage
	.s
	Do not call this procedure explicitly, but be sure that it is
	loaded by including its name in the linkers command string.
	The program will then be called during the normal initialisation
	procedure (via SUPORT in RT-11).
	.s
description
	.s
	Used by the floating point math package to initialise the error
	handling system and to set the standard default parameters for 
	the floating point status.  If the operating system is rt11, it 
	arranges to catch the interrupts from the FPU since that is not
	done in traps for rt11 (c.f. Wizard and source code).  Though
	cmathe() and fps() are called here they can also be called at
	any stage by the users program to invoke different values of the
	parameters set by these functions.
	.s
diagnostics
	.s
	None
	.s
internal
	.s
author
	.s
	Hamish Ross
	.s
date
	.s
	31-Jan-85
#endif

#include <stdio.h>
#include <initia.h>
#include <fps.h>
INITIAL
{
#if rt11
	fptrap();
#endif
	fps(FIV | FIC);
	cmathe(0);
}
                                                                                                                                                                                                                                                                                                                                                                   