{$nomain}

{ this is the file 'DIRDAT.PAS' which contains the routine for translating
  and printing/writing the date from rt-11 directory format into standard
  system date format }

const
%include 'dircon.pas';

type
%include 'dirtyp.pas';

{                                                            }
{                      procedure dirdat                      }
{                                                            }

procedure dirdat(var xfile: text;
                 dateword: uword16);

external;

procedure dirdat;

  const
    monthmask = 8#36000;        { bits 10 thru 13 }

    daymask = 8#1740;           { bits 5 thru 10 }

    yearmask = 8#37;            { bits 0 thru 4 }

    monthfactor = 8#2000;       { bit 10 }

    dayfactor = 8#40;           { bit 5 }

  var
    month: integer;

    day: integer;

    year: integer;




  procedure splitdate(dateword: uword16;
                      var nmonth: integer;
                      var nday: integer;
                      var nyear: integer);

{ uses masks to split date word into component parts }

  begin
  nmonth := (dateword and monthmask) div monthfactor;
  nday := (dateword and daymask) div dayfactor;
  nyear := (dateword and yearmask) + 8#110;
  end;                             { of procedure splitdate }


  procedure putmonth(month: integer);

  begin
  if month in [1..12] then
    case month of
      1: write(xfile,'Jan');
      2: write(xfile,'Feb');
      3: write(xfile,'Mar');
      4: write(xfile,'Apr');
      5: write(xfile,'May');
      6: write(xfile,'Jun');
      7: write(xfile,'Jul');
      8: write(xfile,'Aug');
      9: write(xfile,'Sep');
      10: write(xfile,'Oct');
      11: write(xfile,'Nov');
      12: write(xfile,'Dec');
      end              { of case body }
  else
    write(xfile,'???');
  end;                        { of procedure putmonth }

  begin                { dirdat procedure body }
  splitdate(dateword,month,day,year);
  write(xfile,day:1,'-');
  putmonth(month);
  write(xfile,'-',year:1);
  end;                { of procedure dirdat }

                                                                                                                                                                                                                                                                                                                                                                                                              