	.PAGE
	.SBTTL	8250 SYSTEM MACROS
.NLIST
;	PORT HANDLER NAMING CONVENTION
;
;	_	IS DEVICE UNIT LETTER
;	NNNN	IS DEVICE CODE
;	****	IS ANY ALPHA/NUMERIC SEQUENCE
;
;
;	_$NNNN	- UNIT DEFINED
;	_.NNNN	- DEVICE ADDRESS
;
;
;	$_NNNN	- UNIT DEFINITION MACRO'S OR
;			NON-INLINE CODE
;
;	_NNNN$	- COMMON SUBROUTINE ENTRY POINTS REQUIRING
;			X,Y,U, OR D TO BE SPECIFIED
;			BEFORE ENTRY
;
;	_NNNNI	- COMMON INTERRUPT ENTRY POINTS REQUIRING
;			X,Y,U, OR D TO BE SPECIFIED
;			BEFORE ENTRY
;
;	.INNNN	- IN-LINE INITIALIZATION MACRO CALLS REQUIRING
;			X,Y,U, OR D TO BE SPECIFIED
;			BEFORE ENTRY
;
;	_.****	- OLDER HANDLERS USED THIS FORMAT FOR INTERNAL
;			LABELS AND ENTRY POINTS. THIS FORM SHOULD
;			NOT BE USED FOR NEW HANDLERS.
;
.LIST

	;
	;  THESE MACROS MAY BE USED TO DEFINE THE CONFIGURATION
	;OF THE 8250 ACE SYSTEM
	;
	;
	;	EACH CHARACTER OF <I> CORRESPONDS TO
	;		AN 8250 ACE IN THE SYSTEM
	;
	;  8250 DEFINITIONS
	;
	.MACRO	D$8250,J
;
;  A.8250 STATUS BUFFER DEFINITIONS
;
A.MO$V=0
;	.BYTE	0,0	;MODEM DISPATCH VECTOR
A.XM$V=2
;	.BYTE	0,0	;XMTR DISPATCH VECTOR
A.RC$V=4
;	.BYTE	0,0	;RCVR DISPATCH VECTOR
A.LN$V=6
;	.BYTE	0,0	;LINE DISPATCH VECTOR
	;
A.LNST=10
;	.BYTE	0	;LINE STATUS FLAG
	;		= 0	NO PROCESS PENDING
	;		=-1	REQUIRES BAUD RATE PROCESSING
A.ERCT=11
;	.BYTE	0	;LINE ERROR COUNTER
A.LNBL=12
;	.BYTE	0	;'LINE' SERVICE ENABLES
A.MNBL=13
;	.BYTE	0	;'MODEM' SERVICE ENABLES
	;
A.PBCT=14
;	.BYTE	0,0	;PREVIOUS BAUD COUNT
A.CBCT=16
;	.BYTE	0,0	;CURRENT BAUD COUNT
A.BDIF=20
;	.BYTE	0,0	;COMPUTED DIFFERENCE
A.LWCT=22
;	.BYTE	0,0	;LOWEST DIFFERENCE FOUND
A.BDVS=24
;	.BYTE	0,0	;BAUD RATE DIVISOR
A.BDTB=26
;	.BYTE	0,0	;ADDRESS OF BAUD RATE TABLE
A.PADD=30
;	.BYTE	0,0	;ADDRESS OF THIS 8250 PORT
	;
	A$LEN=32
	;
	.IRPC	X,<J>
	X'S8250=VARSAV		;ALLOCATE STATUS BUFFERS
	VARSAV=VARSAV+A$LEN
X'8250I:
	LDX	#,X'.8250	;PORT ADDRESS
	LDY	#,X'S8250	;POINTER TO PORT TABLE
	JMP	D8250$		;COMMON ENTRY POINT
	.ENDM
	.ENDM
	;
	;
	;  8250 INITIALIZATION
	;
	.MACRO	.I8250,J
	.IRPC	X,<J>
	LDX	#,X'.8250	;PORT ADDRESS
	LDY	#,X'S8250	;PORT STATUS BUFFER ADDRESS
	LDU	#,X'B8250	;USE SPECIFIED BAUD RATE TABLE
	JSR	I8250$		;INITIALIZE
	.ENDM
	.ENDM
	;
                                                                                                                                                                                                                                                                                                                   