	  SOUTH AUSTRALIAN INSTITUTE OF TECHNOLOGY
	  ----------------------------------------

		 SAENET PROGRAMMING SERVICES
		 ---------------------------


PROJECT DOCUMENTATION
---------------------

PROJECT NUMBER:    CC016

PROJECT NAME:      SAETAN

DOCUMENT NAME:



     #   #  ###   ###  ####   ###         #   #      #  #### ####
     ## ## #   # #   # #   # #   #       ##  ##     #  #     #   #
     # # # ##### #     ####  #   # #####  #   #    #    ###  ####
     #   # #   # #   # #  #  #   #        #   #   #        # #
     #   # #   #  ###  #   #  ###        ### ### #     ####  #


   #   #  #### ##### ####        #   #  ###  #   # #   #  ###  #
   #   # #     #     #   #       ## ## #   # ##  # #   # #   # #
   #   #  ###  ###   ####        # # # ##### # # # #   # ##### #
   #   #     # #     #  #        #   # #   # #  ## #   # #   # #
    ###  ####  ##### #   #       #   # #   # #   #  ###  #   # #####



DOCUMENT VERSION:  2

AUTHOR:            D L HERON
		   P O BOX 1, INGLE FARM, S.A., 5098, AUSTRALIA

DATE:              29 JUNE 77

----------------------------------------------------------------------


0	SUMMARY
	=======


	THIS IS THE USER DOCUMENTATION FOR THE MACRO-11/SP
	STRUCTURED PROGRAMMING MACROS, WHICH IN EFFECT CREATE A
	SIGNIFICANT EXTENSION TO THE STANDARD PDP-11 ASSEMBLY
	LANGUAGE MACRO-11.

	THIS DOCUMENT CONTAINS INTRODUCTORY MATERIAL, AND THE
	COMPLETE SPECIFICATION FOR USAGE.  AN APPENDIX SHOWS AN
	EXAMPLE OF USAGE, AND THE CODE GENERATED FOR THAT EXAMPLE.

	THE READER OF THIS MANUAL IS EXPECTED TO BE FAMILIAR WITH
	THE MACRO-11 LANGUAGE.  THE USER OF MACRO-11/SP SHOULD
	PREFERABLY HAVE SOME EXPERIENCE OF MACRO-11 PROGRAMMING.
	CONTENTS
	========

	0 SUMMARY
	  CONTENTS

	1 INTRODUCTION
	  1.1 GENERAL DESCRIPTION
	      1.1.1 FACILITIES AVAILABLE
	      1.1.2 FEATURES
	  1.2 PROGRAM STRUCTURE
	      1.2.1 'MACSP' MACRO
	      1.2.2 NESTING
	      1.2.3 PROCEDURES
	  1.3 INTERACTIONS
	      1.3.1 ASSEMBLY-TIME VARIABLES
	      1.3.2 INTERNAL MACROS
	      1.3.3 SIZE LIMIT
	      1.3.4 LABELS AND 'IF' ... 'FI' AND 'LOOP' ... 'REPEAT'
	      1.3.5 INTERACTION WITH CONDITION CODES AT RUN TIME
	      1.3.6 INTERACTION WITH PROCESSOR STACK AT RUN TIME
	      1.3.7 INTERACTION WITH '.RADIX'
	      1.3.8 INTERACTION WITH '.CSECT', '.ASECT' AND '.PSECT'
	  1.4 ERRORS
	  1.5 SYSTEMS
	  1.6 DISTRIBUTION MATERIALS
	      1.6.1 PDP-11 SYSTEMS
	      1.6.2 CYBER SYSTEM

	2 CONDITIONAL/ALTERNATIVE EXECUTION: IF, IFB, IFC, ELSE, FI
	  2.1 CONDITIONAL EXECUTION
	  2.2 ALTERNATIVE EXECUTION
	  2.3 SIMPLE CONDITIONS
	      2.3.1 WORD COMPARISON
	      2.3.2 BYTE COMPARISON
	      2.3.3 BIT TESTING
	      2.3.4 CONDITION CODE TESTING
	  2.4 COMPOUND CONDITIONS
	  2.5 RUN-TIME INTERACTIONS
	      2.5.1 CONDITION CODES
	      2.5.2 PROCESSOR STACK
	  2.6 ERRORS

	3 REPETITIVE EXECUTION: LOOP, LOOPB, EXLOOP, REPEAT
	  3.1 UNCONDITIONAL LOOP
	  3.2 COUNTED LOOP
	      3.2.1 WORD COUNT
	      3.2.2 BYTE CONUT
	  3.3 LOOP EXIT
	      3.3.1 UNCONDITIONAL EXIT
	      3.3.2 CONDITIONAL EXIT
	  3.4 RUN-TIME INTERACTIONS
	      3.4.1 CONDITION CODES
	      3.4.2 PROCESSOR STACK
	  3.5 ERRORS
	4 PROCEDURE AND BLOCK DEFINITON AND INVOCATION: PROC, BEGIN, END, CALL
	  4.1 PROCEDURE DEFINITION AND INVOCATION
	  4.2 RECOMMENDED CONVENTIONS
	  4.3 REGISTER SAVING
	  4.4 STORAGE ACQUISITION
	  4.5 CRITICAL PROCEDURES
	  4.6 BEGIN BLOCKS
	  4.7 RUN-TIME INTERACTIONS
	      4.7.1 CONDITION CODES
	      4.7.2 PROCESSOR STACK
	  4.8 ERRORS

	5 MULTIPLE-ALTERNATIVE EXECUTION: CASE, VALUE, CASEND
	  5.1 BASIC FACILITY
	      5.1.1 INTRODUCTION
	      5.1.2 'CASE' STATEMENT
	      5.1.3 'VALUE' STATEMENT
	      5.1.4 'CASEND' STATEMENT
	  5.2 ADVANCED FEATURES
	      5.2.1 VALUE RANGES
	      5.2.2 OUT-OF-RANGE VALUES
	      5.2.3 UNSELECTED VALUES
	  5.3 'PACKED' OPTION
	  5.4 RUN-TIME INTERACTIONS
	      5.4.1 CONDITION CODES
	      5.4.2 PROCESSOR STACK
	      5.4.3 INPUT ARGUMENT DESTROYED
	  5.5 ERRORS

	A1 APPENDIX 1: EXAMPLE OF USAGE
1	INTRODUCTION
	============

1.1	GENERAL DESCRIPTION
	-------------------

	THESE MACROS PROVIDE A SIMPLE, COMPREHENSIVE SET OF "STRUCTURED
	PROGRAMMING" CONTROL STRUCTURES FOR PROGRAMS CODED IN MACRO-11.

	THE USE OF THESE CONTROL STRUCTURES HAS BEEN FOUND TO IMPROVE
	SUBSTANTIALLY THE CLARITY OF PROGRAMS, WITH CONSEQUENT
	REDUCTION IN THE NUMBER OF BUGS, AND IMPROVEMENT IN MAINTAINABILITY.
	PROGRAMS ARE ALSO QUICKER AND EASIER TO WRITE.  THERE IS A PRICE
	TO PAY IN LEARNING THE DISCIPLINE OF USING THESE MACROS;
	BUT ONCE LEARNED, THEY MAKE A SIGNIFICANT CONTRIBUTION TO
	PROGRAMMING EFFICIENCY, FOR EVEN THE SIMPLEST PROGRAMS.

	NO GREAT THEORETICAL ELEGANCE IS CLAIMED FOR THESE MACROS;
	THEY ARE MERELY ONE PRACTICAL COMPROMISE BETWEEN PROGRAMMING
	DISCIPLINE, FLEXIBILITY AND IMPLEMENTABILITY, BASED ON THE
	AUTHOR'S NEEDS AND EXPERIENCE AT THE TIME OF THEIR EVOLUTION.

	NOTE THAT THESE MACROS SPECIFY TESTS WHICH ARE MADE AT RUN-TIME.
	THEY ARE QUITE DISTINCT FROM THE ASSEMBLER'S .IF, .IFF, .IFT,
	.IFTF, .ENDC, .IIF, .REPT, .IRP, .IRPC AND .ENDR DIRECTIVES,
	WHICH CONTROL THE GENERATION OF CODE AT ASSEMBLY TIME.

1.1.1	FACILITIES AVAILABLE

	1. A STRUCTURE WHICH SPECIFIES CONDITIONAL EXECUTION.
	   THIS CAUSES A SECTION OF CODE TO EXECUTED IF A LOGICAL
	   CONDITION IS TRUE, AND SKIPPED IF THE CONDITION IS FALSE.
	2. A STRUCTURE WHICH SPECIFIES ALTERNATIVE EXECUTION.
	   THIS CAUSES A SECTION OF CODE TO EXECUTED IF A LOGICAL
	   CONDITION IS TRUE, AND AN ALTERNATIVE SECTION TO BE
	   EXECUTED IF THE CONDITION IS FALSE.
	3. A STRUCTURE WHICH SPECIFIES REPETITIVE EXECUTION.
	   LOOPS CAN BE UNCONDITIONAL, OR CAN BE EXECUTED A
	   PREDETERMINED NUMBER OF TIMES, OR CAN BE TERMINATED
	   CONDITIONALLY FROM ANY POINT WITHIN THE LOOP DURING
	   EXECUTION.
	4. PROCEDURE DEFINITION.  OPTIONALLY, REGISTERS
	   CAN BE SAVED, AND A BLOCK OF STORAGE CAN BE ACQUIRED, ON
	   PROCEDURE ENTRY, WITH AUTOMATIC RESTORATION ON EXIT.
	   ANOTHER OPTION IS FOR THE CODE OF A PROCEDURE TO BE
	   DECLARED "CRITICAL" I.E. INTERRUPT-FREE.
	   PROCEDURES ARE OUT-OF-LINE SECTIONS OF CODE WHICH MUST BE
	   INVOKED EXPLICITLY FROM ELSEWHERE.  THERE IS ALSO A FACILITY
	   FOR IN-LINE CODE TO SAVE REGISTERS, ACQUIRE STORAGE OR BE
	   PROTECTED FROM INTERRUPTS.
	5. PROCEDURE INVOCATION.
	6. A STRUCTURE WHICH SPECIFIES MULTIPLE-ALTERNATIVE EXECUTION.
	   THIS STRUCTURE ALLOWS EXECUTION OF ONE OF AN ARBITRARY NUMBER
	   OF ALTERNATIVE CODE SEQUENCES, DEPENDING ON THE VALUE OF AN
	   UNSIGNED INTEGER VARIABLE.
1.1.2	FEATURES

	1. THE CONDITIONS SPECIFIABLE IN CONDITIONAL, ALTERNATIVE AND
	   REPETITIVE EXECUTION CAN USE ANY PDP-11 TEST AND CONDITIONAL
	   BRANCH INSTRUCTIONS.  INDIVIDUAL TESTS CAN BE COMBINED
	   WITH LOGICAL "AND" AND "OR" OPERATORS.  WORD OR BYTE
	   VARIABLES CAN BE TESTED, BITS CAN BE EXAMINED, OR
	   THE CONDITION CODE SETTING FROM THE PREVIOUS INSTRUCTION
	   CAN BE TESTED.  THE SPECIFICATION OF ARITHMETIC COMPARISONS
	   IS DESIGNED TO ENCOURAGE THE SELECTION OF THE CORRECT TEST
	   FOR SIGNED AND UNSIGNED DATA.
	2. ALL CODE GENERATED BY THESE MACROS IS POSITION-INDEPENDENT
	   (UNLESS THE USER REFERENCES DATA IN A NON-PIC MANNER),
	   RE-ENTRANT (I.E. NOT SELF-MODIFYING), AND WILL PRODUCE THE
	   SAME EFFECT ON ANY PDP-11 PROCESSOR.  ALL PRIVATE DATA
	   USED AT RUN-TIME BY THE GENERATED CODE IS KEPT ON THE
	   PROCESSOR STACK.
	3. THE MACROS ARE DESIGNED FOR EASE OF USE AND EFFICIENCY
	   OF THE GENERATED CODE, AT THE EXPENSE OF ASSEMBLY TIME.
	   CONSIDERABLE EFFORT HAS BEEN EXPENDED TO REDUCE THE
	   ASSEMBLY-TIME SPACE REQUIREMENTS OF THESE MACROS;
	   HOWEVER IT IS STILL SIGNIFICANT.
1.2	PROGRAM STRUCTURE
	-----------------

	USE OF THESE MACROS IMPOSES DISCIPLINE ON THE STRUCTURE
	OF THE PROGRAM.


1.2.1	'MACSP' MACRO

	BEFORE ANY OF THE OTHER MACROS CAN BE CALLED, THE PROGRAM MUST
	CALL THE MACRO 'MACSP', AS FOLLOWS.
		.MCALL MACSP
		MACSP
	THIS MACRO INITIALIZES ASSEMBLY-TIME VARIABLES FOR USE BY
	THE SUBSEQUENT MACROS, AND ISSUES '.MCALL' DIRECTIVES TO OBTAIN
	THEM FROM THE SYSTEM MACRO LIBRARY.

	AN ALTERNATIVE FORM OF THE CALL TO 'MACSP' IS
		.MCALL MACSP
		MACSP LIST
	WHICH CAUSES THE SUBSEQUENT MACROS TO LIST THE INSTRUCTIONS
	AND LABELS WHICH THEY GENERATE.  THIS LISTING MAY BE OF
	INTEREST, AND CAN BE IMPORTANT WHEN ISOLATING A BUG.
	SOME OF THE INSTRUCTIONS ARE LISTED IN OCTAL, AND THERE ARE A FEW
	LINES LISTED WHICH ARE IRRELEVANT TO THE USER.



1.2.2	NESTING

	THESE MACROS PRODUCE NESTED CONTROL STRUCTURES.  IT IS THE ADHERENCE
	TO THIS NESTED STRUCTURE THAT MAKES THE CHIEF CONTRIBUTION TO AN
	UNDERSTANDABLE PROGRAM.  THESE STRUCTURES SHARE THE PROPERTIES
	(1) THAT CONTROL FLOWS IN AT ONE POINT - THE TOP - AND OUT AT
	ONE POINT - THE BOTTOM - AND (2) THAT THE STATEMENTS WHICH DEFINE
	A STRUCTURE CLEARLY DEFINE THE CONTROL FLOW WITHIN THAT
	STRUCTURE.  HENCE THE CONTROL FLOW THROUGH THE WHOLE PROGRAM
	IS READILY PERCEIVED.

	THE STRUCTURAL UNITS ARE AS FOLLOWS;  NOTE THAT THE STATEMENT SYNTAX
	HAS BEEN ABBREVIATED IN THIS SECTION FOR SIMPLICITY.
	GENERIC ITEMS ARE ENCLOSED IN ANGLE BRACKETS.

	CONDITIONAL EXECUTION:
		IF <CONDITION> THEN
		  ...
		FI

	ALTERNATIVE EXECUTION:
		IF <CONDITION> THEN
		  ...
		ELSE
		  ...
		FI

	REPETITIVE EXECUTION:
		LOOP
		  ...
		REPEAT
	REPETITIVE EXECUTION WITH CONDITIONAL EXIT:
		LOOP			OR:	LOOP
		  ...				  ...
		  IF <CONDITION> THEN		  EXLOOP IF <CONDITION>
		    ...				  ...
		    EXLOOP			REPEAT
		  FI
		  ...
		REPEAT

	BEGIN BLOCK:
		BEGIN
		  ...
		END

	MULTIPLE-ALTERNATIVE EXECUTION:
		CASE
		  ...
		VALUE <LIST>	) REPEATED AS
		  ...		) REQUIRED
		CASEND

	IN EACH CASE, THE '...' INDICATES THE PRESENCE OF ZERO OR
	MORE UNITS OF MACRO-11/SP CODE WHICH MAY BE BASIC INSTRUCTIONS,
	"FOREIGN" MACROS, OR WHOLE STRUCTURAL UNITS FROM THE ABOVE SET.
	THAT IS, THE STRUCTURES MAY BE NESTED WITHIN OTHERS, IN ANY
	ORDER AND TO A DEPTH LIMITED BY THE CAPABILITIES OF MACRO-11
	AND/OR THE HARDWARE, AND THE STRUCTURE SIZE RESTRICTIONS DESCRIBED
	IN SECTION 1.3.3.  THE SCOPE OF EACH
	STRUCTURAL UNIT IS ESTABLISHED BY THE APPEARANCE IN THE SOURCE
	CODE OF THE STATEMENT WHICH TERMINATES IT ('ELSE', 'FI', 'REPEAT',
	'END', 'VALUE OR 'CASEND');  THERE IS NO LABELLING IN THE SOURCE TO
	CONNECT AN 'IF' TO ITS 'FI', FOR EXAMPLE.  FOR THIS REASON IT IS
	RECOMMENDED THAT THE STATEMENTS WITHIN THE SCOPE OF A
	STRUCTURAL UNIT BE INDENTED FROM THE OPENING AND CLOSING
	STATEMENTS, TO MAKE THE PROGRAM'S STRUCTURE READILY APPARENT.
	THIS MAKES NO DIFFERENCE TO THE MACROS OF COURSE;  THEY MAINTAIN
	AN ASSEMBLY-TIME STACK TO REMEMBER THE STRUCTURE OF THE PROGRAM.


1.2.3	PROCEDURES

	ALL OF THE STRUCTURES SHOWN IN SECTION 1.2.2 ARE IN-LINE
	STRUCTURES WHICH ARE EXECUTED THROUGH.  IN ADDITION, IT IS
	POSSIBLE (AND USUALLY NECESSARY) TO DEFINE PROCEDURES WHICH ARE
	INVOKED FROM ELSEWHERE.

	A PROCEDURE IS DEFINED BY
		PROC <NAME>
		  ...
		END
	AND INVOKED BY
		CALL <NAME>

	A PROCEDURE DEFINITION MAY NOT BE NESTED WITHIN ANY OTHER STRUCTURE, BUT
	IT MAY CONTAIN ANY OTHER MACRO-11/SP STATEMENT NESTED WITHIN IT.
	THIS CAUSES A TYPICAL MACRO-11/SP PROGRAM TO APPEAR AS A SEQUENCE
	OF ONE OR MORE PROCEDURES, OFTEN PRECEDED BY A MAIN-PROGRAM SECTION.
1.3	INTERACTIONS
	------------

	THESE MACROS PERFORM COMPLEX PROCESSING, AND SO HAVE SIGNIFICANT
	INTERACTIONS AMONG THEMSELVES, AND WITH THE REST OF THE
	PROGRAM.  THOSE INTERACTIONS WHICH APPLY IN GENERAL ARE
	DESCRIBED IN THIS SECTION.


1.3.1	ASSEMBLY-TIME VARIABLES

	THE MACROS USE A NUMBER OF VARIABLES AT ASSEMBLY TIME.
	THESE ALL HAVE SYMBOLS OF THE FORM '$NNN', WHERE "NNN" IS A 1, 2, 3 OR
	4 DIGIT NUMBER.  THE USER SHOULD NOT USE SYMBOLS OF THAT FORM.


1.3.2	INTERNAL MACROS

	APART FROM THE USER-CALLABLE MACROS, VIZ:
		MACSP
		IF, IFB, IFC, ELSE, FI
		LOOP, LOOPB, EXLOOP, REPEAT
		PROC, BEGIN, END, CALL
		CASE, VALUE, CASEND
	THERE ARE A NUMBER OF INTERNAL MACROS WHICH ARE CALLED BY THEM.
	THESE ALL HAVE NAMES OF THE FORM '$NN', WHERE "NN" IS A 2-DIGIT
	NUMBER.  THE USER SHOULD NOT USE MACROS WITH NAMES OF THAT FORM.


1.3.3	SIZE LIMIT

	ALL TRANSFERS OF CONTROL GENERATED BY THE 'IF', 'ELSE', 'LOOP'
	AND 'REPEAT' MACROS USE PDP-11 BRANCH INSTRUCTIONS, WHICH HAVE
	A RANGE OF -376(8) TO +400(8) BYTES.  THIS LIMITS THE SIZE OF
	THE 'IF' ... 'FI' AND 'LOOP' ... 'REPEAT' STRUCTURAL UNITS
	TO APPROXIMATELY 400(8) BYTES.
1.3.4	LABELS AND 'IF' ... 'FI' AND 'LOOP' ... 'REPEAT'

	MACRO-11 LOCAL LABELS ARE USED AT THE DESTINATIONS OF TRANSFERS
	OF CONTROL IN THE 'IF' ... 'FI AND 'LOOP' ... 'REPEAT' STRUCTURES;
	LABELS ARE CONSUMED IN THE SEQUENCE 1$, 2$, ... AND THE SEQUENCE
	IS RESET AT THE START OF EACH PROCEDURE.  THIS HAS THE FOLLOWING
	CONSEQUENCES;  REMEMBER THAT A LOCAL LABEL MUST APPEAR LESS
	THAN 400 BYTES AFTER THE LAST NORMAL LABEL, AND CANNOT
	BE REFERENCED FROM BEYOND THE NORMAL LABELS ON EITHER SIDE OF IT.
	1. USER-WRITTEN NORMAL LABELS CANNOT APPEAR WITHIN EITHER OF
	   THESE STRUCTURES.
	2. ANY USER-WRITTEN LABEL WITHIN THESE STRUCTURES MUST
	   THEREFORE BE A LOCAL LABEL, AND THESE SHOULD BE CHOSEN FROM
	   SAY ABOVE 100$ TO AVOID CONFLICT WITH THE MACRO-GENERATED
	   LABELS.  PROPER USE OF THE CONTROL STRUCTURES PROVIDED HERE
	   ALMOST COMPLETELY REMOVES THE NEED FOR THE USER TO WRITE LABELS.
	3. THESE STRUCTURES MUST FINISH WITHIN 400 BYTES OF THE 
	   LAST NORMAL LABEL, WHICH WILL USUALLY BE AT THE START OF THE
	   PROCEDURE (SINCE THE 'PROC' STATEMENT GENERATES A NORMAL LABEL).
	   HENCE NO PROBLEMS CAN OCCUR IF PROCEDURES ARE
	   RESTRICTED TO 400 BYTES IN LENGTH.  THIS RESTRICTION
	   IS NOT SERIOUS IN PRACTICE, AND IT ENCOURAGES THE SEPARATION
	   OF THE PROGRAM INTO SHORT, UNDERSTANDABLE MODULES OF CODE.
	   (THE ONLY PLACE WHERE A PROBLEM MAY OCCUR IS IN A LARGE
	   'CASE' ... 'CASEND' STRUCTURE.  THE USER MAY HAVE TO INTRODUCE
	   A NORMAL LABEL ON SOME 'VALUE' STATEMENTS TO ENSURE THERE IS ONE
	   WITHIN 400 BYTES OF EACH MACRO-GENERATED LOCAL LABEL.)

1.3.5	INTERACTION WITH CONDITION CODES AT RUN TIME

	EXECUTION OF THE MAJORITY OF THE MACROS CHANGES THE CONDITION
	CODES.  THE DESCRIPTION OF EACH GROUP OF MACROS HAS A SECTION
	WHICH SPECIFIES THOSE STATEMENTS WHICH AFFECT THE CONDITION-CODE
	SETTING.


1.3.6	INTERACTION WITH PROCESSOR STACK AT RUN TIME

	APART FROM EXPLICIT INTERACTIONS WITH THE STACK, CAUSED BY 'SP'
	(OR '%6' OR AN EQUIVALENT) APPEARING IN MACRO CALLS, CERTAIN
	OF THE STRUCTURES USE THE STACK IMPLICITLY FOR STORAGE AT
	RUN TIME.  THE STACK'S CONDITION AT THE BEGINNING OF THOSE STRUCTURES
	MUST BE PRESERVED AT EXIT, AND THE USER MAY ONLY BRANCH INTO
	OR OUT OF THEM VIA THE FACILITIES PROVIDED,
	UNLESS THE TRANSFER IS A "PANIC EXIT" TO CODE WHICH
	RE-INITIALIZES THE STACK.

	THE DESCRIPTION OF EACH GROUP OF MACROS HAS A SECTION
	WHICH SPECIFIES THEIR EFFECT ON THE STACK.


1.3.7	INTERACTION WITH '.RADIX'

	ALL THE MACROS MUST BE EXPANDED UNDER OCTAL RADIX ('.RADIX 8').


1.3.8	INTERACTION WITH '.CSECT', '.ASECT' AND '.PSECT'

	THESE DIRECTIVES MAY NOT APPEAR WITHIN ANY STRUCTURAL UNIT.
1.4	ERRORS
	------

	USER ERRORS ARE DETECTED AT ASSEMBLY TIME (SO FAR AS IS PRACTICABLE)
	EITHER BY THE MACROS OR BY THE ASSEMBLER.  NO CODE IS GENERATED
	TO PERFORM RUN-TIME ERROR CHECKING.

	THE MACROS REPORT ERRORS BY A
		.ERROR ;X
	DIRECTIVE, WHERE "X" IS A SINGLE LETTER WHICH INDICATES THE
	CAUSE OF THE ERROR.  THE DESCRIPTION OF EACH GROUP OF MACROS HAS
	A SECTION WHICH LISTS THE ERRORS THAT THEY MAY DETECT, AND THEIR
	MEANING.

	IT SHOULD BE NOTED THAT AN ERROR MESSAGE MAY APPEAR ON A
	STATEMENT OTHER THAN THE ONE IN ERROR, DUE TO THE
	NON-LOCAL NATURE OF SOME OF THE PROCESSING - THE MESSAGE MAY
	EVEN APPEAR BEFORE THE ERROR.  NOTE ALSO THAT THE ERROR MAY NOT
	BE IN A CALL TO ONE OF THESE MACROS - FOR EXAMPLE, THE INVALID
	PLACEMENT OF A LABEL.

	IN ORDER TO SAVE SPACE AT ASSEMBLY TIME, NO ERROR RECOVERY IS ATTEMPTED, SO 
	SO A SINGLE ERROR MAY GIVE RISE TO A NUMBER OF ERROR MESSAGES.
	ALL INTERNAL VARIABLES ARE RESET AT THE BEGINNING OF EACH
	PROCEDURE;  THIS WILL LOCALISE THE EFFECTS OF ANY
	ERROR TO THE PROCEDURE IN WHICH IT OCCURS.

	THE CODE GENERATED BY THESE MACROS IS UNDEFINED IF EITHER THEY
	OR THE ASSEMBLER REPORT ANY ERRORS.



1.5	SYSTEMS
	-------

	THESE MACROS HAVE BEEN TESTED WITH THE FOLLOWING MACRO-11 ASSEMBLERS.

	1. RT-11 V02.  REFERENCE RT-11 SYSTEM REFERENCE MANUAL,
		       DEC-11-ORUGA-C-D.
	2. DOS-11 V09. REFERENCE DOS/BATCH HANDBOOK, DEC-11-ODBHA-A-D.
	3. RSX-11D V06.REFERENCE RSX-11D MACRO ASSEMBLER, DEC-11-OXDMA-B-D.
	4. SAENET CYBER MACRO-11 CROSS-ASSEMBLER.
1.6	DISTRIBUTION MATERIALS
	----------------------

1.6.1	PDP-11 SYSTEMS

	THE FILES IN THE MACRO-11/SP KIT FOR PDP-11 SYSTEMS ARE AS FOLLOWS.

	MACSP.MAC  DEFINITIONS OF THE OPERATIONAL FORM OF THE MACROS,
		   TO BE INSERTED AT THE FRONT OF THE SYSTEM MACRO LIBRARY.
	MACSP.DOC  INTERNAL-DOCUMENTATION FORM OF THE MACRO DEFINITIONS.
	MACSP.MAN  THIS MANUAL.
	MACSP.TST  TEST SOURCE FILE.
	MACSP.LST  TEST LISTING.


1.6.2	CYBER SYSTEM

	THE FILES IN THE MACRO-11/SP KIT FOR THE CYBER CROSS-ASSEMBLER
	ARE AS FOLLOWS.

	MACSPMC = MACSP.MAC
	MACSFMC   DEFINITIONS OF THE ALTERNATIVE FAST MACROS, WHICH SAVE
		  ABOUT 30% OF ASSEMBLY TIME, AT THE EXPENSE OF
		  IGNORING THE 'LIST' OPTION OF THE 'MACSP' MACRO.
	MACSIWU = MACSP.DOC
	MACSUWU = MACSP.MAN
	MACSPTD = MACSP.TST
	MACSPTL = MACSP.LST
2	CONDITIONAL/ALTERNATIVE EXECUTION:  IF, IFB, IFC, ELSE, FI
	==========================================================

2.1	CONDITIONAL EXECUTION
	----------------------

	THE CODE TO BE EXECUTED IF A CONDITION IS TRUE IS PRECEDED BY AN
	'IF', 'IFB' OR 'IFC' STATEMENT WHICH SPECIFIES THE CONDITION, AND
	FOLLOWED BY A 'FI' STATEMENT.

	FOR EXAMPLE, TO INTERCHANGE THE CONTENTS OF R0 AND R1,
	CONSIDERED AS SIGNED NUMBERS, TO ENSURE THAT R0 <= R1, CODE:
		IF R0 SGT R1 THEN
		  MOV R0,-(SP)
		  MOV R1,R0
		  MOV (SP)+,R1
		FI
	THE CONDITION 'SGT' ("SIGNED GREATER-THAN") IS DEFINED IN 2.3.



2.2	ALTERNATIVE EXECUTION
	---------------------

	THE CODE TO BE EXECUTED IF A CONDITION IS TRUE IS PRECEDED BY AN
	'IF', 'IFB' OR 'IFC' STATEMENT WHICH SPECIFIES THE CONDITION, AND
	FOLLOWED BY AN 'ELSE' STATEMENT.  THE ALTERNATIVE CODE, TO BE
	EXECUTED IF THE CONDITION IS FALSE, IS WRITTEN BETWEEN THE 'ELSE'
	STATEMENT AND A 'FI' STATEMENT.

	FOR EXAMPLE, TO ADD TO R2 THE SMALLER OF THE CONTENTS OF R0 AND
	R1, CONSIDERED AS UNSIGNED INTEGERS, CODE:
		IF R0 ULE R1 THEN
		  ADD R0,R2
		ELSE
		  ADD R1,R2
		FI
	THE CONDITION 'ULE' ("UNSIGNED LESS-OR-EQUAL") IS DEFINED IN 2.3.
2.3	SIMPLE CONDITIONS
	-----------------

2.3.1	WORD COMPARISON

	SIGNED OR UNSIGNED WORD OPERANDS CAN BE COMPARED, AS FOLLOWS.

	EXPRESSION	OPERAND TYPE	    CONDITION TESTED

	IF A EQ B	ANY WORDS		A = B
	IF A NE B	ANY WORDS		A <> B

	IF A SLT B	SIGNED WORDS		A < B
	IF A SLE B	SIGNED WORDS		A <= B
	IF A SGE B	SIGNED WORDS		A >= B
	IF A SGT B	SIGNED WORDS		A > B

	IF A ULT B	UNSIGNED WORDS		A < B
	IF A ULE B	UNSIGNED WORDS		A <= B
	IF A UGE B	UNSIGNED WORDS		A >= B
	IF A UGT B	UNSIGNED WORDS		A > B

	THE TWO OPERANDS, SHOWN AS 'A' AND 'B' ABOVE, CAN BE TWO VARIABLES,
	OR ONE VARIABLE AND ONE CONSTANT;  THE CONSTANT CONVENTIONALLY
	APPEARS SECOND.  ANY OPERAND WHICH CAN APPEAR AS THE SOURCE OR
	DESTINATION OF A 'CMP' INSTRUCTION IS PERMITTED.

	NOTE.  IF THE CONSTANT '#0' APPEARS AS THE SECOND OPERAND, A 'TST'
	INSTRUCTION IS GENERATED INSTEAD OF A 'CMP', FOR EFFICIENCY.


2.3.2	BYTE COMPARISON

	SIGNED OR UNSIGNED BYTE OPERANDS CAN BE COMPARED IN ALL THE WAYS
	WHICH APPLY TO WORD OPERANDS, BY REPLACING THE 'IF' IN 2.3.1
	BY 'IFB'.
2.3.3	BIT TESTING

	THE STATE OF INDIVIDUAL BITS IN AN OPERAND CAN BE TESTED WITH
	THE OPERATORS 'IN' AND 'NI' ("NOT-IN"), AS FOLLOWS.

	EXPRESSION	OPERAND TYPE		CONDITION TESTED

	IF A IN B	 ANY WORDS	'A' AND 'B' HAVE AT LEAST ONE BIT
					SET TO 1 IN COMMON
	IF A NI B	 ANY WORDS	'A' AND 'B' HAVE NO BITS
					SET TO 1 IN COMMON

	IFB A IN B	 ANY BYTES	'A' AND 'B' HAVE AT LEAST ONE BIT
					SET TO 1 IN COMMON
	IFB A NI B	 ANY BYTES	'A' AND 'B' HAVE NO BITS
					SET TO 1 IN COMMON

	AGAIN, THE OPERANDS CAN BE TWO VARIABLES, OR ONE CONSTANT AND
	ONE VARIABLE;  THE CONSTANT CONVENTIONALLY APPEARS FIRST.
	ANY OPERAND WHICH CAN APPEAR AS THE SOURCE OR DESTINATION
	OF A 'BIT' (FOR WORDS) OR 'BITB' (FOR BYTES) INSTRUCTION IS
	PERMITTED.

	FOR EXAMPLE, TO CHANGE THE STATE OF BIT 3 OF R0, CODE:
		BIT3 = 10
		  ...
		IF #BIT3 IN R0 THEN
		  BIC #BIT3,R0
		ELSE
		  BIS #BIT3,R0
		FI
2.3.4	CONDITION CODE TESTING

	THE STATEMENTS DESCRIBED ABOVE ALL PERFORM THE TEST BY
	GENERATING A 'CMP', 'CMPB', 'TST', 'TSTB', 'BIT' OR 'BITB' INSTRUCTION,
	FOLLOWED BY THE APPROPRIATE CONDITIONAL BRANCH.  IT IS ALSO
	POSSIBLE TO TEST THE CONDITION CODE SETTING FROM THE PREVIOUS
	USER-WRITTEN INSTRUCTION WITH THE 'IFC' STATEMENT, AS FOLLOWS.

	EXPRESSION	CONDITION CODE SETTING TESTED

	IFC NE			Z = 0
	IFC EQ			Z = 1

	IFC PL			N = 0
	IFC MI			N = 1

	IFC CC			C = 0
	IFC CS			C = 1

	IFC VC			V = 0
	IFC VS			V = 1

	IFC SLT			N XOR V = 1
	IFC SLE			Z OR (N XOR V) = 1
	IFC SGE			N XOR V = 0
	IFC SGT			Z OR (N XOR V) = 0

	FOR EXAMPLE, TO PLACE THE ABSOLUTE VALUE OF THE SIGNED
	INTEGER IN R0 INTO R1, CODE:
		MOV R0,R1
		IFC MI THEN
		  NEG R1
		FI
2.4	COMPOUND CONDITIONS
	-------------------

	THE SIMPLE CONDITIONS DESCRIBED IN 2.3 CAN BE
	COMPOUNDED, WITH LOGICAL "AND" AND/OR "OR" OPERATORS.
	IN PLACE OF THE SINGLE 'IF', 'IFB' OR 'IFC' STATEMENT SHOWN ABOVE,
	TWO OR MORE SUCH STATEMENTS ARE WRITTEN ON ADJACENT LINES, WITH
	'AND' OR 'OR' REPLACING THE 'THEN' ON ALL BUT THE LAST.

	FOR EXAMPLE, TO INCREMENT R2 IF R0 IS ZERO OR THE LOWER BYTE OF
	R1 IS NON-ZERO, CODE:
		IF R0 EQ #0 OR
		IFB R1 NE #0 THEN
		  INC R2
		FI
	TO ZERO R0 IF THE TOP THREE WORDS ON THE PROCESSOR STACK ARE
	ZERO, AND TO NEGATE IT OTHERWISE, CODE:
		IF (SP) EQ #0 AND
		IF 2(SP) EQ #0 AND
		IF 4(SP) EQ #0 THEN
		  CLR R0
		ELSE
		  NEG R0
		FI

	'AND' AND 'OR' OPERATORS CAN BE MIXED IN ONE COMPOUND CONDITION.
	THE PRECEDENCE IS DETERMINED BY THE RULE THAT EACH SIMPLE
	CONDITION IS COMPOUNDED WITH THE COMBINATION OF ALL THE
	FOLLOWING CONDITIONS.  FOR EXAMPLE:
		IF R0 EQ #0 OR
		IF R1 EQ #0 AND
		IF R2 EQ #0
	IS EVALUATED AS:
		(IF R0 EQ #0) OR ((IF R1 EQ #0) AND (IF R2 EQ #0))
	NOT AS:
		((IF R0 EQ #0) OR (IF R1 EQ #0)) AND (IF R2 EQ #0)

	IF THE EVALUATION OF A CONDITION HAS SIDE-EFFECTS
	(E.G. IF ONE OR BOTH OF THE OPERANDS IS ACCESSED BY
	AUTO-INCREMENT OR AUTO-DECREMENT ADDRESSING), IT MUST NOT
	APPEAR OTHER THAN FIRST IN A COMPOUND CONDITION.  THE REASON FOR
	THIS IS THAT THE SUBSEQUENT COMPONENTS OF A COMPOUND CONDITION
	ARE NOT EXECUTED WHEN A PREVIOUS COMPONENT DETERMINES THE TRUTH
	OF THE WHOLE CONDITION.

	IF 'IFC' CONDITIONS ARE COMPOUNDED WITH 'IF' OR 'IFB' CONDITIONS, THE
	'IFC' CONDITIONS MUST APPEAR FIRST, SINCE AN 'IF' OR 'IFB' STATEMENT
	WILL CHANGE THE CONDITION CODE SETTING, WHILE AN 'IFC' STATEMENT
	WILL NOT.
2.5	RUN-TIME INTERACTIONS
	---------------------

2.5.1	CONDITION CODES

	EXECUTION OF AN 'IF' OR 'IFB' STATEMENT WILL CHANGE THE CONDITION
	CODE SETTING, WHILE EXECUTION OF AN 'IFC', 'ELSE' OR 'FI'
	STATEMENT WILL NOT.


2.5.2	PROCESSOR STACK

	THESE STATEMENTS DO NOT IMPLICITLY ACCESS THE STACK.



2.6	ERRORS
	------

	ERROR N	REPORTED BY 'ELSE' OR 'FI', MEANS THAT IT DOES NOT MATCH AN
		'IF', 'IFB', 'IFC' OR ('FI' ONLY) 'ELSE' STATEMENT.

	ERROR U	REPORTED BY 'IF', 'IFB' OR 'IFC', MEANS THAT THE CONDITION
		KEYWORD ('EQ', 'SLT' ETC) WAS NOT RECOGNISED, OR THAT
		SOMETHING OTHER THAN 'THEN', 'OR' OR 'AND' APPEARED AS
		THE LAST PARAMETER.
3	REPETITIVE EXECUTION:  LOOP, LOOPB, EXLOOP, REPEAT
	==================================================

3.1	UNCONDITIONAL LOOP
	------------------

	A SECTION OF CODE CAN BE EXECUTED FOREVER BY PRECEDING IT WITH
	A 'LOOP' STATEMENT, AND FOLLOWING IT WITH A 'REPEAT' STATEMENT.

	FOR EXAMPLE, TO PRODUCE THE IDLE LOOP OF AN INTERRUPT-
	DRIVEN PROGRAM (ABOUT THE ONLY USE FOR AN UNCONDITIONAL LOOP),
	CODE:
		LOOP
		  WAIT
		  INC COUNT  ;(ONE MORE INTERRUPT)
		REPEAT
3.2	COUNTED LOOP
	------------

3.2.1	WORD COUNT

	A SECTION OF CODE CAN BE EXECUTED A PREDETERMINED NUMBER OF
	TIMES BY PRECEDING IT WITH A 'LOOP' STATEMENT WITH A PARAMETER
	SPECIFYING THE LOOP COUNT, AND FOLLOWING IT WITH A 'REPEAT'
	STATEMENT.

	FOR EXAMPLE, TO SET EVERY BIT IN A 10-WORD AREA, CODE:
	AREA:	.BLKW 10.
		  ...
		MOV #AREA,R0
		LOOP #10.
		  MOV #177777,(R0)+
		REPEAT

	THE LOOP COUNT CAN BE SPECIFIED BY ANY OPERAND WHICH CAN
	APPEAR AS THE SOURCE IN A 'MOV' INSTRUCTION, INCLUDING THAT
	NOMINATING ANY VARIABLE LOCATION.  THE LOCATION IS NOT
	ALTERED.

	THE LOOP COUNT IS TREATED AS AN UNSIGNED NUMBER;  THAT IS,
	'#100000' SPECIFIES 32768 PASSES ROUND THE LOOP, AND '#177777'
	SPECIFIES 65535 PASSES (THE MAXIMUM COUNT POSSIBLE).  A COUNT
	OF ZERO CAUSES THE LOOP TO BE SKIPPED.

	THIS FORM OF LOOP USES DATA ON TOP OF THE PROCESSOR STACK TO
	MAINTAIN THE LOOP COUNT, AND CLEARS IT OFF THE STACK WHEN
	EXITING THE LOOP.  LOOPS CAN BE NESTED.

	BECAUSE LOOPS ARE COUNTED ON TOP OF THE STACK, AN OPTIMIZATION
	IS MADE WHEN THE COUNT CAN BE PLACED THERE BY THE USER, WHEN THE
	COUNT HAS TO BE COMPUTED IN A SCRATCH LOCATION.  FOR EXAMPLE, IF
	THE LOOP COUNT IS THE SUM OF R0 AND R1, CODE:
		MOV R0,-(SP)
		ADD R1,(SP)
		LOOP (SP)+
		  ...
		REPEAT
	THE PARAMETER MUST BE '(SP)+' IN ORDER TO EFFECT THE
	OPTIMIZATION - '(%6)+' WILL NOT DO.  THE LOOP COUNT DATA IS CLEARED
	OFF THE STACK AT THE TERMINATION OF THE LOOP.


3.2.2	BYTE COUNT

	A VARIANT OF THE COUNTED LOOP IS AVAILABLE FOR USE WHEN THE LOOP
	COUNT IS A VARIABLE WHICH IS STORED IN A BYTE.  IN THIS CASE,
	'LOOPB' REPLACES 'LOOP' IN 3.2.1, WITH A PARAMETER NOMINATING THE
	BYTE WHICH CONTAINS THE LOOP COUNT.  UNLIKE 'LOOP', 'LOOPB' MUST
	HAVE A PARAMETER.  'LOOPB #<EXPRESSION>' GENERATES LESS
	EFFICIENT CODE THAN 'LOOP #<EXPRESSION>' WHILE HAVING THE
	SAME EFFECT;  IT THEREFORE SHOULD NOT BE USED.

	THE ABOVE OPTIMIZATION IS ALSO MADE WITH 'LOOPB (SP)+'.
3.3	LOOP EXIT
	---------

	AN UNCONDITIONAL LOOP CAN BE MADE CONDITIONAL, OR A COUNTED LOOP
	CAN BE MADE TO TERMINATE PREMATURELY, BY THE USE OF ONE OR MORE
	'EXLOOP' STATEMENTS.  AN 'EXLOOP' STATEMENT CAN BE PLACED WITHIN A
	LOOP, BUT NOT OUTSIDE.  IT CAUSES EXIT FROM THE IMMEDIATELY CONTAINING
	LOOP TO THE STATEMENT FOLLOWING THE 'REPEAT'.  IF THE LOOP HAS A COUNT,
	THE STACK IS CLEANED UP;  THEREFORE THE STACK MUST BE RESTORED
	TO THE STATE IT WAS IN IMMEDIATELY AFTER THE 'LOOP' STATEMENT,
	BEFORE EXECUTING AN 'EXLOOP' WITHIN A COUNTED LOOP.

	THERE IS NO WAY TO EXIT FROM MORE THAN ONE LEVEL OF LOOP WITH
	A SINGLE 'EXLOOP'.

	THE 'EXLOOP' STATEMENT(S) CAN BE NESTED WITHIN 'IF' ... 'FI' AND/OR
	'CASE' ... 'CASEND' STRUCTURES TO ANY DEPTH, BUT CANNOT APPEAR
	WITHIN A 'BEGIN' ... 'END' THAT IS NESTED WITHIN THE
	'LOOP' ... 'REPEAT'.


3.3.1	UNCONDITIONAL EXIT

	THERE IS NO POINT IN HAVING A COMPLETELY UNCONDITIONAL LOOP
	EXIT, BUT IF IT IS REQUIRED CONDITIONALLY TO PERFORM SOME
	PROCESSING WITHIN THE LOOP, AND THEN EXIT, AN UNCONDITIONAL
	'EXLOOP' IS APPROPRIATE.

	FOR EXAMPLE, IT IS REQUIRED TO SUM THE FIRST FIVE WORDS OF A
	LIST, WHICH IS TERMINATED BY A ZERO WORD.  THE FOLLOWING CODE
	WILL DO THAT, AND PRINT A COMMENT IF THERE ARE LESS THAN FIVE
	ITEMS IN THE LIST.  A MACRO 'PRINT' IS ASSUMED TO BE AVAILABLE
	TO PRINT THE MESSAGE IN ITS ARGUMENT.
	LIST:	...
		...
		CLR R0  ;ACCUMULATES SUM
		MOV #LIST,R1  ;LIST POINTER
		LOOP #5
		  IF (R1) EQ #0 THEN  ;LIST FINISHED EARLY
		    PRINT <"SHORT LIST">
		    EXLOOP
		  FI
		  ADD (R1)+,R0
		REPEAT
3.3.2	CONDITIONAL EXIT

	IF ALL THAT IS REQUIRED IS TO EXIT FROM THE LOOP UPON A GIVEN
	CONDITION, THE CONDITION CAN BE INCORPORATED INTO THE 'EXLOOP'
	STATEMENT AS A QUALIFIER.

	FOR EXAMPLE, TO SUM ALL MEMBERS OF THE LIST IN THE ABOVE
	EXAMPLE, CODE:
		CLR R0
		MOV #LIST,R1
		LOOP
		  EXLOOP IF (R1) EQ #0
		  ADD (R1)+,R0
		REPEAT

	THE QUALIFIER TO BE ADDED TO THE 'EXLOOP' STATEMENT
	IS ANY OF THE FORMS OF THE 'IF', 'IFB'
	OR 'IFC' STATEMENTS DESCRIBED IN SECTION 2, WITH THE 'THEN'
	OMITTED.

	THE TERMINATING CONDITION CAN BE COMPOUND:  THE FIRST
	SUB-CONDITION IS ADDED TO THE 'EXLOOP', TERMINATING IN 'AND'
	OR 'OR' AS APPROPRIATE, THEN SUBSEQUENT 'IF', 'IFB' OR 'IFC'
	STATEMENTS APPEAR ON ADJACENT LINES, LINKED BY 'AND' OR 'OR',
	UP TO THE LAST ONE, WHICH HAS ITS 'THEN' OMITTED.

	FOR EXAMPLE, TO MODIFY THE LAST EXAMPLE SO THAT THE LIST
	TERMINATOR IS THREE CONSECUTIVE WORDS OF ZERO, CODE:
		CLR R0
		MOV #LIST,R1
		LOOP
		  EXLOOP IF (R1) EQ #0 AND
			 IF 2(R1) EQ #0 AND
			 IF 4(R1) EQ #0
		  ADD (R1)+,R0
		REPEAT
3.4	RUN-TIME INTERACTIONS
	---------------------

3.4.1	CONDITION CODES

	THE 'LOOP' AND 'REPEAT' OF A NON-COUNTED LOOP DO NOT CHANGE
	CONDITION CODES, WHILE THOSE OF A COUNTED LOOP DO.
	AN UNCONDITIONAL 'EXLOOP' DOES NOT CHANGE CONDITION CODES.
	A CONDITIONAL 'EXLOOP' HAS THE SAME EFFECT ON CONDITION CODES
	AS THE 'IF...'  STATEMENTS WHICH IT CONTAINS.


3.4.2	PROCESSOR STACK

	DATA IS PUSHED ONTO THE STACK AT THE START OF A COUNTED LOOP
	AND REMAINS THERE UNTIL THE LOOP IS FINISHED, EITHER BY THE
	COUNT EXPIRING OR BY EXECUTION OF AN 'EXLOOP'.  NON-COUNTED LOOPS
	AND 'EXLOOP' STATEMENTS DO NOT IMPLICITLY ACCESS THE STACK.



3.5	ERRORS
	------

	ERROR N REPORTED BY 'EXLOOP', MEANS EITHER THAT IT IS NOT
		CONTAINED WITHIN 'LOOP' ... 'REPEAT', OR THAT IT IS
		CONTAINED WITHIN 'BEGIN' ... 'END' INSIDE THE
		'LOOP' ... 'REPEAT'.

	ERROR N REPORTED BY 'REPEAT', MEANS THAT IT DOES NOT MATCH A 'LOOP'
		OR 'LOOPB'.

	ERROR U REPORTED BY 'EXLOOP IF...', MEANS THAT THE CONDITION
		KEYWORD ('EQ', 'SLT' ETC) WAS NOT RECOGNISED, OR THAT
		SOMETHING OTHER THAN BLANK, 'AND' OR 'OR' APPEARED AS
		THE LAST PARAMETER.

	ERROR Z REPORTED BY 'LOOP #<EXPRESSION>', MEANS THAT THE
		EXPRESSION IS ZERO.
4	PROCEDURE AND BLOCK DEFINITION AND INVOCATION:  PROC, BEGIN, END, CALL
	======================================================================

4.1	PROCEDURE DEFINITION AND INVOCATION
	-----------------------------------

	A PROCEDURE IS A SECTION OF CODE, PRECEDED BY A
	'PROC' STATEMENT WHICH CONTAINS ITS NAME, AND FOLLOWED BY AN 'END'
	STATEMENT.  A PROCEDURE USUALLY HAS A SPECIFIC PURPOSE, I.E. IS
	A "MODULE" OF CODE FOR THE PARTICULAR APPLICATION.

	FOR EXAMPLE, A PROCEDURE TO INTERCHANGE CYCLICALLY THE
	CONTENTS OF R0, R1 AND R2 MIGHT APPEAR AS:
		PROC INTERC
		  MOV R2,-(SP)
		  MOV R1,R2
		  MOV R0,R1
		  MOV (SP)+,R0
		END

	NOTE THAT THE PROCEDURE NAME MUST APPEAR AS THE FIRST PARAMETER
	TO THE 'PROC' MACRO, NOT IN THE STATEMENT'S LABEL FIELD.
	FOLLOWING SECTIONS DESCRIBE THE USAGE OF THE SECOND, THIRD
	AND FOURTH PARAMETERS OF THE 'PROC' STATEMENT.

	THE 'PROC' STATEMENT GENERATES A LABEL OF THE SAME NAME AS THE
	PROCEDURE;  HENCE THE PROCEDURE NAMES AND ANY EXPLICIT LABELS IN THE
	PROGRAM MUST ALL BE UNIQUE WITHIN THE FIRST SIX CHARACTERS.

	A PROCEDURE MUST NOT BE EXECUTED THROUGH, BUT MUST BE
	INVOKED FROM ELSEWHERE BY A 'CALL' STATEMENT, SUCH AS:
		CALL INTERC
	THE 'CALL' STATEMENT DOES A SUBROUTINE CALL TO THE 'PROC'.  THE CODE
	OF THE PROCEDURE IS THEN EXECUTED UP TO THE 'END', WHICH CAUSES
	A RETURN TO THE STATEMENT AFTER THE CALL.

	A PROCEDURE CAN NOT BE CONTAINED IN ANY OF THE
	STRUCTURES DESCRIBED IN THIS DOCUMENT, BUT CAN OF COURSE
	CONTAIN ANY OTHER STRUCTURE.
4.2	RECOMMENDED CONVENTIONS
	-----------------------

	THE 'CALL', 'PROC' AND 'END' STATEMENTS TAKE CARE OF THE RETURN LINK
	FROM THE SUBROUTINE.  HOWEVER THE USER MUST STILL, IN GENERAL,
	PASS PARAMETERS TO, AND RECEIVE RETURN VALUES FROM, THE
	PROCEDURE.  THE ONLY TECHNIQUES WHICH ARE SUPPORTED BY THESE
	STATEMENTS ARE FOR THE INPUT OR OUTPUT DATA TO BE IN:
	1. REGISTERS, OR
	2. BLOCKS OF MEMORY POINTED TO BY REGISTERS, OR
	3. COMMON BLOCKS OF MEMORY.
	THAT IS, THE COMMON PDP-11 TECHNIQUES OF PUTTING DATA ON THE
	PROCESSOR STACK TO BE ACCESSED BY OFFSET FROM SP, OR IN LINE
	AFTER THE CALL INSTRUCTION, OR IN THE CONDITION CODES,
	ARE NOT SUPPORTED.

	A CONVENTION WHICH IS SUPPORTED (AND STRONGLY RECOMMENDED) IS
	THAT THE SUBROUTINE SHOULD PRESERVE ALL GENERAL PURPOSE
	REGISTERS, EXCEPT THOSE IN WHICH VALUES ARE RETURNED.

	PDP-11 SUBROUTINE LINKAGE INSTRUCTIONS SUPPORT RE-ENTRANCY AND
	RECURSION;  ALL OF THE FACILITIES DESCRIBED IN SECTION 4 CAN
	BE USED BY RE-ENTRANT AND/OR RECURSIVE ROUTINES.
4.3	REGISTER SAVING
	---------------

	IF IT IS DESIRED TO SAVE GENERAL PURPOSE REGISTERS TO USE AS
	VARIABLE SPACE DURING EXECUTION OF THE PROCEDURE, AN EXTRA
	PARAMETER CAN BE ADDED TO THE 'PROC' STATEMENT, GIVING THE LIST
	OF REGISTERS TO BE SAVED.

	FOR EXAMPLE, TO SAVE R4 AND R2, CODE:
		PROC SUBR <R4,R2>
		  ...
		END
	WHEN SUBR IS CALLED, R4 AND R2 WILL BE SAVED ON THE PROCESSOR
	STACK BEFORE EXECUTION OF SUBR'S CODE, WHICH PRESUMABLY USES
	R4 AND R2.  WHEN EXECUTION FINALLY ARRIVES AT THE 'END', R4 AND
	R2 WILL BE RESTORED TO THEIR SAVED VALUES BEFORE THE RETURN IS 
	MADE TO THE CALLING CODE.

	ONLY REGISTERS IN THE RANGE R0 TO R5 CAN BE SAVED BY THIS MEANS;
	ANY REGISTER EXPRESSION IN THE RANGE 0 TO 5 CAN
	APPEAR AS AN ITEM IN THE LIST.



4.4	STORAGE ACQUISITION
	-------------------

	IT CAN OCCUR THAT MORE VARIABLE SPACE THAN IS AVAILABLE IN THE
	REGISTERS IS REQUIRED, OR THAT, FOR EXAMPLE, A BUFFER IN WHICH
	TO FORMAT A LINE OF OUTPUT IS NEEDED.  TO CATER FOR THIS CASE,
	A FIXED-SIZE BLOCK OF STORAGE CAN BE ACQUIRED (FROM THE STACK)
	ON PROCEDURE ENTRY AND RETURNED ON EXIT, BY ADDING A THIRD
	PARAMETER TO THE 'PROC' STATEMENT, VIZ AN EXPRESSION WHICH
	SPECIFIES THE BLOCK SIZE IN BYTES.  AT LEAST ONE REGISTER
	MUST ALSO BE SAVED IN THE 'PROC';  THE LAST REGISTER IN THE SAVE
	LIST IS LEFT POINTING TO THE FIRST (LOWEST-ADDRESS) BYTE IN
	THE BLOCK, WHICH WILL BE AN EVEN-ADDRESS BYTE.  THE POINTER
	REGISTER CAN BE USED IN ANY WAY, AND NEED NOT BE LEFT UNALTERED
	AT PROCEDURE EXIT.  THE USER MUST BE CAREFUL NOT TO CHANGE WORDS
	OUTSIDE THE SPECIFIED NUMBER OF BYTES.  THE SIZE OF BLOCK WHICH
	CAN BE SPECIFIED MUST BE IN THE RANGE 1 TO 7776 (4094(10))
	BYTES;  IT IS ROUNDED UP IF IT IS ODD.  NOTE THAT PROCESSOR
	STACK OVERFLOW WILL OCCUR IF MORE STORAGE THAN AVAILABLE IS
	ACQUIRED BY A NUMBER OF NESTED ROUTINES.

	FOR EXAMPLE, A PROCEDURE WHICH FORMATS LINES OF PRINTER OUTPUT
	COULD ACQUIRE A BLOCK OF 100 BYTES FOR ITS BUFFER, PROVIDED IT
	DISPOSES OF THE CONTENTS BEFORE EXIT, AS FOLLOWS:
		PROC FORMAT <R0,R1,R5>,<100.>
		  ...
		END
	AFTER EXECUTION OF THIS 'PROC' STATEMENT, R5 POINTS TO THE
	START OF THE BUFFER.
4.5	CRITICAL PROCEDURES
	-------------------

	IN A PROGRAM IN WHICH ROUTINES AT DIFFERENT INTERRUPT LEVELS
	ACCESS A COMMON DATA STRUCTURE, FOR EXAMPLE A CHAINED LIST
	WHICH REPRESENTS A QUEUE, IT IS USUALLY NECESSARY TO ENSURE
	THAT THE COMMON ROUTINE WHICH PUTS ELEMENTS ON THE QUEUE, SAY,
	IS NOT INTERRUPTED AT A CRITICAL STAGE, TO PREVENT THE QUEUE
	BEING CORRUPTED.  THIS MAY BE ACHIEVED FOR THE DURATION OF A
	PROCEDURE BY ADDING THE FOURTH PARAMETER 'CRITICAL' TO THE 'PROC'
	STATEMENT.  THIS SAVES THE CURRENT PROCESSOR STATUS REGISTER
	CONTENTS ON THE STACK, THEN SETS THE PROCESSOR PRIORITY TO 7,
	WHICH INHIBITS INTERRUPTS UNTIL THE 'END' STATEMENT, WHEN THE
	PRIORITY WILL BE RESTORED TO THE VALUE IT HAD ON ENTRY.
	THIS OPTION MUST NOT BE USED IN MAPPED SYSTEMS, UNLESS THE
	PROGRAM HAS ACCESS TO THE STATUS REGISTER AT ITS STANDARD
	ADDRESS (177776).

	FOR EXAMPLE:
		PROC ENQUE <R0>,,CRITICAL
		  ...
		END

	NOTE THAT PROCEDURES WHICH USE THIS OPTION SHOULD BE AS SHORT
	AS POSSIBLE, SO AS NOT TO DELAY UNNECESSARILY THE RESPONSE TO
	HIGH-PRIORITY INTERRUPTS - A BEGIN BLOCK CONTAINING
	THE CRITICAL PART OF THE ROUTINE WILL OFTEN BE MORE APPROPRIATE
	(SEE NEXT SECTION).



4.6	BEGIN BLOCKS
	------------

	IT CAN HAPPEN THAT A SHORT SECTION OF CODE IN A PROGRAM NEEDS
	REGISTERS SAVED, TEMPORARY USE OF A BLOCK OF STORAGE, OR
	PROTECTION FROM INTERRUPTS.  THESE CAN BE ACHIEVED WITHOUT
	INCURRING THE OVERHEAD OF A SUBROUTINE CALL AND RETURN, BY
	PRECEDING THE SECTION OF CODE WITH A 'BEGIN' STATEMENT , AND FOLLOWING
	IT WITH AN 'END' STATEMENT.  THE 1ST, 2ND AND 3RD PARAMETERS
	OF A 'BEGIN' STATEMENT HAVE THE SAME MEANING AS THE 2ND, 3RD AND
	4TH PARAMETERS OF A 'PROC' STATEMENT.  EXECUTION FLOWS
	THROUGH A BEGIN BLOCK, WITH THE ACTIONS OF 4.3, 4.4 AND 4.5
	PERFORMED AS SPECIFIED AT 'BEGIN' AND 'END';  NO RETURN
	IS TAKEN AT THE 'END'.

	FOR EXAMPLE, TO SAVE R0 AND R1 TEMPORARILY, CODE:
		BEGIN <R0,R1>
		  ...
		END
4.7	RUN-TIME INTERACTIONS
	---------------------

4.7.1	CONDITION CODES

	'CALL', 'PROC', 'BEGIN' AND 'END' ALL CHANGE CONDITION CODES.


4.7.2	PROCESSOR STACK

	'CALL', 'PROC', 'BEGIN' AND 'END' ALL CHANGE THE STACK,
	BUT WITH A ZERO NET EFFECT.



4.8	ERRORS
	------

	ERROR N REPORTED BY 'PROC', MEANS THAT THE PROCEDURE IS
		NESTED WITHIN ANOTHER STRUCTURE.

	ERROR N REPORTED BY 'END', MEANS THAT IT DOES NOT MATCH A 'PROC'
		OR 'BEGIN'.

	ERROR P REPORTED BY 'PROC' OR 'BEGIN', MEANS THAT A BLOCK OF STORAGE
		IS TO BE ACQUIRED, WITHOUT A REGISTER SPECIFIED TO POINT TO IT.

	ERROR T REPORTED BY 'PROC' OR 'BEGIN', MEANS THAT SOMETHING OTHER THAN A
		REGISTER EXPRESSION IN THE RANGE 0 TO 5 APPEARS IN THE
		SAVE LIST.

	ERROR U REPORTED BY 'PROC' OR 'BEGIN', MEANS THAT SOMETHING OTHER THAN
		'CRITICAL' APPEARS AS THE LAST PARAMETER.

	ERROR V REPORTED BY 'PROC' OR 'BEGIN', MEANS THAT THE STORAGE
		BLOCK SIZE IS NOT IN THE RANGE 1 TO 7776.
5	MULTIPLE-ALTERNATIVE EXECUTION: CASE, VALUE, CASEND
	===================================================

5.1	BASIC FACILITY
	--------------

5.1.1	INTRODUCTION

	THE ALTERNATIVE-EXECUTION STRUCTURE ('IF' ... 'ELSE' ... 'FI')
	DESCRIBED IN SECTION 2.2 ALLOWS EXECUTION OF TWO ALTERNATIVE
	SECTIONS OF CODE, DEPENDING ON THE TWO POSSIBLE VALUES
	OF A LOGICAL CONDITION.  THE STRUCTURE DESCRIBED IN THIS SECTION
	ALLOWS EXECUTION OF AN ARBITRARY NUMBER OF SECTIONS OF CODE,
	DEPENDING ON THE VALUE OF AN UNSIGNED-INTEGER VARIABLE.

	THE STRUCTURE COMMENCES WITH A 'CASE' STATEMENT WHICH SPECIFIES
	THE "CONTROL VARIABLE", AND THE LARGEST VALUE OF IT TO BE SELECTED.
	THE STRUCTURE IS TERMINATED BY A 'CASEND' STATEMENT.  BETWEEN
	THESE TWO STATEMENTS THE VARIOUS SECTIONS OF CODE ARE HEADED
	BY 'VALUE' STATEMENTS, EACH OF WHICH SPECIFIES THE VALUE(S)
	OF THE CONTROL VARIABLE WHICH CAUSE EXECUTION OF THAT SECTION
	OF CODE.

	FOR EXAMPLE, TO PRINT THE VALUE MODULO 3 OF THE VARIABLE 'DIGIT',
	WHICH CAN HAVE VALUES IN THE RANGE 0 TO 9, CODE:
		MOV DIGIT,R0
		CASE R0,9.
		VALUE <0,3,6,9.>
		  PRINT <"DIGIT MOD 3 = 0">
		VALUE <1,4,7>
		  PRINT <"DIGIT MOD 3 = 1">
		VALUE <2,5,8.>
		  PRINT <"DIGIT MOD 3 = 2">
		CASEND
5.1.2	'CASE' STATEMENT

	THE FIRST PARAMETER OF THE 'CASE' STATEMENT SPECIFIES THE REGISTER
	WHICH CONTAINS THE CONTROL VARIABLE.  IN THIS EXAMPLE,
	R0 WAS USED, BUT ANY OF R0 TO R5 IS VALID.

	IT IS VERY IMPORTANT TO NOTE THAT THE CONTENTS OF THE REGISTER
	ARE DESTROYED BY EXECUTION OF THE 'CASE' STATEMENT;  THE VALUE
	LOADED INTO IT BY THE PROGRAM IS NOT AVAILABLE TO CODE
	WITHIN OR AFTER THE 'CASE' ... 'CASEND' STRUCTURE.

	THE SPECIFIED REGISTER IS CONSIDERED TO CONTAIN AN UNSIGNED
	WORD VALUE, WHICH OF COURSE CANNOT BE NEGATIVE.  IF THE
	VARIABLE HAS NEGATIVE VALUES WHICH ARE TO BE SELECTED, THEN AN
	APPROPRIATE CONSTANT MUST BE ADDED TO THE REGISTER BEFORE
	EXECUTING THE 'CASE' STATEMENT, AND THE VALUES IN THE 'VALUE'
	STATEMENTS MUST BE BIASSED ACCORDINGLY.  (IF, AFTER ANY NECESSARY
	CONSTANT HAS BEEN ADDED, THERE ARE NEGATIVE VALUES WHICH ARE
	TO BE IGNORED, THIS WILL OCCUR AUTOMATICALLY SINCE THEY WILL BE
	LARGER THAN THE SPECIFIED LARGEST VALUE WHEN CONSIDERED AS UNSIGNED
	NUMBERS;  SEE SECTION 5.2.2)

	CARE MUST BE TAKEN WHEN LOADING AN UNSIGNED BYTE VARIABLE INTO
	THE REGISTER PRIOR TO EXECUTION OF THE 'CASE' STATEMENT;  USING
		MOVB BYTE,R0
	WILL CAUSE SIGN-EXTENSION (SEE PDP-11 PROCESSOR HANDBOOK),
	SO THAT VALUES GREATER THAN 177(8) WILL APPEAR TO BE NEGATIVE.
	THE CORRECT CODE FOR THIS CASE IS
		CLR R0
		BISB BYTE,R0

	THE SECOND PARAMETER OF THE 'CASE' STATEMENT IS AN ASSEMBLER
	EXPRESSION WHICH SPECIFIES THE LARGEST VALID VALUE OF THE CONTROL
	VARIABLE;  THIS IS THE LARGEST VALUE WHICH MAY APPEAR IN A
	'VALUE' STATEMENT CORRESPONDING TO THIS 'CASE' STATEMENT.
	THE VALID RANGE FOR THIS EXPRESSION IS 1 TO 7777 (4095(10)).
	THE SMALLEST VALID VALUE OF THE CONTROL VARIABLE IS ALWAYS 0.

	SECTION 5.3 DESCRIBES THE 'PACKED' OPTION OF THE 'CASE'
	STATEMENT.
5.1.3	'VALUE' STATEMENT

	THE BASIC FORM OF THE 'VALUE' STATEMENT HAS A SINGLE PARAMETER
	WHICH IS A LIST OF ONE OR MORE ASSEMBLER EXPRESSIONS, IN THE
	RANGE 0 TO THE MAXIMUM SPECIFIED IN THE SECOND PARAMETER OF THE
	CORRESPONDING 'CASE' STATEMENT.  THE CODE GENERATED BY THE 'CASE'
	STATEMENT TRANSFERS CONTROL TO THE CODE FOLLOWING THAT 'VALUE'
	STATEMENT WHICH CONTAINS IN ITS LIST THE CURRENT VALUE OF
	THE CONTROL VARIABLE.  THAT CODE THEN EXECUTES UNTIL THE
	NEXT 'VALUE' STATEMENT (OR IF NONE THE TERMINATING 'CASEND' STATEMENT)
	IS ENCOUNTERED, WHEN CONTROL TRANSFERS TO THE CODE FOLLOWING THE
	'CASEND' STATEMENT.

	IF A PARTICULAR VALUE APPEARS IN MORE THAN ONE 'VALUE' STATEMENT,
	EITHER EXPLICITLY OR IMPLICITLY BY APPEARANCE IN A VALUE RANGE
	(SEE SECTION 5.2.1), ITS LAST APPEARANCE SUPERSEDES ANY PREVIOUS
	ONE.

	SECTION 5.2 DESCRIBES THE MORE EXOTIC FEATURES OF THE 'VALUE'
	STATEMENT.


5.1.4	'CASEND' STATEMENT

	THE 'CASEND' STATEMENT TERMINATES THE STRUCTURE.  IT HAS NO
	PARAMETERS.

	THERE IS NO SIZE LIMIT ON THE 'CASE' ... 'CASEND' STRUCTURE,
	EXCEPT AS NOTED UNDER THE 'PACKED' OPTION IN SECTION 5.3
5.2	ADVANCED FEATURES
	-----------------

5.2.1	VALUE RANGES

	IF A 'VALUE' STATEMENT IS REQUIRED TO SELECT A CONTIGUOUS
	RANGE OF VALUES, THE RANGE MAY BE SPECIFIED BY WRITING IN THE
	VALUE LIST THE LOWEST VALUE OF THE RANGE, FOLLOWED BY THE
	NEGATIVE OF THE HIGHEST VALUE.

	FOR EXAMPLE, TO SPLIT ON THE TYPE OF ASCII CHARACTER IN THE
	BYTE 'CHAR', CODE:
		MOVB CHAR,R4
		BIC #177600,R4  ;REMOVE PARITY AND SIGN EXTENSION
		CASE R4,177
		VALUE <'A,-'Z, 141,-172>
		  ;PROCESS UPPER AND LOWER CASE ALPHABETICS
		VALUE <'0,-'9>
		  ;PROCESS NUMERICS
		VALUE <0,-37>
		  ;PROCESS CONTROL CHARACTERS
		VALUE <177>
		  ;PROCESS RUBOUT
		VALUE <40>
		  ;PROCESS SPACE
		VALUE <'!,-'/, ':,-'@, '[,-140, 173,-176>
		  ;PROCESS GRAPHIC CHARACTERS
		CASEND


5.2.2	OUT-OF-RANGE VALUES

	IF THE 'CASE' STATEMENT IS EXECUTED WITH THE CONTROL VARIABLE
	OUT OF THE RANGE 0 TO THE MAXIMUM SPECIFIED IN THE SECOND
	PARAMETER, THE CODE (IF ANY) BETWEEN THE 'CASE' STATEMENT AND
	THE FIRST 'VALUE' STATEMENT IS EXECUTED, AFTER WHICH
	CONTROL TRANSFERS TO THE CODE AFTER THE 'CASEND' STATEMENT.
5.2.3	UNSELECTED VALUES

	NOT ALL THE VALUES IN THE VALID RANGE NEED APPEAR IN ONE OF
	THE VALUE LISTS, EITHER EXPLICITLY OR IMPLICITLY BY INCLUSION
	IN A VALUE RANGE.  WHEN THE CONTROL VARIABLE ASSUMES ONE OF
	THESE UNSELECTED VALUES, TWO OPTIONS ARE AVAILABLE:
	1. BY DEFAULT, UNSELECTED VALUES CAUSE EXECUTION OF THE
	   OUT-OF-RANGE CODE BETWEEN THE 'CASE' AND FIRST 'VALUE'
	   STATEMENTS.  THIS WILL OFTEN BE CONVENIENT.
	2. IF IT IS REQUIRED TO DISTINGUISH UNSELECTED FROM OUT-OF-RANGE
	   VALUES, PRECEDE THE UNSELECTED-VALUES CODE WITH A 'VALUE'
	   STATEMENT WHICH HAS NO VALUE LIST.
	   THIS NEED NOT BE THE LAST 'VALUE' STATEMENT IN THE
	   STRUCTURE;  IT WILL ONLY ATTRACT VALUES WHICH DO NOT APPEAR
	   IN ANY OTHER 'VALUE' STATEMENT.
	   IF MORE THAN ONE 'VALUE' STATEMENT APPEARS WITH NO VALUE
	   LIST, THE LAST ONE SUPERSEDES ANY PREVIOUS ONES

	TO ILLUSTRATE OUT-OF-RANGE AND UNSELECTED VALUES, THE EXAMPLE
	IN SECTION 5.2.1 IS RECODED AS FOLLOWS.
		MOVB CHAR,R4
		BIC #177600,R4
		CASE R4,176
		  ;PROCESS RUBOUT, WHICH IS NOW OUT OF RANGE
		VALUE <'A,-'Z, 140,-172>
		  ;PROCESS UPPER AND LOWER CASE ALPHABETICS
		VALUE <'0,-'9>
		  ;PROCESS NUMERICS
		VALUE <0,-37>
		  ;PROCESS CONTROL CHARACTERS
		VALUE <40>
		  ;PROCESS SPACE
		VALUE
		  ;PROCESS GRAPHIC CHARACTERS, WHICH ARE ALL THE REST
		CASEND
5.3	'PACKED' OPTION
	---------------

	THE DEFAULT VARIANT OF THE 'CASE' STATEMENT GENERATES 5 EXECUTABLE
	INSTRUCTIONS OCCUPYING 7 WORDS (WITH 20 MICROSECONDS EXECUTION
	TIME ON A PDP-11/10), PLUS A TABLE CONTAINING ONE 1-WORD
	OFFSET FOR EACH VALUE IN THE VALID RANGE OF THE CONTROL VARIABLE.
	THIS VARIANT MINIMIZES EXECUTION TIME AND IMPOSES NO
	LIMIT ON THE SIZE OF THE 'CASE' ... 'CASEND' STRUCTURE, AT THE
	COST OF GENERATING A POTENTIALLY LARGE OFFSET TABLE.

	IF THERE IS A LARGE RANGE OF VALID VALUES OF THE CONTROL VARIABLE,
	STORAGE USE MAY BY REDUCED BY ADDING THE THIRD PARAMETER
	'PACKED' TO THE 'CASE' STATEMENT.  THIS VARIANT GENERATES
	7 EXECUTABLE INSTRUCTIONS OCCUPYING 10 WORDS (WITH
	29 MICROSECONDS EXECUTION TIME ON A PDP-11/10), PLUS A TABLE
	CONTAINING ONE 1-BYTE OFFSET FOR EACH VALUE IN THE VALID
	RANGE.  HENCE STORAGE WILL BE SAVED BY USE OF THE 'PACKED' OPTION,
	PROVIDED THE MAXIMUM VALID VALUE OF THE CONTROL VARIABLE IS
	9 OR GREATER.  HOWEVER, SINCE EACH OFFSET IS STORED IN
	A BYTE, THE 'PACKED' OPTION CANNOT BE USED IF THE LAST
	'VALUE' STATEMENT IN THE STRUCTURE IS MORE THAN 1016(8) BYTES
	AFTER THE 'CASE' STATEMENT - ASSEMBLER "T" ERRORS WILL
	BE REPORTED IF THIS CONDITION IS NOT SATISFIED.
5.4	RUN-TIME INTERACTIONS
	---------------------

5.4.1	CONDITION CODES

	'CASE' CHANGES CONDITION CODES.  'VALUE' AND 'CASEND'
	DO NOT CHANGE CONDITION CODES.


5.4.2	PROCESSOR STACK

	THESE STATEMENTS DO NOT ACCESS THE STACK.


5.4.3	INPUT ARGUMENT DESTROYED

	NOTE VERY CAREFULLY THAT 'CASE' DESTROYS THE CONTENTS OF THE
	REGISTER SPECIFIED BY ITS FIRST PARAMETER.


5.5	ERRORS
	------

	ERROR N REPORTED BY 'VALUE' OR 'CASEND', MEANS THAT IT
		DOES NOT MATCH A 'CASE' STATEMENT.

	ERROR R REPORTED BY 'VALUE', MEANS THAT THE ABSOLUTE VALUE
		OF AN ENTRY IN ITS LIST IS GREATER THAN
		THE MAXIMUM VALUE SPECIFIED IN THE MATCHING 'CASE'
		STATEMENT, OR THAT A NEGATIVE VALUE IN THE
		LIST (MINUS THE UPPER LIMIT OF A VALUE RANGE) IS NOT
		PRECEDED BY A POSITIVE VALUE (THE LOWER LIMIT OF THE
		RANGE) OF SMALLER MAGNITUDE.

	ERROR V REPORTED BY 'CASE', MEANS THAT THE SECOND PARAMETER
		IS NOT IN THE RANGE 1 TO 7777(8).
A1	APPENDIX 1: EXAMPLE OF USAGE
	============================

	THIS APPENDIX CONTAINS THE SOURCE AND ASSEMBLER LISTINGS OF
	A PAIR OF MACRO-11/SP PROCEDURES, WHICH PROVIDE A TYPICAL
	EXAMPLE OF THE USAGE OF THE FACILITIES DESCRIBED IN THIS DOCUMENT.

	THE ASSEMBLER LISTINGS HAVE BEEN PRODUCED WITH THE 
	'MACSP LIST' OPTION TO SHOW THE GENERATED CODE.
	THE LISTINGS HAVE BEEN EDITED TO REMOVE THE SUPERFLUOUS
	LINES WHICH ARE UNAVOIDABLY GENERATED BY THE ASSEMBLER
	WHEN THE 'LIST' OPTION IS USED.

	THE PROCEDURES ARE ASSEMBLED INDEPENDENTLY;  THEY ARE PART OF
	A LARGER SET OF UTILITY ROUTINES.

	THE MACRO 'GENDEF' IS A UTILITY MACRO WHICH DEFINES 'R0' TO 'R5',
	AND OTHER SYMBOLS WHICH ARE NOT USED BY THESE PROCEDURES.
	.TITLE SNGBTC
;THIS ROUTINE IS A GENERAL-PURPOSE BINARY-TO-CHAR CONVERTER.
;IT CONVERTS THE NUMBER (SIGNED OR UNSIGNED) IN R3
;TO AN ARRAY OF TERM COUNTS POINTED TO BY R1
;
;INPUT:
;R0 ->	COUNT OF TERMS, N, FOLLOWED BY
;	N 1-WORD NEGATIVE TERMS, TO BE REPEATEDLY ADDED TO R3
;	TO FIND OUT HOW MANY TIMES THE MAGNITUDE OF EACH GOES.
;	TERMS SHOULD BE IN DESCENDING ORDER
;R1 ->	BYTE ARRAY TO TAKE THE SUCCESSIVE TERM COUNTS.
;	N+1 BYTES ARE REQUIRED: THE LAST BYTE GETS THE REMAINDER
;	R1 IS LEFT POINTING TO THE BEGINNING OF THE ARRAY
;R3	CONTAINS THE NUMBER TO BE CONVERTED. UNCHANGED ON EXIT
;
;OUTPUT:
;R0	DESTROYED
;R1 ->	ARRAY OF RESULTS
;
;D L HERON.  SAENET PROGRAMMING SERVICES.  29 MAY 75
;		CONVERTED TO MACRO-11/SP,  21 JUN 77

	.MCALL GENDEF,MACSP
	GENDEF
	MACSP LIST

	.GLOBL SNGBTC

PROC SNGBTC <R1,R3>
  LOOP (R0)+		;THRU EACH TERM IN THE LIST
    CLRB (R1)		;CLEAR TERM COUNT
    LOOP		;TIL TERM STOPS GOING
      ADD (R0),R3	;TAKE TERM OUT OF R3
      EXLOOP IFC CC	;WE WENT TOO FAR
      INCB (R1)		;IT WENT ONCE MORE
    REPEAT
    SUB (R0)+,R3	;REVERSE THE LAST ADDITION
    TSTB (R1)+		;-> NEXT BYTE IN ARRAY
  REPEAT
  MOVB R3,(R1)+		;PUT REMAINDER IN THE ARRAY
END

	.END
	.TITLE SNGBSD
;THIS ROUTINE CONVERTS A 1-WORD SIGNED NUMBER TO DECIMAL CHARS
;
;INPUT:
;R1 ->	STRING TO RECEIVE THE CONVERTED VALUE
;R3	CONTAINS THE NUMBER TO BE CONVERTED. UNCHANGED ON EXIT.
;
;OUTPUT:
;R0	DESTROYED
;R1 ->	BYTE AFTER THE CONVERTED STRING WHICH IS 6 BYTES LONG
;	IN THE FORMAT SDDDDD (+ SIGN = SPACE, SIGN AND DIGITS
;	RIGHT-JUSTIFIED AND SPACE-FILLED)
;
;D L HERON.  SAENET PROGRAMMING SERVICES.  2 JUN 75
;		CONVERTED TO MACRO-11/SP,  21 JUN 77

	.MCALL GENDEF,MACSP
	GENDEF
	MACSP LIST

	.GLOBL SNGBTC

	.GLOBL SNGBSD

PROC SNGBSD <R3,R4>
  MOV R1,R4		;-> SIGN POSITION
  IF R3 SGE #0 THEN	;NUMBER POSITIVE
    MOVB #' ,(R1)+	;POSITIVE SIGN
  ELSE
    MOVB #'-,(R1)+	;NEGATIVE SIGN
    NEG R3		;MAKE IT POSITIVE
  FI

  MOV PC,R0
  ADD #100$-.,R0	;-> PARAMETER TABLE
  CALL SNGBTC

  MOV #4,R0		;MAX OF 4 0'S TO BE SPACE-FILLED
  LOOP			;TO SPACE-FILL LEADING ZEROES
    EXLOOP IFB (R1) NE #0  ;QUIT AT FIRST NON-ZERO
    MOVB (R4),(R1)+	;MOVE THE SIGN DOWN
    MOVB #' ,(R4)+	;PUT IN A SPACE
    DEC R0		;ONE LESS TO GO
    EXLOOP IFC EQ	;NO MORE
  REPEAT
  LOOP			;TO CONVERT REMAINING COUNTS TO CHARS
    BISB #'0,(R1)+
    DEC R0		;ONE LESS TO GO
    EXLOOP IFC SLT	;NO MORE
  REPEAT
END

100$:	.WORD 4		;SNGBTC PARAMETER TABLE
	.WORD -10000.
	.WORD -1000.
	.WORD -100.
	.WORD -10.

	.END
SNGBTC	RT-11 MACRO VM02-12   24-JUN-77 12:59:54 PAGE 1


1               	.TITLE SNGBTC
2               ;THIS ROUTINE IS A GENERAL-PURPOSE BINARY-TO-CHAR CONVERTER.
3               ;IT CONVERTS THE NUMBER (SIGNED OR UNSIGNED) IN R3
4               ;TO AN ARRAY OF TERM COUNTS POINTED TO BY R1
5               ;
6               ;INPUT:
7               ;R0 ->	COUNT OF TERMS, N, FOLLOWED BY
8               ;	N 1-WORD NEGATIVE TERMS, TO BE REPEATEDLY ADDED TO R3
9               ;	TO FIND OUT HOW MANY TIMES THE MAGNITUDE OF EACH GOES.
10              ;	TERMS SHOULD BE IN DESCENDING ORDER
11              ;R1 ->	BYTE ARRAY TO TAKE THE SUCCESSIVE TERM COUNTS.
12              ;	N+1 BYTES ARE REQUIRED: THE LAST BYTE GETS THE REMAINDER
13              ;	R1 IS LEFT POINTING TO THE BEGINNING OF THE ARRAY
14              ;R3	CONTAINS THE NUMBER TO BE CONVERTED. UNCHANGED ON EXIT
15              ;
16              ;OUTPUT:
17              ;R0	DESTROYED
18              ;R1 ->	ARRAY OF RESULTS
19              ;
20              ;D L HERON.  SAENET PROGRAMMING SERVICES.  29 MAY 75
21              ;		CONVERTED TO MACRO-11/SP,  21 JUN 77
22
23              	.MCALL GENDEF,MACSP
24 00000        	GENDEF
25 00000        	MACSP LIST
26
27              	.GLOBL SNGBTC
28
29 00000        PROC SNGBTC <R1,R3>
   00000        					SNGBTC:
   00000 010146 						MOV R1,-(%6)
   00002 010346 						MOV R3,-(%6)
30 00004          LOOP (R0)+		;THRU EACH TERM IN THE LIST
   00004 012046 						MOV (R0)+,-(%6)
   00006 001411 						BEQ 1$
   00010        					2$:
31 00010 105011     CLRB (R1)		;CLEAR TERM COUNT
32 00012            LOOP		;TIL TERM STOPS GOING
   00012        					3$:
33 00012 061003       ADD (R0),R3	;TAKE TERM OUT OF R3
34 00014              EXLOOP IFC CC	;WE WENT TOO FAR
   00014 000402 						BR 4$
         000015'					.=.-1
   00015    206 						.BYTE $6
35 00016 105211       INCB (R1)		;IT WENT ONCE MORE
36 00020            REPEAT
   00020 000774 						BR 3$
   00022        					4$:
37 00022 162003     SUB (R0)+,R3	;REVERSE THE LAST ADDITION
38 00024 105721     TSTB (R1)+		;-> NEXT BYTE IN ARRAY
39 00026          REPEAT
   00026 005316 						DEC @%6
SNGBTC	RT-11 MACRO VM02-12   24-JUN-77 12:59:54 PAGE 1+


   00030 001367 						BNE 2$
   00032        					1$:
   00032 005726 						TST (%6)+
40 00034 110321   MOVB R3,(R1)+		;PUT REMAINDER IN THE ARRAY
41 00036        END
   00036 012603 						12603
   00040 012601 						12601
   00042 012607 						12607
42
43       000001'	.END
SNGBTC	RT-11 MACRO VM02-12   24-JUN-77 12:59:54 PAGE 1+
SYMBOL TABLE

BEL   = 000007  	B0    = 000001  	B1    = 000002
B10   = 002000  	B11   = 004000  	B12   = 010000
B13   = 020000  	B14   = 040000  	B15   = 100000
B2    = 000004  	B3    = 000010  	B4    = 000020
B5    = 000040  	B6    = 000100  	B7    = 000200
B8    = 000400  	B9    = 001000  	CR    = 000015
DEL   = 000177  	FF    = 000014  	HT    = 000011
IOTVEC= 000020  	LF    = 000012  	PC    =%000007
PS    = 177776  	PWRVEC= 000024  	R0    =%000000
R1    =%000001  	R2    =%000002  	R3    =%000003
R4    =%000004  	R5    =%000005  	SNGBTC  000000RG
SP    =%000006  	SR    = 177570  	TRPVEC= 000034
$0    = 000020  	$1    = 000005  	$10   = 000001
$11   = 001000  	$12   = 077777  	$2    = 000000
$20   = 000070  	$21   = 000010  	$22   = 000030
$23   = 000141  	$24   = 000000  	$25   = 000020
$26   = 000052  	$27   = 000010  	$3    = 000000
$30   = 000000  	$31   = 000062  	$4    = 000000
$5    = 000007  	$6    = 000014  	$8    = 000000
$9    = 000001
. ABS.	000000	   000
      	000044	   001
ERRORS DETECTED: 0
FREE CORE: 11896. WORDS

,SNGBTC=SNGBTC

SNGBSD	RT-11 MACRO VM02-12   21-JUN-77 12:46:47 PAGE 1


1               	.TITLE SNGBSD
2               ;THIS ROUTINE CONVERTS A 1-WORD SIGNED NUMBER TO DECIMAL CHARS
3               ;
4               ;INPUT:
5               ;R1 ->	STRING TO RECEIVE THE CONVERTED VALUE
6               ;R3	CONTAINS THE NUMBER TO BE CONVERTED. UNCHANGED ON EXIT.
7               ;
8               ;OUTPUT:
9               ;R0	DESTROYED
10              ;R1 ->	BYTE AFTER THE CONVERTED STRING WHICH IS 6 BYTES LONG
11              ;	IN THE FORMAT SDDDDD (+ SIGN = SPACE, SIGN AND DIGITS
12              ;	RIGHT-JUSTIFIED AND SPACE-FILLED)
13              ;
14              ;D L HERON.  SAENET PROGRAMMING SERVICES.  2 JUN 75
15              ;		CONVERTED TO MACRO-11/SP,  21 JUN 77
16
17              	.MCALL GENDEF,MACSP
18 00000        	GENDEF
19 00000        	MACSP LIST
20
21              	.GLOBL SNGBTC
22
23              	.GLOBL SNGBSD
24
25 00000        PROC SNGBSD <R3,R4>
   00000        					SNGBSD:
   00000 010346 						MOV R3,-(%6)
   00002 010446 						MOV R4,-(%6)
26 00004 010104   MOV R1,R4		;-> SIGN POSITION
27 00006          IF R3 SGE #0 THEN	;NUMBER POSITIVE
   00006 005703 						TST R3
   00010 000403 						BR 1$
         000011'					.=.-1
   00011    005 						.BYTE $6
28 00012 112721     MOVB #' ,(R1)+	;POSITIVE SIGN
         000040
29 00016          ELSE
   00016 000403 						BR 2$
   00020        					1$:
30 00020 112721     MOVB #'-,(R1)+	;NEGATIVE SIGN
         000055
31 00024 005403     NEG R3		;MAKE IT POSITIVE
32 00026          FI
   00026        					2$:
33
34 00026 010700   MOV PC,R0
35 00030 062700   ADD #100$-.,R0	;-> PARAMETER TABLE
         000054
36 00034          CALL SNGBTC
   00034 004767 						JSR %7,SNGBTC
         000000G
37
38 00040 012700   MOV #4,R0		;MAX OF 4 0'S TO BE SPACE-FILLED
SNGBSD	RT-11 MACRO VM02-12   21-JUN-77 12:46:47 PAGE 1+


         000004
39 00044          LOOP			;TO SPACE-FILL LEADING ZEROES
   00044        					3$:
40 00044            EXLOOP IFB (R1) NE #0  ;QUIT AT FIRST NON-ZERO
   00044 105711 						TSTB (R1)
   00046 000406 						BR 4$
         000047'					.=.-1
   00047    002 						.BYTE $6
41 00050 111421     MOVB (R4),(R1)+	;MOVE THE SIGN DOWN
42 00052 112724     MOVB #' ,(R4)+	;PUT IN A SPACE
         000040
43 00056 005300     DEC R0		;ONE LESS TO GO
44 00060            EXLOOP IFC EQ	;NO MORE
   00060 000401 						BR 4$
         000061'					.=.-1
   00061    003 						.BYTE $6
45 00062          REPEAT
   00062 000770 						BR 3$
   00064        					4$:
46 00064          LOOP			;TO CONVERT REMAINING COUNTS TO CHARS
   00064        					5$:
47 00064 152721     BISB #'0,(R1)+
         000060
48 00070 005300     DEC R0		;ONE LESS TO GO
49 00072            EXLOOP IFC SLT	;NO MORE
   00072 000401 						BR 6$
         000073'					.=.-1
   00073    005 						.BYTE $6
50 00074          REPEAT
   00074 000773 						BR 5$
   00076        					6$:
51 00076        END
   00076 012604 						12604
   00100 012603 						12603
   00102 012607 						12607
52
53 00104 000004 100$:	.WORD 4		;SNGBTC PARAMETER TABLE
54 00106 154360 	.WORD -10000.
55 00110 176030 	.WORD -1000.
56 00112 177634 	.WORD -100.
57 00114 177766 	.WORD -10.
58
59       000001'	.END
SNGBSD	RT-11 MACRO VM02-12   21-JUN-77 12:46:47 PAGE 1+
SYMBOL TABLE

BEL   = 000007  	B0    = 000001  	B1    = 000002
B10   = 002000  	B11   = 004000  	B12   = 010000
B13   = 020000  	B14   = 040000  	B15   = 100000
B2    = 000004  	B3    = 000010  	B4    = 000020
B5    = 000040  	B6    = 000100  	B7    = 000200
B8    = 000400  	B9    = 001000  	CR    = 000015
DEL   = 000177  	FF    = 000014  	HT    = 000011
IOTVEC= 000020  	LF    = 000012  	PC    =%000007
PS    = 177776  	PWRVEC= 000024  	R0    =%000000
R1    =%000001  	R2    =%000002  	R3    =%000003
R4    =%000004  	R5    =%000005  	SNGBSD  000000RG
SNGBTC= ****** G	SP    =%000006  	SR    = 177570
TRPVEC= 000034  	$0    = 000020  	$1    = 000007
$10   = 000001  	$11   = 001000  	$12   = 077777
$2    = 000000  	$20   = 000070  	$21   = 000030
$22   = 000040  	$23   = 000141  	$24   = 000000
$25   = 000020  	$26   = 000122  	$3    = 000000
$4    = 000000  	$5    = 000007  	$6    = 000014
$8    = 000000  	$9    = 000001
. ABS.	000000	   000
      	000116	   001
ERRORS DETECTED: 0
FREE CORE: 15330. WORDS

,SNGBSD=SNGBSD

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   