
	PROGRAM RDOSMT
C					06-MAY-78/09-MAY-78
C
C      AUTHOR: N. A. BOURGEOIS, JR.
C              ADVANCED SYSTEMS DEVELOPMENT DIVISION 1736
C              SANDIA LABORATORIES
C              PO BOX 5800
C              ALBUQUERQUE, NM 87185
C              505-264-8088
C              FTS 475-8088
C      
C      THIS SOFTWARE IS ISSUED BY SANDIA LABORATORIES, OPERATED
C      FOR  THE  UNITED  STATES  DEPARTMENT OF ENERGY BY SANDIA
C      CORPORATION.
C      
C                               NOTICE
C      
C      THIS  SOFTWARE  WAS  SPONSORED  BY  THE  UNITED   STATES
C      GOVERNMENT.   NEITHER  THE  UNITED STATES GOVERNMENT NOR
C      THE UNITED STATES DEPARTMENT OF ENERGY, NOR ANY OF THEIR
C      EMPLOYEES, NOR ANY OF THEIR CONTRACTORS, SUBCONTRACTORS,
C      OR  THEIR  EMPLOYEES  MAKES  ANY  WARRANTY,  EXPRESS  OR
C      IMPLIED,    OR    ASSUMES   ANY   LEGAL   LIABILITY   OR
C      RESPONSIBILITY  FOR  THE   ACCURACY,   COMPLETENESS   OR
C      USEFULNESS  OF  ANY  INFORMATION,  APPARATUS, PRODUCT OR
C      PROCESS DISCLOSED, OR REPRESENTS THAT ITS USE WOULD  NOT
C      INFRINGE PRIVATELY OWNED RIGHTS.
C      
C      THIS WORK WAS SPONSORED AND FUNDED BY:
C         BASE AND INSTALLATION SECURITY SYSTEMS PROGRAM OFFICE
C         ELECTRONIC SYSTEMS DIVISION
C         AIR FORCE SYSTEMS COMMAND
C         HANSCOM AIR FORCE BASE, MA 01731
C
C                          ****************
C                          *              *
C                          * UNCLASSIFIED *
C                          *              *
C                          ****************
C
C	TABLE OF CONTENTS
C		DESCRIPTION		2
C		USER INCTRUCTIONS	2
C		DATA ASSIIGNMENTS	3
C		FORTRAN PROGRAM		4
C		S/R SKIP FILES		5
C		S/R TRANSFER FILES	6
C	DESCRIPTION			06-MAY-78/
C
C	THIS PROGRAM READS DOS/BATCH FILES FROM MAGNETIC TAPE AND WRITES
C	THEM OUT TO ANY RT-11 DEVICE IN RT-11 FORMAT.  FILES ARE
C	TRANSFERED FROM ANY DESIRED STARTING POINT UNTIL EITHER THE 
C	RT-11 DEVICE IS FULL OR UNTIL THE TAPE IS EMPTIED.  THE PROGRAM
C	ALWAYS STARTS AT THE LOGIGAL BEGINNING-OF-TAPE (BOT) OR LOAD
C	POINT (LD PT).
C
C	THE SEQUENCE OF EVENTS IS AS FOLLOWS:
C		1.  A MESSAGE IS PRINTED ASKING FOR THE TAPE TO BE
C		    MOUNTED.
C		2.  A MESSAGE IS PRINTED ASKING FOR THE OUTPUT DEVICE
C		    NAME.
C		3.  A MESSAGE IS PRINTED ASKING HOW MANY FILES TO SKIP
C		    FROM BOT.
C		4.  THE TAPE IS REWOUND TO BOT.
C		5.  THE TAPE IS SPACED FORWARD PAST THE REQUESTED NUMBER
C		    OF FILES.
C		6.  FILES ARE TRANSFERED FROM THE TAPE TO THE REQUESTED
C		    RT-11 OUTPUT DEVICE.
C		7.  A MESSAGE IS PRINTED STATING THE REASON FOR PROGRAM
C		    TERMINATION.
C
C	FOR A DESCRIPTION OF THE SUBROOUTINE "EXTMT" REFER TO:
C		N. A. BOURGEOIS, JR., "A GENERAL PURPOSE MAGNETIC TAPE
C		HANDLER", SAND77-1492, SANDIA LABORATORIES,
C		ALBUQUERQUE, NM.
C
C
C	USER INSTRUCTIONS		06-MAY-78/08-MAY-78
C
C	COMPILER COMMAND STRING:
C		RDOSMT[,LP:]<RDOSMT[/L:1]/U/W
C	ASSEMBLER COMMAND STRING:
C		EXTMT[,LP:]<TT:,SY:EXTMT[/C/N:TTM:CND]
C		CHANGE=60000
C		^Z^Z
C	LINKER COMMAND STRING:
C		RDOSMT[,LP:]<RDOSMT,EXTMT,SYSLIB[/A/W]/F
C	MONITOR COMMAND STRING:
C		R RDOSMT
C
C	NOTE: THE ITEMS IN SQUARE BRACKETS ARE OPTIONAL.
C	DATA ASSIGNMENTS		06-MAY-78/
C
C	DOS/BATCH MT LABEL RECORD
C	WORD #		CONTENT		COMMENT
C	1-2		FILNAM		RAD50
C	3		EXT		RAD50
C	4		UIC		-
C	5		PROTECTION	-
C	6		DATE		-
C	7		NOT USED	0
C
	DIMENSION IDATA(256)
	DIMENSION IDBLK(4)
C
	COMMON IDATA,IDBLK
C
1	FORMAT (' MOUNT THE TAPE ON 9-TRACK DRIVE MT0:')
2	FORMAT (' ENTER THE OUTPUT DEVICE NAME')
3	FORMAT (' ENTER THE NUMBER OF FILES TO SKIP')
10	FORMAT (A4)
11	FORMAT (I4)
C	FORTRAN PROGRAM: RDOSMT		06-MAY-78/
C
C	ASK FOR TAPE MOUNT
	TYPE 1
	PAUSE ' PRESS RETURN TO PROCEED'
C
C	SET UP THE OUTPUT DEVICE
100	TYPE 2
	ACCEPT 10,DEVNAM
	I=IRAD50(3,DEVNAM,IDBLK)
	IF (I.LT.1) GO TO 100
	ICHAN=IGETC()
	IF (ICHAN.LT.0) STOP ' RDOSMT: IGETC ERROR'
	I=IFETCH(IDBLK)
	IF (I.NE.0) STOP ' RDOSMT: IFETCH ERROR'
C
C	ASK HOW MANY FILES TO SKIP
	TYPE 3
	ACCEPT 11,IFILES
C
C	REWIND THE TAPE
	CALL EXTMT(7)
C
C	SKIP THE REQUSTED NUMBER OF FILES
	CALL SKPFLS(IFILES)
C
C	TRANSFER FILES TO THE NAMED DEVICE
	CALL XFRFLS(ICHAN)
C
C	FREE THE CHANNEL
	I=IFREEC(ICHAN)
	IF (I.GT.0) STOP ' RDOSMT: IFREEC ERROR'
C
C	LOGICAL AND PHYSICAL END OF PROGRAM: RDOSMT
	END
	SUBROUTINE SKPFLS(IFILES)
C					07-MAY-78/09-MAY-78
C
C	DATA ASSIGNMENTS
	DIMENSION IDATA(256)
	COMMON IDATA
C
C	LOGICAL START OF SUBROUTINE: SKPFLS
C	TEST IF NO FILES TO SKIP
	IF (IFILES.EQ.0) GO TO 299
C
C	TEST FOR LOGICAL END OF TAPE
200	CALL EXTMT(1,512,IDATA,ICHAR)
	IF (ICHAR.EQ.0) STOP ' SKIP RQEUEST TOO BIG'
C
C	SKIP PAST A FILE
210	CALL EXTMT(1,512,IDATA,ICHAR)
	IF (ICHAR.NE.0) GO TO 210
C
C	TEST FOR MORE FILES TO SKIP
	IFILES=IFILES-1
	IF (IFILES.GT.0) GO TO 200
C
C	LOGICAL AND PHYSICAL END OF SUBROUTINE: SKPFLS
299	RETURN
	END
	SUBROUTINE XFRFLS(ICHAN)
C					07-MAY-78/09-MAY-78
C
C	DATA ASSIGNMENTS
	DIMENSION IDATA(256)
	DIMENSION LABEL(7)
	DIMENSION IDBLK(4)
	COMMON IDATA,IDBLK
	EQUIVALENCE (IDATA,LABEL)
30	FORMAT (' OUTPUT DEVICE FULL')
31	FORMAT (' MISSING LABEL RECORD')
32	FORMAT (' RDOSMT: IENTER ERROR')
33	FORMAT (' RDOSMT: IWRITW ERROR')
34	FORMAT (' NO MORE FILES ON TAPE')
C
C	LOGICAL START OF SUBROUTINE: XFRFLS
C	TEST FOR LOGICAL END OF TAPE
300	CALL EXTMT(1,512,IDATA,ICHAR)
	IF (ICHAR.EQ.0) GO TO 360
	IF (ICHAR.NE.14) GO TO 330
C
C	OPEN A FILE ON THE OUTPUT DEVICE
	IBLOCK=0
	IDBLK(2)=LABEL(1)
	IDBLK(3)=LABEL(2)
	IDBLK(4)=LABEL(3)
	I=IENTER(ICHAN,IDBLK,-1)
	IF (I.LT.0) GO TO 340
C
C	TRANSFER THE FILE
310	CALL EXTMT(1,512,IDATA,ICHAR)
	IF (ICHAR.EQ.0) GO TO 320
	I=IWRITW(256,IDATA,IBLOCK,ICHAN)
	IBLOCK=IBLOCK+1
C
C	TEST FOR ERRORS
	IF(I.GT.0) GO TO 310
	CALL PURGE(ICHAN)
	IF (I.LT.-1) GO TO 350
	TYPE 30
	GO TO 399
C
C	CLOSE THE FILE
320	CALL CLOSEC(ICHAN)
	GO TO 300
C
C	TYPE AN ERROR MESSAGE
330	TYPE 31
	GO TO 399
340	TYPE 32
	GO TO 399
350	TYPE 33
	GO TO 399
C
C	EOT MESSAGE
360	TYPE 34
C
C	LOGICAL AND PHYSICAL END OF SUBROUTINE: XFRFLS
399	RETURN
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                              