;
;FFTR8K.RSX  FEBRUARY 1974
;WRITTEN BY BOB DAY
;COMPUTER SPECIAL SYSTEMS
;DIGITAL EQUIPMENT CORPORATION
;


;GLOBALS

.GLOBL FFTR



;IDENTIFIERS

F.R:	0		;(LOG N)-2
ARRAY:	0		;DATA ARRAY
F.N:	0		;NUMBER OF DATA POINTS
F.SCLF:	0		;SCALE FACTOR
F.INV:	0		;FORWARD/INVERSE FLAG
F.SPCT:	0		;POWER SPECTRUM OPTION FLAG
F.LL:	0		;NO. OF SUBGROUPS WITHIN A COLUMN
F.M:	0		;USED TO LOCATE ORIGIN OF A SUBGROUP
F.L:	0		;INDEX FOR MAIN LOOP
F.A1:	0		;OFFSET OF 1ST HALF OF A SUBGROUP
F.A2:	0		;OFFSET OF 2ND HALF OF A SUBGROUP
F.K:	0		;INDEX FOR NO. OF SUBGPS W/IN A COL.
F.SR:	0		;TEMP STORAGE FOR CURRENT POINTS
F.ORG:	0		;ORIGIN OF NEXT SUBGROUP
F.H:	0		;POWER OF W
F.HH:	0		;TRIG TABLE INCREMENT
F.TRT:	0		;TEMP STORAGE
F.COS:	0		;CURRENT COSINE
F.SIN:	0		;CURRENT SINE
F.MM:	0		;TEMP STORAGE
F.GRPN:	0		;NO. OF POINTS IN CURRENT GROUP
F.SCT:	0		;COUNTER FOR POINTS IN CURRENT GROUP
R.HH:	0
R.CTR:	0
R.B:	0
R.D:	0
XR0:	0		;TEMP.
XR1:	0		;TEMP.
X.BIT:	0		;POINTER FOR BIT REVERSAL
F.TCNT:	1		;TIMING COUNTER


	R0=%0
	R1=%1
	R2=%2
	R3=%3
	R4=%4
	R5=%5
	SP=%6
	PC=%7



;
;SUBROUTINE FOR COMPUTING FAST FOURIER
;TRANSFORM OF STRICTLY REAL DATA POINTS.
;THE NUMBER OF DATA POINTS MUST BE A
;POWER OF TWO NOT LESS THAN 16. OR
;GREATER THAN 8192.
;
;CALLING SEQUENCE
;	JSR R5,FFTR
;	BR  [AROUND PARAMATERS]
;	A[DATA ARRAY ADDRESS]
;	A[NUMBER OF DATA POINTS]
;	A[SCALE FACTOR, F.SCLF, RETURNED HERE]
;	A[0 FOR FORWARD; 1 FOR INVERSE]
;	A[0 FOR POWER SPECTRUM; 1 FOR NOT]*
;	A[ERROR WORD]
;	*THIS FLAG IS IGNORED IF INVERSE HAS BEEN REQUESTED
;
;ON ERROR, SUBROUTINE SETS C AND RETURNS
;
FFTR:	MOV	R0,-(SP)	;SAVE REGISTERS
	MOV	R1,-(SP)	;	"
	MOV	R2,-(SP)	;	"
	MOV	R3,-(SP)	;	"
	MOV	R4,-(SP)	;	"
	MOV	R5,-(SP)	;	"
	MOVB	@R5,R1		;CHECK NO. OF PARAMS
	CMP	#3,R1		;AT LEAST 3?
	BGT	R.EREX		;NO, BEAT IT
	CMP	#6,R1		;MORE THAN 6?
	BLT	R.EREX		;YES, SCRAM
	BGT	R.IN4		;HOP OVER IF NO ERROR WORD
	MOV	#1,@12.(R5)	;INIT ERROR WORD TO 1
R.IN4:	MOV	#5,R0		;INIT INTERNAL PARAMS
	MOV	#F.N,R2		;	"
R.IN5:	CLR	(R2)+		;	"
	DEC	R0		;	"
	BGT	R.IN5		;	"
	MOV	#4,R.IN6+2	;INSERT USER'S PARAMS
	DEC	R1		;	"
	MOV	#ARRAY,R2	;	"
	MOV	2(R5),(R2)+	;	"
R.IN6:	MOV	@4(R5),(R2)+	;	"
	ADD	#2,R.IN6+2	;	"
	DEC	R1		;	"
	BGT	R.IN6		;	"
	ASR	F.N		;N = COMPLEX TYPE N
	BCS	R.EREX		;ERROR IF LOW ORDER BIT SET
	TST	F.N		;N LEQ ZERO?
	BLE	R.EREX		;YES, ERROR
	CMP	#4096.,F.N	;N GTR 4096.?
	BLT	R.EREX		;YES,ERROR
	MOV	F.N,F.M		;TEMP STORE
	CLR	F.R		;
R.IN1:	ROR	F.M
	BCS	R.IN2
	INC	F.R
	BR	R.IN1
R.IN2:	BNE	R.EREX		;NOT PWR OF TWO, ERROR
	SUB	#2,F.R		;R IS PWR OF TWO MINUS 2
	BLE	R.EREX		;N LESS THAN 16.,ERROR
	CLR	R1		;CALCULATE INC FOR TRIG TABLE
	MOV	#4096.,R0	;	"
R.IN3:	ASR	R0		;	"
	INC	R1		;	"
	CMP	F.R,R1		;	"
	BGT	R.IN3		;	"
	MOV	R0,R.HH		;INCREMENT FOR TRIG TABLE
	MOV	R0,F.HH		;AGAIN
	CLR	F.SCLF		;INIT SCALE FACTOR
	TST	F.INV		;INVERSE REQUESTED?
	BNE	R.M1		;YES,BRANCH
	JSR	PC,F.MAIN	;NO, DO FORWARD TRANSFORM
	MOV	R.HH,F.HH	;GET INC IN TRIG TABLE
	ASR	F.HH		;ADJUST TRIG INC.
	JSR	PC,R.RIZE	;GO COMPUTE REAL TRANSFORM
	TST	F.SPCT		;DO POWER SPECTRUM?
	BNE	R.EXIT		;NO,SKIP
	JSR	PC,F.SPM	;YES, GO COMPUTE IT
	BR	R.EXIT		;EXIT
R.M1:	ASR	F.HH		;ADJUST TRIG INC.
	JSR	PC,R.RIZE	;INVERSE: GO REAL-IZE
	ASL	F.HH		;ADJUST TRIG INC
	JSR	PC,F.MAIN	;DO TRANSFORM
R.EXIT:	CLC			;CLEAR ERROR FLAG
R.EXER:	MOV	(SP)+,R5	;RESTORE REGS
	MOV	F.SCLF,@6(R5)	;RETURN SCALE FACTOR
R.ERR2:	MOV	(SP)+,R4	;RESTORE REGISTERS
	MOV	(SP)+,R3	;	"
	MOV	(SP)+,R2	;	"
	MOV	(SP)+,R1	;	"
	MOV	(SP)+,R0	;	"
	RTS	PC		;RETURN
R.EREX:	MOV	(SP)+,R5	;GET NO. OF PARAMS
	CMPB	#6,@R5		;IS ERROR WORD THERE?
	BGT	R.ERR1		;NO, BR
	MOV	#2,@12.(R5)	;YES,INSERT ERROR CODE
R.ERR1:	SEC			;SET ERROR FLAG
	BR	R.ERR2		;GO EXIT


;
;ROUTINE TO COMBINE OR SEPARATE THE
;REAL AND COMPLEX PARTS OF A COMPLEX
;TRANSFORM TO PRODUCE THE REAL TRANSFORM
;
;CALL BY JSR PC,R.RIZE
;
R.RIZE:	MOV	F.N,R.CTR	;SET UP LOOP COUNTER
	ASR	R.CTR		;	"
	MOV	F.N,R4		;SET UP UPPER POINTER
	ASL	R4		;	"
	ASL	R4		;	"
	MOV	ARRAY,R3	;SET UP LOWER POINTER
	ADD	R3,R4		;ADD BASE TO UPPER POINTER
	CLR	F.H		;CLEAR POINTER TO TRIG TABLE
	MOV	#R.R5,F.ORTN
	BR	R.SKP1
R.OFL1:	JMP	F.OFL
R.SKP1:
R.R5:	MOV	(R3),R2		;X(I)
	MOV	2(R3),R0	;Y(I)
	MOV	R2,XR1		;X(I)
	MOV	R0,R5		;Y(I)
	ADD	(R4),R2		;X(I)+ X(N-I)
	BVS	R.OFL1		;OVERFLOW
	ADD	2(R4),R0	;Y(I)+Y(N-I)
	BVS	R.OFL1		;
	SUB	(R4),XR1	;X(I)-X(N-I)
	BVS	R.OFL1		;
	SUB	2(R4),R5	;Y(I)-Y(N-I)
	BVS	R.OFL1		;
	JSR	PC,R.TRIG	;GET CURRENT SINE & COSINE
	MOV	R0,XR0		;SAVE R0
	MUL	F.COS,R0	;FORM THE POINT TRANSFORM
	ASHC	#1,R0		;	"
	MOV	R0,R.B		;	"
	MOV	XR1,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	SUB	R0,R.B		;	"
	BVS	R.OFL1
	MOV	XR0,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	MOV	R0,R.D		;	"
	MOV	XR1,R0		;	"
	MUL	F.COS,R0	;	"
	ASHC	#1,R0		;	"
	ADD	R0,R.D		;	"
	BVS	R.OFL1
	TST	F.INV		;INVERSE REQUESTED?
	BNE	R.R3		;YES,BRANCH
	MOV	R2,R0		;A
	MOV	R5,R1		;C
	ADD	R.B,R2		;NEW X(I)
	BVS	R.OFL2
	SUB	R.B,R0		;NEW X(N-I)
	BVS	R.OFL2
	SUB	R.D,R1		;NEW Y(I)
	BVS	R.OFL2
	NEG	R5
	SUB	R.D,R5		;NEW Y(N-I)
	BVS	R.OFL2
	BR	R.R4		;GO STORE NEW VALUES
R.OFL2:	JMP	F.OFL
R.R3:	MOV	R2,R0		;A
	MOV	R5,R1		;C
	SUB	R.B,R2		;X(I)
	BVS	R.OFL2		;
	ADD	R.B,R0		;X(N-I)
	BVS	R.OFL2
	ADD	R.D,R1		;Y(I)
	BVS	R.OFL2
	NEG	R5
	ADD	R.D,R5		;Y(M-I)
	BVS	R.OFL2
R.R4:	MOV	R2,(R3)		;STORE NEW VALUES
	MOV	R0,(R4)		;	"
	MOV	R1,2(R3)	;	"
	MOV	R5,2(R4)	;	"
	ADD	F.HH,F.H	;BUMP TRIG TABLE POSITION
	CMP	(R3)+,(R3)+	;INC LOWER POINTER
	CMP	-(R4),-(R4)	;DEC UPPER POINTER
	DEC	R.CTR		;LOOP?
	BGE	R.R5		;YES, BRANCH
	TST	F.INV		;ADJUST SCALE FACTOR
	BNE	R.R6		;	"
	DEC	F.SCLF		;	"
R.R6:	RTS	PC		;RETURN
;
;ROUTINE TO LOOK UP TRIG TABLE VALUES
;
;CALL BY JSR PC,R.TRIG
;
;
R.TRIG:	MOV	R4,-(SP)
	CMP	F.H,#4096.
	BLE	R.HOP1
	MOV	#8192.,R4
	SUB	F.H,R4
	MOV	F.TRIG(R4),F.SIN
	MOV	F.H,R4
	SUB	#4096.,R4
	MOV	F.TRIG(R4),F.COS
	NEG	F.COS
	BR	R.HOP2
R.HOP1:	MOV	F.H,R4
	MOV	F.TRIG(R4),F.SIN
	NEG	R4
	ADD	#4096.,R4
	MOV	F.TRIG(R4),F.COS
R.HOP2:	TST	F.INV
	BEQ	R.HOP3
	NEG	F.SIN
R.HOP3:	MOV	(SP)+,R4
	RTS	PC
;START OF PROGRAM


F.MAIN:	MOV	#1,F.LL		;1 SUBGROUP IN FIRST COLUMN
	MOV	F.N,F.M		;M IS POINTER TO NEXT SUBGP
	ASL	F.M		;ADDRESSES GO BY 4'S
	ASL	F.M		;	"
	MOV	F.N,F.GRPN	;NO. OF POINTS IN SUBGROUP
	MOV	#F.ORT1,F.ORTN	;SET UP RETURN FROM OFLOW RTN
	MOV	F.R,F.L		;START MAIN LOOP:(LOG N)-2 TIMES
	BR	F.SKP8
F.OFL2:	JMP	F.OFL
F.SKP8:
F.NXTC:	MOV	F.M,F.ORG	;OFFSET OF NEXT SUBGROUP
	ASR	F.M		;M=M/2
	ASR	F.GRPN		;INIT SUBGROUP POINT COUNTER
	MOV	F.GRPN,F.SCT	;	"
	CLR	F.A1		;POINTER TO TOP HALF SUBGROUP
	MOV	F.M,F.A2	;POINTER TO BOTTOM HALF SUBGROUP
	MOV	F.LL,F.K	;NUMBER OF SUBGROUPS PER COL
	CLR	F.H		;SET TRIG TABLE POINTER
F.SBGP:	MOV	ARRAY,R2	;PTR TO TOP HALF OF SUBGROUP
	MOV	R2,R3		;PTR TO BOTTOM HALF OF SUBGRP
	ADD	F.A1,R2		;SET UP SUBGP HALF ADDRESSES
	ADD	F.A2,R3		;      "
	MOV	R4,-(SP)	;STORE R4
	CMP	F.H,#4096.	;LOOK UP SINE AND COSINE
	BLE	F.HOP1		;(2 BYTES = 1 WORD)
	MOV	#8192.,R4	;H GT 2048
	SUB	F.H,R4		;
	MOV	F.TRIG(R4),F.SIN ;SINE
	MOV	F.H,R4
	SUB	#4096.,R4
	MOV	F.TRIG(R4),F.COS ;COSINE
	NEG	F.COS
	BR	F.HOP2
F.HOP1:	MOV	F.H,R4		;H LE 2048
	MOV	F.TRIG(R4),F.SIN  ;SINE
	NEG	R4
	ADD	#4096.,R4
	MOV	F.TRIG(R4),F.COS  ;COSINE
F.HOP2:	TST	F.INV
	BEQ	F.HOP3		;NO, SKIP
	NEG	F.SIN		;YES, NEGATE SINE
F.HOP3:	MOV	(SP)+,R4	;RESTORE R4
F.ORT1:	MOV	(R2),R4		;GET 1ST HALF, REAL
	MOV	2(R2),R5	;GET 1ST HALF, IMAG
	MOV	R4,XR0		;TEMP
	MOV	R5,XR1		;TEMP
	ADD	(R3),XR0	;DON'T ADD DIRECTLY, SINCE YOU
	BVS	F.OFL2		;DON'T WANT TO ALTER THE DATA
	ADD	2(R3),XR1	;BEFORE CHECKING FOR OVERFLOW
	BVS	F.OFL2
	SUB	(R3),R4		;FORM SR-TR
	BVS	F.OFL2
	SUB	2(R3),R5	;FORM SI-TI
	BVS	F.OFL2
	MOV	R4,R0		;FORM 2ND HALF SUBGROUP ENTRY
	MUL	F.COS,R0	;	"
	ASHC	#1,R0		;	"
	MOV	R0,F.TRT	;	"
	MOV	R5,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	ADD	R0,F.TRT	;	"
	BVS	F.OFLO
	MOV	R5,R0		;	"
	MUL	F.COS,R0	;	"
	ASHC	#1,R0		;	"
	MOV	R0,R5		;	"
	MOV	R4,R0		;	"
	MUL	F.SIN,R0	;	"
	ASHC	#1,R0		;	"
	SUB	R0,R5		;	"
	BVS	F.OFLO
	MOV	XR0,(R2)	;INSERT TRANSFORMED POINTS
	MOV	XR1,2(R2)	;     "
	MOV	F.TRT,(R3)		;     "
	MOV	R5,2(R3)	;     "
	DEC	F.K		;SUBGROUP SCAN DONE?
	BLE	F.SKP4		;BR IF ALL SUBGROUPS DONE
	ADD	F.ORG,R2	;SET UP FOR POINT IN
	ADD	F.ORG,R3	;NEXT SUBGROUP
	BR	F.ORT1		;GO DO IT
F.SKP4:	DEC	F.SCT		;DONE WITH COLUMN?
	BLE	F.SKP5		;YES, BR
	MOV	F.LL,F.K	;RE-INIT NO. OF SUBGROUPS
	ADD	F.HH,F.H	;NO, NEXT W
	ADD	#4,F.A1		;SET UP FOR NEXT
	ADD	#4,F.A2		;SUBGROUP SCAN
	JMP	F.SBGP		;GO DO IT
F.SKP5:	DEC	F.L		;N-2 COLUMNS DONE
	BLE	F.SKP1		;YES, BR TO FIRST SPEC. LOOP
	ASL	F.LL		;DOUBLE NO. OF SUBGROUPS
	ASL	F.HH		;DOUBLE TRIG INC TOO
	JMP	F.NXTC		;GO DO NEXT COLUMN
F.OFLO:	JMP	F.OFL		;JUMP TO OVERFLOW ROUTINE

;DONE WITH (LOG N)-2 COLUMNS
;NOW DO 2 SPECIAL LOOPS

;FIRST SPECIAL LOOP

F.SKP1:	MOV	F.N,F.K		;K=N/4
	ASR	F.K
	ASR	F.K
	MOV	ARRAY,R2	;R2 KEEPS TRACK OF CURRENT FOUR
F.SPL1:	MOV	#F.ORT2,F.ORTN	;SET UP OVERFLOW ROUTINE
F.ORT2:	MOV	(R2),R0
	MOV	2(R2),R1
	MOV	R0,R4
	MOV	R1,R5
	ADD	8.(R2),R0	;REAL PART OF FIRST HALF
	BVS	F.OFLO
	ADD	2+8.(R2),R1	;IMAG PART OF FIRST HALF
	BVS	F.OFLO
	SUB	8.(R2),R4	;1ST POINT IN 2ND HALF OF SBGP
	BVS	F.OFLO
	SUB	2+8.(R2),R5	;
	BVS	F.OFLO
	MOV	R0,(R2)		;STORE THE POINTS
	MOV	R1,2(R2)
	MOV	R4,8.(R2)
	MOV	R5,2+8.(R2)
	MOV	#F.ORT4,F.ORTN	;SET UP OVERFLOW ROUTINE
F.ORT4:	MOV	4(R2),R0	;DO 2ND POINTS IN SUBGROUP
	MOV	2+4(R2),R1
	MOV	R0,R4
	MOV	R1,R5
	ADD	12.(R2),R0
	BVS	F.OFLO
	ADD	2+12.(R2),R1
	BVS	F.OFLO
	SUB	2+12.(R2),R5	;REAL PART
	BVS	F.OFLO
	NEG	R4
	ADD	12.(R2),R4	;IMAGINARY PART
	BVS	F.OFLO
	TST	F.INV
	BEQ	F.SP11		;NO, SKIP
	NEG	R5		;YES, NEGATE BOTTOM POINT
	NEG	R4		;	"
F.SP11:	MOV	R0,4(R2)	;STORE THE POINTS
	MOV	R1,2+4(R2)
	MOV	R5,12.(R2)
	MOV	R4,2+12.(R2)
	ADD	#16.,R2
	DEC	F.K
	BGT	F.SPL1

;END OF FIRST SPECIAL LOOP

;SECOND SPECIAL LOOP

	BR	F.SKP3
F.OFL1:	JMP	F.OFL
F.SKP3:	MOV	ARRAY,R2
	MOV	F.N,F.M		;SET UP COUNTER
	ASR	F.M		;	"
	MOV	#F.ORT3,F.ORTN	;SET UP OVERFLOW RETURN
F.SPL2:
F.ORT3:	MOV	(R2),R0
	MOV	2(R2),R1
	MOV	R0,R4
	MOV	R1,R5
	ADD	4(R2),R0
	BVS	F.OFL1
	ADD	2+4(R2),R1
	BVS	F.OFL1
	SUB	4(R2),R4
	BVS	F.OFL1
	SUB	2+4(R2),R5
	BVS	F.OFL1
	MOV	R0,(R2)
	MOV	R1,2(R2)
	MOV	R4,4(R2)
	MOV	R5,2+4(R2)
	ADD	#8.,R2
	DEC	F.M
	BGT	F.SPL2

;END OF SECOND SPECIAL LOOP


;DO UNSCRAMBLING

F.UNSH:	MOV	#11.,X.BIT	;CALC. OFFSET IN BIT TABLE
	SUB	F.R,X.BIT	;	"
	ASL	X.BIT		;	"
	ADD	#X.S,X.BIT	;	"
	CLR	R3		;R3 COUNTS BIT REVERSED
	MOV	ARRAY,R0	;SAVE DATA ARRAY ADRS.
	MOV	F.N,F.M
	SUB	#2,F.M
	MOV	#4,R2
F.NSLP:	MOV	X.BIT,R1	;CALC. NEXT BIT
	BR	F.UN15		;REVERSED NUMBER
F.UN10:	BIC	(R1)+,R3	;	"
F.UN15:	BIT	(R1),R3		;	"
	BNE	F.UN10		;	"
	BIS	(R1),R3		;R3 NOW HAS BIT REV. NO.
	CMP	R3,R2
	BLE	F.NSCR
	ADD	R0,R2		;ADD ADRS. OF DATA ARRAY
	ADD	R0,R3		;	"
	MOV	(R2),R4
	MOV	(R3),(R2)
	MOV	R4,(R3)
	MOV	2(R2),R4
	MOV	2(R3),2(R2)
	MOV	R4,2(R3)
	SUB	R0,R2		;SUB. ADRS. OF DATA ARRAY
	SUB	R0,R3		;	"
F.NSCR:	ADD	#4,R2
	DEC	F.M
	BGT	F.NSLP
	MOV	F.N,R2		;SET Z(N)=Z(0)
	ASL	R2		;	"
	ASL	R2		;	"
	ADD	R0,R2		;	"
	MOV	(R0)+,(R2)+	;	"
	MOV	(R0),(R2)	;	"
	RTS	PC		;RETURN

X.S:	40000
	20000
	10000
	4000
	2000
	1000
	400
	200
	100
	40
	20
	10
	4
	0



;COMPUTE SPECTRAL ESTIMATES RE**2+IM**2

F.SPM:	MOV	F.N,F.M		;SET UP COUNTER
	MOV	ARRAY,R2
	MOV	R2,R4
F.ESTL:	MOV	(R2),R0
	MUL	R0,R0
	ASHC	#1,R0
	BVC	F.ESL1		;BR IF NO O'FLOW
	MOV	#77777,F.SR	;YES, SET MAX.
	BR	F.ESL2		;BR
F.ESL1:	MOV	R0,F.SR
F.ESL2:	MOV	2(R2),R0
	MUL	R0,R0
	ASHC	#1,R0
	BVC	F.ESL3		;BR IF NO O'FLOW
	ADD	#77777,F.SR	;YES, ADD MAX.
	BR	F.ESL4		;BR
F.ESL3:	ADD	R0,F.SR
F.ESL4:	BVS	F.ROFL
	MOV	F.SR,(R4)+
	CMP	(R2)+,(R2)+
	DEC	F.M
	BGE	F.ESTL
	RTS	PC


;OVERFLOW ROUTINE

F.OFL:	MOV	F.N,R0
	ASR	R0
	MOV	ARRAY,R1
F.OFLP:	ASR	(R1)+
	ASR	(R1)+
	ASR	(R1)+
	ASR	(R1)+
	DEC	R0
	BGT	F.OFLP
	ASR	(R1)+		;SHIFT LAST TWO POINTS ALSO
	ASR	(R1)		;	"
	INC	F.SCLF		;BUMP SCALE FACTOR
	JMP	@F.ORTN

F.ORTN:	0

;OVERFLOW ROUTINE FOR SPECTRAL ESTIMATES

F.ROFL:	MOV	F.N,F.MM
	ASL	F.MM
	ASL	F.MM
	MOV	ARRAY,R3
	ADD	R3,F.MM		;ADD IN DATA ARRAY ADRS.
	CMP	R3,R2
	BEQ	F.ROF2
F.ROF1:	ASR	(R3)
	ASR	(R3)+
	CMP	R2,R3
	BHI	F.ROF1
F.ROF2:	ASR	(R3)+
	ASR	(R3)+
	CMP	F.MM,R3
	BHIS	F.ROF2
	INC	F.SCLF
	JMP	F.ESTL


;SINE/COSINE TABLE


F.TRIG:	00000
	00031
	00062
	00113
	00145
	00176
	00227
	00260
	00311
	00342
	00373
	00424
	00456
	00507
	00540
	00571
	00622
	00653
	00704
	00736
	00767
	01020
	01051
	01102
	01133
	01164
	01215
	01247
	01300
	01331
	01362
	01413
	01444
	01475
	01526
	01560
	01611
	01642
	01673
	01724
	01755
	02006
	02037
	02071
	02122
	02153
	02204
	02235
	02266
	02317
	02350
	02401
	02433
	02464
	02515
	02546
	02577
	02630
	02661
	02712
	02743
	02775
	03026
	03057
	03110
	03141
	03172
	03223
	03254
	03305
	03336
	03370
	03421
	03452
	03503
	03534
	03565
	03616
	03647
	03700
	03731
	03762
	04014
	04045
	04076
	04127
	04160
	04211
	04242
	04273
	04324
	04355
	04406
	04437
	04470
	04521
	04553
	04604
	04635
	04666
	04717
	04750
	05001
	05032
	05063
	05114
	05145
	05176
	05227
	05260
	05311
	05342
	05373
	05424
	05455
	05507
	05540
	05571
	05622
	05653
	05704
	05735
	05766
	06017
	06050
	06101
	06132
	06163
	06214
	06245
	06276
	06327
	06360
	06411
	06442
	06473
	06524
	06555
	06606
	06637
	06670
	06721
	06752
	07003
	07034
	07065
	07116
	07147
	07200
	07231
	07262
	07313
	07344
	07374
	07425
	07456
	07507
	07540
	07571
	07622
	07653
	07704
	07735
	07766
	10017
	10050
	10101
	10132
	10163
	10214
	10244
	10275
	10326
	10357
	10410
	10441
	10472
	10523
	10554
	10605
	10636
	10666
	10717
	10750
	11001
	11032
	11063
	11114
	11145
	11175
	11226
	11257
	11310
	11341
	11372
	11423
	11453
	11504
	11535
	11566
	11617
	11650
	11701
	11731
	11762
	12013
	12044
	12075
	12125
	12156
	12207
	12240
	12271
	12321
	12352
	12403
	12434
	12465
	12515
	12546
	12577
	12630
	12661
	12711
	12742
	12773
	13024
	13054
	13105
	13136
	13167
	13217
	13250
	13301
	13332
	13362
	13413
	13444
	13474
	13525
	13556
	13607
	13637
	13670
	13721
	13751
	14002
	14033
	14063
	14114
	14145
	14175
	14226
	14257
	14307
	14340
	14371
	14421
	14452
	14503
	14533
	14564
	14615
	14645
	14676
	14726
	14757
	15010
	15040
	15071
	15121
	15152
	15203
	15233
	15264
	15314
	15345
	15376
	15426
	15457
	15507
	15540
	15570
	15621
	15651
	15702
	15732
	15763
	16014
	16044
	16075
	16125
	16156
	16206
	16237
	16267
	16320
	16350
	16401
	16431
	16461
	16512
	16542
	16573
	16623
	16654
	16704
	16735
	16765
	17016
	17046
	17076
	17127
	17157
	17210
	17240
	17270
	17321
	17351
	17402
	17432
	17462
	17513
	17543
	17573
	17624
	17654
	17705
	17735
	17765
	20016
	20046
	20076
	20127
	20157
	20207
	20237
	20270
	20320
	20350
	20401
	20431
	20461
	20511
	20542
	20572
	20622
	20652
	20703
	20733
	20763
	21013
	21044
	21074
	21124
	21154
	21204
	21235
	21265
	21315
	21345
	21375
	21426
	21456
	21506
	21536
	21566
	21616
	21647
	21677
	21727
	21757
	22007
	22037
	22067
	22117
	22147
	22200
	22230
	22260
	22310
	22340
	22370
	22420
	22450
	22500
	22530
	22560
	22610
	22640
	22670
	22720
	22750
	23000
	23030
	23060
	23110
	23140
	23170
	23220
	23250
	23300
	23330
	23360
	23410
	23440
	23470
	23520
	23550
	23600
	23627
	23657
	23707
	23737
	23767
	24017
	24047
	24077
	24126
	24156
	24206
	24236
	24266
	24316
	24345
	24375
	24425
	24455
	24505
	24534
	24564
	24614
	24644
	24674
	24723
	24753
	25003
	25033
	25062
	25112
	25142
	25171
	25221
	25251
	25301
	25330
	25360
	25410
	25437
	25467
	25517
	25546
	25576
	25625
	25655
	25705
	25734
	25764
	26014
	26043
	26073
	26122
	26152
	26201
	26231
	26261
	26310
	26340
	26367
	26417
	26446
	26476
	26525
	26555
	26604
	26634
	26663
	26713
	26742
	26772
	27021
	27050
	27100
	27127
	27157
	27206
	27236
	27265
	27314
	27344
	27373
	27423
	27452
	27501
	27531
	27560
	27607
	27637
	27666
	27715
	27745
	27774
	30023
	30052
	30102
	30131
	30160
	30210
	30237
	30266
	30315
	30345
	30374
	30423
	30452
	30501
	30531
	30560
	30607
	30636
	30665
	30714
	30744
	30773
	31022
	31051
	31100
	31127
	31156
	31205
	31235
	31264
	31313
	31342
	31371
	31420
	31447
	31476
	31525
	31554
	31603
	31632
	31661
	31710
	31737
	31766
	32015
	32044
	32073
	32122
	32151
	32200
	32227
	32255
	32304
	32333
	32362
	32411
	32440
	32467
	32516
	32544
	32573
	32622
	32651
	32700
	32727
	32755
	33004
	33033
	33062
	33110
	33137
	33166
	33215
	33243
	33272
	33321
	33350
	33376
	33425
	33454
	33502
	33531
	33560
	33606
	33635
	33664
	33712
	33741
	33767
	34016
	34045
	34073
	34122
	34150
	34177
	34225
	34254
	34302
	34331
	34360
	34406
	34435
	34463
	34511
	34540
	34566
	34615
	34643
	34672
	34720
	34747
	34775
	35023
	35052
	35100
	35127
	35155
	35203
	35232
	35260
	35306
	35335
	35363
	35411
	35440
	35466
	35514
	35542
	35571
	35617
	35645
	35673
	35722
	35750
	35776
	36024
	36052
	36101
	36127
	36155
	36203
	36231
	36257
	36305
	36334
	36362
	36410
	36436
	36464
	36512
	36540
	36566
	36614
	36642
	36670
	36716
	36744
	36772
	37020
	37046
	37074
	37122
	37150
	37176
	37224
	37252
	37300
	37326
	37354
	37401
	37427
	37455
	37503
	37531
	37557
	37605
	37632
	37660
	37706
	37734
	37761
	40007
	40035
	40063
	40110
	40136
	40164
	40212
	40237
	40265
	40313
	40340
	40366
	40414
	40441
	40467
	40515
	40542
	40570
	40615
	40643
	40671
	40716
	40744
	40771
	41017
	41044
	41072
	41117
	41145
	41172
	41220
	41245
	41273
	41320
	41346
	41373
	41420
	41446
	41473
	41521
	41546
	41573
	41621
	41646
	41673
	41721
	41746
	41773
	42021
	42046
	42073
	42120
	42146
	42173
	42220
	42245
	42272
	42320
	42345
	42372
	42417
	42444
	42471
	42517
	42544
	42571
	42616
	42643
	42670
	42715
	42742
	42767
	43014
	43041
	43066
	43113
	43140
	43165
	43212
	43237
	43264
	43311
	43336
	43363
	43410
	43435
	43462
	43507
	43534
	43560
	43605
	43632
	43657
	43704
	43731
	43755
	44002
	44027
	44054
	44100
	44125
	44152
	44177
	44223
	44250
	44275
	44321
	44346
	44373
	44417
	44444
	44471
	44515
	44542
	44566
	44613
	44640
	44664
	44711
	44735
	44762
	45006
	45033
	45057
	45104
	45130
	45155
	45201
	45225
	45252
	45276
	45323
	45347
	45373
	45420
	45444
	45470
	45515
	45541
	45565
	45612
	45636
	45662
	45707
	45733
	45757
	46003
	46027
	46054
	46100
	46124
	46150
	46174
	46221
	46245
	46271
	46315
	46341
	46365
	46411
	46435
	46461
	46505
	46531
	46555
	46601
	46625
	46651
	46675
	46721
	46745
	46771
	47015
	47041
	47065
	47111
	47135
	47161
	47204
	47230
	47254
	47300
	47324
	47350
	47373
	47417
	47443
	47467
	47512
	47536
	47562
	47605
	47631
	47655
	47700
	47724
	47750
	47773
	50017
	50043
	50066
	50112
	50135
	50161
	50204
	50230
	50254
	50277
	50323
	50346
	50371
	50415
	50440
	50464
	50507
	50533
	50556
	50601
	50625
	50650
	50673
	50717
	50742
	50765
	51011
	51034
	51057
	51103
	51126
	51151
	51174
	51220
	51243
	51266
	51311
	51334
	51357
	51403
	51426
	51451
	51474
	51517
	51542
	51565
	51610
	51633
	51656
	51701
	51724
	51747
	51772
	52015
	52040
	52063
	52106
	52131
	52154
	52177
	52221
	52244
	52267
	52312
	52335
	52360
	52402
	52425
	52450
	52473
	52516
	52540
	52563
	52606
	52630
	52653
	52676
	52720
	52743
	52766
	53010
	53033
	53055
	53100
	53123
	53145
	53170
	53212
	53235
	53257
	53302
	53324
	53347
	53371
	53414
	53436
	53460
	53503
	53525
	53547
	53572
	53614
	53637
	53661
	53703
	53725
	53750
	53772
	54014
	54036
	54061
	54103
	54125
	54147
	54171
	54214
	54236
	54260
	54302
	54324
	54346
	54370
	54412
	54434
	54456
	54500
	54522
	54544
	54566
	54610
	54632
	54654
	54676
	54720
	54742
	54764
	55006
	55030
	55051
	55073
	55115
	55137
	55161
	55202
	55224
	55246
	55270
	55311
	55333
	55355
	55377
	55420
	55442
	55464
	55505
	55527
	55550
	55572
	55614
	55635
	55657
	55700
	55722
	55743
	55765
	56006
	56030
	56051
	56072
	56114
	56135
	56157
	56200
	56221
	56243
	56264
	56305
	56327
	56350
	56371
	56413
	56434
	56455
	56476
	56520
	56541
	56562
	56603
	56624
	56645
	56667
	56710
	56731
	56752
	56773
	57014
	57035
	57056
	57077
	57120
	57141
	57162
	57203
	57224
	57245
	57266
	57307
	57327
	57350
	57371
	57412
	57433
	57454
	57474
	57515
	57536
	57557
	57600
	57620
	57641
	57662
	57702
	57723
	57744
	57764
	60005
	60026
	60046
	60067
	60107
	60130
	60150
	60171
	60211
	60232
	60252
	60273
	60313
	60334
	60354
	60375
	60415
	60435
	60456
	60476
	60516
	60537
	60557
	60577
	60620
	60640
	60660
	60700
	60721
	60741
	60761
	61001
	61021
	61041
	61062
	61102
	61122
	61142
	61162
	61202
	61222
	61242
	61262
	61302
	61322
	61342
	61362
	61402
	61422
	61442
	61462
	61502
	61521
	61541
	61561
	61601
	61621
	61640
	61660
	61700
	61720
	61737
	61757
	61777
	62017
	62036
	62056
	62076
	62115
	62135
	62154
	62174
	62213
	62233
	62253
	62272
	62312
	62331
	62351
	62370
	62407
	62427
	62446
	62466
	62505
	62524
	62544
	62563
	62602
	62622
	62641
	62660
	62700
	62717
	62736
	62755
	62774
	63014
	63033
	63052
	63071
	63110
	63127
	63146
	63165
	63204
	63223
	63243
	63262
	63301
	63320
	63336
	63355
	63374
	63413
	63432
	63451
	63470
	63507
	63526
	63544
	63563
	63602
	63621
	63640
	63656
	63675
	63714
	63732
	63751
	63770
	64006
	64025
	64044
	64062
	64101
	64120
	64136
	64155
	64173
	64212
	64230
	64247
	64265
	64304
	64322
	64340
	64357
	64375
	64414
	64432
	64450
	64467
	64505
	64523
	64541
	64560
	64576
	64614
	64632
	64651
	64667
	64705
	64723
	64741
	64757
	64775
	65013
	65032
	65050
	65066
	65104
	65122
	65140
	65156
	65174
	65211
	65227
	65245
	65263
	65301
	65317
	65335
	65353
	65370
	65406
	65424
	65442
	65460
	65475
	65513
	65531
	65546
	65564
	65602
	65617
	65635
	65652
	65670
	65706
	65723
	65741
	65756
	65774
	66011
	66027
	66044
	66062
	66077
	66114
	66132
	66147
	66165
	66202
	66217
	66235
	66252
	66267
	66304
	66322
	66337
	66354
	66371
	66406
	66424
	66441
	66456
	66473
	66510
	66525
	66542
	66557
	66574
	66611
	66626
	66643
	66660
	66675
	66712
	66727
	66744
	66761
	66776
	67012
	67027
	67044
	67061
	67076
	67112
	67127
	67144
	67161
	67175
	67212
	67227
	67243
	67260
	67275
	67311
	67326
	67342
	67357
	67373
	67410
	67424
	67441
	67455
	67472
	67506
	67523
	67537
	67553
	67570
	67604
	67620
	67635
	67651
	67665
	67702
	67716
	67732
	67746
	67762
	67777
	70013
	70027
	70043
	70057
	70073
	70107
	70123
	70137
	70153
	70167
	70203
	70217
	70233
	70247
	70263
	70277
	70313
	70327
	70343
	70357
	70372
	70406
	70422
	70436
	70452
	70465
	70501
	70515
	70530
	70544
	70560
	70573
	70607
	70623
	70636
	70652
	70665
	70701
	70714
	70730
	70743
	70757
	70772
	71006
	71021
	71034
	71050
	71063
	71077
	71112
	71125
	71140
	71154
	71167
	71202
	71215
	71231
	71244
	71257
	71272
	71305
	71320
	71334
	71347
	71362
	71375
	71410
	71423
	71436
	71451
	71464
	71477
	71512
	71525
	71537
	71552
	71565
	71600
	71613
	71626
	71640
	71653
	71666
	71701
	71713
	71726
	71741
	71753
	71766
	72001
	72013
	72026
	72041
	72053
	72066
	72100
	72113
	72125
	72140
	72152
	72165
	72177
	72211
	72224
	72236
	72250
	72263
	72275
	72307
	72322
	72334
	72346
	72360
	72373
	72405
	72417
	72431
	72443
	72455
	72470
	72502
	72514
	72526
	72540
	72552
	72564
	72576
	72610
	72622
	72634
	72646
	72657
	72671
	72703
	72715
	72727
	72741
	72752
	72764
	72776
	73010
	73021
	73033
	73045
	73056
	73070
	73102
	73113
	73125
	73136
	73150
	73162
	73173
	73205
	73216
	73230
	73241
	73252
	73264
	73275
	73307
	73320
	73331
	73343
	73354
	73365
	73376
	73410
	73421
	73432
	73443
	73455
	73466
	73477
	73510
	73521
	73532
	73543
	73554
	73565
	73576
	73607
	73620
	73631
	73642
	73653
	73664
	73675
	73706
	73717
	73730
	73740
	73751
	73762
	73773
	74003
	74014
	74025
	74036
	74046
	74057
	74070
	74100
	74111
	74121
	74132
	74143
	74153
	74164
	74174
	74205
	74215
	74225
	74236
	74246
	74257
	74267
	74277
	74310
	74320
	74330
	74341
	74351
	74361
	74371
	74401
	74412
	74422
	74432
	74442
	74452
	74462
	74472
	74502
	74512
	74523
	74533
	74542
	74552
	74562
	74572
	74602
	74612
	74622
	74632
	74642
	74652
	74661
	74671
	74701
	74711
	74720
	74730
	74740
	74747
	74757
	74767
	74776
	75006
	75016
	75025
	75035
	75044
	75054
	75063
	75073
	75102
	75111
	75121
	75130
	75140
	75147
	75156
	75166
	75175
	75204
	75214
	75223
	75232
	75241
	75250
	75260
	75267
	75276
	75305
	75314
	75323
	75332
	75341
	75350
	75357
	75366
	75375
	75404
	75413
	75422
	75431
	75440
	75447
	75456
	75464
	75473
	75502
	75511
	75520
	75526
	75535
	75544
	75552
	75561
	75570
	75576
	75605
	75613
	75622
	75631
	75637
	75646
	75654
	75663
	75671
	75677
	75706
	75714
	75723
	75731
	75737
	75746
	75754
	75762
	75771
	75777
	76005
	76013
	76021
	76030
	76036
	76044
	76052
	76060
	76066
	76074
	76102
	76110
	76116
	76124
	76132
	76140
	76146
	76154
	76162
	76170
	76176
	76203
	76211
	76217
	76225
	76233
	76240
	76246
	76254
	76261
	76267
	76275
	76302
	76310
	76316
	76323
	76331
	76336
	76344
	76351
	76357
	76364
	76372
	76377
	76405
	76412
	76417
	76425
	76432
	76437
	76445
	76452
	76457
	76464
	76472
	76477
	76504
	76511
	76516
	76523
	76530
	76535
	76543
	76550
	76555
	76562
	76567
	76574
	76601
	76605
	76612
	76617
	76624
	76631
	76636
	76643
	76647
	76654
	76661
	76666
	76672
	76677
	76704
	76711
	76715
	76722
	76726
	76733
	76740
	76744
	76751
	76755
	76762
	76766
	76773
	76777
	77003
	77010
	77014
	77021
	77025
	77031
	77036
	77042
	77046
	77052
	77057
	77063
	77067
	77073
	77077
	77103
	77110
	77114
	77120
	77124
	77130
	77134
	77140
	77144
	77150
	77154
	77160
	77164
	77170
	77173
	77177
	77203
	77207
	77213
	77216
	77222
	77226
	77232
	77235
	77241
	77245
	77250
	77254
	77260
	77263
	77267
	77272
	77276
	77301
	77305
	77310
	77314
	77317
	77323
	77326
	77331
	77335
	77340
	77343
	77347
	77352
	77355
	77360
	77364
	77367
	77372
	77375
	77400
	77403
	77406
	77412
	77415
	77420
	77423
	77426
	77431
	77434
	77437
	77442
	77444
	77447
	77452
	77455
	77460
	77463
	77466
	77470
	77473
	77476
	77501
	77503
	77506
	77511
	77513
	77516
	77520
	77523
	77526
	77530
	77533
	77535
	77540
	77542
	77545
	77547
	77552
	77554
	77556
	77561
	77563
	77565
	77570
	77572
	77574
	77576
	77601
	77603
	77605
	77607
	77611
	77613
	77616
	77620
	77622
	77624
	77626
	77630
	77632
	77634
	77636
	77640
	77642
	77643
	77645
	77647
	77651
	77653
	77655
	77656
	77660
	77662
	77664
	77665
	77667
	77671
	77672
	77674
	77676
	77677
	77701
	77702
	77704
	77705
	77707
	77710
	77712
	77713
	77715
	77716
	77717
	77721
	77722
	77723
	77725
	77726
	77727
	77731
	77732
	77733
	77734
	77735
	77736
	77740
	77741
	77742
	77743
	77744
	77745
	77746
	77747
	77750
	77751
	77752
	77753
	77754
	77754
	77755
	77756
	77757
	77760
	77761
	77761
	77762
	77763
	77764
	77764
	77765
	77766
	77766
	77767
	77767
	77770
	77770
	77771
	77771
	77772
	77772
	77773
	77773
	77774
	77774
	77775
	77775
	77775
	77776
	77776
	77776
	77776
	77777
	77777
	77777
	77777
	77777
	77777
	77777
	77777
	77777
	77777
	77777
	77777
	77777

	.END

                                                                                                                                                                                                                                                                                           