	.ENABLE SUBSTITUTION
	.ENABLE GLOBAL
	.SETT TSC
.;
.;
.;	Command file used to generate MTREK for an RSX-11M or
.;	RSX-11M+ system.
.;
.;
;===========================================================================
;
;				MTREKGEN
;
;		    MTREK-PLUS generation command file
;
;===========================================================================
.;
.;	GET DEVICE INFORMATION
.;
.GETIN:
	;
	.ASKS INDEV Enter input device [D=SY0:]
	.IF <STRLEN> EQ 0 .SETS INDEV "SY0:"
	.TESTDEVICE 'INDEV'
	.PARSE <EXSTRI> "," DEV OTHER
	.IF DEV NE "NSD" .GOTO GETOUT
	.GOSUB BADDEV
	.GOTO GETIN
	.;
.GETOUT:
	;
	.ASKS OUTDEV Enter output device [D=SY0:]
	.IF <STRLEN> EQ 0 .SETS OUTDEV "SY0:"
	.TESTDEVICE 'OUTDEV'
	.PARSE <EXSTRI> "," DEV OTHER
	.IF DEV NE "NSD" .GOTO GETMAP
	.GOSUB BADDEV
	.GOTO GETOUT
.;
.GETMAP:
	;
	.ASKS MAPDEV Enter map device [D=NL:]
	.IF <STRLEN> EQ 0 .SETS MAPDEV "NL:"
	.TESTDEVICE 'MAPDEV'
	.PARSE <EXSTRI> "," DEV OTHER
	.IF DEV NE "NSD" .GOTO  CHKFIL
	.GOSUB BADDEV
	.GOTO GETMAP
.;
.BADDEV:
	;
	; 	MTREKGEN ** Error ** Invalid device or unit
	.RETURN
.CHKFIL:
;
;===========================================================================
;
;	Checking for required installation files
;
;===========================================================================
;
	ASN 'INDEV'=IN:
	ASN 'OUTDEV'=OU:
	ASN 'MAPDEV'=MP:
	.TESTFILE IN:MTREK.ODL
	.IF <FILERR> NE 1 .GOTO NOTFND
	.TESTFILE IN:PLAYER.ODL
	.IF <FILERR> NE 1 .GOTO NOTFND
	.TESTFILE IN:DUMPER.ODL
	.IF <FILERR> NE 1 .GOTO NOTFND
	.TESTFILE IN:TRDEMO.ODL
	.IF <FILERR> NE 1 .GOTO NOTFND
	.TESTFILE IN:MTREK.OLB
	.IF <FILERR> NE 1 .GOTO NOTFND
	.TESTFILE IN:DUMPER.OLB
	.IF <FILERR> NE 1 .GOTO NOTFND
	.TESTFILE IN:PLAYER.OLB
	.IF <FILERR> NE 1 .GOTO NOTFND
	.TESTFILE IN:EXTRAS.OLB
	.IF <FILERR> NE 1 .GOTO NOTFND
	.SETF HLPAVL
	.SETF LBHLP
	.TESTFILE LB:[1,2]TREKHELP.HLP
	.IF <FILERR> EQ 1 .SETT LBHLP
	.IFF LBHLP .TESTFILE IN:TREKHELP.HLP
	.IF <FILERR> EQ 1 .SETT HLPAVL
	.IFT HLPAVL .OR .IFT LBHLP .GOTO HLPOK
	;
	;	No help file found, help will not be available during game
	.GOTO GETSYS
.HLPOK:
	.IFT LBHLP .GOTO GETSYS
	;
	;	Copying help file to LB:[1,2]TREKHELP.HLP
	;
	PIP LB:[1,2]/NV=IN:TREKHELP.HLP
	.GOTO GETSYS
.NOTFND:
;
;	All required installation files were not found.  Please copy them
;	from your distribution and continue this process.
	.PAUSE
.GOTO CHKFIL
.;
.;	Parse a copy of PLAYER.TKB to see all the defaults taken
.;
.GETSYS:
	.SETF BLDSUP
	.SETS SUPL ""
	.SETS APR ":6"
	.SETS MUSW ""
	.SETS IDSW ""
	.SETF BLDID
	.SETF BLDMU
	.SETS MMR "/-RO"
	.SETT PRO
	.SETF PCP
	.SETT YESNO
.;
;
;===========================================================================
	.TESTFILE PLAYER.TKB
	.IF <FILERR> EQ 1 .GOTO GOTONE
;
;	No exiting configuration found...
;
	.GOTO GTSYS
.GOTONE:
;
;	Examining current configuration...
;
	.OPENR PLAYER.TKB
.;
	.SETN PX 0
.GETRC:
	.INC PX
	.READ REC
	.IF PX LT 4 .GOTO GETRC
.;
.;	Got the first good record
.;
	.TEST REC
	.SETS PCHR REC['<STRLEN>':'<STRLEN>']
	.IF PCHR EQ "+" .SETT MPLUS
.;
.;	Skip next record
.;
	.READ REC
	.READ REC
	.PARSE REC "," STG OTHER
.;
.;	At this point, parse out all the switches present, since all we
.;	are left with is the command line up to the map file specification.
.;
	.PARSE STG "/" OTHER SW1 SW2 SW3 SW4 SW5
.;
.;	Now we just have the switches left
.;
	.SETS TMP "'SW1'"
	.GOSUB CHECK
	.SETS TMP "'SW2'"
	.GOSUB CHECK
	.SETS TMP "'SW3'"
	.GOSUB CHECK
	.SETS TMP "'SW4'"
	.GOSUB CHECK
	.SETS TMP "'SW5'"
	;
	;	Information found for current configuration:
	;	-------------------------------------------
	;
	.IFF MPLUS ;	Built for RSX-11M
	.IFT MPLUS ;	Built for RSX-11M-Plus
	.IFF BLDMU .GOTO CH1
	.SETS MUSW "/MU"
	.SETS APR ""
	;	Multi-user
.CH1:
	.IFT PRO .GOTO CH1A
	.SETS MMR "/-RO"
	;	Disk-resident overlays
	.GOTO CH2
.CH1A:
	.SETS MMR ""
	;	Memory-resident overlays
.CH2:
	.IFF BLDID .GOTO CH3
	.SETS IDSW "/ID"
	.SETS APR ""
	;	I/D space support
.CH3:
	.IFF PCP .GOTO CHKSUP
	;	Checkpointable
.;
.;	Last thing left is to check for supervisor mode library support
.;
.CHKSUP:
	.READ REC
	.IFT <EOF> .GOTO DONE
	.PARSE REC ":" X REST
	.IF REST NE "SV" .GOTO CHKSUP
	.PARSE X "=" Y SUPL
	;	Supervisor-mode library = 'SUPL'
	.SETT BLDSUP
	.GOTO DONE
.;
.;	Routine to check and see what a switch is
.;
.CHECK:
	.IF TMP EQ "ID" .SETT BLDID
	.IF TMP EQ "MU" .SETT BLDMU
	.IF TMP EQ "-RO" .SETF PRO
	.IF TMP EQ "CP" .SETT PCP
	.RETURN
.;
.;	If no PLAYER.TKB found, or operator wants new configuration, ask
.;	the rest of the questions, or just skip down and build.
.;
.DONE:
	.CLOSE
	;
	.ASK YESNO Do you wish to override the current configuration
	.IFF YESNO .GOTO BUILD
.GTSYS:
	;
	.SETS $SYS "RSX11M+"
	.IF <SYSTEM> EQ 1 .SETS $SYS "RSX11M"
	.ASKS SYS Enter target operating system [D='$SYS']
	.SETF MPLUS
	.IF <STRLEN> EQ 0 .SETS SYS "'$SYS'"
	.IF SYS EQ "RSX11M+" .SETT MPLUS
	.IF SYS NE "RSX11M" .AND .IF SYS NE "RSX11M+" .GOTO GETSYS
.;
.;	GET MPLUS SWITCHES
.;
	.IFF MPLUS .GOTO GETRES
;
;===========================================================================
;
	.SETS SUPL ""
	.ASK BLDSUP Build task with supervisor mode FCS library
	.IFF BLDSUP .GOTO MUTASK
	;
	.ASKS SUPL Enter supervisor mode FCS library name [D=FCSFSL]
	.IF <STRLEN> EQ 0 .SETS SUPL "FCSFSL"
.;
.MUTASK:
	;
	.ASK BLDID Build task with I/D space support
	.IFF BLDID .GOTO SKIPMU
	;
	.ASK BLDMU Build task multi-user
.SKIPMU:
	.IFT BLDMU .SETS MUSW "/MU"
	.IFT BLDID .SETS IDSW "/ID"
	.IFT BLDMU .OR .IFT BLDID .SETS APR ""
.;
.;	BUILD PROPER COMMAND FILES
.;
	.GETRES:
.;
.;	See if memory resident overlays are desired
.;
	.IFF BLDSUP .GOTO BUILD
	;
	.ASK MEMRES Build tasks with memory resident overlays
	.IFT MEMRES .SETS MMR ""
.;
.BUILD:
.;
	.SETF MTREK
	.SETF DUMPER
	.SETF PLAYER
	.SETF TRDEMO
	.SETF TRKCOM
	.SETF PLAYEM
	.SETF UNICOM
	.SETF NEWINS
.;
	;
	.ASK COMPON Performing a component-mode generation
	;
	.ASK BLDNEW Supercede existing .TKB command files
	.IFT COMPON .GOTO DONSUP
	;
	.ASK NEWINS Supercede existing TREK.CMD file
.DONSUP:
	.IFF COMPON .GOTO DOALL
	;
.;
.COMLOP:
	.ASKS NAMES Enter component name, one per line, <cr> to end
	.IF <STRLEN> EQ 0 .GOTO BLDTKB
	.IF NAMES EQ "DUMPER" .SETT DUMPER
	.IF NAMES EQ "MTREK" .SETT MTREK
	.IF NAMES EQ "PLAYER" .SETT PLAYER
	.IF NAMES EQ "TRDEMO" .SETT TRDEMO
	.IF NAMES EQ "PLAYEM" .SETT PLAYEM
	.IF NAMES EQ "TRKCOM" .SETT TRKCOM
	.IF NAMES EQ "UNICOM" .SETT UNICOM
	.GOTO COMLOP
.;
.DOALL:
	.SETT DUMPER
	.SETT MTREK
	.SETT PLAYER
	.SETT TRDEMO
	.SETT TRKCOM
	.SETT PLAYEM
	.SETT UNICOM
.;
.BLDTKB:
;
;===========================================================================
;
;	Building taskbuild files
;
;===========================================================================
	.IFF MTREK .GOTO TST1
	.TESTFILE MTREK.TKB
	.IFF BLDNEW .IF <FILERR> EQ 1 .GOTO TST1
	.OPEN MTREK.TKB
.ENABLE DATA
;
;	MTREK.TKB
;
;	BUILT ON '<DATE>' AT '<TIME>' FOR '$SYS'
;
OU:MTREK/PR:0/FP/CP'MMR',MP:MTREK/-WI/-SP=IN:MTREK/MP
.DISABLE DATA
.IFT TSC .DATA PRI=10
.ENABLE DATA
TASK=MTP...
RESCOM=TRKCOM/RW:6
WNDWS=1
//
.DISABLE DATA
.CLOSE
.;
.TST1:
	.IFF PLAYER .GOTO TST2
	.TESTFILE PLAYER.TKB
	.IFF BLDNEW .IF <FILERR> EQ 1 .GOTO TST2
	.OPEN PLAYER.TKB
.ENABLE DATA
;
;	PLAYER.TKB
;
;	BUILT ON '<DATE>' AT '<TIME>' FOR '$SYS'
;
OU:PLAYER'IDSW''MUSW''MMR'/CP/FP,MP:PLAYER/-WI/-SP=IN:PLAYER/MP
RESCOM=TRKCOM/RW'APR'
.DISABLE DATA
.IFT MPLUS .IFT BLDSUP .DATA SUPLIB='SUPL':SV
.ENABLE DATA
TASK=...PLA
.DISABLE DATA
.IFT TSC .DATA PRI=10
.ENABLE DATA
WNDWS=1
.DISABLE DATA
.IFF BLDID .IFF BLDMU .GOTO LAST
.ENABLE DATA
;
;	This global patch must be included to map a multi-user task
;	to the correct window, which in this version exists at 60000
;	in both I/D space
;
GBLPAT=PLAYER:WDB:1400
;	Use APR 3
.DISABLE DATA
.LAST:
.ENABLE DATA
ACTFIL=3
//
.DISABLE DATA
.CLOSE
.;
.TST2:
	.SETF PLAYEM
	.IFF PLAYEM .GOTO TST3
	.TESTFILE PLAYEM.TKB
	.IFF BLDNEW .IF <FILERR> EQ 1 .GOTO TST3
	.OPEN PLAYEM.TKB
.ENABLE DATA
;
;	PLAYEM.TKB
;
;	BUILT ON '<DATE>' AT '<TIME>' FOR '$SYS'
;
OU:PLAYEM/CP/FP'MMR',MP:PLAYEM/-SP/-WI=IN:EXTRAS/LB:PLAYEM:GETINT:GETCHR
IN:EXTRAS/LB:RDLINE:POSITN:ATTUNI:UNIV:CURWRT:PLAY
IN:EXTRAS/LB:SCANER:INTERS,LB:[1,1]F77OTS/LB
/
RESCOM=TRKCOM/RW:6
.DISABLE DATA
.IFT TSC .DATA PRI=10
.ENABLE DATA
WNDWS=1
//
.DISABLE DATA
.CLOSE
.;
.TST3:
	.IFF TRDEMO .GOTO TST4
	.TESTFILE TRDEMO.TKB
	.IFF BLDNEW .IF <FILERR> EQ 1 .GOTO TST4
	.OPEN TRDEMO.TKB
.ENABLE DATA
;
;	TRDEMO.TKB
;
;	BUILT ON '<DATE>' AT '<TIME>' FOR '$SYS'
;
OU:TRDEMO/CP/FP'MMR',MP:TRDEMO/-WI/-SP=IN:TRDEMO/MP
RESCOM=TRKCOM/RW:6
MAXBUF=512
TASK=...TRD
.DISABLE DATA
.IFT TSC .DATA PRI=10
.ENABLE DATA
WNDWS=1
//
.DISABLE DATA
.CLOSE
.;
.TST4:
	.IFF TRKCOM .GOTO TST5
	.TESTFILE TRKCOM.TKB
	.IFF BLDNEW .IF <FILERR> EQ 1 .GOTO TST5
	.OPEN TRKCOM.TKB
.ENABLE DATA
OU:TRKCOM/CP/-HD/PI,,TRKCOM=IN:EXTRAS/LB:.DATA.,LB:[1,1]F77OTS/LB
/
.DISABLE DATA
.IFF MPLUS .DATA PAR=TRKCOM:140000:20000
.ENABLE DATA
STACK=0
UNITS=0
//
.DISABLE DATA
.CLOSE
.;
.TST5:
	.IFF UNICOM .GOTO TST6
	.TESTFILE UNICOM.TKB
	.IFF BLDNEW .IF <FILERR> EQ 1 .GOTO TST6
	.OPEN UNICOM.TKB
.ENABLE DATA
OU:UNICOM/CP/-HD/PI,,UNICOM=IN:EXTRAS/LB:UNICOM
/
.DISABLE DATA
.IFF MPLUS .DATA PAR=UNICOM:0:0
.ENABLE DATA
STACK=0
UNITS=0
//
.DISABLE DATA
.CLOSE
.;
.TST6:
	.IFF DUMPER .GOTO TST7
	.TESTFILE DUMPER.TKB
	.IFF BLDNEW .IF <FILERR> EQ 1 .GOTO TST7
	.OPEN DUMPER.TKB
.ENABLE DATA
;
;	DUMPER.TKB
;
;	BUILT ON '<DATE>' AT '<TIME>' FOR '$SYS'
;
OU:DUMPER/CP/FP'MMR',MP:DUMPER/-WI/-SP=IN:DUMPER/MP
RESCOM=TRKCOM/RW:6
MAXBUF=150
TASK=...MDA
.DISABLE DATA
.IFT TSC .DATA PRI=10
.ENABLE DATA
WNDWS=1
//
.DISABLE DATA
.CLOSE
;
;	All operator intervention has now been completed and MTREK-PLUS will
;	now build.  This process may take up to 1/2 hour.
;
;		Begin MTREK-PLUS taskbuilds at '<TIME>'
;
;===========================================================================
;
.TST7:
	.IFNINS TKB INS $TKB
	;
	.IFT TRKCOM TKB @TRKCOM.TKB
	.IFT UNICOM TKB @UNICOM.TKB
	.IFT PLAYER TKB @PLAYER.TKB
	.IFT PLAYEM TKB @PLAYEM.TKB
	.IFT MTREK TKB @MTREK.TKB
	.IFT TRDEMO TKB @TRDEMO.TKB
	.IFT DUMPER TKB @DUMPER.TKB
;
;===========================================================================
;
;	MTREK-PLUS generation is now complete at '<TIME>'.
	.IFT MPLUS .GOTO REST
;
;	You must create a 4kw partition called TRKCOM and a 32kw partition
;	called UNICOM prior to bringing up MTREK-PLUS.
.REST:
;
;	To install MTREK-PLUS, invoke the command file TREK.CMD.
;
;===========================================================================
	.TESTFILE TREK.CMD
	.IFT NEWINS .OR .IF <FILERR> NE 1 .GOTO NEEDIT
	.STOP
.NEEDIT:
	.OPEN TREK.CMD
.IFT MPLUS .GOTO BLD2
.DISABLE SUBSTITUTION
.ENABLE DATA
.ENABLE SUBSTITUTION
.TESTPARTITION GEN
.PARSE <EXSTRI> "," F1 BASE SIZE TYPE
.SETN GENSIZ 'SIZE'-2201
.SETN TRKBAS 'BASE'+'GENSIZ'
.SETN UNIBAS 'TRKBAS'+200
SET /TOP=GEN:-2202
SET /MAIN=TRKCOM:'TRKBAS':200:COM
SET /MAIN=UNICOM:'UNIBAS':2000:COM
.DISABLE DATA
.BLD2:
.ENABLE DATA
INS TRKCOM
INS UNICOM
INS MTREK
INS PLAYER
INS DUMPER
INS TRDEMO
.CLOSE
