.;	DIR.CMD
.;
.; 	PRINT A LIST OF THE ENTRIES IN A DIRECTORY FILE
.;	   ON THE USERS TERMINAL
.;
.;	AUTHOR:	ANTHONY E. LEVAN
.;		SYSTEMS RESEARCH LABORATORIES
.;		2800 INDIAN RIPPLE ROAD
.;		DAYTON, OHIO  45440
.;		513-426-6000
.;
.;	THIS SOFTWARE WAS WRITTEN UNDER CONTRACT WITH THE
.;	UNITED STATES AIR FORCE.
.;
.;	DEFINE THE RAD-50 CHARACTER SET
.;		*** NOTE ***
.;	SET THE UNDEFINED CHARACTER (35) TO "?"
.;
	.SETS R50CS " ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789"
.;
.;	DEFINE THE DEFAULT VALUES FOR THE SWITCHES
.;		/AL = FALSE - PRINT ALL ENTRIES
.;		/CN = FALSE - COMPRESS FILENAMES
.;		/CE = TRUE  - PRINT CURRENT ENTRIES
.;		/DE = FALSE - PRINT DELETED ENTRIES
.;		/EN = FALSE - PRINT ENTRY NUMBER
.;		/FI = FALSE - PRINT FILE ID'S
.;		/ST = TRUE  - PRINT STATISTICS
.;		/UE = FALSE - PRINT UNUSED ENTRIES
.;
.;		*** NOTE ***
.;	THE USE OF THE /AL SWITCH WITH ANY OF THE OTHER ENTRY
.;	SELECTION SWITCHES (/CE /DE /UE) IS NOT RECOMMENDED
.;	AS THESE SWITCHES WILL BE IGNORED
.;
	.SETF SWAL
	.SETF SWCN
	.SETT SWCE
	.SETF SWEN
	.SETF SWDE
	.SETF SWFI
	.SETT SWST
	.SETF SWUE
.;
.;	INITIALIZE STATISTICS COUNTERS
.;
	.SETN NCE 0
	.SETN NDE 0
	.SETN NUE 0
.;
.;	DEFINE DEFAULT DEVICE
.;
	.SETS DEV "SY:"
.;
.;	DEFINE DEFAULT GROUP AND MEMBER (UIC)
.;
	.PARSE <UIC> "[,]" JUNK1 GRP MEM JUNK2
.;
	.ENABLE	SUBSTITUTION
.;
.;	A COMMAND LINE HAS THE FOLLOWING FORMAT:
.;
.;	DIR DDNN:[GGG,MMM]/SW1/SW2/SW3...
.;
.;	WHERE:
.;	   DDNN = DEVICE
.;	   [GGG,MMM] = UIC
.;	   /SW... = SWITCHES
.;
.;	GET THE COMMAND LINE
.; 	IF NO COMMAND LINE, USE CURRENT DEVICE AND UIC
.;	P0 = COMMAND (THIS FILENAME)
.; 	P1-P9 = OPERANDS
.;
	.IF P1 EQ "" .GOTO 20
.;
.;	A COMMAND LINE WAS FOUND
.;	SEE IF IT WAS A CALL FOR HELP
.;
	.IF P1 NE "?" .GOTO 10
.;
.;	IT WAS - GIVE USER A LIST OF THE OPTIONS
.;
;	A COMMAND LINE HAS THE FOLLOWING FORMAT:
;
;	DDNN:[GGG,MMM]/SW1/SW2/SW3...
;
;	WHERE:
;	   DDNN = DEVICE (EX: DL10:)
;	   [GGG,MMM] = UIC (EX: [127,131])
;	   /SW... = SWITCHES (EX: /-CE/DF)
;
;	THE DEFAULT VALUES FOR THE SWITCHES ARE:
;		/AL = FALSE - PRINT ALL ENTRIES
;		/CN = FALSE - COMPRESS FILENAMES
;		/CE = TRUE  - PRINT CURRENT ENTRIES
;		/DE = FALSE - PRINT DELETED ENTRIES
;		/EN = FALSE - PRINT ENTRY NUMBER
;		/FI = FALSE - PRINT FILE ID'S
;		/ST = TRUE  - PRINT STATISTICS
;		/UE = FALSE - PRINT UNUSED ENTRIES
;		*** NOTE ***
;	THE USE OF THE /AL SWITCH WITH ANY OF THE OTHER ENTRY
;	SELECTION SWITCHES (/CE /DE /UE) IS NOT RECOMMENDED
;	AS THESE SWITCHES WILL BE IGNORED
;
	.ASKS P1 COMMAND LINE
.;
.;	SEARCH THE COMMAND LINE FOR A DEVICE AND UIC
.;
.10:
	.TEST P1 ":"
	.IF <STRLEN> EQ 0 .GOTO 15
	.PARSE P1 ":" DEV JUNK1
	.SETS DEV DEV+":"
.15:	.TEST P1 "["
	.IF <STRLEN> EQ 0 .GOTO 20
	.PARSE P1 "[,]" JUNK1 GRP MEM JUNK2
.;
.;	CONSTRUCT DIRECTORY FILENAME
.;
.20:	.SETN NGRP 'GRP'
	.SETN NMEM 'MEM'
	.SETS DFIL DEV+"[0,0]"+"'NGRP%ZOR3'"+"'NMEM%ZOR3'"+".DIR"
	; DIRECTORY FILE = 'DFIL'
.;
.;	SEARCH THE COMMAND LINE FOR ANY SWITCHES
.;
.30:	.TEST P1 "/"
	.IF <STRLEN> EQ 0 .GOTO 39
.;
.;	PARSE SWITCHES
.;
	.PARSE P1 "/" JUNK1 SW1 SW2 SW3 SW4 SW5 SW6 SW7 SW8 SW9
	.SETN NSW <STRLEN>-1
.;
	.SETN K1 0
.;
.31:
	.SETF NFLG
	.INC K1
	.SETS S SW'K1'
	.SETS CH1 S[1:1]
	.IF CH1 NE "-" .GOTO 32
	.TEST S
	.SETT NFLG
	.SETS S S[2:<STRLEN>]
.32:	.SETS CHS S[1:2]
	.IF CHS NE "NO" .GOTO 33
	.TEST S
	.SETT NFLG
	.SETS S S[3:<STRLEN>]
.33:	.SETS SWITCH "SW"+S
	.IFDF 'SWITCH' .GOTO 34
	; SWITCH -'S'- IS INVALID
	.GOTO 100
.34:	.SETT 'SWITCH'
	.IFT NFLG .SETF 'SWITCH'
	.IF K1 LT NSW .GOTO 31
.;
.;	IF THE /AL WAS SPECIFIED, SET /CE,/DE,/UE SWITCHES TRUE
.;
.35:	.IFF SWAL .GOTO 39
	.SETT SWCE
	.SETT SWDE
	.SETT SWUE
.;
.39:
.;
.;	TEST THE DIRECTORY FILENAME
.;	IF AN ERROR IS FOUND, INFORM USER AND EXIT
.;
	.TESTFILE	'DFIL'
	.IF <FILERR> EQ 1 .GOTO 40
	.SETS REASN "UNKNOWN ERROR"
	.IF <FILERR> EQ 346 .SETS REASN "NO SUCH FILE"
	.IF <FILERR> EQ 177644 .SETS REASN "INVALID DEVICE OR UNIT"
	; TESTFILE ERROR ON DIRECTORY FILE = 'DFIL'
	; FILERR='<FILERR>'	'REASN'
	.GOTO 100
.;
.;	OPEN THE DIRECTORY FILE
.;
.40:	.OPENR	'DFIL'
	.SETN ENTN 0
.;
.;	READ THE NEXT ENTRY IN THE FILE
.;
.;	BRANCH ON EOF
.;	IF ERROR ON READ, TELL USER AND EXIT
.;
.50:
	.READ	RECORD
	.IFT <EOF> .GOTO 90
	.IF <FILERR> EQ 1 .GOTO 60
.;
.;	ERROR - PRINT ERROR # AND EXIT
.;
	; ERROR IN FILE READ
	; FILERR='<FILERR>'
	.GOTO 90
.;
.;	SET UP TO PARSE ENTRY
.;
.60:
	.INC ENTN
	.SETN K1 0
	.SETN K2 0
	.SETT ALLZ
.;
.;	CONVERT THE 16 BYTE ENTRIES TO 8 VALUES
.;	IF ALL BYTES=0 SET ALLZ FLAG (ENTRY UNUSED)
.;
.61:
	.INC K1
	.SETS S RECORD[K1:K1]
	.SETN NL 'S%V'
	.SETN NL NL&377
	.INC K1
	.SETS S RECORD[K1:K1]
	.SETN NH 'S%V'
	.SETN NH NH&377
	.SETN VAL'K2' (400*NH)+NL
	.IF VAL'K2' NE 0 .SETF ALLZ
	.INC K2
	.IF K2 LT 8. .GOTO 61
.;
.;	IF ENTRY IS UNUSED, INCREMENT COUNTER
.;
	.IFT ALLZ .INC NUE
.;
.;	IF ALLZ=TRUE AND SWUE=FALSE - SKIP FILE
.;	ELSE, IF ALLZ=TRUE AND SWUE=TRUE, GO HANDLE IT
.;
	.IFT ALLZ .AND .IFF SWUE .GOTO 50
	.IFT ALLZ .AND .IFT SWUE .GOTO 62
.;
.;	THIS ENTRY EITHER CONTAINS AN ACTIVE FILENAME
.;	OR A DELETED FILENAME - SET COUNTER ACCORDINGLY
.;
	.IF VAL0 EQ 0 .INC NDE
	.IF VAL0 NE 0 .INC NCE
.;
.;	IF VAL0=0 AND SWDE=FALSE - SKIP FILE
.;
	.IF VAL0 EQ 0 .AND .IFF SWDE .GOTO 50
.;
.;	IF VAL0<>0 AND SWCE=FALSE - SKIP FILE
.;
	.IF VAL0 NE 0 .AND .IFF SWCE .GOTO 50
.;
.;	CONVERT OCTAL VALUES TO FILE NAME AND TYPE
.;
.62:	.SETN K1 2
	.SETN K2 0
	.SETS FNAM ""
.65:
	.INC K1
	.SETN C VAL'K1'
	.SETN C1 C/3100
	.SETN C C-(3100*C1)
	.SETN C2 C/50
	.SETN C C-(50*C2)
	.SETN C3 C
	.SETS FNAM FNAM+R50CS[C1+1:C1+1]+R50CS[C2+1:C2+1]+R50CS[C3+1:C3+1]
	.INC K2
	.IF K2 EQ 3 .SETS FNAM FNAM+"."
	.IF K2 LT 4 .GOTO 65
.;
.;	INSERT VERSION NUMBER
.;
	.SETS FNAM FNAM+";"+"'VAL7%R5'"
.;
.;	FORMAT OUTPUT STRING
.;
.;	IF SWEN SWITCH=TRUE INSERT ENTRY #
.;	IF SWFI=TRUE, INSERT FILE ID
.;
.70:	.SETS OUTS ""
	.IFT SWEN .SETS OUTS OUTS+"ENTRY="+"'ENTN%DR5'"
	.IFT SWFI .SETS OUTS OUTS+"	FID=("+"'VAL0%R5'"+","+"'VAL1%R5'"
	.IFT SWFI .SETS OUTS OUTS+","+"'VAL2'"+")"
.;
.;	IF SWCN=TRUE, COMPRESS FILENAME
.;
	.IFF SWCN .GOTO 80
	.SETN K1 0	; INPUT POINTER
	.SETN K2 0	; OUTPUT POINTER
	.SETS JUNK1 FNAM
	.SETS FNAM ""

.71:
	.INC K1
	.SETS CHS JUNK1[K1:K1]
	.IF CHS EQ " " .GOTO 72
	.INC K2
	.SETS FNAM FNAM+CHS
.72:	.IF K1 LT 19. .GOTO 71

.80:	.SETS OUTS OUTS+"	"+FNAM
.;
.;	IF ENTRY IS FOR A DELETED OR UNUSED ENTRY, INSERT NOTE
.;
	.SETS S ""
	.IF VAL0 EQ 0 .SETS S "(DELETED ENTRY)"
	.IFT ALLZ .SETS S "(UNUSED ENTRY)"
.;
	.SETS OUTS OUTS+S
.;
.;	PRINT INFORMATION ON USER TERMINAL
.;
; 'OUTS'
.;
	.GOTO 50
.;
.;	CLOSE DIRECTORY FILE
.;
.90:	.CLOSE
.;
.;	IF SWST=TRUE, PRINT STATISTICS
.;
	.IFF SWST .GOTO 100
.;
;
;	NUMBER OF CURRENT ENTRIES = 'NCE%D'
;	NUMBER OF DELETED ENTRIES = 'NDE%D'
;	NUMBER OF  UNUSED ENTRIES = 'NUE%D'
;	  TOTAL NUMBER OF ENTRIES = 'ENTN%D'
.;
.100:	.EXIT
