.;----------------------------------------------------------------------------
.;
.; CMD-program:	S Y S B A C K U P 
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	14-MAY-80
.;
.; Version:	V1.16	25-Oct-88
.;
.; Purpose:	SYSBACKUP copies files from disk to disk or magtape.
.;
.; Modified by:	Jan H. Belgraver	21-SEP-82	JB01	V1.1
.;		Replaced "call" to RUNVFY.CMD with local coding.
.;
.;		Jan H. Belgraver	17-NOV-82	JB02	V1.2
.;		Made it suitable for RSX-11M V4.0, i.e. DSC is 
.;		renamed into DSC64K, whereas BRU64K has been added.
.;
.;		Jan H. Belgraver	25-MAY-83	JB03	V1.3
.;		Clear remanining plot files if there are any of them.
.;
.;		Jan H. Belgraver	3-OCT-83	JB04	V1.4
.;		Dismount DM1:.
.;
.;		Jan H. Belgraver	12-DEC-83	JB05	V1.5
.;		Dismount of DM1: after stopping Error Logging.
.;
.;		Jan H. Belgraver	19-JAN-84	JB06	V1.6
.;		Ringing the bell after VFY has finished.
.;
.;		Jan H. Belgraver	7-MAY-84	JB07	V1.7
.;		Made running VFY optional.
.;		Disabled BRU or DSC question.
.;
.;		Jan H. Belgraver	5-JUN-84	JB08	V1.8
.;		Section for incremental backups.
.;		Removal of DSC feature since we don't use is.
.;
.;		Jan H. Belgraver	17-JUN-85	JB09	V1.9
.;		Backup mode as very first question.
.;
.;		Jan H. Belgraver	24-JAN-86	JB10	V1.10
.;		1. Show system disk usage.
.;		2. Dismount our 'new' DB:
.;
.;		Jan H. Belgraver	4-FEB-86	JB11	V1.11
.;		1. Debug JB10 PIP /FREE command
.;		2. Dismount DM1: via DMODATADK.CMD
.;
.;		Jan H. Belgraver	18-MAR-86	JB12	V1.12
.;		Start INCBACKUP.CMD from BIOREGAN.CLB.
.;
.;		Jan H. Belgraver	17-Sep-86	JB13	V1.13
.;		Start INCBACKUP without device parameter
.;
.;		Jan H. Belgraver	28-NOV-86	JB14	V1.14
.;		1. Dismount other devices than DM1: only if full backup
.;		2. Show Clock and Printer Queues
.;		3. Disabled display of several MCR commands.
.;
.;		Jan H. Belgraver	30-Nov-87	JB15	V1.15
.;		1. ELI /sh before dismounting disks, otherwise QIO counts
.;		are listed as zero.
.;
.;		Jan H. Belgraver	25-Oct-88	JB16	V1.16
.;		Support for dismounting and deassigning virtual disks.
.;----------------------------------------------------------------------------
.;

.enable substitution
.SETT	STATUS								! JB01
SET /NOLOGON
.IFNINS	BOO	INS $BOO
.IFNINS	VFY	INS $VFY
.IFNINS BRU	INS $BRU
.START:
	TIM
	.ASKS [1:1]	MODES	Incremental [I] or Full [F] backup	
	.IF	MODES EQ "I"	.GOTO	INCBUP				.;JB09
;
	PIP	[20,20]*.VEC;*/DE/NM,*.SEC;*/DE/NM
;
.ASK [<FALSE>]	MODE	Do you want to have VFY check the disk 
.IFF	MODE	.GOTO	VFYLO						! JB07
;
;	Running VFY to check readability and validity of SYSTEM disk.
;
	VFY	DM:
.GOSUB	CHECK								! JB01
	.enable quiet							! JB14
	TIM
	BELL 1
	.disable quiet							! JB14
.;									! JB01
.VFYLO:
;
.ASK [<TRUE>]	MODE	Do you want to recover lost files 	
.IFF	MODE	.GOTO CONTIN						! JB01
	VFY	DM:/LO	! Check for and store lost files into [1,3]
.GOSUB	CHECK								! JB01
	.enable quiet							! JB14
	TIM
	PIP	[1,3]/FU
	PIP	DM:/FREE						! JB11
.;									! JB01
.CONTIN:
;
	.ASK [<FALSE>]	MODE	More to do 
	.IFF	MODE	.GOTO	BUPMOD					! JB08
.PAUSE									! JB01
	.enable quiet							! JB14
	REM VFY
.;
.BUPMOD:
	.enable quiet							! JB14
;
.IF	MODES EQ "F"	.GOTO	BOOT					! JB08
.IF	MODES NE "I"	.GOTO	START					.;JB09
.INCBUP:
	.enable quiet							! JB14
	@/LB:INCBACKUP 							! JB13
.EXIT
;
.BOOT:
	.disable quiet							! JB14
;	Clock and Printer Queue Status: '<DATE>' '<TIME>'
;
	.enable quiet							! JB14
	CLQ
	QUE	/LI
	ELI /SH
	ELI /NOLOG
	.enable quiet							! JB14
	@/LB:DMODATADK		! Dismount DM1:				| JB11
	DMO	DM2:/DEV						! JB14
	@DM:[1,2]VEDDISMNT	! Dismount and deassign VEn:		| JB16
.;				| MUST be done before dismounting DB:	| JB16
	DMO	DB0:/DEV						! JB10
	.disable quiet							! JB14
;
;
;	STAND-ALONE BRU will be bootstrapped.
;
;	WARNING: Write protect your input device after BOOting BRU ! ! !
;
;	After entering the time, BRU is started by  entering the
;	command string RUN BRU following the MCR prompt >.
;
;	Thus:
;		>RUN BRU<cr>
;		 -----------
;		BRU>/VER/OUT:volume label[/BAC:backup set][/DEN:1600] <cr>
;		    ------------------------------------------------------
;		FROM:input device <cr>
;		     ----------------
;		TO:  output device <cr>
;		     -----------------
;
;	For system disks use following volume-label syntax:
;
;		S Y S y y m m d d , e.g.: SYS801031. 
;
;	[....] qualifiers to be used for backups to tape.
;	
	BOO [1,51]BRU64K
.EXIT
.;
.;----------------------------------------------------------------------------
.;
.CHECK:
.IF	<EXSTAT> NE 1	.SETF	STATUS
.IFF	STATUS	;	*** FATAL ***, VFY ERROR, EXIT STATUS: '<EXSTAT>'
.IFF	STATUS	.EXIT
.;
.SETT	STATUS
.RETURN
.;
.;----------------------------------------------------------------------------
.;
