.;
.;----------------------------------------------------------------------------
.;
.; CMD-program:	S R D M F D U F D
.;
.; Purpose:	Sorting MFD and UFD's found in MFD using SRD utility.
.;		Modified from COPY.CMD.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	3-NOV-83
.;
.; Version:	1.5	29-JUL-86
.;
.; Description:	In UIC [1,5] in de drive selected to types of directory files
.;		are generated; MFD.TMP;1234 and MFDUFD.LST files. 
.;		MFD.TMP contains the [0,0] directory which is used 
.;		subsequently to append directory listings of non-empty 
.;		directories to MFDUFD.LST.
.;
.; Calls to:	PIP,	SRD
.;
.; Modified by:	Jan H. Belgraver	25-JUN-84	JB01	V1.1
.;		1. Sort directories permanently.
.;		2. Add processing date to file.
.;		Jan H. Belgraver	25-JUN-85	JB02	V1.2
.;		Test on files in directory under test; 
.;		if No Such File	don't add form-feeds to list.
.;
.;		Jan H. Belgrver		19-DEC-85	JB03	V1.3
.;		1. Exit if some MCR commands fail.
.;		2. Made skip of FF in case of No Such File work with SRD V6.5
.;
.;		Jan H. Belgrver		14-jan-86	JB04	V1.4
.;		1. First three identification lines.
.;		2. 1st question now says 'Spool' i.s.o. 'Directories'
.;		3. 1st question now default TRUE.
.;		4. No KEEP doens'n imply NO SPOOL any more.
.;
.;		Jan H. Belgrver		29-JUL-86	JB05	V1.5
.;		1. For different input and output devices.
.;		2. Added /TB switch
.;----------------------------------------------------------------------------
.;

.enable  substitution
.disable lowercase							! JB03
	.setf	DCL							! 
	.if	<CLI> EQ "DCL"	.SETT	DCL				! 
.;	If current CLI is DCL reset to MCR				! 
	.ift	DCL	SET TERMINAL/MCR
.setf	del
.sett	KEEP								! JB04
;
;	Preparing sorted User File Directories listing
;
.enable	 quiet								! 
.;
.;	Ask for command parameter if not present
.;
	.asks [1:4:"SY:"]	DEVI	Input  Device	.
	.asks [1:4:"DB:"]	DEVO	Output Device	.
.SETUFD:
	UFD	'DEVI'[1,5]
	.if	<EXSTAT> gt 1	.goto	FINISH				! JB03
	UFD	'DEVO'[1,5]						! JB05
	.if	<EXSTAT> gt 1	.goto	FINISH				! JB05
.sets	UFDLST	DEVO+"[1,5]UFD.LST"					! JB05
.sets	MFDUFD	DEVO+"[1,5]MFDUFD.LST"					! JB05
.;
.;	Get rid of old MFDUFD.LST, we don't want to append to that file.
.;
	PIP	'MFDUFD';*/DE/NM
	.if	<EXSTAT> gt 1	.goto	FINISH				! JB03
;
	.ask [<FALSE>]	LIST	Spool listing	.
	.iff	LIST	.SETS	UFDLST	""
	.iff	LIST	.GOTO	10
	.opena	#1	'MFDUFD'
	.data	#1 
	.data	#1 Sorted Directory Listings Prepared by SRDMFDUFD.CMD
	.data	#1                         on
	.data	#1                  '<DATE>' '<TIME>'
	.data	#1 
	.data	#1 
	.close	#1
;
	.ask [<TRUE>]	KEEP	Keep listing       .
;
.10:
;	Progress display   .?
	.ask [<FALSE>]	DISP	(Shows PIP and SRD).
.;
.;	Prepare sorted MFD-list to control UFD sorting
.;
	SRD	'DEVO'[1,5]MFD.TMP;1234='DEVI'[0,0]/NA/WB		! JB05
	.if	<EXSTAT> ne 1	.goto	FINISH				! JB03
.;
.;	Main UFD sort loop
.;
	.openr	'DEVO'[1,5]MFD.TMP;1234					! JB05
.LOOP:
	.read	RECORD
	.ift	<EOF>	.goto	EXIT
	.if	<FILERR> ne 1	.goto	ERROR
	.parse	RECORD	".;"	NAME TYPE VERS
	.if	TYPE eq ""	.goto	LOOP
.;
.;	Watch out for the sort directory itself and system files.
.;
	.if	NAME eq "001005   "	.goto	LOOP
	.if	TYPE ne "DIR"		.goto	LOOP
	.sets	GRP	NAME[1:3]
	.sets	MEM	NAME[4:6]
	.sets	UFD	"["+GRP+","+MEM+"]"
.;
	.disable quiet
	; 'UFD'
	.iff	DISP	.enable	quiet
.;
.SORT:	.setf	NSF							.;JB02
	SRD	'UFDLST'='DEVI''UFD'/NA/FU/WB/SM/TB			! JB05
	.if	<EXSTAT> gt 2	.goto	FINISH				! JB03
.;	.openr	#2	'UFDLST'					! JB02
.;	.read	#2	record						.;JB02
.;	.ift	<EOF>	.sett	NSF	.; Empty directory		.;JB02
.;	.close	#2							.;JB02
	.if	<EXSTAT> eq 2	.sett	NSF	.; Empty directory	.;JB03
	.ift	NSF	.goto	LOOP					.;JB02
	.iff	LIST	.goto	LOOP					! JB01
	PIP	'MFDUFD'/AP='UFDLST'
	.if	<EXSTAT> ne 1	.goto	FINISH				! JB03
	.opena	#1	'MFDUFD'
	.data	#1 
	.close	#1
	.goto	LOOP
.ERROR:
	.disable	quiet
	;..... ERROR '<FILERR>' in '<FILSPC>'
.EXIT:
	PIP	'DEVO'[1,5]MFD.TMP;1234/DE/NM,UFD.LST;*/DE/NM
	.ift	LIST	PIP	'MFDUFD'/SP
	.iff	KEEP	PIP	'MFDUFD';*/DE/NM
.FINISH:
	.enable	quiet							! 
	.;	If user CLI was DCL reset terminal.			! 
	.ift	DCL	SET /DCL=TI:
.EXIT
