.;----------------------------------------------------------------------------
.;
.; CMD-file:	P 1 6 L 9
.;
.; Purpose:	Setting LA120 printer parameters
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	18-JUN-86
.;
.; Version:	V1.0
.;
.; Description:	Defines escape sequences for pitch (16.5 char./in/), 
.;		margins (9 resp. 132), and tabs (starting at 9).
.;		Stores them in temporary file P16L9.TMP
.;
.; Calls to:	
.;
.; Arguments:	Name	Type	I/O	Description
.;		$PRSET	String	 O	File containing escape sequence
.;
.; Modified by:	
.;
.;----------------------------------------------------------------------------
.;
.;

.enable	global
.enable	substitution
.;
.sets	$PRSET	"P16L9.TMP"
.sets	ESC	""
.sets	PITCH	ESC+"[4w"
.sets	MARGIN	ESC+"[9;132s"
.sets	CLRTAB	ESC+"[2g"
.sets	TABS	ESC+"[9;17;25;33;41;49;57;65;73;81;89;97;105;113;121;129u"
.sets	ESCSEQ	PITCH+MARGIN+CLRTAB+TABS
.;
.open	'$PRSET'
.data 'ESCSEQ'
.close
.;
.exit
