.;
.;----------------------------------------------------------------------------
.;
.; CMD-File:	L A S D F L T
.;
.; Purpose:	Sets LA120 default charactersize, Left and Right Margins.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	10-APR-85
.;
.; Version:	1.6	26-NOV-85
.;
.; Description:	Escape sequences are send to the LA120 via PIP.
.;		They are defined in the file LASDFLT.ESC.
.;		ESC[4w		Character Size 16.5 char/inch
.;		ESC[4s;132s	Left  Margin 4, Right Margin 132
.;		ESC[2g		Clear all tabs
.;		ESC[4;12,etc	Tabs at 4,+8,+8, etc
.;
.; Calls to:	DEVATTTST.CMD, LAS, PIP 
.;
.; Modified by:	Jan H. Belgraver	21-JUN-85	JB01	V1.1
.;		For DCL users.
.;
.;		Jan H. Belgraver	1-JUL-85	JB02	V1.2
.;		If TT4: is attached by e.g. BRU or QMG exit.
.;
.;		Jan H. Belgraver	10-SEP-85	JB03	V1.3
.;		Generate escape sequence file on-line.
.;
.;		Jan H. Belgraver	22-NOV-85	JB04	V1.4
.;		1. Left margin decreased from 5 to 4.
.;		2. Spawn DEVATTTST.CMD from BIOREGAN.CLB
.;		3. Symbols for left- and right margins
.;
.;		Jan H. Belgraver	25-NOV-85	JB05	V1.5
.;		Debuged missing library ref. in 'call' to DEVATTTST.
.;
.;		Jan H. Belgraver	26-NOV-85	JB06	V1.6
.;		Adjusted tab-settings according to left-margin change.
.;----------------------------------------------------------------------------
.;
.;

.enable	substitution
.enable global								.;JB02
.enable decimal								! JB04
.enable	quiet					
.setn	LM	4			! Left  margin			! JB04
.setn	RM	132			! Right margin			! JB04
.sets	ESC	""							.;JB03
.setf	$ATACH								.;JB02
	.SETF	DCL				
	.IF	<CLI> EQ "DCL"	.SETT	DCL	
.;	If current CLI is DCL reset to MCR	
	.IFT	DCL	SET TERMINAL/MCR	
	@/lb:DEVATTTST TT4:						! JB05
	.ift	$ATACH	.goto	ATAERR					.;JB02
	.setn	T1	LM
	.sets	STMP	"'T1%D'"
	.setn	N	0						! JB06
.LOOP:									! JB06
	.inc	N							! JB06
	.setn	M	N+1
	.setn	T'M'	T'N'+8						! JB06
	.setn	NTMP	T'M'
	.sets	STMP	STMP+";'NTMP%D'"
	.if	T'M' lt 132	.goto	LOOP				! JB06

	.open	LASDFLT.ESC						! JB03
	.data 'ESC'[4w'ESC'['LM';'RM's					! JB04
	.data 'ESC'[2g
	.data 'ESC'['STMP'u
	.data ;	Character Size 16.5 char/inch
	.data ;	Left  Margin 'LM'
	.data ;	Right Margin 'RM'
	.close								.;JB03

	LAS	PA			! Do Form-feed
	PIP	TT4:=LASDFLT.ESC
	.goto	FINISH							.;JB02
.ATAERR:								.;JB02
	.disable quiet							.;JB02
	; -- WARNING -- LA120 (TT4:) not available
	.enable  quiet							.;JB02
.FINISH:
		PIP	LASDFLT.ESC;*/DE/NM				! JB03
	.;	If user CLI was DCL reset terminal.
	.IFT	DCL	SET /DCL=TI:
	.disable display
.EXIT
