.;
.;	DL11W.CMD - Command file to determine DL11-W DIP switch settings
.;
.;	 26-JUL-1990 09:51:42
.;
	.SETS F "off"
	.SETS N " ON"
;    Determine the DIP switch settings for a DL11-W
.3:	.ASKN [174000:177700:177560] ADR What is the CSR address
	.SETN B ADR&7
	.IF B NE 0 .GOTO 3
.4:	.ASKN [0:774:60] VEC What is the vector address
	.SETN B VEC&7
	.IF B NE 0 .GOTO 4
.5:	.ASKN [0.:9600.:9600.] TBAUD What is the transmitter baud rate
.6:	.ASKN [0.:9600.:'TBAUD'.] RBAUD What is the receiver baud rate
	.ASKN [5.:8.:8.] DATA How many data bits
	.ASK PARITY Is there a parity bit
	.SETF ODDPAR
	.IFT PARITY .ASK ODDPAR Is it odd parity
	.ASKN [1.:2.:1.] STOP How many stop bits
	.ASK BREAK Is break enabled
	.ASK ERROR Is error notification enabled

	.SETN Z 0
.; Set transmitter baud rate:
	.SETS S410 F
	.SETS S31 F
	.SETS S34 F
	.SETN I 77
	.IF TBAUD EQ 9600. .SETN I 2
	.IF TBAUD EQ 4800. .SETN I 1
	.IF TBAUD EQ 2400. .SETN I 0
	.IF TBAUD EQ 1200. .SETN I 6
	.IF TBAUD EQ  600. .SETN I 5
	.IF TBAUD EQ  300. .SETN I 4
	.IF TBAUD EQ  150. .SETN I 3
	.IF TBAUD EQ  110. .SETN I 7
	.IF I EQ 77 .GOTO 5
	.IF Z NE I&4 .SETS S410 N
	.IF Z NE I&2 .SETS S31 N
	.IF Z NE I&1 .SETS S34 N
.; Set receiver baud rate:
	.SETS S32 F
	.SETS S33 F
	.SETS S35 F
	.SETN I 77
	.IF RBAUD EQ 9600. .SETN I 5
	.IF RBAUD EQ 4800. .SETN I 6
	.IF RBAUD EQ 2400. .SETN I 7
	.IF RBAUD EQ 1200. .SETN I 1
	.IF RBAUD EQ  600. .SETN I 2
	.IF RBAUD EQ  300. .SETN I 3
	.IF RBAUD EQ  150. .SETN I 4
	.IF RBAUD EQ  110. .SETN I 0
	.IF I EQ 77 .GOTO 6
	.IF Z NE I&4 .SETS S32 N
	.IF Z NE I&2 .SETS S33 N
	.IF Z NE I&1 .SETS S35 N

.; The following sets the bus address:
.160:	.SETS S53 F
	.SETN B ADR&2000
	.IF B = 0 .SETS S53 N
	.SETS S52 F
	.SETN B ADR&1000
	.IF B = 0 .SETS S52 N
	.SETS S51 F
	.SETN B ADR&400
	.IF B = 0 .SETS S51 N
	.SETS S54 F
	.SETN B ADR&200
	.IF B = 0 .SETS S54 N
	.SETS S55 F
	.SETN B ADR&100
	.IF B = 0 .SETS S55 N
	.SETS S56 F
	.SETN B ADR&40
	.IF B = 0 .SETS S56 N
	.SETS S58 F
	.SETN B ADR&20
	.IF B = 0 .SETS S58 N
	.SETS S57 F
	.SETN B ADR&10
	.IF B = 0 .SETS S57 N
.;  The following set the line clock to be inaccessible:
	.SETS S59 N
	.SETS S510 F
.; The following sets the vector address:
	.SETS S28 N
	.SETN B VEC&400
	.IF B = 0 .SETS S28 F
	.SETS S27 N
	.SETN B VEC&200
	.IF B = 0 .SETS S27 F
	.SETS S25 N
	.SETN B VEC&100
	.IF B = 0 .SETS S25 F
	.SETS S23 N
	.SETN B VEC&40
	.IF B = 0 .SETS S23 F
	.SETS S26 N
	.SETN B VEC&20
	.IF B = 0 .SETS S26 F
	.SETS S24 N
	.SETN B VEC&10
	.IF B = 0 .SETS S24 F
.; Switches 2-1 and 2-2 are unused:
	.SETS S21 F
	.SETS S22 F
.; Set transmitter current mode switches to passive:
	.SETS S11 F
	.SETS S12 F
	.SETS S13 N
	.SETS S16 N
	.SETS S17 F
.; Set receiver current mode switches to passive:
	.SETS S36 F
	.SETS S37 N
	.SETS S38 F
	.SETS S39 N
	.SETS S310 F
.; Set paper tape reader enable current mode switches to passive:
	.SETS S14 F
	.SETS S15 N
	.SETS S18 F
	.SETS S19 N
	.SETS S110 F
.; Set data format:
	.IFT PARITY .SETS S46 N
	.IFF PARITY .SETS S46 F
	.IFT ODDPAR .SETS S42 N
	.IFF ODDPAR .SETS S42 F
	.IF STOP = 1. .SETS S45 N
	.IF STOP = 2. .SETS S45 F
	.SETS S43 N
	.SETS S44 N
	.IF DATA = 6. .SETS S43 F
	.IF DATA = 7. .SETS S44 F
	.IF DATA = 8. .SETS S43 F
	.IF DATA = 8. .SETS S44 F
.; Set break enable:
	.IFF BREAK .SETS S41 F
	.IFT BREAK .SETS S41 N
.; Set error notification enable:
	.IFF ERROR .SETS S47 F
	.IFT ERROR .SETS S47 N
.; Switches 4-8 and 4-9 are unused:
	.SETS S48 F
	.SETS S49 F

	.OPEN DL11W.DAT
	.SETS S "N"
	.IFT PARITY .IFT ODDPAR .SETS S "O"
	.IFT PARITY .IFF ODDPAR .SETS S "E"
	.SETS FORM "'DATA''S''STOP'"
	.ENABLE DATA
; Switch settings for a DL11-W Asynchronous Serial Interface board with:
;	CSR address of 'ADR'
;	Vector address of 'VEC'
;	Transmitter baud rate of 'TBAUD'
;	Receiver baud rate of 'RBAUD'
;	Data format is 'FORM'
;	Break enable is 'BREAK'
;	Error notification is 'ERROR'
;	
;             1    2    3    4    5    6    7    8    9   10
; Switch 1: 'S11', 'S12', 'S13', 'S14', 'S15', 'S16', 'S17', 'S18', 'S19', 'S110'
;
; Switch 2: 'S21', 'S22', 'S23', 'S24', 'S25', 'S26', 'S27', 'S28'
;
; Switch 3: 'S31', 'S32', 'S33', 'S34', 'S35', 'S36', 'S37', 'S38', 'S39', 'S310'
;
; Switch 4: 'S41', 'S42', 'S43', 'S44', 'S45', 'S46', 'S47', 'S48', 'S49', 'S410'
;
; Switch 5: 'S51', 'S52', 'S53', 'S54', 'S55', 'S56', 'S57', 'S58', 'S59', 'S510'
.DISABLE DATA
	.CLOSE
	.DISABLE DISPLAY
