.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	R E P L A C E 
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	25,28-JUN-84
.;
.; Version:	1.3	31-Jul-86
.;
.; Purpose:	Replacement of files on new system disk after sysgen.
.;
.; Description:	Before copying starts the user has to answer some 
.;		questions and than a temporary file is made that 
.;		consists of the file specifications of the selected files.
.;		The selection is made by using the /BE, /DA, /AE and
.;		/HV features of SRD.
.;		Moreover, one has the choice of copying the files 
.;		- using PIP - with /CO or /-CO; /-CO is the default mode.
.;		/CO is meant for task and library file directories.
.;					Warning
.;		Since the directory is sorted with the version 
.;		numbers in ascending order, the highest number appears
.;		first on the list. The consequence of this is, that 
.;		if the /DE option is used the only file that remains
.;		on the output device is the one with the lowest 
.;		version number.
.;
.;		All delete-protected files will deleted as well.
.;
.; Calls to:	TSTDAT
.;
.; Modified by:	Jan H. Belgraver	7-JAN-86	JB01	V1.1
.;		1. For current version of SRD
.;		2. Never delete some system tasks, see SAVTBL.
.;
.;		Jan H. Belgraver	15-JAN-86	JB02	V1.2
.;		1. Suppress copy command
.;		2. No selective delete.
.;		3. Spool DIRECTORY.TMP always
.;
.;		Jan H. Belgraver	31-Jul-86	JB03	V1.3
.;		Show files copied.
.;----------------------------------------------------------------------------
.;

.;
.enable substitution
.enable global								! JB01
.enable	quiet					
	.SETF	DCL				
	.IF	<CLI> EQ "DCL"	.SETT	DCL	
.;	If current CLI is DCL reset to MCR	
	.IFT	DCL	SET TERMINAL/MCR
.disable	quiet				
.;
.setf	FLAG
.setf	GO
.setf	PRINT								

.sets	STRING	""
.sets	DEVIN	""
.sets	DEVOUT	""
.sets	BE	"<"
.sets	DA	"="
.sets	AF	">"
.sets	BEF	"/BE:"
.sets	AFT	"/AE:"
.sets	DAY	"/DA:"
.sets	LOV	"/HV:"
.sets	CO	"/CO"
.sets	NV	"/NV"
.sets	SAVTBL	",DMDRV,EXCOM1,EXCOM2,FCPMDL,ICP,MCRMU,LDR,PIP,RSX11M"	! JB01
.sets	SAVTBL	SAVTBL+",SYS,TTDRV,"					! JB01

.;
.;	ASK FOR COMMAND PARAMETERS IF NOT PRESENT
;
;* WARNING *	Directory must have been purged,
;		otherwise lowest version number of file is kept only
	.ask [<FALSE>]	CONTIN		Continue           
	.iff	CONTIN	.EXIT
;
	.ask [<FALSE>]	CONTIG	Contiguous   output   files
	.iff	CONTIG	.sets	CO	""
;
	.ask [<FALSE>]	DELET	Delete files before copying
	.ift	DELET	.sett	DEL
;
	.askn [::1]	LVNUM	Lowest version to be copied
;
.30:
;	File dates On/Before [<], On [=] or On/After [>] 
;	date to be entered. 
;
	.asks [10.:11.]	DATE	Enter date as: >:dd-mmm-yy  
	.gosub	TSTDAT
.32:
	.if	MODE eq DA	.goto	34
	.if	MODE eq BE	.goto	36
	.if	MODE eq AF	.goto	38
	.goto	30
.34:
	.sets	BEF	""
	.sets	AFT	""
	.sets	$DATE	DAY+$DATE
	.goto	40
.36:
	.sets	DAY	""
	.sets	AFT	""
	.sets	$DATE	BEF+$DATE
	.goto	40
.38:
	.sets	BEF	""
	.sets	DAY	""
	.sets	$DATE	AFT+$DATE
	.goto	40
.40:
;
	.asks[::"DM0:"] 	DEVIN	FROM	
	.sets		TMPS	DEVIN[3:3]				! JB01
	.if	TMPS eq ":"	.sets	DEVIN	"DM0:"			! JB01
	.asks[::"DM1:"] 	DEVOUT	TO	
	.sets		TMPS	DEVOUT[3:3]				! JB01
	.if	TMPS eq ":"	.sets	DEVOUT	"DM0:"			! JB01
	.sets	SYDEV	<SYDISK>+"'<SYUNIT>%O'"				! JB01
.;	.if	DEVOUT eq "'<SYSDEV>':"	.setf	DELET			! JB01
.;	.if	DEVOUT eq "SY:"	.if SYDEV eq <SYSDEV>	.setf	DELET	! JB01
.;
.;	FIND OUT WHAT TO COPY
.;
	.enable	quiet					
	SRD	'DEVIN'DIRECTORY.TMP;1234='DEVIN'/LI'$DATE''LOV''LVNUM'/MI!JB01
	PRI	'DEVIN'DIRECTORY.TMP;1234				! JB02
	.openr	'DEVIN'DIRECTORY.TMP;1234
.LOOP:
	.sets	PREVIO	STRING
	.read	RECORD
	.ift	<EOF>	.goto	EXIT
	.if	<FILERR> ne 1	.goto	ERROR
	.test	RECORD
.;
.;	GET RID OF <CR><LF>	applies to PIP-files only
.;
	.if	<STRLEN> le 2	.goto	LOOP
	.sets	STRING	RECORD
	.parse	STRING	".;"	NAME TYPE VERS
	.sets	VERS	VERS[1:4]
	.sets	STRING	NAME+"."+TYPE+";"+VERS
	.if	TYPE eq ""	.goto	LOOP
.;
.;	WATCH OUT FOR THE FILE ITSELF
.;
	.if	NAME ne "DIRECTORY"	.goto	MORE
	.if	TYPE ne "TMP"	.goto	MORE
	.if	VERS ne "1234"	.goto	MORE
	.GOTO	LOOP
.MORE:
	.ift	GO	.goto	COPY
;
	.asks 	ANSWER	Copy 'STRING'	[Y,N,Q,G,^]	
	.if	ANSWER eq ""	.goto LOOP
	.sets	FIRST	ANSWER [1:1]
	.if	FIRST eq "N"	.goto LOOP
	.if	FIRST eq "Y"	.goto COPY
	.if	FIRST eq "Q"	.goto EXIT
	.if	FIRST eq "G"	.sett GO
	.if	FIRST EQ "^"	.SETT FLAG
	.ift	GO	.goto	COPY
	.iff	FLAG	.goto	MORE
	.sets	CURREN	STRING
	.sets	STRING	PREVIO
	.parse	STRING	".;"	NAME TYPE VERS				! JB01
.COPY:
	.enable	quiet					
	.sets	NAME	"'NAME%C'"	.; Remove any trailing blanks	  JB01
	.test	SAVTBL	","+NAME+","	.; Is it a restricted task?	  JB01
	.if	<STRLEN> ne 0	.setf	DEL	.; If Y, reset flag	  JB01
	.ift	DEL	PIP	'DEVOUT''NAME'.'TYPE';*/PR:0
	.ift	DEL	PIP	'DEVOUT''NAME'.'TYPE';*/DE/NM		! JB02
	.ift	DELET	.sett	DEL					! JB01
	.disable quiet							! JB03
	; 'STRING'
	.enable  quiet							! JB03
	PIP	'DEVOUT''NV''CO'='DEVIN''STRING'
	.iff	FLAG	.goto	LOOP
	.setf	FLAG
	.sets	STRING	CURREN
	.goto	MORE
.ERROR:
	.disable	quiet
	;..... Error '<FILERR>' in '<FILSPC>'
.EXIT:
	.enable	quiet					
	PIP	'DEVIN'DIRECTORY.TMP;1234/DE
.FINISH:
	.enable	quiet					
	.;	If user CLI was DCL reset terminal.	
	.ift	DCL	SET /DCL=TI:
.EXIT

.;----------------------------------------------------------------------------
.;
.; Subroutine:	T S T D A T
.;
.; Purpose:	Checks date string syntax.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	28-JUN-84
.;
.; Version:	V1.1	8-JAN-86
.;
.; Description:	It expects:	m:dd-mmm-yy
.;
.;		with m =	<, =, or >
.;		and dd-mmm-yy	28-JUN-84
.;
.; Calls to:	BIOREGAN/LB:CHKDATE
.;		P1 argument is $DATE
.;
.TSTDAT:
	.PARSE	DATE	":"	MODE	$DATE
	.TEST	MODE
	.IF	<STRLEN> EQ 1	.GOTO	310
;	Is 'MODE', expected: <, =, or >
	.GOTO	300				! Stinglength not in range
.310:
	.IF	MODE EQ "="	.GOTO	320	! Check syntax
	.IF	MODE EQ "<"	.GOTO	320	! Must be <, =, or >
	.IF	MODE EQ ">"	.GOTO	320
;	Is: 'MODE', expected: <, =, or >
;
	.GOTO	300				! Syntax error
.320:
;	@[5,104]BIOREGAN/LB:CHKDATE '$DATE'				! JB01
	.return								! JB01
.330:
	.SETS	ERRPNT		"         "
	.SETS	ERRPNT	ERRPNT[1:DIG-1]+"^"	
;	'$DATE'
;	'ERRPNT'
;
.300:	.GOTO	30				! Error   return
	.RETURN
