.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	P P O
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	14-JUN-82
.;
.; Version:	V1.8	2-Sep-86
.;
.; Purpose:	Sets file protecting first to RWED,RWED,RWED,RWED,
.; 		purges the files and sets protection to ,RWE,,.
.; 		Modified from PUP.CMD.
.;
.; Modified by:	Jan H. Belgraver	1-SEP-82	JB01	V1.1
.; 		Added check on PIP exit status to abort program flow
.; 		in case of error, e.g. NO SUCH FILE.
.; 		Added undocumented command line input parameter option
.; 			@FILE p1,p2,p3,p4,p5,p6,p7,p8
.; 		p1,p2,....p8 transfer data to parameters P1,P2,....P8
.; 		inside command file.
.; 		New will be that file to protected is entered as 
.; 		part of command line submitted to MCR.
.; 		e.g.
.; 		MCR>PUP FILE.CMD
.;
.; 		Jan H. Belgraver	1-FEB-83	JB02	V1.2
.; 		For compatibility with DCL.
.;
.; 		Jan H. Belgraver	30-MAY-84	JB03	V1.3
.; 		Made it to loop around until an <ESC> is entered.
.;
.; 		Jan H. Belgraver	13-JUN-84	JB04	V1.4
.; 		Disabled display of @ <EOF>.
.;
.; 		Jan H. Belgraver	27-SEP-85	JB05	V1.5
.; 		Truncate file.
.;
.; 		Jan H. Belgraver	 1-OCT-85	JB06	V1.6
.;		Disabled display of setting protection and truncation.
.;
.; 		Jan H. Belgraver	25-APR-86	JB07	V1.7
.;		Purge using SRD
.;
.; 		Jan H. Belgraver	 2-Sep-86	JB08	V1.8
.;		1. Don't stop SRD on "No Such File(s)"
.;		2. Don't display anything, but "Working ..."
.;		3. Added /HD to SRD to show command line
.;----------------------------------------------------------------------------
.;

.enable	substitution
.enable	quiet								! JB02
.enable	escape								! JB03
	.setf	DCL							! JB02
	.if	<CLI> EQ "DCL"	.SETT	DCL				! JB02
.;	If current CLI is DCL reset to MCR				! JB02
	.ift	DCL	SET TERMINAL/MCR
.;
	.test	P1			! Check on empty string		! JB01
	.if	<STRLEN> eq 0	.goto	INPUT				! JB01
	.sets	FILNAM	P1
	.goto	PURGE							! JB01
.INPUT:									
;
	.asks	FILNAM	Enter file spec. [<ESC> = Exit] 
	.ift	<ESCAPE>	.GOTO	FINISH				! JB03
.PURGE:									
	.disable quiet							! JB06
;	Working . . .
	.enable	quiet							! JB08
	PIP	'FILNAM';*/PR:0
	.if	<EXSTAT> ne 1	.goto	INPUT				! JB01
	SRD	'FILNAM'/PU/HD						! JB08
	.if	<EXSTAT> gt 2	.goto	INPUT				! JB08
	PIP	 'FILNAM'/PR:177617
	.if	<EXSTAT> ne 1	.goto	INPUT				! JB06
	PIP	'FILNAM'/TR						! JB05
	.goto	INPUT							! JB03
.FINISH:
	.enable		QUIET						! JB02
	.disable	DISPLAY						! JB04
	.;	If user CLI was DCL reset terminal.			! JB02
	.ift	DCL	SET /DCL=TI:
.EXIT
