.;
.;----------------------------------------------------------------------------
.;
.; CMD-File:	L A S 8 0 C D O C
.;
.; Purpose:	Sets LA120 charactersize, Left and Right Margins
.;		for printing 80-collumn documents with a larger
.;		character size than the default.
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	10-APR-85
.;
.; Version:	1.4	25-NOV-85
.;
.; Description:	Escape sequences are send to the LA120 via PIP.
.;		They are defined in the file LAS80CDOC.ESC.
.;		ESC[3w		Character Size 13.2 char/inch
.;		ESC[10;106s	Left  Margin 10, Right Margin 106
.;		ESC[2g		Clear all tabs
.;		ESC[10;18,etc.u	Tabs at 10, +8, +8, etc.
.;		
.;		The terminal default settings can be restored using
.;		the command file LASDFLT.CMD.
.;
.; Calls to:	DEVATTTST.CMD LAS, PIP
.;
.; Modified by:	Jan H. Belgraver	21-JUN-85	JB01	V1.1
.;		For DCL users.
.;
.;		Jan H. Belgraver	1-JUL-85	JB02	V1.2
.;		If TT4: is attached, e.g. by BRU or QMG exit.
.;
.;		Jan H. Belgraver	10-SEP-85	JB03	V1.3
.;		Generate escape sequence file on-line.
.;
.;		Jan H. Belgraver	25-NOV-85	JB04	V1.4
.;		1. Spawn DEVATTTST from BIOREGAN.CLB.
.;		2. Symbols for left-, and right margins.
.;
.;----------------------------------------------------------------------------
.;
.;

	.enable	substitution
	.enable decimal							! JB04
	.enable global							.;JB02
	.enable	quiet					
	.onerr	finish
	.sets	ESC	""						.;JB03
	.setn	LM	10		! Left margin			! JB04
	.setn	RM	106		! Right margin			! JB04
	.setf	$ATACH							.;JB02
	.setf	DCL				
	.if	<CLI> EQ "DCL"	.SETT	DCL	
.;	If current CLI is DCL reset to MCR	
	.ift	DCL	SET TERMINAL/MCR	

	@/lb:DEVATTTST TT4:						! JB04
	.ift	$ATACH	.goto	EXIT					.;JB02

	.open	LAS80CDOC.ESC						! JB03
	.data 'ESC'[3w'ESC'['LM';'RM's					.;JB04
	.data 'ESC'[2g'ESC'[10;18;26;34;42;50;58;66;74;82;90;98u
	.data ;	Character Size 13.2 char/inch
	.data ;	Left  Margin  'LM'
	.data ;	Right Margin 'RM'
	.close								.;JB03
	LAS	PA
	PIP	TT4:=LAS80CDOC.ESC
	.goto	FINISH							.;JB02
.EXIT:									.;JB02
	.disable quiet							.;JB02
	; -- WARNING -- LA120 (TT4:) not available
	.enable  quiet							.;JB02
.FINISH:
		PIP	LAS80CDOC.ESC;*/DE/NM				! JB03
	.;	If user CLI was DCL reset terminal.
	.IFT	DCL	SET /DCL=TI:
	.disable display
.EXIT
